/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.alert;

import coldfusion.filter.CFCInvokeContext;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.active.ActiveRequestMonitor;
import coldfusion.monitor.alert.AlertConfig;
import coldfusion.monitor.alert.CFCAlertStruct;
import coldfusion.monitor.alert.CustomAlertManager;
import coldfusion.monitor.alert.Messages;
import coldfusion.monitor.alert.Notification;
import coldfusion.monitor.alert.SlackClient;
import coldfusion.monitor.scheduler.HeapDump;
import coldfusion.monitor.threaddump.ThreadDumpUtil;
import coldfusion.monitor.util.ThreadDictionary;
import coldfusion.runtime.Struct;
import coldfusion.server.MonitoringService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class AlertAction {
    protected static Logger logger = CFLogs.MONITOR_LOG;
    AlertConfig config;
    private List<String> killedThreadsList = null;
    String threadDumpOverview = null;
    String heapDumpFile = "";
    private CFCAlertStruct cfcAlertArgs;
    private AlertConfig.Actions actions;
    private Notification notification;
    private MonitoringService ms;
    private StringBuilder mailMsg;

    public AlertAction(AlertConfig config, Notification notification) {
        this.config = config;
        this.actions = config.getActions();
        this.notification = notification;
        this.ms = ServiceFactory.getMonitoringService();
    }

    public void recoverActions() {
        ArrayList<Struct> actionList = new ArrayList<Struct>();
        if (this.actions.isSlack()) {
            Struct action = new Struct();
            this.sendAlertOnSlack(action);
            actionList.add(action);
        }
        if (this.config.getActions().isRejectNewRequests()) {
            ActiveRequestMonitor.INSTANCE.acceptNewRequests();
        }
        if (this.actions.isSendMail()) {
            Struct temp = new Struct();
            this.sendNotification(temp);
            actionList.add(temp);
        }
        this.notification.setActions(actionList);
    }

    public void execute() {
        Struct action;
        ArrayList<Struct> actionList = new ArrayList<Struct>();
        if (this.actions.isSlack()) {
            action = new Struct();
            this.sendAlertOnSlack(action);
            actionList.add(action);
        }
        if (this.actions.isTriggerThreadDump()) {
            action = new Struct();
            action.put("name", (Object)"threaddump");
            try {
                this.threadDumpOverview = ThreadDumpUtil.getInstance().takeThreadDumpFromAlert(this.notification.getAlertId());
                this.notification.setThreadDumpId(this.threadDumpOverview);
                action.put("success", (Object)"true");
                action.put("value", (Object)this.threadDumpOverview);
                this.appendMailMessage(RB.getString(AlertAction.class, "THREAD_DUMP_SUCCESS.message", (Object)this.threadDumpOverview));
            }
            catch (Throwable th) {
                action.put("success", (Object)"false");
                action.put("message", (Object)RB.getString(AlertAction.class, "THREAD_DUMP_ERROR.message", (Object)th.getMessage()));
                this.appendMailMessage(RB.getString(AlertAction.class, "THREAD_DUMP_ERROR.message", (Object)th.getMessage()));
            }
            actionList.add(action);
        }
        if (this.actions.isTriggerHeapDump()) {
            action = new Struct();
            action.put("name", (Object)"Heap Dump");
            String heapDumpFile = this.dumpHeap(action);
            this.notification.setHeapDumpFile(heapDumpFile);
            actionList.add(action);
        }
        if (this.actions.isKillThreads()) {
            action = new Struct();
            this.killThreads(action);
            actionList.add(action);
        }
        if (this.actions.isInvokeCFC()) {
            action = new Struct();
            action.put("name", (Object)"invoke-cfc");
            this.invokeCFC(action);
            actionList.add(action);
        }
        if (this.actions.isRejectNewRequests()) {
            action = new Struct();
            action.put("name", (Object)"reject-new-request");
            action.put("success", (Object)"true");
            this.rejectNewRequests();
            actionList.add(action);
        }
        if (this.actions.isInvokeGarbageCollection()) {
            action = new Struct();
            if (this.ms != null) {
                try {
                    action.put("name", (Object)"GarbageCollection");
                    this.ms.callGC();
                    action.put("success", (Object)"true");
                }
                catch (Exception ex) {
                    action.put("success", (Object)"false");
                    action.put("message", (Object)RB.getString(AlertAction.class, "GC_ERROR.message", (Object)ex.getMessage()));
                }
                actionList.add(action);
            }
        }
        if (this.actions.isSendMail()) {
            Struct temp = new Struct();
            this.sendNotification(temp);
            actionList.add(temp);
        }
        this.notification.setActions(actionList);
    }

    private void rejectNewRequests() {
        ActiveRequestMonitor.INSTANCE.rejectNewRequests();
    }

    protected void sendAlertOnSlack(Struct action) {
        action.put("name", (Object)"SlackNotification");
        String notifyalertslackwebhookurl = CustomAlertManager.getSlackWebHookUrl();
        SlackClient slackClient = SlackClient.getSlackClient();
        if (notifyalertslackwebhookurl == null) {
            this.notification.setSlack(false);
            this.setSlackMessageOnCompletion(action, "false", Messages.getString("SLACK_NOT_CONFIGURED.message"));
            return;
        }
        try {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
            String activeAtDisplay = dateFormatter.format(this.notification.getTimeStamp());
            String instanceId = activeAtDisplay + " " + RB.getString(AlertAction.class, "INSTANCE.message") + Configuration.INSTANCE.getInstanceId() + " ";
            String emoji = "";
            emoji = this.notification.getType().equals("recovery") ? " :thumbsup:\" }" : " :fire:\" }";
            String message = "{\"text\":\" " + this.notification.getMessage() + instanceId + emoji;
            this.notification.setSlack(true);
            this.setSlackMessageOnCompletion(action, "true", Messages.getString("SLACK_SUCCESS.message"));
        }
        catch (Exception ex) {
            this.setSlackMessageOnCompletion(action, "false", Messages.getString("SLACK_ERROR.message") + " " + ex.getMessage());
            logger.error("Alert: " + this.notification.getName() + ": Failed to send slack notification.", ex);
        }
    }

    private void setSlackMessageOnCompletion(Struct action, String success, String message) {
        action.put("success", (Object)success);
        action.put("message", (Object)message);
        this.appendMailMessage(message);
    }

    private void sendNotification(Struct action) {
        try {
            action.put("name", (Object)"sendmail");
            String subject = this.constructSubject();
            String mailBody = this.constructBody();
            this.notification.setMailBody(mailBody);
            this.notification.setMailSubject(subject);
            this.notification.setSendMail(true);
            action.put("success", (Object)"true");
            action.put("message", (Object)RB.getString(AlertAction.class, "MAIL_SENT.message"));
            logger.debug("Alert: " + this.config.getName() + ": Email notification to be sent.");
        }
        catch (Throwable t) {
            action.put("success", (Object)"false");
            String errorMsg = t.getMessage();
            this.notification.setSendMail(false);
            action.put("message", (Object)RB.getString(AlertAction.class, "MAIL_FAILURE.message", (Object)this.config.getName(), (Object)errorMsg));
            logger.error("Failed to send email notification.", t);
        }
    }

    private String constructSubject() {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
        String activeAtDisplay = dateFormatter.format(this.notification.getTimeStamp());
        String subject = "";
        subject = "recovery".equals(this.notification.getType()) ? RB.getString((Object)this, "recoveredmailsubject", (Object)this.config.getName(), (Object)activeAtDisplay) : RB.getString((Object)this, "activemailsubject", (Object)this.config.getName(), (Object)activeAtDisplay);
        return subject;
    }

    private String constructBody() {
        StringBuilder message = new StringBuilder(this.notification.getMessage());
        message.append(System.lineSeparator());
        message.append("Instance ID: " + Configuration.INSTANCE.getInstanceId());
        if (Configuration.INSTANCE.getClusterId() != null) {
            message.append(System.lineSeparator());
            message.append("Cluster: " + Configuration.INSTANCE.getClusterId());
        }
        if (Configuration.INSTANCE.getGroupId() != null) {
            message.append(System.lineSeparator());
            message.append("Group: " + Configuration.INSTANCE.getGroupName());
        }
        message.append(System.lineSeparator());
        if (this.mailMsg != null) {
            message.append(this.mailMsg.toString());
        }
        return message.toString();
    }

    private void createCFCArgs() {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
        String activeAtDisplay = dateFormatter.format(this.notification.getTimeStamp());
        this.cfcAlertArgs = new CFCAlertStruct();
        this.cfcAlertArgs.setAlertName(this.config.getName());
        this.cfcAlertArgs.setAlertDetailMessage(this.config.getMessage());
        this.cfcAlertArgs.setActiveAt(activeAtDisplay);
        this.cfcAlertArgs.setIsActive(true);
        if (this.threadDumpOverview != null) {
            this.cfcAlertArgs.setSnapshotFileName(this.threadDumpOverview);
        } else {
            this.cfcAlertArgs.setSnapshotFileName("");
        }
        if (this.actions.getCfcFqn() != null) {
            this.cfcAlertArgs.setAlertProcessingCFC(this.actions.getCfcFqn());
        } else {
            this.cfcAlertArgs.setAlertProcessingCFC("");
        }
    }

    public String dumpHeap(Struct action) {
        String fileName = ServiceFactory.getRuntimeService().getRootDir() + File.separator + "bin" + File.separator + "HeapDump-" + this.notification.getAlertId().toString() + ".hprof";
        try {
            HeapDump.dumpHeap(fileName, true);
            action.put("success", (Object)"true");
            action.put("message", (Object)RB.getString(AlertAction.class, "HEAP_DUMP_FILE_NAME.message", (Object)fileName));
            HeapDump.pushHeapDumpInfoToDataSource(this.notification.getAlertId().toString(), "alert-triggered");
            this.appendMailMessage(RB.getString(AlertAction.class, "HEAP_DUMP_FILE_NAME.message", (Object)fileName));
        }
        catch (Throwable th) {
            logger.warn("Exception while taking Heap Dump for Alert Id: " + this.notification.getAlertId().toString());
            action.put("success", (Object)"false");
            action.put("message", (Object)RB.getString(AlertAction.class, "HEAP_DUMP_ERROR.message"));
            this.appendMailMessage(RB.getString(AlertAction.class, "HEAP_DUMP_ERROR.message"));
        }
        return fileName;
    }

    private void invokeCFC(Struct action) {
        File cfcFile = new File(this.config.getActions().getCfcFqn().trim());
        if (!cfcFile.exists()) {
            logger.warn("Cfc not invoked for " + this.notification.getName() + "as CFC does not exist.");
            action.put("success", (Object)"false");
            action.put("message", (Object)RB.getString(AlertAction.class, "CFC_NOT_FOUND.message", (Object)this.notification.getName()));
            return;
        }
        CFCInvokeContext cfcContext = new CFCInvokeContext();
        cfcContext.enableMonitoring = false;
        cfcContext.useMappings = true;
        cfcContext.remoteAccess = false;
        cfcContext.cfcAlias = cfcContext.cfc = Utils.getCanonicalPath(cfcFile);
        cfcContext.doNotResolvePath = true;
        this.createCFCArgs();
        if (this.killedThreadsList != null) {
            this.cfcAlertArgs.setKilledThreadsList(this.killedThreadsList);
        }
        Object[] args = new Object[]{this.cfcAlertArgs.getCFCArgs()};
        cfcContext.setMethod("onAlertStart", args);
        try {
            action.put("success", (Object)"true");
            action.put("message", (Object)RB.getString(AlertAction.class, "CFC_INVOKE_SUCCESS.message", (Object)this.config.getName(), (Object)this.actions.getCfcFqn()));
            this.appendMailMessage(RB.getString(AlertAction.class, "CFC_INVOKE_SUCCESS.message", (Object)this.config.getName(), (Object)this.actions.getCfcFqn()));
            logger.debug("Alert: " + this.config.getName() + ": Invoked user-defined CFC: " + this.actions.getCfcFqn());
        }
        catch (Throwable t) {
            action.put("success", (Object)"false");
            action.put("message", (Object)RB.getString(AlertAction.class, "CFC_INVOKE_ERROR.message", (Object)this.config.getName(), (Object)this.actions.getCfcFqn(), (Object)t.getLocalizedMessage()));
            this.appendMailMessage(RB.getString(AlertAction.class, "CFC_INVOKE_ERROR.message", (Object)this.config.getName(), (Object)this.actions.getCfcFqn(), (Object)t.getLocalizedMessage()));
            logger.debug("Alert: " + this.config.getName() + ": Error invoking CFC " + this.actions.getCfcFqn() + " " + t.getLocalizedMessage());
        }
        FusionContext.setCurrent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killThreads(Struct action) {
        action.put("name", (Object)"kill-threads");
        long currentTime = System.currentTimeMillis();
        ThreadDictionary.FusionContextExtraInfo[] info = ThreadDictionary.getInstance().getCurrentValues();
        this.killedThreadsList = new ArrayList<String>();
        for (int i = 0; i < info.length; ++i) {
            ThreadDictionary.FusionContextExtraInfo fusionContextExtraInfo = info[i];
            synchronized (fusionContextExtraInfo) {
                long startedAt = info[i].getMonitorData().getRequestStartTime();
                if (this.ms != null && info[i].getMonitorData().getUri() != null && currentTime - startedAt > (long)(this.actions.getThreadKillThreshhold() * 1000)) {
                    logger.debug("thread killed for alert ? " + info[i].getMonitorData().getUri());
                    boolean success = ActiveRequestMonitor.INSTANCE.abortRequest(info[i].getThreadName());
                    if (this.killedThreadsList != null && success) {
                        this.killedThreadsList.add(info[i].getMonitorData().getTemplatePath());
                    }
                }
                logger.debug("thread URI and time spent ? " + info[i].getMonitorData().getUri() + " time spent " + (currentTime - startedAt));
                continue;
            }
        }
        logger.debug("killed thread size is " + this.killedThreadsList.size());
        if (this.killedThreadsList != null && this.killedThreadsList.size() > 0) {
            action.put("success", (Object)"true");
            action.put("value", (Object)RB.getString(AlertAction.class, "THREAD_KILLED.message", this.killedThreadsList.size()));
            action.put("message", (Object)RB.getString(AlertAction.class, "THREAD_KILLED.message", this.killedThreadsList.size()));
            this.appendMailMessage(RB.getString(AlertAction.class, "THREAD_KILLED.message", this.killedThreadsList.size()));
        } else {
            action.put("success", (Object)"true");
            action.put("message", (Object)RB.getString(AlertAction.class, "THREAD_KILLED_ERROR.message"));
            this.appendMailMessage(RB.getString(AlertAction.class, "THREAD_KILLED_ERROR.message"));
        }
    }

    private StringBuilder appendMailMessage(String msg) {
        if (!this.actions.isSendMail()) {
            return null;
        }
        if (this.mailMsg == null) {
            this.mailMsg = new StringBuilder();
            this.mailMsg.append(Messages.getString("ACTION_TAKEN.message"));
        }
        this.mailMsg.append(System.lineSeparator());
        this.mailMsg.append(msg);
        return this.mailMsg;
    }
}

