/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.alert;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.alert.AlertAction;
import coldfusion.monitor.alert.AlertConfig;
import coldfusion.monitor.alert.CustomAlertManager;
import coldfusion.monitor.alert.Notification;
import coldfusion.monitor.datastore.Client;
import coldfusion.monitor.datastore.JSONConverter;
import coldfusion.monitor.datastore.QueryBuilder;
import coldfusion.monitor.util.MonitoringServiceUtils;
import coldfusion.monitor.util.ThreadDictionary;
import coldfusion.runtime.Struct;
import coldfusion.util.RB;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class AlertUtils {
    private static Logger logger = CFLogs.SERVER_LOG;

    public static void triggerSchedulerBasedAlert() {
        try {
            AlertUtils.processJVMMemoryAlerts();
            AlertUtils.processCPUAlerts();
            AlertUtils.processHungAlert();
            AlertUtils.processSlowServerAlert();
            AlertUtils.processTimeOutAlerts();
            AlertUtils.processSystemMemoryAlert();
        }
        catch (Exception ex) {
            logger.error("Exception while triggering alerts", ex);
        }
    }

    private static void processJVMMemoryAlerts() {
        List<AlertConfig> alertConfigList = CustomAlertManager.INSTANCE.getAlertInstance("jvm");
        if (alertConfigList == null) {
            return;
        }
        try {
            AlertUtils.processJVMandCPUAlerts(alertConfigList);
        }
        catch (Exception ex) {
            logger.error("Exception while triggering JVM Memory alerts", ex);
        }
    }

    private static void processCPUAlerts() {
        List<AlertConfig> alertConfigList = CustomAlertManager.INSTANCE.getAlertInstance("cpu");
        if (alertConfigList == null) {
            return;
        }
        try {
            AlertUtils.processJVMandCPUAlerts(alertConfigList);
        }
        catch (Exception ex) {
            logger.error("Exception while triggering CPU alerts", ex);
        }
    }

    private static void processHungAlert() {
        List<AlertConfig> configList = CustomAlertManager.INSTANCE.getAlertInstance("hung");
        if (configList == null) {
            return;
        }
        for (AlertConfig config : configList) {
            if (!config.isActive()) continue;
            if (AlertUtils.isHung(config)) {
                if (AlertUtils.isAlertRaised(config)) continue;
                AlertUtils.raiseAlert(config, "");
                continue;
            }
            if (!AlertUtils.isAlertRaised(config)) continue;
            AlertUtils.recoverAlert(config);
        }
    }

    public static void processSlowServerAlert() {
        List<AlertConfig> configList = CustomAlertManager.INSTANCE.getAlertInstance("request");
        if (configList == null) {
            return;
        }
        for (AlertConfig config : configList) {
            if (!config.isActive() || !"AVERAGE_RESPONSE_TIME".equals(config.getCriterion()) || !config.isActive()) continue;
            String keyMetrics = AlertUtils.getKeyMetricsForAlert(config);
            String qry = AlertUtils.buildQuery(config);
            String latestIndex = MonitoringServiceUtils.getLatestRequestIndex();
            String jsonOutput = Client.get().query(AlertUtils.getRequestType(config), qry, null);
            logger.debug(config.getName() + " : query: " + qry + " result: " + jsonOutput);
            JsonNode node = JSONConverter.INSTANCE.toJsonNode(jsonOutput);
            StringBuilder bldr = null;
            String currentValue = null;
            if ("average".equals(config.getMetric())) {
                bldr = new StringBuilder();
            }
            if (AlertUtils.beyondThreshold(node, config, keyMetrics, bldr, null)) {
                if (AlertUtils.alertAlreadyRaised(config)) continue;
                if (bldr != null) {
                    currentValue = bldr.toString();
                }
                AlertUtils.raiseAlert(config, currentValue);
                continue;
            }
            if (!AlertUtils.alertAlreadyRaised(config)) continue;
            AlertUtils.recoverAlert(config);
        }
    }

    private static void raiseAlert(AlertConfig config, String currentValue) {
        logger.trace("raising alert for " + config.getDisplayName());
        Notification notification = new Notification();
        notification.setDisplayName(config.getDisplayName());
        notification.setAlertId(UUID.randomUUID());
        notification.setTimeStamp(System.currentTimeMillis());
        notification.setCriterion(config.getCriterion());
        notification.setName(config.getName());
        notification.setType(config.getType());
        notification.setValue(currentValue);
        notification.setRead(false);
        notification.setMessage(AlertUtils.getAlertMessage(config));
        CustomAlertManager.INSTANCE.getLiveAlerts().put(config.getName(), notification);
        AlertAction action = new AlertAction(config, notification);
        action.execute();
        Configuration setttings = Configuration.INSTANCE;
        notification.setClusterId(setttings.getClusterId());
        AlertUtils.setGlobalFilterId(notification);
        String alertJson = JSONConverter.toJson(notification);
        Client.get().indexDocument(alertJson, MonitoringServiceUtils.getLatestalertsIndex(), notification.getAlertId().toString());
        logger.debug("Raised alert being sent to DataSource " + alertJson);
    }

    private static void setGlobalFilterId(Notification notf) {
        String clusterId = Configuration.INSTANCE.getClusterId();
        String grpName = Configuration.INSTANCE.getGroupName();
        String grpId = Configuration.INSTANCE.getGroupId();
        String instanceId = Configuration.INSTANCE.getInstanceId();
        if (notf.getInstanceId() == null) {
            notf.setInstanceId(instanceId);
        }
        if (clusterId != null) {
            notf.setClusterId(clusterId);
        }
        notf.setGroupId(grpId);
        notf.setGroupName(grpName);
    }

    private static String getAlertMessage(AlertConfig config) {
        String message = "";
        message = config.getMetric() != null ? RB.getString(AlertUtils.class, config.getName() + "-" + config.getMetric() + ".message", config.getDisplayThreshold(), (Object)config.getDuration()) : ("hung".equals(config.getType()) ? RB.getString(AlertUtils.class, config.getName() + ".message", config.getHungThreadCount(), (Object)config.getBusyThreadTime()) : RB.getString(AlertUtils.class, config.getName() + ".message", config.getDisplayThreshold(), (Object)config.getDuration()));
        return message;
    }

    public static void recoverAlert(AlertConfig config) {
        if (!AlertUtils.isAlertAlreadyRaised(config)) {
            logger.trace("Alert already recovered for " + config.getName());
            return;
        }
        logger.debug("recovering Alert  for " + config.getName());
        Notification notification = AlertUtils.createNotificationForRaisingAlert(config);
        AlertAction action = new AlertAction(config, notification);
        action.recoverActions();
        String jsonAlert = AlertUtils.persistAlertNotification(config, notification);
        CustomAlertManager.INSTANCE.getLiveAlerts().remove(config.getName());
        logger.debug("Persisting recovery alert to DataSource " + jsonAlert);
    }

    private static String persistAlertNotification(AlertConfig config, Notification notif) {
        String jsonAlert = JSONConverter.toJson(notif);
        Client.get().indexDocument(jsonAlert, MonitoringServiceUtils.getLatestalertsIndex(), notif.getAlertId().toString());
        return jsonAlert;
    }

    private static boolean isAlertAlreadyRaised(AlertConfig config) {
        if (CustomAlertManager.INSTANCE.getLiveAlerts().get(config.getName()) != null) {
            logger.debug("Alert already raised for " + config.getName());
            return true;
        }
        logger.debug("Alert not raised for " + config.getName());
        return false;
    }

    private static Notification createNotificationForRaisingAlert(AlertConfig config) {
        long timeStamp = System.currentTimeMillis();
        Notification notification = new Notification();
        notification.setTimeStamp(timeStamp);
        notification.setDisplayName(config.getDisplayName());
        notification.setAlertId(UUID.randomUUID());
        notification.setCriterion(config.getCriterion());
        notification.setName(config.getName());
        notification.setType("recovery");
        notification.setMessage(RB.getString(AlertUtils.class, "RECOVERED.message", (Object)config.getDisplayName()));
        notification.setRead(false);
        notification.setRecoveredAlertId(CustomAlertManager.INSTANCE.getLiveAlerts().get(config.getName()).getAlertId());
        AlertUtils.setGlobalFilterId(notification);
        Configuration setttings = Configuration.INSTANCE;
        notification.setClusterId(setttings.getClusterId());
        if (notification.getInstanceId() == null) {
            notification.setInstanceId(Configuration.INSTANCE.getInstanceId());
        }
        return notification;
    }

    public static boolean isAlertRaised(AlertConfig config) {
        return AlertUtils.isAlertAlreadyRaised(config);
    }

    public static boolean isHung(AlertConfig config) {
        logger.debug("Evaluating UnresponsiveServerAlert");
        boolean hung = false;
        int currentHungThreadCount = 0;
        long currentTime = System.currentTimeMillis();
        ThreadDictionary.FusionContextExtraInfo[] info = ThreadDictionary.getInstance().getCurrentValues();
        for (int i = 0; i < info.length; ++i) {
            long startedAt = info[i].getMonitorData().getRequestStartTime();
            if (startedAt <= 0L || (currentTime - startedAt) / 1000L <= (long)config.getBusyThreadTime() || info[i].getMonitorData().getResponseCode() == 503) continue;
            logger.debug("hung request url " + info[i].getMonitorData().getTemplatePath());
            ++currentHungThreadCount;
        }
        if (currentHungThreadCount >= config.getHungThreadCount()) {
            hung = true;
        }
        logger.debug("Server Hung? " + hung + "current hung thread " + currentHungThreadCount);
        return hung;
    }

    public static void processTimeOutAlerts() {
        List<AlertConfig> configList = CustomAlertManager.INSTANCE.getAlertInstance("request");
        if (configList == null) {
            return;
        }
        for (AlertConfig config : configList) {
            if (!"timeout".equals(config.getCriterion()) || !config.isActive()) continue;
            logger.debug("Time Out Alert: processing starts");
            String keyMetrics = AlertUtils.getKeyMetricsForAlert(config);
            String qry = AlertUtils.buildQuery(config);
            String latestIndex = MonitoringServiceUtils.getLatestRequestIndex();
            String jsonOutput = Client.get().query(AlertUtils.getRequestType(config), qry, null);
            logger.debug(config.getName() + " : query: " + qry + " result: " + jsonOutput);
            JsonNode node = JSONConverter.INSTANCE.toJsonNode(jsonOutput);
            StringBuilder bldr = null;
            String currentValue = null;
            bldr = new StringBuilder();
            if (AlertUtils.beyondThreshold(node, config, keyMetrics, bldr, null)) {
                if (!AlertUtils.alertAlreadyRaised(config)) {
                    if (bldr != null) {
                        currentValue = bldr.toString();
                    }
                    AlertUtils.raiseAlert(config, currentValue);
                }
            } else if (AlertUtils.alertAlreadyRaised(config)) {
                AlertUtils.recoverAlert(config);
            }
            logger.debug("Time Out Alert: processing ends");
        }
    }

    private static void processJVMandCPUAlerts(List<AlertConfig> alertConfigList) {
        for (AlertConfig config : alertConfigList) {
            if (!config.isActive()) continue;
            logger.debug("evaluating alert " + config.getName() + ":" + config.getMetric() + config.getThreshold());
            String keyMetric = AlertUtils.getKeyMetricsForAlert(config);
            JsonNode queryResult = AlertUtils.getQueryResult(config);
            StringBuilder bldr = null;
            String currentValue = null;
            Struct valueMap = null;
            if ("average".equals(config.getMetric())) {
                bldr = new StringBuilder();
            } else if ("all".equals(config.getMetric())) {
                valueMap = new Struct();
            }
            if (AlertUtils.beyondThreshold(queryResult, config, keyMetric, bldr, valueMap)) {
                if (AlertUtils.alertAlreadyRaised(config)) continue;
                if (bldr != null) {
                    currentValue = bldr.toString();
                }
                AlertUtils.raiseAlert(config, currentValue);
                continue;
            }
            if (!AlertUtils.alertAlreadyRaised(config)) continue;
            if ("all".equals(config.getMetric())) {
                int count = (Integer)valueMap.get("count");
                if (count <= 0) continue;
                AlertUtils.recoverAlert(config);
                continue;
            }
            AlertUtils.recoverAlert(config);
        }
    }

    private static JsonNode getQueryResult(AlertConfig config) {
        String latestIndex = MonitoringServiceUtils.getLatestRequestIndex();
        String qry = AlertUtils.buildQuery(config);
        String jsonOutput = Client.get().query(AlertUtils.getRequestType(config), qry, null);
        logger.debug(config.getName() + " : query: " + qry + " result: " + jsonOutput);
        return JSONConverter.INSTANCE.toJsonNode(jsonOutput);
    }

    private static String getRequestType(AlertConfig config) {
        if ("request".equals(config.getType())) {
            return MonitoringServiceUtils.getLatestRequestIndex();
        }
        return MonitoringServiceUtils.getLatestNonRequestIndex();
    }

    private static String getKeyMetricsForAlert(AlertConfig config) {
        if (!"average".equals(config.getMetric())) {
            return "";
        }
        String keyMetrics = "";
        if ("JVM-CPU-USAGE-ALERT".equals(config.getName())) {
            keyMetrics = "avg_jvm_cpu_load";
        } else if ("SYSTEM-CPU-USAGE-ALERT".equals(config.getName())) {
            keyMetrics = "avg_system_cpu_load";
        } else if ("JVM-HEAP-MEMORY-USAGE-ALERT".equals(config.getName())) {
            keyMetrics = "avg_heap_usage";
        } else if ("JVM-METASPACE-MEMORY-USAGE-ALERT".equals(config.getName())) {
            keyMetrics = "avg_metaspace_usage";
        } else if ("OLD-GENERATION-MEMORY-USAGE-ALERT".equals(config.getName())) {
            keyMetrics = "avg_oldgen_usage";
        } else if ("CODE-CACHE-MEMORY-USAGE-ALERT".equals(config.getName())) {
            keyMetrics = "avg_codecache_usage";
        } else if ("SLOW-SERVER-ALERT".equals(config.getName())) {
            keyMetrics = "avg_response_time";
        } else if ("SYSTEM-MEMORY-USAGE-ALERT".equals(config.getName())) {
            keyMetrics = "avg_system_memory_usage";
        }
        return keyMetrics;
    }

    private static boolean beyondThreshold(JsonNode node, AlertConfig config, String keyMetric, StringBuilder bldr, Struct valueMap) {
        boolean match = false;
        if (node != null) {
            int count;
            if ("average".equals(config.getMetric())) {
                if (!node.hasNonNull("aggregations")) {
                    return false;
                }
                if (!node.get("aggregations").hasNonNull(keyMetric)) {
                    return false;
                }
                JsonNode metricNode = node.get("aggregations").get(keyMetric);
                double existingValue = metricNode.get("value").asDouble();
                if ("jvm".equals(config.getType()) || "system".equals(config.getType())) {
                    existingValue /= 1048576.0;
                }
                if (existingValue > config.getThreshold()) {
                    bldr.append(String.valueOf(existingValue));
                    return true;
                }
                match = false;
            } else if ("all".equals(config.getMetric())) {
                int count2 = Integer.parseInt(node.get("hits").get("total").get("value").toString());
                valueMap.put("count", (Object)count2);
                if (valueMap != null && count2 > 0) {
                    return false;
                }
                if (count2 == 0 && AlertUtils.getTotalDocumentCount(node, config) != 0) {
                    valueMap.put("count", (Object)count2);
                    return true;
                }
            } else if ("REQUEST-TIME-OUT".equals(config.getName()) && (double)(count = Integer.parseInt(node.get("hits").get("total").get("value").toString())) > config.getThreshold()) {
                bldr.append(String.valueOf(count));
                return true;
            }
        }
        return match;
    }

    private static String buildQuery(AlertConfig config) {
        String metric = config.getMetric();
        long duration = config.getDuration();
        String instanceId = Configuration.INSTANCE.getInstanceId();
        String cpuRange = "0";
        long threshold = (int)config.getThreshold();
        long currentTime = System.currentTimeMillis();
        long minTime = currentTime - duration * 1000L;
        String qry = null;
        if ("all".equals(metric)) {
            if ("jvm".equals(config.getType()) || "system".equals(config.getType())) {
                threshold = threshold * 1024L * 1024L;
            }
            qry = QueryBuilder.getQuery(AlertUtils.getTemplateId(config), Arrays.asList("instance_id", "min_time", "max_time", "cpu_range", AlertUtils.getQueryMetric(config)), Arrays.asList(instanceId, String.valueOf(minTime), String.valueOf(currentTime), cpuRange, String.valueOf(threshold)));
        } else if ("average".equals(metric)) {
            qry = QueryBuilder.getQuery(AlertUtils.getTemplateId(config), Arrays.asList("instance_id", "min_time", "max_time", "avg"), Arrays.asList(instanceId, String.valueOf(minTime), String.valueOf(currentTime), "true"));
        } else if ("REQUEST-TIME-OUT".equals(config.getName())) {
            qry = QueryBuilder.getQuery(AlertUtils.getTemplateId(config), Arrays.asList("instance_id", "min_time", "max_time", "cpu_range", "request_timeout"), Arrays.asList(instanceId, String.valueOf(minTime), String.valueOf(currentTime), cpuRange, "true"));
        }
        return qry;
    }

    private static String getQueryMetric(AlertConfig config) {
        if ("average".equals(config.getMetric())) {
            return "";
        }
        String keyMetrics = "";
        if ("JVM-CPU-USAGE-ALERT".equals(config.getName())) {
            keyMetrics = "jvm_cpu_range_value";
        } else if ("SYSTEM-CPU-USAGE-ALERT".equals(config.getName())) {
            keyMetrics = "system_cpu_range_value";
        } else if ("JVM-HEAP-MEMORY-USAGE-ALERT".equals(config.getName())) {
            keyMetrics = "jvm_heap_range_value";
        } else if ("JVM-METASPACE-MEMORY-USAGE-ALERT".equals(config.getName())) {
            keyMetrics = "jvm_meta_range_value";
        } else if ("OLD-GENERATION-MEMORY-USAGE-ALERT".equals(config.getName())) {
            keyMetrics = "jvm_oldgen_range_value";
        } else if ("CODE-CACHE-MEMORY-USAGE-ALERT".equals(config.getName())) {
            keyMetrics = "jvm_codecache_range_value";
        } else if ("SYSTEM-MEMORY-USAGE-ALERT".equals(config.getName())) {
            keyMetrics = "system_memory_range_value";
        }
        return keyMetrics;
    }

    private static String getTemplateId(AlertConfig config) {
        if ("request".equals(config.getType())) {
            return "coldfusion-request-alerts";
        }
        return "coldfusion-alerts";
    }

    private static boolean alertAlreadyRaised(AlertConfig config) {
        if (!CustomAlertManager.INSTANCE.getLiveAlerts().containsKey(config.getName())) {
            return false;
        }
        return AlertUtils.isAlertAlreadyRaised(config);
    }

    private static int getTotalDocumentCount(JsonNode node, AlertConfig config) {
        int count = 1;
        if (node.hasNonNull("aggregations") && node.get("aggregations").hasNonNull("global")) {
            JsonNode global = node.get("aggregations").get("global");
            count = Integer.parseInt(global.get("doc_count").toString());
            if (count == 0) {
                logger.debug("total documents count is zero ");
                return count;
            }
            ArrayNode bucket = (ArrayNode)global.get("all").get("non-gc").get("range_bound").get("buckets");
            count = Integer.parseInt(bucket.get(0).get("doc_count").toString());
            logger.debug("total documents in given time range  is  " + count);
        } else {
            count = 0;
        }
        return count;
    }

    private static void processSystemMemoryAlert() {
        List<AlertConfig> alertConfigList = CustomAlertManager.INSTANCE.getAlertInstance("system");
        if (alertConfigList == null) {
            return;
        }
        try {
            AlertUtils.processJVMandCPUAlerts(alertConfigList);
        }
        catch (Exception ex) {
            logger.error("Exception while triggering System Memory alert", ex);
        }
    }
}

