/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.beans;

import coldfusion.monitor.beans.VariableBean;
import coldfusion.monitor.memory.MemoryMonitor;
import coldfusion.monitor.util.ThreadMonitorData;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Struct;
import coldfusion.thread.ThreadScope;
import java.util.List;

public class CFThreadData {
    private String spawnedTemplate;
    private String threadName;
    private int lineNo;
    private long startTime;
    private long elapsedTime;
    private long functionLocalScopeMemory;
    private long threadScopeMemory;
    private String requestId;
    private Struct threadScopeMemoryData;

    public void populate(ThreadMonitorData tmd, NeoPageContext pageContext) {
        this.startTime = tmd.getStartTime();
        this.elapsedTime = tmd.getElapsedTime();
        this.spawnedTemplate = tmd.getTemplatePath();
        this.threadName = tmd.getThreadName();
        this.lineNo = tmd.getLineNo();
        this.requestId = tmd.getParentRequestMonitorData().getRequestId();
        LocalScope activeFunctionLocalScope = pageContext.getActiveFunctionLocalScope();
        ThreadScope threadScope = ThreadScope.getCurrent();
        if (MemoryMonitor.isEnabled()) {
            this.functionLocalScopeMemory = MemoryMonitor.getScopeMaxMemory(activeFunctionLocalScope);
            this.threadScopeMemory = MemoryMonitor.getScopeMaxMemory(threadScope);
            this.threadScopeMemoryData = new Struct();
            List<VariableBean> variablesMemory = MemoryMonitor.getVariablesMemory(threadScope);
            variablesMemory.remove("PRIORITY");
            variablesMemory.remove("ELAPSEDTIME");
            variablesMemory.remove("STARTTIME");
            variablesMemory.remove("OUTPUT");
            variablesMemory.remove("NAME");
            variablesMemory.remove("STATUS");
            this.threadScopeMemoryData.put("THREADSCOPESVARIABLES", (Object)variablesMemory);
        }
    }

    public void setThreadScopeMemory(long threadScopeMemory) {
        this.threadScopeMemory = threadScopeMemory;
    }

    public void setThreadScopeMemoryData(Struct threadScopeMemoryData) {
        this.threadScopeMemoryData = threadScopeMemoryData;
    }

    public void setFunctionLocalScopeMemory(long functionLocalScopeMemory) {
        this.functionLocalScopeMemory = functionLocalScopeMemory;
    }

    public void setSpawnedTemplate(String spawnedTemplate) {
        this.spawnedTemplate = spawnedTemplate;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setElapsedTime(long endTime) {
        this.elapsedTime = endTime;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }
}

