/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.beans;

import coldfusion.cloud.CloudServiceName;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.MonitoringConstants;
import coldfusion.monitor.active.ActiveRequestMonitor;
import coldfusion.monitor.beans.TagAttribute;
import coldfusion.monitor.beans.VariableBean;
import coldfusion.monitor.memory.MemoryCalculator;
import coldfusion.monitor.memory.MemoryTracker;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.monitor.memory.VariableStat;
import coldfusion.monitor.scheduler.TaskScheduler;
import coldfusion.monitor.sql.QueryStat;
import coldfusion.monitor.util.AttributeTypes;
import coldfusion.monitor.util.CodeMergeUtil;
import coldfusion.monitor.util.FunctionStat;
import coldfusion.monitor.util.MonitorConstants;
import coldfusion.monitor.util.PageElementStat;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.monitor.util.TagStat;
import coldfusion.runtime.Struct;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class RequestData {
    private String responseContentType;
    private String httpMethod;
    private String uri;
    private String url;
    private String queryParameters;
    private String clientIp;
    private String clientHost;
    private String templatePath;
    private String threadId;
    private String requestFunctionName;
    private long timeStamp;
    private long requestStartTime;
    private long requestEndTime;
    private long responseTime;
    private boolean isError;
    private String errorMessage;
    private String reqType;
    private long estimatedMaxMemory;
    private int responseCode;
    private boolean isTimeOut;
    private boolean rest;
    private boolean tagFunctionLimitExceeded;
    private String restUri;
    private String clusterId;
    private String groupId;
    private String instanceId;
    private String profilingId;
    private String connectorId;
    private String siteId;
    private String applicationName;
    private List<VariableBean> variables;
    private String requestId;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private List<Struct> tagList = new ArrayList<Struct>();
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private List<Struct> queryList = new ArrayList<Struct>();
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private List<Struct> functionList = new ArrayList<Struct>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Struct codeFlow = new Struct();
    private List<Map> cfThreadList = null;
    private String error = null;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private List<Struct> externalServicesList = new ArrayList<Struct>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> reqMap;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> respMap;
    private List cfSessions;
    private long sessionCount;
    private long loggedInUsersCount;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private List<Struct> cloudServicesList = new ArrayList<Struct>();
    private Struct requestScopeVariables;
    private String monitoring;
    private String jdk;
    private long dbOverhead;
    private long externalServiceOverhead;
    private long cloudServiceOverhead;
    private long graphqlServiceOverhead;
    private long cfOwnOverhead;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private List<Struct> graphqlQueryList = new ArrayList<Struct>();

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public List<Struct> getFunctionList() {
        return this.functionList;
    }

    public List<Struct> getCloudServicesList() {
        return this.cloudServicesList;
    }

    public void setFunctionList(List<Struct> functionList) {
        this.functionList = functionList;
    }

    public List<Struct> getExternalServicesList() {
        return this.externalServicesList;
    }

    public List<Struct> getTagList() {
        return this.tagList;
    }

    public void setExternalServicesList(List<Struct> externalServicesList) {
        this.externalServicesList = externalServicesList;
    }

    public List<Struct> getGraphqlQueryList() {
        return this.graphqlQueryList;
    }

    public void setGraphqlQueryList(List<Struct> graphqlQueryList) {
        this.graphqlQueryList = graphqlQueryList;
    }

    private void updateLoggedInUserCount() {
        this.loggedInUsersCount = ActiveRequestMonitor.INSTANCE.getLoggedInUserCount();
    }

    private void updatecfThreadaData(RequestMonitorData rmd) {
        this.cfThreadList = rmd.getThreadDataList();
    }

    public void setDbOverhead(long dbOverhead) {
        this.dbOverhead = dbOverhead;
    }

    public void setExternalServiceOverhead(long externalServiceOverhead) {
        this.externalServiceOverhead = externalServiceOverhead;
    }

    public void setCloudServiceOverhead(long cloudServiceOverhead) {
        this.cloudServiceOverhead = cloudServiceOverhead;
    }

    public void setGraphqlServiceOverhead(long graphqlServiceOverhead) {
        this.graphqlServiceOverhead = graphqlServiceOverhead;
    }

    public void setCfOwnOverhead(long cfOwnOverhead) {
        this.cfOwnOverhead = cfOwnOverhead;
    }

    public void updateData(RequestMonitorData rmd) {
        this.updateLoggedInUserCount();
        this.updateMemoryDetails(rmd);
        this.updateTagData(rmd);
        this.updatecfQueryData(rmd);
        this.updateVariables(rmd);
        this.updatecfErrorData(rmd);
        this.updatecfThreadaData(rmd);
        this.updateRequestHeaderAttributes(rmd);
    }

    private void updateHiddenScopeVariable(RequestMonitorData rmd) {
        Map hiddenScope = rmd.getHiddenScope();
        if (hiddenScope != null && hiddenScope.keySet() != null) {
            for (String scpType : hiddenScope.keySet()) {
                Object listVar = null;
                if (hiddenScope.get(scpType) == null) continue;
                Iterator itrScope = ((Map)hiddenScope.get(scpType)).entrySet().iterator();
                while (itrScope.hasNext()) {
                    Struct tempStore = new Struct();
                    Map.Entry entry = itrScope.next();
                    String varType = AttributeTypes.getAttributeType(entry.getValue());
                    VariableBean var = new VariableBean();
                    var.setType(varType);
                    var.setName(entry.getKey().toString());
                    var.setScope(scpType);
                    if ("SIMPLE".equals(varType)) {
                        String varValue = "";
                        if (entry.getValue() != null) {
                            varValue = entry.getValue().toString();
                        }
                        if (varValue.length() > 100) {
                            varValue = varValue.substring(0, 99);
                        }
                    }
                    if (rmd.shouldProfile() && rmd.isProfileMemory()) {
                        var.setSize(new Long(MemoryCalculator.calculateMemory(entry.getValue())));
                    }
                    this.variables.add(var);
                }
            }
        }
    }

    private void updateRequestHeaderAttributes(RequestMonitorData rmd) {
        this.responseContentType = rmd.getResponseContentType();
        this.httpMethod = rmd.getHttpMethod();
        this.uri = rmd.getUri();
        this.url = rmd.getUrl();
        this.queryParameters = rmd.getQueryParameters();
        this.templatePath = rmd.getTemplatePath();
        this.requestId = rmd.getRequestId();
        this.requestFunctionName = rmd.getRequestFunctionName();
        this.timeStamp = rmd.getRequestStartTime();
        this.requestStartTime = rmd.getRequestStartTime();
        this.requestEndTime = rmd.getRequestEndTime();
        this.responseTime = rmd.getResponseTime();
        this.reqType = rmd.getReqType();
        this.isError = rmd.isError();
        this.errorMessage = rmd.getErrorMessage();
        this.responseCode = rmd.getResponseCode();
        this.reqMap = rmd.getReqMap();
        this.respMap = rmd.getRespMap();
        this.isTimeOut = rmd.isTimeOut();
        this.threadId = rmd.getThreadId();
        this.clientHost = rmd.getClientHost();
        this.clientIp = rmd.getClientIp();
        this.applicationName = rmd.getApplicationName();
        this.rest = rmd.getRest();
        this.restUri = rmd.getRestUri();
        this.cfOwnOverhead = rmd.getResponseTime() - (this.dbOverhead + this.externalServiceOverhead + this.cloudServiceOverhead + this.graphqlServiceOverhead);
        Configuration settings = Configuration.INSTANCE;
        this.clusterId = settings.getClusterId();
        this.groupId = settings.getGroupId();
        this.instanceId = settings.getInstanceId();
        this.connectorId = this.clusterId == null || this.clusterId.isEmpty() ? Configuration.INSTANCE.getServerHostName() + ":" + Configuration.INSTANCE.getInstanceName() : settings.getClusterId();
        if (Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isTagMetrics()) {
            this.monitoring = "tag_metrics";
        }
        if (this.isError && rmd.getResponseCode() < 300) {
            this.responseCode = 500;
        }
        this.jdk = TaskScheduler.INSTANCE.getJvm();
    }

    public void updateSessions() {
        if (this.applicationName != null) {
            this.cfSessions = ActiveRequestMonitor.INSTANCE.getAllActiveSessions(this.applicationName, true);
            this.sessionCount = ActiveRequestMonitor.INSTANCE.getActiveSessionCount(this.applicationName);
        }
    }

    public void updateMemoryDetails(RequestMonitorData rmd) {
        if (Configuration.INSTANCE.getMonitorSettings().isCfMemoryMonitoringEnabled()) {
            MemoryTrackerProxy requestMTP = rmd.getRequestMTProxy();
            if (requestMTP == null) {
                return;
            }
            MemoryTracker mt = requestMTP.getBuiltInMemoryTracker();
            this.estimatedMaxMemory = mt.getEstimatedMaxMemory();
        }
    }

    public void updatecfQueryData(RequestMonitorData rmd) {
        if (!Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isQueryMetrics()) {
            return;
        }
        if (rmd.getQueryStatList() == null) {
            return;
        }
        HashMap<CallSite, QueryStat> qryMap = new HashMap<CallSite, QueryStat>();
        for (QueryStat st : rmd.getQueryStatList()) {
            if (qryMap.containsKey(st.getSql() + st.getLineNo())) {
                QueryStat tempStat = (QueryStat)qryMap.get(st.getSql() + st.getLineNo());
                tempStat.setExecutionTime((tempStat.getExecutionTime() * tempStat.getExecutionCount() + st.getExecutionTime()) / (long)(tempStat.getQryHitCount() + 1));
                tempStat.setQryHitCount(tempStat.getQryHitCount() + 1);
            } else {
                qryMap.put((CallSite)((Object)(st.getSql() + st.getLineNo())), st);
            }
            this.dbOverhead += st.getExecutionTime();
        }
        if (qryMap.values() != null) {
            for (QueryStat qrSt : qryMap.values()) {
                qrSt.setApplicationName(rmd.getApplicationName());
                qrSt.setInstanceId(Configuration.INSTANCE.getInstanceId());
                qrSt.setThreadId(rmd.getThreadId());
                this.queryList.add((Struct)qrSt.toMap());
            }
        }
    }

    public List<Struct> getQueryList() {
        return this.queryList;
    }

    private String getVariableType(int type) {
        switch (type) {
            case 0: {
                return "LOCAL";
            }
            case 1: {
                return "ARGUMENTS";
            }
            case 2: {
                return "THREAD";
            }
            case 3: {
                return "PAGE";
            }
            case 4: {
                return "THIS";
            }
            case 5: {
                return "REQUEST";
            }
            case 6: {
                return "SESSION";
            }
            case 7: {
                return "APPLICATION";
            }
            case 8: {
                return "SERVER";
            }
        }
        return "" + type;
    }

    public void updateTagData(RequestMonitorData rmd) {
        if (Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isTagMetrics() || rmd.hasExternalServices()) {
            this.tagFunctionLimitExceeded = rmd.isTagFunctionLimitExceeded();
            List<PageElementStat> pgElemList = rmd.getPageElementList();
            if (pgElemList == null) {
                return;
            }
            Iterator<PageElementStat> pageElementItr = pgElemList.iterator();
            ArrayList<String> tagStack = new ArrayList<String>();
            HashMap<String, Struct> tagMap = new HashMap<String, Struct>();
            HashMap<String, Struct> fnMap = new HashMap<String, Struct>();
            int fileHitCount = 0;
            long totalFileFunctionTime = 0L;
            List<TagAttribute> attrbtListFileFunctions = null;
            for (PageElementStat pageElementStat : pgElemList) {
                if (pageElementStat instanceof TagStat) {
                    this.updateTagMetrics(pageElementStat, tagMap);
                    tagStack.addAll(pageElementStat.getStackTrace().getStackFramesAsStrings());
                    tagStack.add("\n");
                    continue;
                }
                if (!(pageElementStat instanceof FunctionStat)) continue;
                if (this.isExternalTagPresent(pageElementStat.getTagAttributes())) {
                    this.updateStatWithExternalTag(pageElementStat);
                    this.updateTagMetrics(pageElementStat, tagMap);
                } else {
                    this.updateFunctionMetrics(pageElementStat, fnMap);
                }
                tagStack.addAll(pageElementStat.getStackTrace().getStackFramesAsStrings());
                tagStack.add("\n");
            }
            for (Struct struct : tagMap.values()) {
                this.updateTagList(struct);
                if (!MonitorConstants.TAGS_WITH_ATTRIBUTES.contains(struct.get("name")) || "cftransaction".equals(struct.get("name"))) continue;
                Struct extStruct = this.useNewStructForCfFile(struct);
                if (Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isExternalServicesMetrics()) {
                    List list = (List)extStruct.get("tag_attributes");
                    List<Struct> list1 = this.convertToListOfStruct(list);
                    extStruct.put("tag_attributes", (Object)list1);
                }
                this.externalServicesList.add(extStruct);
            }
            for (Map.Entry entry : fnMap.entrySet()) {
                Struct fnStruct = (Struct)entry.getValue();
                this.functionList.add(fnStruct);
                if (!MonitorConstants.FUNCTIONS_FOR_EXTERNAL_SERVICES.contains(fnStruct.get("name"))) continue;
                int currentHitCount = (Integer)fnStruct.get("hitcount");
                totalFileFunctionTime = (Long)fnStruct.get("time_taken") * (long)currentHitCount;
                fileHitCount += currentHitCount;
                attrbtListFileFunctions = this.updateTagAttributeList(attrbtListFileFunctions, fnStruct);
            }
            this.addFileFunctionsInExternalServiceList(fileHitCount, totalFileFunctionTime, attrbtListFileFunctions);
            if (rmd.shouldProfile()) {
                this.profilingId = rmd.getProfilingId();
                this.codeFlow.put("tag_stack", (Object)CodeMergeUtil.getInstance().mergeStackTrace(tagStack));
            }
        }
    }

    private List<Struct> convertToListOfStruct(List<TagAttribute> list) {
        ArrayList<Struct> list1 = new ArrayList<Struct>();
        for (int i = 0; i < list.size(); ++i) {
            Struct struct = new Struct();
            struct.put("attribute_name", (Object)list.get(i).getAttributeName());
            struct.put("attribute_value", list.get(i).getAttributeValue());
            list1.add(struct);
        }
        return list1;
    }

    private List<TagAttribute> updateTagAttributeList(List<TagAttribute> attrbtListFileFunctions, Struct fnStruct) {
        if (fnStruct.get("tag_attributes") != null) {
            if (attrbtListFileFunctions == null) {
                attrbtListFileFunctions = (List)fnStruct.get("tag_attributes");
            } else {
                attrbtListFileFunctions.addAll((List)fnStruct.get("tag_attributes"));
            }
        }
        return attrbtListFileFunctions;
    }

    private Struct useNewStructForCfFile(Struct st) {
        if ("cffile".equals(st.get("name"))) {
            Struct extStruct = new Struct();
            extStruct.put("name", (Object)"cffile");
            extStruct.put("hitcount", (Object)((Integer)st.get("hitcount")));
            extStruct.put("time_taken", (Object)((Long)st.get("time_taken")));
            extStruct.put("tag_attributes", (Object)((List)st.get("tag_attributes")));
            return extStruct;
        }
        return st;
    }

    private void addFileFunctionsInExternalServiceList(int fileFunctionHitCount, long totalFileFunctionTime, List<TagAttribute> attrbtListFileFunctions) {
        if (fileFunctionHitCount > 0) {
            Struct cffileStruct = null;
            Object attrbtListCFFile = null;
            for (Struct externalService : this.externalServicesList) {
                if (!"cffile".equals(externalService.get("name"))) continue;
                cffileStruct = externalService;
            }
            if (cffileStruct == null) {
                cffileStruct = new Struct();
                cffileStruct.put("name", (Object)"cffile");
                cffileStruct.put("hitcount", (Object)fileFunctionHitCount);
                cffileStruct.put("time_taken", (Object)(totalFileFunctionTime / (long)fileFunctionHitCount));
            } else {
                this.updateExistingCfFile(fileFunctionHitCount, totalFileFunctionTime, cffileStruct);
            }
            this.updateAttributeListForFileExternalService(attrbtListFileFunctions, cffileStruct);
        }
    }

    private void updateAttributeListForFileExternalService(List<TagAttribute> attrbtListFileFunctions, Struct cffileStruct) {
        if (Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isExternalServicesMetrics()) {
            if (cffileStruct.get("tag_attributes") != null) {
                List attrbtListCFFile = (List)cffileStruct.get("tag_attributes");
                attrbtListCFFile.addAll(attrbtListFileFunctions);
            } else {
                List<TagAttribute> attrbtListCFFile = attrbtListFileFunctions;
                cffileStruct.put("tag_attributes", (Object)attrbtListCFFile);
                this.externalServicesList.add(cffileStruct);
            }
        }
    }

    private void updateExistingCfFile(int fileHitCount, long totalFileFunctionTime, Struct cffileStruct) {
        long existingTimeTaken = (Long)cffileStruct.get("time_taken");
        int existingHitCount = (Integer)cffileStruct.get("hitcount");
        long avgCffileTime = (totalFileFunctionTime + existingTimeTaken * (long)existingHitCount) / (long)(existingHitCount + fileHitCount);
        cffileStruct.put("hitcount", (Object)(fileHitCount + existingHitCount));
        cffileStruct.put("time_taken", (Object)avgCffileTime);
    }

    private void updateFunctionMetrics(PageElementStat stat, Map<String, Struct> fnMap) {
        Struct mp = null;
        mp = this.processTagMetrics(stat, fnMap);
        if (this.isGraphQlService(stat)) {
            this.updateGraphQlData(stat);
        }
        if (this.isCloudService(stat)) {
            this.updateCloudServiceData(stat);
        } else if (MonitorConstants.FUNCTIONS_FOR_EXTERNAL_SERVICES.contains(stat.getName())) {
            List attrbtList = null;
            if (mp.get("tag_attributes") != null) {
                attrbtList = (List)mp.get("tag_attributes");
                if (stat.getTagAttributes() != null) {
                    attrbtList.addAll(stat.getTagAttributes());
                }
            } else {
                attrbtList = stat.getTagAttributes();
            }
            mp.put("tag_attributes", (Object)attrbtList);
            this.externalServiceOverhead += stat.getExecutionTime();
        }
    }

    private void updateTagMetrics(PageElementStat stat, Map<String, Struct> tagMap) {
        Struct mp = null;
        mp = this.processTagMetrics(stat, tagMap);
        if (MonitorConstants.TAGS_WITH_ATTRIBUTES.contains(stat.getName())) {
            List attrbtList = null;
            if (mp.get("tag_attributes") != null) {
                attrbtList = (List)mp.get("tag_attributes");
                if (stat.getTagAttributes() != null) {
                    attrbtList.addAll(stat.getTagAttributes());
                }
            } else {
                attrbtList = stat.getTagAttributes();
            }
            mp.put("tag_attributes", (Object)attrbtList);
            if (!"cftransaction".equals(stat.getName())) {
                this.externalServiceOverhead += stat.getExecutionTime();
            }
        }
    }

    private Struct processTagMetrics(PageElementStat stat, Map<String, Struct> dataMap) {
        Struct mp;
        if (dataMap.containsKey(stat.getName())) {
            mp = dataMap.get(stat.getName());
            int count = (Integer)mp.get("hitcount");
            long avg = (Long)mp.get("time_taken");
            mp.put("time_taken", (Object)((avg * (long)count + stat.getExecutionTime()) / (long)(count + 1)));
            mp.put("hitcount", (Object)(count + 1));
        } else {
            mp = new Struct();
            mp.put("name", (Object)stat.getName());
            mp.put("hitcount", (Object)1);
            mp.put("time_taken", (Object)stat.getExecutionTime());
        }
        dataMap.put(stat.getName(), mp);
        return mp;
    }

    private void updatecfErrorData(RequestMonitorData rmd) {
        if (rmd.getThrowable() == null) {
            return;
        }
        this.error = ExceptionUtils.getStackTrace((Throwable)rmd.getThrowable());
        if (this.error.length() * 2 > 32000) {
            this.error = this.error.substring(0, 200);
        }
    }

    private void updateVariables(RequestMonitorData rmd) {
        if (Configuration.INSTANCE.getMonitorSettings().isCfMemoryMonitoringEnabled()) {
            Iterator itr = rmd.getVariableStatsIterator();
            if (itr == null) {
                return;
            }
            ArrayList list = new ArrayList();
            while (itr.hasNext()) {
                list.add(itr.next());
            }
            Collections.sort(list, new Comparator(){

                public int compare(Object o1, Object o2) {
                    VariableStat vs1 = (VariableStat)o1;
                    VariableStat vs2 = (VariableStat)o2;
                    boolean condition = vs2.getScopeType() > vs1.getScopeType();
                    condition = condition || vs2.getScopeType() == vs1.getScopeType() && vs2.getMaxSize() > vs1.getMaxSize();
                    return condition ? 1 : 0;
                }
            });
            Iterator sortedItr = list.iterator();
            this.variables = new ArrayList<VariableBean>();
            while (sortedItr.hasNext()) {
                MemoryTracker memoryTracker;
                VariableBean var = new VariableBean();
                VariableStat stat = (VariableStat)sortedItr.next();
                var.setType(stat.getType());
                var.setName(stat.getName());
                var.setFunctionName(stat.getFunctionName());
                var.setTemplateName(stat.getTemplateName());
                var.setScope(this.getVariableType(stat.getScopeType()));
                var.setSize(stat.getMaxSize());
                if (stat.getMaxSize() > 0L) {
                    this.variables.add(var);
                    continue;
                }
                if (!"QUERY".equalsIgnoreCase(stat.getType()) || (memoryTracker = stat.getMemoryTracker()) == null) continue;
                long estimatedMemory = memoryTracker.getEstimatedMemory();
                var.setSize(estimatedMemory);
                if (estimatedMemory <= 0L) continue;
                this.variables.add(var);
            }
            this.updateHiddenScopeVariable(rmd);
        }
    }

    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    public String getProfilingId() {
        return this.profilingId;
    }

    public void setProfilingId(String profilingId) {
        this.profilingId = profilingId;
    }

    public boolean isTagFunctionLimitExceeded() {
        return this.tagFunctionLimitExceeded;
    }

    public void setTagFunctionLimitExceeded(boolean tagFunctionLimitExceeded) {
        this.tagFunctionLimitExceeded = tagFunctionLimitExceeded;
    }

    private boolean isCloudService(PageElementStat stat) {
        return stat != null && stat.getTagAttributes() != null && stat.getTagAttributes().stream().anyMatch(tag -> "service".equals(tag.getAttributeName()) && (CloudServiceName.fromName((String)tag.getAttributeValue()) != null || "MONGO_DB".equals(tag.getAttributeValue())));
    }

    private boolean isGraphQlService(PageElementStat stat) {
        if (stat != null && stat.getTagAttributes() != null) {
            Optional<TagAttribute> tagAttribute = this.findTagAttributeByName(stat.getTagAttributes(), "service");
            return tagAttribute != null ? tagAttribute.get().getAttributeValue().equals("GraphQL") : false;
        }
        return false;
    }

    private void updateCloudServiceData(PageElementStat stat) {
        Optional<TagAttribute> tagAttributeOptional;
        Struct cloudServiceData = new Struct();
        cloudServiceData.put("name", (Object)stat.getName());
        cloudServiceData.put("time_taken", (Object)stat.getExecutionTime());
        Optional<TagAttribute> tagAttribute = this.findTagAttributeByName(stat.getTagAttributes(), "service");
        String service = "";
        if (tagAttribute.isPresent()) {
            cloudServiceData.put("service", tagAttribute.get().getAttributeValue());
            service = (String)tagAttribute.get().getAttributeValue();
            stat.getTagAttributes().remove(tagAttribute.get());
        }
        if ((tagAttribute = this.findTagAttributeByName(stat.getTagAttributes(), "aliasname")).isPresent()) {
            cloudServiceData.put("aliasname", tagAttribute.get().getAttributeValue());
            stat.getTagAttributes().remove(tagAttribute.get());
        }
        if ((tagAttribute = this.findTagAttributeByName(stat.getTagAttributes(), "region")).isPresent()) {
            cloudServiceData.put("region", tagAttribute.get().getAttributeValue());
            stat.getTagAttributes().remove(tagAttribute.get());
        }
        String rn = null;
        Object rv = null;
        if ("MONGO_DB".equalsIgnoreCase(service)) {
            rn = "db";
        } else {
            this.cloudServiceOverhead += stat.getExecutionTime();
            switch (CloudServiceName.fromName(service)) {
                case SQS: {
                    rn = "queue";
                    break;
                }
                case SNS: {
                    rn = "topic";
                    if (this.findTagAttributeByName(stat.getTagAttributes(), rn).isPresent()) break;
                    rn = "subscription";
                    break;
                }
                case SERVICE_BUS: {
                    rn = "queue";
                    if (this.findTagAttributeByName(stat.getTagAttributes(), rn).isPresent()) break;
                    rn = "topic";
                    break;
                }
                case S3: {
                    rn = "bucket";
                    break;
                }
                case AZURE_BLOB: {
                    rn = "container";
                    break;
                }
                case STORAGE: {
                    rn = "bucket";
                    break;
                }
                case PUBSUB: {
                    rn = "topic";
                    break;
                }
            }
        }
        if (rn != null && (tagAttributeOptional = this.findTagAttributeByName(stat.getTagAttributes(), rn)).isPresent()) {
            cloudServiceData.put("rn", (Object)rn);
            cloudServiceData.put("rv", tagAttributeOptional.get().getAttributeValue());
        }
        List<TagAttribute> list = stat.getTagAttributes();
        if (Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isCloudServiceMetrics() && !"MONGO_DB".equalsIgnoreCase(service)) {
            if (list != null) {
                cloudServiceData.put("tag_attributes", (Object)this.convertToListOfStruct(list));
            }
        } else if (("MONGO_DB".equalsIgnoreCase(service) || CloudServiceName.DYNAMODB.name().equalsIgnoreCase(service)) && Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isQueryMetrics() && list != null) {
            cloudServiceData.put("tag_attributes", (Object)this.convertToListOfStruct(list));
        }
        this.cloudServicesList.add(cloudServiceData);
    }

    private void updateGraphQlData(PageElementStat stat) {
        Struct graphQlData = new Struct();
        graphQlData.put("function_name", (Object)stat.getName());
        graphQlData.put("time_taken", (Object)stat.getExecutionTime());
        if (Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isGraphqlMetricsEnabled()) {
            this.extractGenericDataFromTagAttribute(stat, graphQlData, MonitoringConstants.getGraphQlESKeys());
            if (stat.getTagAttributes() != null) {
                graphQlData.put("tag_attributes", (Object)this.convertToListOfStruct(stat.getTagAttributes()));
            }
        }
        this.graphqlServiceOverhead += stat.getExecutionTime();
        this.graphqlQueryList.add(graphQlData);
    }

    private void extractGenericDataFromTagAttribute(PageElementStat stat, Struct graphQlData, List<String> keys) {
        for (String key : keys) {
            Optional<TagAttribute> tagAttribute = this.findTagAttributeByName(stat.getTagAttributes(), key);
            if (!tagAttribute.isPresent()) continue;
            graphQlData.put(key, tagAttribute.get().getAttributeValue());
            stat.getTagAttributes().remove(tagAttribute.get());
        }
    }

    private boolean isExternalTagPresent(List<TagAttribute> tagAttributes) {
        return tagAttributes != null && tagAttributes.stream().anyMatch(tag -> "isExternal".equals(tag.getAttributeName()) && true == (Boolean)tag.getAttributeValue());
    }

    private boolean isExternalTagPresent(Struct stat) {
        return stat != null && stat.get("tag_attributes") != null && this.isExternalTagPresent((List)stat.get("tag_attributes"));
    }

    private void updateStatWithExternalTag(PageElementStat stat) {
        switch (stat.getName()) {
            case "CreateObject": {
                stat.setName("cfobject");
                break;
            }
            default: {
                stat.setName("cfinvoke");
            }
        }
    }

    private Optional<TagAttribute> findTagAttributeByName(List<TagAttribute> tagAttributes, String name) {
        if (tagAttributes == null || name == null) {
            return Optional.empty();
        }
        return tagAttributes.stream().filter(tag -> name.equals(tag.getAttributeName())).findFirst();
    }

    private void updateTagList(Struct st) {
        if (!this.isExternalTagPresent(st)) {
            this.tagList.add(st);
        } else {
            Optional<TagAttribute> tagAttribute = this.findTagAttributeByName((List)st.get("tag_attributes"), "isExternal");
            if (tagAttribute.isPresent()) {
                ((List)st.get("tag_attributes")).remove(tagAttribute.get());
            }
        }
    }
}

