/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.datastore;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.GenericSettings;
import coldfusion.monitor.MonitorSettings;
import coldfusion.monitor.alert.AlertConfig;
import coldfusion.monitor.beans.Cluster;
import coldfusion.monitor.beans.Group;
import coldfusion.monitor.beans.InstanceHeartbeat;
import coldfusion.runtime.Struct;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public enum JSONConverter {
    INSTANCE;

    private static ObjectMapper mapper;
    private static Logger logger;

    public static <T> List<T> getAllNodes(JsonNode jsonNode, String handle, Class type) {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (jsonNode.get(i) != null) {
            try {
                if (handle != null) {
                    list.add(mapper.treeToValue((TreeNode)jsonNode.get(i).get(handle), type));
                } else {
                    list.add(mapper.treeToValue((TreeNode)jsonNode.get(i), type));
                }
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return list;
    }

    public List<AlertConfig> toAlertSettings(String json) {
        List alertSettings = null;
        try {
            JsonNode jsonConfig = (JsonNode)mapper.readValue(json, JsonNode.class);
            alertSettings = (List)mapper.readValue(jsonConfig.get("_source").get("alert_config").toString(), (TypeReference)new TypeReference<List<AlertConfig>>(){});
        }
        catch (JsonParseException | JsonMappingException jsonEx) {
            logger.error(jsonEx);
        }
        catch (IOException ioEx) {
            logger.error(ioEx);
        }
        return alertSettings;
    }

    public <T> T getNode(String json, Class<T> type) {
        Object object = null;
        try {
            JsonNode jsonConfig = (JsonNode)mapper.readValue(json, JsonNode.class);
            object = mapper.treeToValue((TreeNode)jsonConfig.get("_source"), type);
        }
        catch (JsonParseException | JsonMappingException jsonEx) {
            logger.error(jsonEx);
        }
        catch (IOException ioEx) {
            logger.error(ioEx);
        }
        return (T)object;
    }

    public <T> T structToBean(Struct struct, Class<T> clazz) {
        return (T)mapper.convertValue((Object)struct, clazz);
    }

    public List<InstanceHeartbeat> toInstanceHeartBeatList(String response, List<Object> path, String handle) {
        JsonNode jsonNode = this.getJsonNode(response, path);
        List<InstanceHeartbeat> instanceHeartBeatList = JSONConverter.getAllNodes(jsonNode, handle, InstanceHeartbeat.class);
        return instanceHeartBeatList;
    }

    public JsonNode getJsonNode(String json, List<Object> path) {
        JsonNode jsonNode = null;
        try {
            jsonNode = (JsonNode)mapper.readValue(json, JsonNode.class);
        }
        catch (Exception e) {
            logger.debug(e.getStackTrace());
        }
        if (path != null) {
            for (int i = 0; i < path.size() && jsonNode != null; ++i) {
                if (path.get(i) instanceof String) {
                    jsonNode = jsonNode.get((String)path.get(i));
                    continue;
                }
                if (!(path.get(i) instanceof Integer)) continue;
                jsonNode = jsonNode.get(((Integer)path.get(i)).intValue());
            }
        }
        return jsonNode;
    }

    public MonitorSettings toMonitorSettings(String json) {
        MonitorSettings mntrSettings = null;
        try {
            JsonNode jsonConfig = (JsonNode)mapper.readValue(json, JsonNode.class);
            mntrSettings = (MonitorSettings)mapper.treeToValue((TreeNode)jsonConfig.get("_source"), MonitorSettings.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            logger.error(e);
        }
        catch (IOException ioEx) {
            logger.error(ioEx);
        }
        return mntrSettings;
    }

    public GenericSettings toGenericObject(String json) {
        GenericSettings genSettings = null;
        try {
            JsonNode jsonConfig = (JsonNode)mapper.readValue(json, JsonNode.class);
            genSettings = (GenericSettings)mapper.treeToValue((TreeNode)jsonConfig.get("_source"), GenericSettings.class);
        }
        catch (JsonParseException | JsonMappingException ex) {
            logger.error(ex);
        }
        catch (IOException ioEx) {
            logger.error(ioEx);
        }
        return genSettings;
    }

    public String getClusterQuery(String instnaceId) {
        ObjectNode returnQuery = INSTANCE.getMapper().createObjectNode();
        ObjectNode topQuery = INSTANCE.getMapper().createObjectNode();
        ObjectNode nested = INSTANCE.getMapper().createObjectNode();
        ObjectNode path = INSTANCE.getMapper().createObjectNode();
        nested.put("path", "instances");
        ObjectNode instnace = INSTANCE.getMapper().createObjectNode();
        instnace.put("instances.instance_id", instnaceId);
        ObjectNode match = INSTANCE.getMapper().createObjectNode();
        match.put("match", (JsonNode)instnace);
        nested.put("query", (JsonNode)match);
        topQuery.put("nested", (JsonNode)nested);
        returnQuery.put("query", (JsonNode)topQuery);
        return returnQuery.toString();
    }

    public JsonNode toJsonNode(String json) {
        JsonNode jsonNode = null;
        try {
            jsonNode = (JsonNode)mapper.readValue(json, JsonNode.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            logger.error(e);
        }
        catch (IOException e) {
            logger.error(e);
        }
        return jsonNode;
    }

    public Group toGroupObject(String json) {
        Group groupObj = null;
        try {
            JsonNode jsonNode = (JsonNode)mapper.readValue(json, JsonNode.class);
            ArrayList<String> path = new ArrayList<String>();
            path.add("hits");
            path.add("hits");
            if (path != null && jsonNode != null) {
                for (String key : path) {
                    jsonNode = jsonNode.get(key);
                }
            }
            if (jsonNode != null && jsonNode.get(0) != null) {
                groupObj = (Group)mapper.treeToValue((TreeNode)jsonNode.get(0).get("_source"), Group.class);
            }
        }
        catch (JsonParseException | JsonMappingException e) {
            logger.error(e);
        }
        catch (IOException e) {
            logger.error(e);
        }
        return groupObj;
    }

    public Cluster toClusterObject(String json) {
        Cluster clusterObj = null;
        try {
            JsonNode jsonNode = (JsonNode)mapper.readValue(json, JsonNode.class);
            ArrayList<String> path = new ArrayList<String>();
            path.add("hits");
            path.add("hits");
            if (path != null && jsonNode != null) {
                for (String key : path) {
                    jsonNode = jsonNode.get(key);
                }
            }
            if (jsonNode != null && jsonNode.get(0) != null) {
                clusterObj = (Cluster)mapper.treeToValue((TreeNode)jsonNode.get(0).get("_source"), Cluster.class);
            }
        }
        catch (JsonParseException | JsonMappingException e) {
            logger.error(e);
        }
        catch (IOException e) {
            logger.error(e);
        }
        return clusterObj;
    }

    public static String toJson(Object obj) {
        String json = "";
        try {
            json = mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            logger.error(e);
        }
        return json;
    }

    public static Map toMap(Object obj) {
        Map data = null;
        try {
            data = (Map)mapper.convertValue(obj, Map.class);
        }
        catch (Throwable e) {
            logger.error(e);
        }
        return data;
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }

    static {
        mapper = new ObjectMapper();
        logger = CFLogs.MONITOR_LOG;
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

