/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.discovery;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.discovery.CFMonitoringMulticastService;
import coldfusion.util.RB;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;

public class CFMultiCastMessageReciever
implements Runnable {
    private MulticastSocket multicastSocket;
    private volatile boolean listen = true;
    public static byte APS_MAGIC_BYTE = (byte)17;
    private Logger LOG = CFLogs.MONITOR_LOG;
    private String APSUPMESSAGE = "APS_UP";
    private CFMonitoringMulticastService cfMonitoringMulticastService;

    public CFMultiCastMessageReciever(CFMonitoringMulticastService cfMonitoringMulticastService) {
        this.cfMonitoringMulticastService = cfMonitoringMulticastService;
        this.multicastSocket = cfMonitoringMulticastService.getMcSocket();
    }

    @Override
    public void run() {
        this.LOG.debug("Starting MultiCast socket listener.");
        while (this.listen) {
            try {
                byte[] inbuf = new byte[1024];
                DatagramPacket packet = new DatagramPacket(inbuf, inbuf.length);
                this.multicastSocket.receive(packet);
                this.parseMessage(packet);
            }
            catch (IOException e) {
                this.LOG.debug(RB.getString(CFMultiCastMessageReciever.class, "MulticastNotificationReceiveError"), e);
            }
        }
    }

    private void parseMessage(DatagramPacket packet) {
        String data = null;
        byte[] dataInput = packet.getData();
        if (dataInput != null && dataInput[0] == APS_MAGIC_BYTE) {
            data = new String(dataInput, 1, packet.getLength() - 1);
        }
        if (dataInput != null && dataInput[0] == APS_MAGIC_BYTE && data != null && !data.isEmpty() && this.APSUPMESSAGE.equalsIgnoreCase(data)) {
            this.cfMonitoringMulticastService.broadcastNodeUpMessage();
        }
    }

    public void stopListening() {
        this.listen = false;
    }
}

