/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.error;

import coldfusion.monitor.event.RequestEvent;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.server.InMemoryMonitoringService;
import coldfusion.server.ServiceFactory;

public enum RequestErrorMonitor {
    INSTANCE;

    private long timedOutRequestsCounter = 0L;
    private int requestErrorsCounter = 0;

    public void record(RequestEvent e) {
        if (e.getError() != null) {
            Throwable ex = e.getError();
            InMemoryMonitoringService inMemoryMonitoringService = ServiceFactory.getInMemoryMonitoringService();
            if (ex instanceof RequestTimedOutException) {
                e.getRequestMonitorData().setTimeOut(true);
                if (inMemoryMonitoringService != null && inMemoryMonitoringService.isMonitoringEnabled()) {
                    ++this.timedOutRequestsCounter;
                }
            } else if (inMemoryMonitoringService != null && inMemoryMonitoringService.isMonitoringEnabled()) {
                ++this.requestErrorsCounter;
            }
        }
    }

    public long getTimedOutRequestsCount() {
        return this.timedOutRequestsCounter;
    }

    public int getRequestErrorsCount() {
        return this.requestErrorsCounter;
    }

    public void reset() {
        this.requestErrorsCounter = 0;
        this.timedOutRequestsCounter = 0L;
    }
}

