/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.event;

import coldfusion.filter.FormScope;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.MonitoringConstants;
import coldfusion.monitor.active.ActiveRequestMonitor;
import coldfusion.monitor.aliasing.AliasManager;
import coldfusion.monitor.beans.CFThreadData;
import coldfusion.monitor.beans.RequestData;
import coldfusion.monitor.beans.TagAttribute;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.datastore.Client;
import coldfusion.monitor.datastore.JSONConverter;
import coldfusion.monitor.error.RequestErrorMonitorEventHandler;
import coldfusion.monitor.event.FunctionEvent;
import coldfusion.monitor.event.RequestEvent;
import coldfusion.monitor.event.TagEvent;
import coldfusion.monitor.event.ThreadEvent;
import coldfusion.monitor.inmemory.TimingRequestMonitor;
import coldfusion.monitor.memory.MemoryRequestEventHandler;
import coldfusion.monitor.sql.QueryMonitor;
import coldfusion.monitor.sql.QueryStat;
import coldfusion.monitor.stack.CFStack;
import coldfusion.monitor.stack.CFStackFrame;
import coldfusion.monitor.throttle.RequestThrottleMonitor;
import coldfusion.monitor.timing.TimingRequestEventHandler;
import coldfusion.monitor.util.CFThreadMonitorData;
import coldfusion.monitor.util.CallableThreadMonitorData;
import coldfusion.monitor.util.CommonUtil;
import coldfusion.monitor.util.MonitorConstants;
import coldfusion.monitor.util.MonitoringServiceUtils;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.monitor.util.ThreadDictionary;
import coldfusion.monitor.util.ThreadMonitorData;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.async.CallableUDFMethod;
import coldfusion.server.InMemoryMonitoringService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.GenericTag;
import coldfusion.thread.Task;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class RequestMonitorEventProcessor {
    private static MemoryRequestEventHandler memReqEventHandler = new MemoryRequestEventHandler();
    private static TimingRequestEventHandler timingReqEventHandler = new TimingRequestEventHandler();
    private static RequestErrorMonitorEventHandler reqErrorEventHandler = new RequestErrorMonitorEventHandler();
    private static ThreadDictionary td = ThreadDictionary.getInstance();
    private static String pathToCfadmin;
    private static Logger logger;

    public static void onRequestStart() {
        if (Configuration.INSTANCE.isMonitoringEnabled()) {
            InMemoryMonitoringService inMemoryMonitoringService;
            RequestMonitorData rmd = RequestMonitorData.setup(false);
            if (rmd != null) {
                rmd.setRequestStartTime(System.currentTimeMillis());
            }
            if ((inMemoryMonitoringService = ServiceFactory.getInMemoryMonitoringService()) != null && inMemoryMonitoringService.isMonitoringEnabled()) {
                rmd.setRequestStartTime(System.currentTimeMillis());
            }
        }
    }

    public static void createRequestURI(FusionContext context, RequestMonitorData rmd) {
        int i;
        Object reqURI = "";
        String qp = "";
        StringBuffer curl = context.request.getRequestURL();
        String curi = context.request.getRequestURI();
        if (curl != null && curi != null && (i = curl.indexOf("/")) != -1) {
            String urlwithoutpath = curl.toString();
            if (i + 2 < curl.length() && curl.indexOf("/", i + 2) != -1) {
                urlwithoutpath = curl.substring(0, curl.indexOf("/", i + 2));
            }
            reqURI = urlwithoutpath + curi;
            qp = context.request.getQueryString();
            if (qp != null) {
                reqURI = (String)reqURI + "?" + qp;
                if (Configuration.INSTANCE.isCodeProfilerOn() && "URL".equals(Configuration.INSTANCE.getprofilingLevel())) {
                    rmd.setReqParamMap(context.request.getParameterMap());
                }
            }
        }
        rmd.setUri(curl.toString());
        rmd.setUrl(curl.toString());
        rmd.setQueryParamters(qp);
    }

    public static void onRequestInit(String reqType) {
        InMemoryMonitoringService inMemoryMonitoringService;
        FusionContext context;
        RequestMonitorData rmd;
        if (Configuration.INSTANCE.isMonitoringEnabled() && (rmd = RequestMonitorData.getCurrent()) != null) {
            String requestId = "Request:" + UUID.randomUUID().toString();
            rmd.setRequestId(requestId);
            logger.debug("starting request:" + requestId);
            context = FusionContext.getCurrent();
            String method = "";
            if (context.request != null) {
                RequestMonitorEventProcessor.createRequestURI(context, rmd);
                if (context.request.getMethod() != null) {
                    method = context.request.getMethod();
                }
            }
            rmd.setHttpMethod(method);
            String templatePath = context.getPagePath();
            rmd.setTemplatePath(templatePath);
            rmd.setDoMonitor(RequestMonitorEventProcessor.doMonitor(rmd.getTemplatePath()));
            rmd.setReqType(reqType);
            if (rmd.doMonitor()) {
                AliasManager almgr = AliasManager.getinstance();
                if (almgr.isAliased(templatePath)) {
                    String[] param = almgr.getAliasDetail(templatePath).getParameters();
                    int paramLength = param.length;
                    String[][] aliasParam = new String[paramLength][2];
                    Map urlScope = (Map)context.hiddenScope.get("URL");
                    FormScope formScope = context.getFormScope();
                    for (int i = 0; i < param.length; ++i) {
                        if (urlScope.get(param[i]) != null) {
                            aliasParam[i][0] = param[i];
                            aliasParam[i][1] = (String)urlScope.get(param[i]);
                            continue;
                        }
                        aliasParam[i][0] = param[i];
                        aliasParam[i][1] = (String)formScope.get(param[i]);
                    }
                    rmd.setAliasParameters(aliasParam);
                    rmd.setAliasName(RequestMonitorEventProcessor.initKey(rmd.getTemplatePath(), aliasParam, almgr));
                }
                td.set(context);
            }
            FusionContext fc = FusionContext.getCurrent();
            if (rmd.getApplicationName() == null && fc.getApplicationName() != null) {
                rmd.setApplicationName(fc.getApplicationName());
                if (!fc.getApplicationName().isEmpty() && !Configuration.INSTANCE.checkIfAppExists(fc.getApplicationName())) {
                    Configuration.INSTANCE.updateAppList(fc.getApplicationName(), rmd.getRest());
                }
            }
            rmd.setProfileUrl(RequestMonitorEventProcessor.shouldUrlBeProfiled(rmd));
            rmd.setProfileMemory(Configuration.INSTANCE.isMemoryProfilerOn());
            rmd.setProfilingId(Configuration.INSTANCE.getProfileId());
            if (rmd.getRequestScope() != null) {
                boolean setMemoryProxy = false;
                if (rmd.shouldProfile() && rmd.isProfileMemory()) {
                    setMemoryProxy = true;
                }
                rmd.getRequestScope().setScopeType(5, setMemoryProxy);
            }
        }
        if ((inMemoryMonitoringService = ServiceFactory.getInMemoryMonitoringService()) != null && inMemoryMonitoringService.isMonitoringEnabled() && RequestMonitorData.getCurrent() != null) {
            RequestMonitorData rmd2 = RequestMonitorData.getCurrent();
            context = FusionContext.getCurrent();
            if (context.request != null) {
                rmd2.setReqType(reqType);
                rmd2.setTemplatePath(context.getPagePath());
            }
        }
    }

    private static boolean shouldUrlBeProfiled(RequestMonitorData rmd) {
        Configuration settings = Configuration.INSTANCE;
        if (!settings.isCodeProfilerOn()) {
            return false;
        }
        if ("SERVER".equals(settings.getprofilingLevel())) {
            return true;
        }
        if ("URL".equals(settings.getprofilingLevel()) && settings.validateUrlForProfiling(rmd.getUrl(), rmd.getReqParamMap())) {
            return true;
        }
        return "APPLICATION".equals(settings.getprofilingLevel()) && rmd.getApplicationName() != null && settings.getListToProfile().contains(rmd.getApplicationName());
    }

    private static String initKey(String templatePath, String[][] actionParams, AliasManager almgr) {
        Object key = almgr.getAliasDetail(templatePath).getAliasName() + "?";
        for (int out = 0; out < actionParams.length; ++out) {
            if (actionParams[out][0] == null) continue;
            String value = actionParams[out][1] != null ? actionParams[out][1] : "";
            key = (String)key + actionParams[out][0] + "=" + value + ",";
        }
        key = ((String)key).substring(0, ((String)key).length() - 1);
        return key;
    }

    public static void onCallableThreadStart(CallableUDFMethod task2) {
        CallableThreadMonitorData tmd = new CallableThreadMonitorData(task2);
        String templatePath = task2.getFusContext().getPagePath();
        tmd.setTemplatePath(templatePath);
        if (Configuration.INSTANCE.isMonitoringEnabled()) {
            RequestMonitorEventProcessor.onThreadStart(task2.getParentRmd(), task2.getJavaThreadName(), tmd);
        }
    }

    private static void onThreadStart(RequestMonitorData parentRmd, String threadName, ThreadMonitorData tmd) {
        tmd.setDoMonitor(RequestMonitorEventProcessor.doMonitor(tmd.getTemplatePath()));
        ThreadEvent e = new ThreadEvent();
        e.populate(tmd);
        timingReqEventHandler.onThreadStart(e);
    }

    public static void onCFThreadStart(RequestMonitorData parentRmd, String threadName, int lineno, Task task2) {
        CFThreadMonitorData tmd = new CFThreadMonitorData(parentRmd, threadName, lineno, task2);
        String templatePath = FusionContext.getCurrent().getPagePath();
        tmd.setTemplatePath(templatePath);
        if (Configuration.INSTANCE.isMonitoringEnabled()) {
            RequestMonitorEventProcessor.onThreadStart(parentRmd, threadName, tmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onThreadEnd(NeoPageContext pageContext) {
        ThreadMonitorData tmd = (ThreadMonitorData)RequestMonitorData.getCurrent(true);
        try {
            if (Configuration.INSTANCE.isMonitoringEnabled() && tmd != null && !tmd.isError() && tmd.doMonitor()) {
                if (tmd.getParentRequestMonitorData().isRmdReadyToPersist()) {
                    RequestMonitorEventProcessor.updateRMD(tmd);
                } else {
                    logger.debug("updating thread data in request data inmemory");
                    tmd.getParentRequestMonitorData().addPageElementList(tmd.getPageElementList());
                }
                ThreadEvent e = new ThreadEvent();
                e.populate(tmd);
                e.setPageContext(pageContext);
                timingReqEventHandler.onThreadEnd(e);
                memReqEventHandler.onThreadEnd(e);
                CFThreadData cfThreadData = new CFThreadData();
                cfThreadData.populate(tmd, pageContext);
                String json = JSONConverter.toJson(cfThreadData);
                logger.debug("submit thread data to ElasticSearch " + cfThreadData);
                Client.get().submit(json, MonitoringServiceUtils.getLatestthreadIndex());
            }
        }
        finally {
            if (tmd != null) {
                tmd.destroy();
            }
        }
    }

    private static void updateRMD(ThreadMonitorData tmd) {
        RequestData rdc = new RequestData();
        rdc.updateTagData(tmd);
        rdc.updatecfQueryData(tmd);
        rdc.setRequestId(tmd.getParentRequestMonitorData().getRequestId());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(MonitoringConstants.CLOUDSERVICESLIST, rdc.getCloudServicesList());
        params.put(MonitoringConstants.FUNCTIONLIST, rdc.getFunctionList());
        params.put(MonitoringConstants.EXTERNALSERVICESLIST, rdc.getExternalServicesList());
        params.put(MonitoringConstants.TAGLIST, rdc.getTagList());
        params.put(MonitoringConstants.QUERYLIST, rdc.getQueryList());
        params.put(MonitoringConstants.GRAPHQLQUERYLIST, rdc.getGraphqlQueryList());
        Client.get().update(MonitoringServiceUtils.getLatestRequestIndex(), rdc.getRequestId(), MonitoringConstants.SCRIPTTOUPDATERMDFROMTMD, params);
    }

    public static void setRequestFunctionName(String functionName) {
        RequestMonitorData rmd;
        if (Configuration.INSTANCE.isMonitoringEnabled() && (rmd = RequestMonitorData.getCurrent()) != null) {
            rmd.setRequestFunctionName(functionName);
        }
    }

    public static void onRequestComplete() {
        if (Configuration.INSTANCE.isMonitoringEnabled() && RequestMonitorData.getCurrent() != null) {
            RequestMonitorData rmd = RequestMonitorData.getCurrent();
            RequestMonitorEventProcessor.updateHeaderAttributes(rmd);
            if (rmd != null && !rmd.isError() && rmd.doMonitor() && Configuration.INSTANCE.getMonitorSettings().isCfMemoryMonitoringEnabled()) {
                rmd.setHiddenScope(FusionContext.getCurrent().hiddenScope);
            }
            FusionContext ct = null;
            RequestMonitorData remd = null;
            td.set(ct);
            td.set(remd);
        }
    }

    public static void onRequestEnd() {
        RequestMonitorData rmd;
        InMemoryMonitoringService inMemoryMonitoringService;
        if (Configuration.INSTANCE.isMonitoringEnabled() && RequestMonitorData.getCurrent() != null) {
            RequestMonitorData rmd2 = RequestMonitorData.getCurrent();
            rmd2.setRequestEndTime(System.currentTimeMillis());
            long responseTime = rmd2.getRequestEndTime() - rmd2.getRequestStartTime();
            long responseTimeThreshold = Configuration.INSTANCE.getMonitorSettings().getResponseTimeThreshold();
            if (RequestMonitorEventProcessor.shouldUrlBeProfiled(rmd2) && Configuration.INSTANCE.getCodeProfilingRecord() != null) {
                responseTimeThreshold = Configuration.INSTANCE.getCodeProfilingRecord().getResponseTimeThreshold();
            }
            if (rmd2.getUri() != null && rmd2.doMonitor() && (responseTime > responseTimeThreshold || rmd2.isError())) {
                rmd2.setRmdReadyToPersist(true);
                RequestData rdc = new RequestData();
                rdc.updateData(rmd2);
                if (rmd2.getQeReqId() != null) {
                    Client.get().indexDocument(JSONConverter.toJson(rdc), "/" + MonitoringServiceUtils.getLatestRequestIndex() + "/" + rmd2.getQeReqId(), 1);
                } else {
                    Client.get().submit(rdc);
                }
            }
        }
        if ((inMemoryMonitoringService = ServiceFactory.getInMemoryMonitoringService()) != null && inMemoryMonitoringService.isMonitoringEnabled() && RequestMonitorData.getCurrent() != null && (rmd = RequestMonitorData.getCurrent()).getTemplatePath() != null) {
            rmd.setRequestEndTime(System.currentTimeMillis());
            RequestEvent e = new RequestEvent();
            e.populate(rmd);
            if (!rmd.isError()) {
                TimingRequestMonitor.INSTANCE.record(e);
            }
        }
        RequestMonitorData.teardown();
    }

    public static void onTagStart(GenericTag tag) {
        CFStack cfStack;
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (RequestMonitorEventProcessor.shouldProcessTag(tag, rmd) && !rmd.isTagFunctionLimitExceeded() && (cfStack = rmd.getCFStack()) != null) {
            FusionContext fContext = FusionContext.getCurrent();
            String templateName = fContext.getPagePath();
            int lineNo = fContext.pageContext.getCurrentLineNo();
            String calledName = tag.getCalledName();
            calledName = calledName != null ? calledName : tag.getTagPublicName();
            cfStack.pushStackFrame(templateName, calledName, lineNo, true);
        }
    }

    private static boolean shouldProcessTag(GenericTag tag, RequestMonitorData rmd) {
        return rmd != null && rmd.doMonitor() && (rmd.shouldProfile() || Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isTagMetrics() || RequestMonitorEventProcessor.isExternalService(tag.getTagPublicName(), rmd));
    }

    public static void onTagEnd(GenericTag tag) {
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (RequestMonitorEventProcessor.shouldProcessTag(tag, rmd)) {
            TagEvent e = new TagEvent(tag);
            e.populate(rmd);
            timingReqEventHandler.onTagEnd(e);
            CFStack cfStack = rmd.getCFStack();
            if (cfStack != null && !cfStack.isEmpty()) {
                cfStack.popStackFrame();
            }
        }
    }

    public static void onTagEnd(GenericTag tag, List<TagAttribute> attributes) {
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (RequestMonitorEventProcessor.shouldProcessTag(tag, rmd)) {
            TagEvent e = new TagEvent(attributes, tag);
            e.populate(rmd);
            timingReqEventHandler.onTagEnd(e);
            CFStack cfStack = rmd.getCFStack();
            if (cfStack != null && !cfStack.isEmpty()) {
                cfStack.popStackFrame();
            }
        }
    }

    public static void onFunctionStart(String functionName, Object parent, Object[] args) {
        RequestMonitorEventProcessor.onFunctionStart(functionName, parent);
    }

    public static void onFunctionStart(String functionName, boolean isExternal) {
        RequestMonitorEventProcessor.onFunctionStart(functionName, null, isExternal);
    }

    public static void onFunctionStart(String functionName, Object parent, Map args) {
        RequestMonitorEventProcessor.onFunctionStart(functionName, parent);
    }

    public static void onFunctionStart(String functionName) {
        RequestMonitorEventProcessor.onFunctionStart(functionName, null);
    }

    public static void onFunctionStart(String functionName, Object parent) {
        RequestMonitorEventProcessor.onFunctionStart(functionName, parent, false);
    }

    private static boolean shouldProcessFunction(RequestMonitorData rmd, String functionName, boolean isExternal) {
        return rmd != null && rmd.doMonitor() && (rmd.shouldProfile() || RequestMonitorEventProcessor.isExternalService(functionName, rmd) || Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isTagMetrics() || isExternal);
    }

    public static void onFunctionStart(String functionName, Object parent, boolean isExternal) {
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (RequestMonitorEventProcessor.shouldProcessFunction(rmd, functionName, isExternal)) {
            CFStack cfStack;
            if (isExternal) {
                rmd.setHasExternalServices(true);
            }
            if (!rmd.isTagFunctionLimitExceeded() && (cfStack = rmd.getCFStack()) != null) {
                int lineNo = FusionContext.getCurrent().pageContext.getCurrentLineNo();
                String functionTemplatePath = RequestMonitorEventProcessor.getFunctionTemplatePath(parent);
                cfStack.pushStackFrame(functionTemplatePath, functionName, lineNo, false);
            }
        }
    }

    public static void onFunctionEnd(String functionName, Object parent, Object[] args) {
        RequestMonitorEventProcessor.onFunctionEnd(functionName, parent);
    }

    public static void onFunctionEnd(String functionName, Object parent, Map args) {
        RequestMonitorEventProcessor.onFunctionEnd(functionName, parent);
    }

    public static void onFunctionEnd(String functionName) {
        RequestMonitorEventProcessor.onFunctionEnd(functionName, null);
    }

    private static void onFunctionEnd(String functionName, Object parent) {
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (RequestMonitorEventProcessor.shouldProcessFunction(rmd, functionName, RequestMonitorEventProcessor.isExternalService(functionName, rmd))) {
            if (CommonUtil.isInternalCall()) {
                return;
            }
            FunctionEvent e = new FunctionEvent();
            e.setFunctionName(functionName);
            e.setFunctionTemplatePath(RequestMonitorEventProcessor.getFunctionTemplatePath(parent));
            e.populate(rmd);
            timingReqEventHandler.onFunctionEnd(e);
            CFStack cfStack = rmd.getCFStack();
            if (cfStack != null && !cfStack.isEmpty()) {
                cfStack.popStackFrame();
            }
        }
    }

    public static void onFunctionEnd(String functionName, Object parent, String action) {
        RequestMonitorEventProcessor.onFunctionEnd(functionName, parent, TagAttributeList.getInstance("action", action).getTagAttributes(), false);
    }

    public static void onFunctionEnd(String functionName, Object parent, List<TagAttribute> tagAttributes, boolean isExternal) {
        if (CommonUtil.isInternalCall()) {
            return;
        }
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (RequestMonitorEventProcessor.shouldProcessFunction(rmd, functionName, isExternal)) {
            FunctionEvent e = new FunctionEvent(tagAttributes);
            e.setFunctionName(functionName);
            e.setFunctionTemplatePath(RequestMonitorEventProcessor.getFunctionTemplatePath(parent));
            e.populate(rmd);
            timingReqEventHandler.onFunctionEnd(e);
            CFStack cfStack = rmd.getCFStack();
            if (cfStack != null && !cfStack.isEmpty()) {
                cfStack.popStackFrame();
            }
        }
    }

    private static String convertUpperCase(String keyStr) {
        String actionString = "";
        actionString = keyStr != null && !keyStr.isEmpty() ? keyStr.toUpperCase() : keyStr;
        return actionString;
    }

    public static void onError(Throwable t) {
        RequestMonitorData rmd = RequestMonitorData.getCurrent(true);
        InMemoryMonitoringService inMemoryMonitoringService = ServiceFactory.getInMemoryMonitoringService();
        if (inMemoryMonitoringService != null && inMemoryMonitoringService.isMonitoringEnabled() && RequestMonitorData.getCurrent() != null) {
            rmd.setError(true);
            rmd.setErrorMessage(t.getMessage());
            rmd.setDoMonitor(true);
            RequestEvent evnt = new RequestEvent(t);
            evnt.populate(rmd);
            reqErrorEventHandler.onRequestEnd(evnt);
        }
        if (Configuration.INSTANCE.isMonitoringEnabled() && rmd != null && !rmd.isError()) {
            rmd.setError(true);
            rmd.setErrorMessage(t.getMessage());
            rmd.setThrowable(t);
            rmd.setDoMonitor(true);
            if (rmd.getTemplatePath() == null) {
                FusionContext ctx = FusionContext.getCurrent();
                if (ctx != null) {
                    String templatePath = ctx.getPagePath();
                    rmd.setTemplatePath(templatePath);
                    rmd.setApplicationName(ctx.getApplicationName());
                }
                RequestMonitorEventProcessor.updateHeaderAttributes(rmd);
            }
            if (t instanceof InterruptedException) {
                StringBuffer msgBuff = new StringBuffer();
                msgBuff.append("Interrupted request ");
                msgBuff.append(rmd.getTemplatePath());
                if (rmd.getRequestFunctionName() != null) {
                    msgBuff.append(" :: ").append(rmd.getRequestFunctionName()).append("()");
                }
                msgBuff.append(" handled by thread ").append(Thread.currentThread().getName());
                logger.debug(msgBuff.toString());
                throw new ActiveRequestMonitor.RequestAbortedException(t);
            }
            RequestEvent e = new RequestEvent(t);
            e.populate(rmd);
            reqErrorEventHandler.onRequestEnd(e);
        }
    }

    public static void onError(Throwable t, String url) {
        RequestMonitorEventProcessor.onError(t);
        RequestMonitorData rmd = RequestMonitorData.getCurrent(true);
        if (rmd != null) {
            rmd.setUrl(url);
            rmd.setUri(url);
        }
    }

    private static void updateHeaderAttributes(RequestMonitorData rmd) {
        HttpServletRequest request;
        FusionContext fc = FusionContext.getCurrent();
        if (fc == null) {
            return;
        }
        if (rmd.getUri() == null || rmd.getUri().isEmpty()) {
            RequestMonitorEventProcessor.createRequestURI(fc, rmd);
        }
        if ((request = fc.getRequest()) != null) {
            RequestMonitorEventProcessor.setClientIPHost(rmd, request);
            rmd.setThreadId(Thread.currentThread().getName());
            RequestMonitorEventProcessor.updateAutomatedReqId(rmd, request);
        }
        RequestMonitorEventProcessor.setSiteClusterName(rmd, fc);
    }

    private static void setSiteClusterName(RequestMonitorData rmd, FusionContext fc) {
        HashMap<String, String> reqMap = new HashMap<String, String>();
        rmd.setResponseContentType(fc.getResponse().getContentType());
        if (fc.getRequest().getHeader("XCluster-name") != null) {
            reqMap.put("XCluster-name", fc.getRequest().getHeader("XCluster-name"));
            ServiceFactory.getMonitoringService().setPartOfCluster(true);
        }
        if (fc.getRequest().getHeader("XSite-name") != null) {
            String header = fc.getRequest().getHeader("XSite-name");
            String server_software = (String)fc.getRequest().getAttribute("SERVER_SOFTWARE");
            if (server_software != null && !server_software.isEmpty()) {
                if ((server_software = server_software.toLowerCase()).contains("apache")) {
                    header = "Apache";
                    header = RequestMonitorEventProcessor.getLocalAddress(fc, header);
                } else {
                    header = RequestMonitorEventProcessor.getLocalAddress(fc, header);
                }
            }
            reqMap.put("XSite-name", header);
        }
        rmd.setReqMap(reqMap);
    }

    private static String getLocalAddress(FusionContext fc, String header) {
        String localAddr = fc.getRequest().getLocalAddr();
        if (localAddr != null && !localAddr.isEmpty()) {
            if (localAddr.equalsIgnoreCase("::1")) {
                localAddr = "127.0.0.1";
            }
            header = (String)header + ":" + localAddr;
        }
        return header;
    }

    private static void setClientIPHost(RequestMonitorData rmd, HttpServletRequest request) {
        String clientHost = request.getServerName();
        String clientIp = request.getRemoteAddr();
        if ("0:0:0:0:0:0:0:1".equals(request.getRemoteAddr()) || "::1".equals(request.getRemoteAddr())) {
            clientIp = "127.0.0.1";
        }
        if ("0:0:0:0:0:0:0:1".equals(request.getRemoteHost()) || "::1".equals(request.getRemoteHost())) {
            clientHost = "127.0.0.1";
        }
        rmd.setClientHost(clientHost);
        rmd.setClientIp(clientIp);
    }

    private static void updateAutomatedReqId(RequestMonitorData rmd, HttpServletRequest request) {
        if (System.getProperty("qetest") != null && System.getProperty("qetest").equals("true")) {
            rmd.setQeReqId(request.getParameter("reqid"));
        }
    }

    public static void onThrottle(long memoryUsed) {
        FusionContext context;
        if (Configuration.INSTANCE.isMonitoringEnabled() && (context = FusionContext.getCurrent()).getRequest() != null) {
            RequestThrottleMonitor.getInstance().record(context.getRequest().getRequestURI(), memoryUsed);
        }
    }

    public static QueryStat onQueryStart(String name, boolean isCached, String DSN, String sql, int lineNo, boolean isStoredProc) {
        QueryStat stat = null;
        if (!Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isQueryMetrics()) {
            return stat;
        }
        name = RequestMonitorEventProcessor.updateQueryNameIfNull(name);
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (rmd != null && rmd.doMonitor()) {
            CFStackFrame currentFunctionStackFrame;
            FusionContext fContext = FusionContext.getCurrent();
            String templatePath = fContext.getPagePath();
            String method = "";
            if (fContext.request != null) {
                RequestMonitorEventProcessor.createRequestURI(fContext, rmd);
                if (fContext.request.getMethod() != null) {
                    method = fContext.request.getMethod();
                }
            }
            String functionName = null;
            CFStack cfStack = rmd.getCFStack();
            if (cfStack != null && templatePath != null && templatePath.indexOf(".cfc") != -1 && (currentFunctionStackFrame = cfStack.peekFunctionStackFrame()) != null) {
                functionName = currentFunctionStackFrame.getElementName();
            }
            if (!Configuration.INSTANCE.checkIfDBExists(DSN)) {
                Configuration.INSTANCE.updateDBList(DSN);
            }
            stat = QueryMonitor.getInstance().onQueryStart(templatePath, functionName, lineNo, name, isCached, DSN, sql, rmd, rmd.getUrl(), method, isStoredProc);
        }
        return stat;
    }

    private static String updateQueryNameIfNull(String name) {
        if (name == null || name.isEmpty()) {
            name = "Unnamed-Query";
        }
        return name;
    }

    public static void onQueryEnd(boolean isError, Throwable ex) {
        if (!Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isQueryMetrics()) {
            return;
        }
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (rmd != null && rmd.doMonitor()) {
            FusionContext fContext = FusionContext.getCurrent();
            String templatePath = fContext.getPagePath();
            QueryMonitor.getInstance().onQueryEnd(templatePath, isError, rmd, ex);
        }
    }

    public static void onTemplateChanged(String templatePath) {
        logger.debug("Template [" + templatePath + "] changed, clearing profiling data.");
    }

    private static String getFunctionTemplatePath(Object parent) {
        String functionTemplatePath = null;
        functionTemplatePath = parent != null && parent instanceof CfJspPage ? ((CfJspPage)parent).getPagePath() : FusionContext.getCurrent().getPagePath();
        return functionTemplatePath;
    }

    public static boolean doMonitor(String template) {
        if (!Configuration.INSTANCE.isMonitoringEnabled() || RequestMonitorEventProcessor.isAdminPageMonitoringDisabled(template)) {
            return false;
        }
        boolean accept = true;
        int ixIn = RequestMonitorEventProcessor.isIn(Configuration.INSTANCE.getMonitorSettings().getIncludeList(), template);
        int ixEx = RequestMonitorEventProcessor.isIn(Configuration.INSTANCE.getMonitorSettings().getExcludeList(), template);
        if (ixEx == 2) {
            accept = false;
        } else if (ixIn == 2) {
            accept = true;
        } else if (ixEx == 1) {
            accept = false;
        }
        return accept;
    }

    private static int isIn(List<String> strs, String pt) {
        int r = 0;
        for (int i = 0; i < strs.size(); ++i) {
            if (pt.equalsIgnoreCase(strs.get(i))) {
                r = 2;
                break;
            }
            if (!pt.startsWith(strs.get(i)) || strs.get(i).length() <= 0) continue;
            r = 1;
        }
        return r;
    }

    private static boolean isAdminPageMonitoringDisabled(String template) {
        if (pathToCfadmin == null) {
            FusionContext context = FusionContext.getCurrent();
            if (context.getRequest() != null) {
                pathToCfadmin = ServiceFactory.getRuntimeService().getRealPath(context.getServletContext(), "/CFIDE/");
            } else {
                return false;
            }
        }
        return template.indexOf(pathToCfadmin) != -1 && !Configuration.INSTANCE.getMonitorSettings().isCfadminMonitoringEnabled();
    }

    public static void onRestStart(String requestURI, String appName) {
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (rmd == null) {
            return;
        }
        rmd.setRest(true);
        rmd.setApplicationName(appName);
        if (!appName.isEmpty() && !Configuration.INSTANCE.checkIfAppExists(appName)) {
            Configuration.INSTANCE.updateAppList(appName, rmd.getRest());
        }
        rmd.setRestUri(requestURI);
    }

    private static boolean isExternalService(String tag, RequestMonitorData rmd) {
        if (tag != null && (MonitorConstants.TAGS_WITH_ATTRIBUTES.contains(tag) || tag.startsWith("File"))) {
            if (rmd != null && !rmd.hasExternalServices()) {
                rmd.setHasExternalServices(true);
            }
            return true;
        }
        return false;
    }

    static {
        logger = CFLogs.MONITOR_LOG;
    }

    static final class Fields {
        static final String UNNAMED_QUERY = "Unnamed-Query";

        Fields() {
        }
    }
}

