/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.memory;

import coldfusion.monitor.memory.MemoryTrackable;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryTracker {
    private static Random rand = new Random(System.currentTimeMillis());
    private long internalHashcode = -1L;
    private Map<Integer, ObjectHolder> trackedObjectMap = new ConcurrentHashMap<Integer, ObjectHolder>(new WeakHashMap());
    private MemoryTrackable trackedObject = null;
    private int scopeType = -1;
    private volatile long estimatedMemory = 0L;
    private volatile long estimatedCumulativeMemory = 0L;
    private volatile long estimatedMaxMemory = -1L;
    private Vector<Object> untrackedObjectList = new Vector(1);

    public MemoryTracker(MemoryTrackable trackedObject) {
        this.trackedObject = trackedObject;
        this.scopeType = trackedObject.getScopeType();
        this.internalHashcode = rand.nextLong() + System.currentTimeMillis();
    }

    public long getMTCode() {
        return this.internalHashcode;
    }

    public void setScopeType(int scopeType) {
        this.scopeType = scopeType;
    }

    public int getScopeType() {
        return this.scopeType;
    }

    public boolean isPersistentScope() {
        return this.scopeType >= 6;
    }

    public Object getTrackedObject() {
        return this.trackedObject;
    }

    private Map<Integer, ObjectHolder> getAllPrimitiveMap(Set<MemoryTracker> skipMTSet) {
        skipMTSet.add(this);
        HashMap<Integer, ObjectHolder> map = new HashMap<Integer, ObjectHolder>();
        HashMap<Integer, ObjectHolder> tempTrackedObjects = new HashMap<Integer, ObjectHolder>();
        tempTrackedObjects.putAll(this.trackedObjectMap);
        for (Integer key : tempTrackedObjects.keySet()) {
            ObjectHolder holder = (ObjectHolder)tempTrackedObjects.get(key);
            if (holder.isMTB()) {
                MemoryTracker mt;
                MemoryTrackerProxy mtp = ((MemoryTrackable)holder.getObject()).getMemoryTrackerProxy();
                if (mtp == null || (mt = mtp.getBuiltInMemoryTracker()) == null || this == mt || skipMTSet.contains(mt)) continue;
                map.putAll(mt.getAllPrimitiveMap(skipMTSet));
                continue;
            }
            map.put(key, holder);
        }
        return map;
    }

    public long getEstimatedMemory() {
        long size = 0L;
        Map<Integer, ObjectHolder> primitiveMap = this.getAllPrimitiveMap(new HashSet<MemoryTracker>());
        for (Integer key : primitiveMap.keySet()) {
            ObjectHolder holder = primitiveMap.get(key);
            if (holder.isMTB()) continue;
            size += holder.getSize();
        }
        this.updateMemVars(size);
        return size;
    }

    private void updateMemVars(long size) {
        this.estimatedMemory = size;
        if (this.estimatedMemory > this.estimatedMaxMemory) {
            this.estimatedMaxMemory = this.estimatedMemory;
        }
        this.estimatedCumulativeMemory = size;
    }

    public long getEstimatedCumulativeMemory() {
        return this.estimatedCumulativeMemory;
    }

    public long getEstimatedMaxMemory() {
        if (this.estimatedMaxMemory == -1L) {
            this.getEstimatedMemory();
        }
        return this.estimatedMaxMemory;
    }

    public void reset() {
        this.estimatedMemory = 0L;
    }

    public void onAddObject(Object o, long size) {
        if (o != null && this.registerWithObject(o)) {
            this.trackedObjectMap.put(new Integer(System.identityHashCode(o)), new ObjectHolder(o, size, o instanceof MemoryTrackable));
        }
    }

    public void onRemoveObject(Object o, long size) {
        if (o == null) {
            return;
        }
        if (this.unregisterFromObject(o)) {
            this.trackedObjectMap.remove(new Integer(System.identityHashCode(o)));
        }
    }

    private boolean registerWithObject(Object o) {
        boolean isReferenced = false;
        boolean isUntrackedObject = false;
        if (o instanceof MemoryTrackable) {
            MemoryTrackable mto = (MemoryTrackable)o;
            MemoryTrackerProxy mtp = mto.getMemoryTrackerProxy();
            int refCount = 0;
            if (mtp != null) {
                refCount = mtp.registerMemoryTracker(this);
            }
            if (refCount == -1) {
                return false;
            }
            if (refCount > 1) {
                isReferenced = true;
            }
            if (this.scopeType != -1) {
                isUntrackedObject = mtp != null ? mtp.getHighestTrackerScopeType() > this.scopeType : true;
            }
            if (isUntrackedObject && !this.isUntracked(o)) {
                this.untrackedObjectList.add(o);
            }
        }
        return !isReferenced && !isUntrackedObject;
    }

    private boolean unregisterFromObject(Object o) {
        boolean isUntrackedObject = false;
        boolean isReferenced = false;
        if (o instanceof MemoryTrackable) {
            MemoryTrackable mto = (MemoryTrackable)o;
            MemoryTrackerProxy mtp = mto.getMemoryTrackerProxy();
            int refCount = 0;
            if (mtp != null) {
                refCount = mtp.unregisterMemoryTracker(this);
            }
            if (refCount == -1) {
                return false;
            }
            isReferenced = refCount > 0;
            isUntrackedObject = this.isUntracked(o);
            if (isUntrackedObject && !isReferenced) {
                this.untrackedObjectList.remove(o);
            }
        }
        return !isUntrackedObject && !isReferenced;
    }

    private boolean isUntracked(Object o) {
        boolean isUntrackedObject = false;
        for (int i = 0; i < this.untrackedObjectList.size(); ++i) {
            if (this.untrackedObjectList.elementAt(i) != o) continue;
            isUntrackedObject = true;
            break;
        }
        return isUntrackedObject;
    }

    void incrementMemory(long change) {
        this.estimatedMemory += change;
        if (this.estimatedMemory > this.estimatedMaxMemory) {
            this.estimatedMaxMemory = this.estimatedMemory;
        }
        this.estimatedCumulativeMemory += change;
    }

    void decrementMemory(long change) {
        this.estimatedMemory -= change;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" MT: ").append(this.internalHashcode).append(" estimatedMemory ").append(this.getEstimatedMemory());
        return sb.toString();
    }

    private class ObjectHolder {
        private long size;
        private boolean isMTB;
        private Object o;

        public ObjectHolder(Object o, long size, boolean isMTB) {
            this.o = o;
            this.size = size;
            this.isMTB = isMTB;
        }

        public Object getObject() {
            return this.o;
        }

        public long getSize() {
            return this.size;
        }

        public boolean isMTB() {
            return this.isMTB;
        }
    }
}

