/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.memory;

import coldfusion.monitor.event.ThreadEvent;
import coldfusion.monitor.memory.MemoryMonitor;
import coldfusion.monitor.memory.MemoryTracker;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.Scope;
import java.util.Iterator;

public class ThreadMemoryMonitor {
    public void record(ThreadEvent e) {
        if (!MemoryMonitor.isEnabled()) {
            return;
        }
        long threadLocalScopeMaxMemory = this.getScopeMaxMemory(e.getThreadLocalScope());
        long threadScopeMaxMemory = this.getScopeMaxMemory(e.getThreadScope());
        this.recordRequestAttributesStats(e.getRequestMonitorData());
    }

    private long getScopeMaxMemory(Scope scope) {
        MemoryTrackerProxy mtp;
        if (scope != null && (mtp = scope.getMemoryTrackerProxy()) != null) {
            MemoryTracker threadLocalMT = mtp.getBuiltInMemoryTracker();
            return threadLocalMT.getEstimatedMaxMemory();
        }
        return 0L;
    }

    private void recordRequestAttributesStats(RequestMonitorData rmd) {
        Iterator variableStats;
        if (MemoryMonitor.isProfilingEnabled() && (variableStats = rmd.getVariableStatsIterator()) != null) {
            while (variableStats.hasNext()) {
            }
        }
    }
}

