/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.scheduler;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.datastore.Client;
import coldfusion.monitor.datastore.JSONConverter;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import javax.management.MBeanServer;

public class HeapDump {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static Logger logger = CFLogs.MONITOR_LOG;
    private static volatile Object hotspotMBean;

    public static void dumpHeap(String fileName, boolean live) {
        HeapDump.initHotspotMBean();
        try {
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            Method m = clazz.getMethod("dumpHeap", String.class, Boolean.TYPE);
            m.invoke(hotspotMBean, fileName, live);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initHotspotMBean() {
        if (hotspotMBean != null) return;
        Class<HeapDump> clazz = HeapDump.class;
        synchronized (HeapDump.class) {
            if (hotspotMBean != null) return;
            hotspotMBean = HeapDump.getHotspotMBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static Object getHotspotMBean() {
        try {
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            Object bean = ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, clazz);
            return bean;
        }
        catch (RuntimeException re) {
            logger.error("Runtime Exception while triggering heap dump", re);
        }
        catch (Exception exp) {
            logger.error("Exception while triggering heap dump", exp);
        }
        return null;
    }

    public static void pushHeapDumpInfoToDataSource(String id, String user) {
        String fileName = id + ".hprof";
        Struct dmpHeapJson = new Struct();
        dmpHeapJson.put("file_location", (Object)(ServiceFactory.getRuntimeService().getRootDir() + File.separator + "bin" + File.separator + fileName));
        dmpHeapJson.put("instance_id", (Object)Configuration.INSTANCE.getInstanceId());
        dmpHeapJson.put("group_id", (Object)Configuration.INSTANCE.getGroupId());
        dmpHeapJson.put("user", (Object)user);
        dmpHeapJson.put("time_stamp", (Object)System.currentTimeMillis());
        try {
            Client.get().indexDocument(JSONConverter.toJson(dmpHeapJson), "heap_dumps", 1);
        }
        catch (Exception ex) {
            logger.error("Exception while pushing heap dump details in database", ex);
        }
    }
}

