/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.scheduler;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.scheduler.TaskScheduler;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public enum OperatingSystemMXBean {
    INSTANCE;

    Class<?> osMxBean = null;
    Method jvmMethod = null;
    Method cpuMethod = null;
    JVMTypes jvmType;
    private Logger logger = CFLogs.MONITOR_LOG;
    java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();

    public void initializeBeans() {
        this.jvmType = JVMTypes.other;
        if (System.getProperty("java.vendor").toLowerCase().contains("oracle")) {
            this.jvmType = JVMTypes.sun;
            this.osMxBean = this.getMBeanClass("com.sun.management.OperatingSystemMXBean");
            TaskScheduler.INSTANCE.setJvm("oracle");
        } else if (System.getProperty("java.vendor").toLowerCase().contains("ibm")) {
            this.jvmType = JVMTypes.ibm;
            this.osMxBean = this.getMBeanClass("com.ibm.lang.management.OperatingSystemMXBean");
            TaskScheduler.INSTANCE.setJvm("ibm");
        }
        this.jvmMethod = this.getMethod("getProcessCpuLoad");
        this.cpuMethod = this.getMethod("getSystemCpuLoad");
    }

    public double getSystemCPUUsage() {
        double cpuusage = -1.0;
        if (this.osMxBean == null) {
            return -1.0;
        }
        cpuusage = this.invokeMethodOnBean(this.cpuMethod);
        return cpuusage;
    }

    public double getJVMCPUUsage() {
        double cpuusage = -1.0;
        if (this.osMxBean == null) {
            return -1.0;
        }
        cpuusage = this.invokeMethodOnBean(this.jvmMethod);
        return cpuusage;
    }

    private double invokeMethodOnBean(Method method) {
        double output = -1.0;
        try {
            if (method != null && this.osBean != null) {
                output = (Double)method.invoke((Object)this.osBean, new Object[0]);
            }
        }
        catch (IllegalAccessException ex) {
            this.logger.error(ex);
        }
        catch (IllegalArgumentException ex) {
            this.logger.error(ex);
        }
        catch (InvocationTargetException ex) {
            this.logger.error(ex);
        }
        return output;
    }

    private Method getMethod(String methodName) {
        Method method = null;
        try {
            if (this.osMxBean != null) {
                method = this.osMxBean.getDeclaredMethod(methodName, new Class[0]);
            }
        }
        catch (NoSuchMethodException ex) {
            this.logger.error(ex);
        }
        catch (SecurityException ex) {
            this.logger.error("Exception in getMethod", ex);
        }
        return method;
    }

    private Class<?> getMBeanClass(String osClass) {
        try {
            this.osMxBean = Class.forName(osClass);
        }
        catch (ClassNotFoundException ex) {
            this.logger.error("Exception in getMbeanClass", ex);
        }
        return this.osMxBean;
    }

    static enum JVMTypes {
        sun,
        ibm,
        other;

    }
}

