/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.sql;

import coldfusion.runtime.Struct;
import coldfusion.server.j2ee.sql.pool.JDBCManager;
import coldfusion.server.j2ee.sql.pool.JDBCPool;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public enum JDBCPoolMonitor {
    INSTANCE;


    public static JDBCPoolMonitor getInstance() {
        return INSTANCE;
    }

    public List getDbPoolStats() {
        ArrayList<Struct> response = new ArrayList<Struct>();
        JDBCManager jdbcMan = JDBCManager.getInstance();
        Enumeration pools = jdbcMan.getPools();
        while (pools.hasMoreElements()) {
            JDBCPool pool = (JDBCPool)pools.nextElement();
            String dbName = pool.getPoolname();
            int openCount = new Integer(pool.getCheckedOutCount());
            int totalCount = new Integer(pool.getPoolCount());
            if (openCount == 0 || totalCount == 0) continue;
            Struct stats = new Struct();
            stats.put("dsn", (Object)dbName);
            stats.put("open_connection_count", (Object)openCount);
            stats.put("total_connection_count", (Object)totalCount);
            int maxSize = pool.getMetaData().getMaximumSize();
            if (maxSize == Integer.MAX_VALUE) {
                maxSize = -1;
            }
            stats.put("max_connection_count", (Object)new Integer(maxSize));
            response.add(stats);
        }
        return response;
    }

    public List getInMemoryDbPoolStats() {
        ArrayList<Struct> response = new ArrayList<Struct>();
        JDBCManager jdbcMan = JDBCManager.getInstance();
        Enumeration pools = jdbcMan.getPools();
        while (pools.hasMoreElements()) {
            JDBCPool pool = (JDBCPool)pools.nextElement();
            String dbName = pool.getPoolname();
            int openCount = new Integer(pool.getCheckedOutCount());
            int totalCount = new Integer(pool.getPoolCount());
            Struct stats = new Struct();
            stats.put("dsn", (Object)dbName);
            stats.put("open_connection_count", (Object)openCount);
            stats.put("total_connection_count", (Object)totalCount);
            stats.put("AVGOPENCONNECTIONCOUNT", (Object)new Integer((int)pool.getCheckedOutCountCalculator().getAvgStat().getAvg()));
            stats.put("AVGTOTALCONNECTIONCOUNT", (Object)new Integer((int)pool.getPoolCountCalculator().getAvgStat().getAvg()));
            int maxSize = pool.getMetaData().getMaximumSize();
            if (maxSize == Integer.MAX_VALUE) {
                maxSize = -1;
            }
            stats.put("max_connection_count", (Object)new Integer(maxSize));
            response.add(stats);
        }
        return response;
    }

    public void reset() {
        JDBCManager jdbcMan = JDBCManager.getInstance();
        Enumeration pools = jdbcMan.getPools();
        while (pools.hasMoreElements()) {
            JDBCPool pool = (JDBCPool)pools.nextElement();
            pool.getCheckedOutCountCalculator().reset();
            pool.getPoolCountCalculator().reset();
        }
    }
}

