/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.stack;

import coldfusion.monitor.stack.CFStackFrame;
import coldfusion.monitor.util.CommonUtil;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;

public class CFStack {
    private CFStackFrame currentStackFrame;
    private int size = 0;
    private CFStackFrame currentFunctionStackFrame;
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String AT = "at ";

    public CFStack() {
    }

    private CFStack(CFStack cfStack) {
        if (!cfStack.isEmpty()) {
            this.currentStackFrame = cfStack.peekStackFrame().copy();
            this.size = cfStack.getSize();
        }
    }

    public void pushStackFrame(String templatePath, String elementName, int lineNo, boolean isTag) {
        if (templatePath.contains("WEB-INF")) {
            return;
        }
        CFStackFrame stackFrame = new CFStackFrame(templatePath, elementName, isTag);
        if (this.currentStackFrame != null) {
            this.currentStackFrame.setLineNo(lineNo);
        }
        stackFrame.setNextFrame(this.currentStackFrame);
        this.currentStackFrame = stackFrame;
        ++this.size;
        if (stackFrame.isFunction()) {
            this.currentFunctionStackFrame = stackFrame;
        }
    }

    public void pushStackFrame(CFStackFrame stackFrame) {
        stackFrame = stackFrame.copy();
        stackFrame.setNextFrame(this.currentStackFrame);
        this.currentStackFrame = stackFrame;
        ++this.size;
        if (stackFrame.isFunction()) {
            this.currentFunctionStackFrame = stackFrame;
        }
    }

    public CFStackFrame popStackFrame() {
        CFStackFrame stackFrame = null;
        if (CommonUtil.isInternalCall()) {
            return null;
        }
        if (this.currentStackFrame != null) {
            stackFrame = this.currentStackFrame;
            this.currentStackFrame = stackFrame.getNextFrame();
            stackFrame.setNextFrame(null);
            if (this.currentStackFrame != null) {
                this.currentStackFrame.setLineNo(0);
            }
            --this.size;
        } else {
            throw new EmptyStackException();
        }
        if (stackFrame.isFunction()) {
            this.currentFunctionStackFrame = this.findCurrentFunctionStackFrame();
        }
        return stackFrame;
    }

    private CFStackFrame findCurrentFunctionStackFrame() {
        CFStackFrame stackFrame;
        for (stackFrame = this.currentStackFrame; stackFrame != null && !stackFrame.isFunction(); stackFrame = stackFrame.getNextFrame()) {
        }
        return stackFrame;
    }

    public CFStackFrame peekStackFrame() {
        return this.currentStackFrame;
    }

    public CFStackFrame peekFunctionStackFrame() {
        return this.currentFunctionStackFrame;
    }

    public boolean isEmpty() {
        return this.currentStackFrame == null;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        CFStackFrame stackFrame = this.currentStackFrame;
        if (this.currentStackFrame != null) {
            stackFrame.toString(buffer);
            for (stackFrame = stackFrame.getNextFrame(); stackFrame != null; stackFrame = stackFrame.getNextFrame()) {
                buffer.append(LINE_SEP);
                buffer.append(AT);
                stackFrame.toString(buffer);
            }
        }
        return buffer.toString();
    }

    public List getStackFramesAsStrings() {
        ArrayList<String> list = new ArrayList<String>(this.size);
        for (CFStackFrame stackFrame = this.currentStackFrame; stackFrame != null; stackFrame = stackFrame.getNextFrame()) {
            list.add(stackFrame.toString());
        }
        return list;
    }

    public CFStack copy() {
        return new CFStack(this);
    }
}

