/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.stack;

public class CFStackFrame {
    public static final int UNDEFINED_LINE_NO = 0;
    private String templatePath;
    private String elementName;
    private int lineNo = 0;
    private boolean isTag;
    private long insertedAt;
    private long timeTaken;
    private CFStackFrame nextFrame;
    private static final String SPACE = " ";
    private static final String COLON = ":";
    private static final String PARENTHESIS = "()";

    CFStackFrame(String templatePath, String elementName, boolean isTag) {
        this.templatePath = templatePath;
        this.elementName = elementName;
        this.isTag = isTag;
        this.insertedAt = System.currentTimeMillis();
    }

    private CFStackFrame(CFStackFrame copyFrom) {
        this.templatePath = copyFrom.getTemplatePath();
        this.elementName = copyFrom.getElementName();
        this.isTag = copyFrom.isTag();
        this.lineNo = copyFrom.getLineNo();
        this.insertedAt = copyFrom.getInsertedAt();
        this.timeTaken = copyFrom.getTimeTaken();
        CFStackFrame nextFrame = copyFrom.getNextFrame();
        if (nextFrame != null) {
            this.nextFrame = nextFrame.copy();
        }
    }

    public void setNextFrame(CFStackFrame frame) {
        this.nextFrame = frame;
    }

    public CFStackFrame getNextFrame() {
        return this.nextFrame;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public String getElementName() {
        return this.elementName;
    }

    public boolean isTag() {
        return this.isTag;
    }

    public boolean isFunction() {
        return !this.isTag && this.elementName != null;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public long getInsertedAt() {
        return this.insertedAt;
    }

    public long getTimeTaken() {
        return this.timeTaken;
    }

    public void setTimeTaken(long timeTaken) {
        this.timeTaken = timeTaken;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuffer buffer) {
        buffer.append(this.templatePath).append(SPACE);
        if (this.elementName != null) {
            buffer.append(this.elementName);
        }
        if (!this.isTag) {
            buffer.append(PARENTHESIS);
        }
        buffer.append(SPACE).append(COLON).append(SPACE).append(this.lineNo).append(SPACE).append(COLON).append(SPACE).append(this.timeTaken);
    }

    CFStackFrame copy() {
        return new CFStackFrame(this);
    }
}

