/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.threaddump;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.beans.StackTraceNode;
import coldfusion.monitor.beans.ThreadDumpData;
import coldfusion.monitor.datastore.Client;
import coldfusion.monitor.datastore.JSONConverter;
import coldfusion.monitor.threaddump.DeadlockDetector;
import coldfusion.monitor.threaddump.DeadlockHandler;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import sun.tools.attach.HotSpotVirtualMachine;

public class ThreadDumpUtil {
    private Logger logger = CFLogs.SERVER_LOG;
    private static ThreadDumpUtil instance = null;
    private static final String THREAD_STATES = "thread_states";
    private static final String THREAD_DUMP = "thread_dump";
    private static final String THREAD_DUMP_ID = "thread_dump_id";
    private static final String THREAD_GROUPS = "thread_groups";
    private static final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private static final RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
    private static final OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();

    private ThreadDumpUtil() {
    }

    public static ThreadDumpUtil getInstance() {
        if (instance == null) {
            instance = new ThreadDumpUtil();
        }
        return instance;
    }

    public Map<String, Map<String, Object>> takeThreadDumpAndPushToES(String username, UUID alertId) {
        HashMap<String, Map<String, Object>> threadDumpOverview = new HashMap<String, Map<String, Object>>();
        threadDumpOverview.put(THREAD_STATES, new HashMap());
        threadDumpOverview.put(THREAD_GROUPS, new HashMap());
        threadDumpOverview.put(THREAD_DUMP, new HashMap());
        String json = "";
        try {
            json = this.getJstackThreadDump(username, alertId, threadDumpOverview);
        }
        catch (Throwable e) {
            this.logger.error("Jstack Thread Dump could not be taken successfully. Triggering MBean Thread Dump... ", e);
        }
        if (json == null || json.isEmpty()) {
            json = this.getMbeanThreadDump(username, alertId, threadDumpOverview);
        }
        Client.get().call(json, "/thread_dumps", "_bulk");
        return threadDumpOverview;
    }

    private String getMbeanThreadDump(String username, UUID alertId, Map<String, Map<String, Object>> threadDumpOverview) {
        Object json = "";
        String indexJson = "{ \"index\":{} }";
        Map<Thread, StackTraceElement[]> m = Thread.getAllStackTraces();
        Iterator<Thread> itr = m.keySet().iterator();
        Thread t = null;
        Long timeStamp = System.currentTimeMillis();
        String threadDumpId = Long.toString(timeStamp);
        while (itr.hasNext()) {
            Long l;
            t = itr.next();
            ThreadDumpData threadData = this.prepareDumpForThread(t, alertId);
            threadData.setTimeStamp(timeStamp);
            threadData.setThreadDumpId(username + ":" + threadDumpId);
            Long threadCount = (Long)threadDumpOverview.get(THREAD_STATES).get(threadData.getState());
            if (null == threadCount) {
                threadCount = 1L;
            } else {
                l = threadCount;
                threadCount = threadCount + 1L;
            }
            threadDumpOverview.get(THREAD_STATES).put(threadData.getState(), threadCount);
            threadCount = (Long)threadDumpOverview.get(THREAD_GROUPS).get(threadData.getThreadGroupName());
            if (null == threadCount) {
                threadCount = 1L;
            } else {
                l = threadCount;
                threadCount = threadCount + 1L;
            }
            threadDumpOverview.get(THREAD_GROUPS).put(threadData.getThreadGroupName(), threadCount);
            json = (String)json + indexJson + "\n";
            json = (String)json + JSONConverter.toJson(threadData);
            json = (String)json + "\n";
        }
        threadDumpOverview.get(THREAD_DUMP).put(THREAD_DUMP_ID, username + ":" + threadDumpId);
        return json;
    }

    private String getJstackThreadDump(String username, UUID alertId, Map<String, Map<String, Object>> threadDumpOverview) throws AttachNotSupportedException, IOException {
        Long timeStamp = System.currentTimeMillis();
        String threadDumpId = Long.toString(timeStamp);
        Object json = "";
        String indexJson = "{ \"index\":{} }";
        List<ThreadDumpData> threadList = this.createThreadDump();
        if (threadList != null && !threadList.isEmpty()) {
            for (ThreadDumpData threadData : threadList) {
                Long l;
                threadData.setInstanceId(Configuration.INSTANCE.getInstanceId());
                threadData.setGroupId(Configuration.INSTANCE.getGroupId());
                threadData.setTimeStamp(timeStamp);
                threadData.setThreadDumpId(username + ":" + threadDumpId);
                Long threadCount = (Long)threadDumpOverview.get(THREAD_STATES).get(threadData.getState());
                if (null == threadCount) {
                    threadCount = 1L;
                } else {
                    l = threadCount;
                    threadCount = threadCount + 1L;
                }
                threadDumpOverview.get(THREAD_STATES).put(threadData.getState(), threadCount);
                threadCount = (Long)threadDumpOverview.get(THREAD_GROUPS).get(threadData.getThreadGroupName());
                if (null == threadCount) {
                    threadCount = 1L;
                } else {
                    l = threadCount;
                    threadCount = threadCount + 1L;
                }
                threadDumpOverview.get(THREAD_GROUPS).put(threadData.getThreadGroupName(), threadCount);
                json = (String)json + indexJson + "\n";
                json = (String)json + JSONConverter.toJson(threadData);
                json = (String)json + "\n";
            }
            threadDumpOverview.get(THREAD_DUMP).put(THREAD_DUMP_ID, username + ":" + threadDumpId);
        }
        return json;
    }

    public String takeThreadDumpFromAlert(UUID alertId) {
        Map<String, Map<String, Object>> threadDumpOverview = this.takeThreadDumpAndPushToES("alert", alertId);
        return threadDumpOverview.get(THREAD_DUMP).get(THREAD_DUMP_ID).toString();
    }

    public void mergeStackTrace(String[] stes, StackTraceNode coldfusionCallStackInPage) {
        for (int i = 0; i < stes.length; ++i) {
            String line = stes[i];
            if (line.equals("\n")) continue;
            Stack<String> tempCallStack = new Stack<String>();
            tempCallStack.push(line);
            while (++i != stes.length && !(line = stes[i]).equals("\n")) {
                tempCallStack.push(line);
            }
            this.pushTempCallStackIntoCallTree(coldfusionCallStackInPage, tempCallStack, 0);
        }
        this.calculateTimeTaken(coldfusionCallStackInPage);
    }

    private void calculateTimeTaken(StackTraceNode root) {
        if (root == null) {
            return;
        }
        long timeTaken = 0L;
        String tempId = null;
        if (root.getChildren() == null) {
            return;
        }
        if (root.getChildren().size() > 1) {
            tempId = root.getChildren().get(0).getId();
            for (StackTraceNode node : root.getChildren()) {
                if (tempId != null && !tempId.equals(node.getId())) {
                    tempId = node.getId();
                    timeTaken = 0L;
                }
                long ownTime = node.getTimeTaken() - timeTaken;
                timeTaken = node.getTimeTaken();
                node.setTimeTaken(ownTime);
            }
        }
        long slowestChildTime = 0L;
        for (StackTraceNode node : root.getChildren()) {
            this.calculateTimeTaken(node);
            slowestChildTime = Math.max(slowestChildTime, node.getTimeTaken());
        }
        if (root.getTimeTaken() < 0L) {
            root.setTimeTaken(slowestChildTime);
        }
        root.setId(root.getId() + ":" + root.getLineNumber() + ":" + root.getTimeTaken());
    }

    private void transformStackTraceOfThread(StackTraceElement[] stes, StackTraceNode coldfusionCallStackInPage) {
        Stack<String> tempCallStack = new Stack<String>();
        for (int i = stes.length - 1; i >= 0; --i) {
            StackTraceElement ste = stes[i];
            String stackTraceElement = ste.toString();
            tempCallStack.push(stackTraceElement);
        }
        this.pushTempCallStackIntoCallTree(coldfusionCallStackInPage, tempCallStack, 0);
    }

    public StackTraceNode mergeStackTrace(List<String> list) {
        String[] stes = list.toArray(new String[list.size()]);
        StackTraceNode root = new StackTraceNode("root");
        this.mergeStackTrace(stes, root);
        if (root.getChildren() == null) {
            return root;
        }
        return root.getChildren().get(0);
    }

    private ThreadDumpData prepareDumpForThread(Thread t, UUID alertId) {
        StackTraceElement[] stes = null;
        ThreadDumpData threadData = new ThreadDumpData();
        Configuration settings = Configuration.INSTANCE;
        threadData.setInstanceId(settings.getInstanceId());
        threadData.setRelatedAlertId(alertId);
        threadData.setThreadId(t.getName());
        threadData.setThreadName(t.getName());
        stes = t.getStackTrace();
        threadData.setThreadGroupName(t.getThreadGroup().getName());
        if (stes.length != 0) {
            StackTraceNode cfCallStackInThread = new StackTraceNode("root");
            this.transformStackTraceOfThread(stes, cfCallStackInThread);
            StringBuffer cfFullCallStack = new StringBuffer();
            StringBuffer coldfusionCallStackKeyword = new StringBuffer("");
            ArrayList<String> coldfusionTemplatesList = new ArrayList<String>();
            ThreadDumpUtil.parseCallStackTree(cfCallStackInThread, coldfusionCallStackKeyword, cfFullCallStack, coldfusionTemplatesList);
            if (coldfusionCallStackKeyword.length() == 0) {
                coldfusionCallStackKeyword = cfFullCallStack;
            }
            if (coldfusionTemplatesList != null && coldfusionTemplatesList.size() > 0) {
                threadData.setExecutesColdfusionTemplate(true);
                threadData.setColfusionTemplatesList(coldfusionTemplatesList);
            }
            threadData.setThreadStackTrace(coldfusionCallStackKeyword.toString());
            threadData.setThreadFullStackTrace(cfFullCallStack);
        }
        threadData.setPriority(t.getPriority());
        threadData.setState(t.getState().toString());
        threadData.setDaemon(t.isDaemon());
        return threadData;
    }

    private void detectAnyDeadLocks(String threadDumpId) {
        DeadlockDetector deadlockDetector = new DeadlockDetector(new DeadlockHandlerInThreadDump(), threadDumpId);
        deadlockDetector.start();
    }

    private void pushTempCallStackIntoCallTree(StackTraceNode rootNode, Stack<String> tempCallStack, int currentDepth) {
        if (currentDepth == 500) {
            return;
        }
        while (!tempCallStack.isEmpty()) {
            String element = tempCallStack.peek();
            String[] tokenizedCallString = element.split(": ");
            int lineNum = -1;
            long timeTaken = 0L;
            if (tokenizedCallString.length <= 1) {
                lineNum = -1;
            } else {
                timeTaken = Integer.parseInt(tokenizedCallString[2].trim());
                lineNum = Integer.parseInt(tokenizedCallString[1].trim());
            }
            element = tokenizedCallString[0];
            if (element.startsWith("at ")) {
                element = element.substring(3);
            }
            String stackElement = element.trim();
            boolean isElementPresent = false;
            StackTraceNode child = null;
            if (rootNode.getChildren() != null) {
                for (StackTraceNode s : rootNode.getChildren()) {
                    if (!stackElement.equals(s.getId().trim())) continue;
                    if (lineNum == s.getLineNumber()) {
                        isElementPresent = true;
                        child = s;
                        break;
                    }
                    if (tempCallStack.size() != 1 || lineNum != 0) continue;
                    tempCallStack.pop();
                    return;
                }
            }
            if (rootNode.getChildren() == null || !isElementPresent) {
                StackTraceNode newNode = new StackTraceNode(element, currentDepth);
                newNode.setLineNumber(lineNum);
                newNode.setTimeTaken(timeTaken);
                newNode.setChildren(new ArrayList<StackTraceNode>());
                List<StackTraceNode> rootNodeChildren = rootNode.getChildren();
                if (rootNodeChildren == null) {
                    rootNodeChildren = new ArrayList<StackTraceNode>();
                }
                rootNodeChildren.add(newNode);
                rootNode.setChildren(rootNodeChildren);
                tempCallStack.pop();
                if (tempCallStack.isEmpty()) continue;
                this.pushTempCallStackIntoCallTree(newNode, tempCallStack, currentDepth + 1);
                continue;
            }
            for (StackTraceNode s : rootNode.getChildren()) {
                if (!stackElement.equals(s.getId().trim()) || lineNum != s.getLineNumber()) continue;
                child = s;
                child.setTimeTaken(Math.max(child.getTimeTaken(), timeTaken));
                break;
            }
            if (child.getLineNumber() == -1 && lineNum != -1) {
                child.setLineNumber(lineNum);
            }
            tempCallStack.pop();
            this.pushTempCallStackIntoCallTree(child, tempCallStack, currentDepth + 1);
        }
    }

    private static void parseCallStackTree(StackTraceNode coldfusionCallStackInThread, StringBuffer coldfusionCallStackKeyword, StringBuffer sb, List<String> coldfusionTemplatesList) {
        if (coldfusionCallStackInThread == null) {
            return;
        }
        if (coldfusionCallStackInThread.getDepth() >= 0) {
            sb = sb.append("\t");
        }
        if (!coldfusionCallStackInThread.getId().equals("root")) {
            String currentLine = coldfusionCallStackInThread.getId();
            sb.append(coldfusionCallStackInThread.getId());
            sb.append('\n');
            if (currentLine.contains("coldfusion.bootstrap.BootstrapFilter")) {
                coldfusionCallStackKeyword.append(sb.toString());
            }
            if (currentLine.contains("runFunction(") || currentLine.contains("runPage(")) {
                String template = currentLine.substring(currentLine.indexOf("(") + 1, currentLine.indexOf(")"));
                coldfusionTemplatesList.add(template);
            }
        }
        List<StackTraceNode> children = coldfusionCallStackInThread.getChildren();
        for (StackTraceNode child : children) {
            ThreadDumpUtil.parseCallStackTree(child, coldfusionCallStackKeyword, sb, coldfusionTemplatesList);
        }
    }

    private static Map<String, Float> getCPUUsagePerThread(long[] threadIds) {
        HashMap<String, Float> cpuUsagePerThread = new HashMap<String, Float>();
        long prevUpTime = runtimeBean.getUptime();
        List<Long> prevThreadCpuTime = ThreadDumpUtil.getThreadCpuTime(threadIds);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long upTime = runtimeBean.getUptime();
        List<Long> threadCpuTime = ThreadDumpUtil.getThreadCpuTime(threadIds);
        int nCPUs = osBean.getAvailableProcessors();
        if (prevUpTime > 0L && upTime > prevUpTime) {
            long elapsedTime = upTime - prevUpTime;
            for (int i = 0; i < threadIds.length; ++i) {
                long elapsedCpu = threadCpuTime.get(i) - prevThreadCpuTime.get(i);
                float cpuUsage = Math.min(0.99f, (float)elapsedCpu / ((float)elapsedTime * 1000000.0f * (float)nCPUs));
                cpuUsagePerThread.put(threadBean.getThreadInfo(threadIds[i]).getThreadName(), Float.valueOf(cpuUsage));
            }
        }
        return cpuUsagePerThread;
    }

    private static List<Long> getThreadCpuTime(long[] threadIds) {
        ArrayList<Long> threadCpuTime = new ArrayList<Long>();
        for (int i = 0; i < threadIds.length; ++i) {
            long threadId = threadIds[i];
            if (threadId != -1L) {
                threadCpuTime.add(threadBean.getThreadCpuTime(threadId));
                continue;
            }
            threadCpuTime.add(0L);
        }
        return threadCpuTime;
    }

    private List<ThreadDumpData> createThreadDump() throws AttachNotSupportedException, IOException {
        String selfName = ManagementFactory.getRuntimeMXBean().getName();
        String selfPid = selfName.substring(0, selfName.indexOf(64));
        String re1 = ".*?";
        String re2 = "(tid=)";
        String re3 = ".*?";
        String re4 = "(nid=)";
        Pattern pattern = Pattern.compile(re1 + re2 + re3 + re4, 34);
        VirtualMachine vm = VirtualMachine.attach(selfPid);
        HotSpotVirtualMachine hotSpotVm = (HotSpotVirtualMachine)vm;
        LinkedList<ThreadDumpData> threadDumpDataList = new LinkedList<ThreadDumpData>();
        try (InputStream inputStream = hotSpotVm.remoteDataDump(new Object[0]);
             Scanner scanner = new Scanner(inputStream);){
            while (scanner.hasNextLine()) {
                String nextLine = scanner.nextLine();
                if (nextLine.contains("tid=") || nextLine.contains("nid=")) {
                    Matcher m = pattern.matcher(nextLine);
                    ThreadDumpData threadDumpData = null;
                    if (m.find()) {
                        threadDumpData = this.extractThreadMetaInfo(nextLine);
                        threadDumpDataList.add(threadDumpData);
                    }
                }
                this.printline(threadDumpDataList, nextLine);
                this.setThreadStateParsingNextLine(threadDumpDataList, nextLine);
            }
        }
        this.formGroup(threadDumpDataList);
        vm.detach();
        return threadDumpDataList;
    }

    private void printline(List<ThreadDumpData> threadDumpDataList, String aLine) {
        if (threadDumpDataList.size() > 0) {
            ThreadDumpData threadDumpData = threadDumpDataList.get(threadDumpDataList.size() - 1);
            threadDumpData.getThreadFullStackTrace().append(aLine + System.lineSeparator());
        }
    }

    private ThreadDumpData extractThreadMetaInfo(String aLine) {
        String[] datapoints;
        ThreadDumpData threadDumpData = new ThreadDumpData();
        int quote = aLine.indexOf("\"");
        String threadName = aLine.substring(quote + 1, aLine.lastIndexOf("\""));
        threadDumpData.setThreadName(threadName);
        threadDumpData.setThreadGroupName(threadName);
        threadDumpData.setDaemon(aLine.contains("daemon"));
        block12: for (String datapoint : datapoints = aLine.split(" ")) {
            boolean equals = datapoint.contains("=");
            if (!equals) continue;
            String[] split = datapoint.split("=");
            String name = split[0];
            String value = split[1];
            switch (name) {
                case "tid": {
                    threadDumpData.setThreadId(value);
                    threadDumpData.setTid(value);
                    continue block12;
                }
                case "nid": {
                    threadDumpData.setNid(value);
                    this.setThreadState(threadDumpData, aLine);
                    continue block12;
                }
                case "prio": {
                    threadDumpData.setPriority(Integer.valueOf(value));
                    continue block12;
                }
                case "os_prio": {
                    threadDumpData.setOsPriority(Integer.valueOf(value));
                }
            }
        }
        return threadDumpData;
    }

    private void setThreadState(ThreadDumpData threadDumpData, String aLine) {
        String state;
        String nid = threadDumpData.getNid();
        String stateLine = aLine.substring(aLine.lastIndexOf(nid) + nid.length() + 1);
        String[] split = stateLine.split(" ");
        switch (state = split[0]) {
            case "runnable": {
                threadDumpData.setState("RUNNABLE");
                break;
            }
            case "in": {
                threadDumpData.setState("WAITING");
                break;
            }
            default: {
                threadDumpData.setState("WAITING");
            }
        }
    }

    private void setThreadStateParsingNextLine(List<ThreadDumpData> threadDumpDataList, String aLine) {
        int size = threadDumpDataList.size();
        if (size > 0 && aLine.contains("java.lang.Thread.State:")) {
            String[] split = aLine.split(":");
            String state = split[1];
            state = state.trim().toUpperCase();
            ThreadDumpData threadDumpData = threadDumpDataList.get(size - 1);
            threadDumpData.setState(state);
        }
    }

    private Map<String, Set<String>> formGroup(List<ThreadDumpData> threadDumpDataList) {
        HashMap<String, Set<String>> threadGroups = new HashMap<String, Set<String>>();
        int listSize = threadDumpDataList.size() - 1;
        for (int i = 0; i < listSize; ++i) {
            String threadName1 = threadDumpDataList.get(i).getThreadName();
            for (int j = i; j < listSize; ++j) {
                String checkMiscThread;
                String checkHttporAjpNio;
                int levenshteinDistance;
                String threadName2 = threadDumpDataList.get(j).getThreadName();
                if (threadName1.equalsIgnoreCase(threadName2) || !((levenshteinDistance = StringUtils.getLevenshteinDistance((CharSequence)threadName1, (CharSequence)threadName2)) <= 2 || threadName1.contains("obj-skimmer") && threadName2.contains("obj-skimmer") || threadName1.contains("Statistics Thread") && threadName2.contains("Statistics Thread") || threadName1.startsWith("Thread") && threadName2.startsWith("Thread") || threadName1.startsWith("elasticsearch[high-level-client]") && threadName2.startsWith("elasticsearch[high-level-client]") || threadName1.startsWith("MyClusteredScheduler") && threadName2.startsWith("MyClusteredScheduler") || threadName1.startsWith("QuartzScheduler") && threadName2.startsWith("QuartzScheduler") || threadName1.startsWith("pool-") && threadName2.startsWith("pool-") || threadName1.endsWith(".data") && threadName2.endsWith(".data")) && (!threadName1.startsWith("New I/O server") || !threadName2.startsWith("New I/O server"))) continue;
                String commonPrefix = StringUtils.getCommonPrefix((String[])new String[]{threadName1, threadName2});
                if (threadName1.endsWith(".data") && threadName2.endsWith(".data")) {
                    commonPrefix = ".data";
                }
                if ((checkHttporAjpNio = this.checkHttporAjpNio(commonPrefix)) != null) {
                    commonPrefix = checkHttporAjpNio;
                }
                if ((checkMiscThread = this.checkMiscThread(commonPrefix)) != null) {
                    commonPrefix = checkMiscThread;
                }
                if (commonPrefix.endsWith("-")) {
                    commonPrefix = StringUtils.removeEnd((String)commonPrefix, (String)"-").trim();
                }
                if (commonPrefix.endsWith("#")) {
                    commonPrefix = StringUtils.removeEnd((String)commonPrefix, (String)"#").trim();
                }
                commonPrefix.trim();
                if (commonPrefix.length() <= 2) continue;
                HashSet<String> list = (HashSet<String>)threadGroups.get(commonPrefix);
                if (list != null && !list.isEmpty()) {
                    list.addAll(Arrays.asList(threadName1, threadName2));
                    threadGroups.put(commonPrefix, list);
                    threadDumpDataList.get(i).setThreadGroupName(commonPrefix);
                    threadDumpDataList.get(j).setThreadGroupName(commonPrefix);
                    continue;
                }
                list = new HashSet<String>();
                list.addAll(Arrays.asList(threadName1, threadName2));
                threadGroups.put(commonPrefix, list);
                threadDumpDataList.get(i).setThreadGroupName(commonPrefix);
                threadDumpDataList.get(j).setThreadGroupName(commonPrefix);
            }
            if (!threadName1.startsWith("New I/O server")) continue;
            threadDumpDataList.get(i).setThreadGroupName("New I/O server");
        }
        return threadGroups;
    }

    private String checkHttporAjpNio(String groupname) {
        String re6;
        String re5;
        String re4;
        String re3;
        String re2;
        String re1;
        Pattern p;
        Matcher m;
        if ((groupname.startsWith("http-nio") || groupname.startsWith("ajp-nio")) && (m = (p = Pattern.compile((re1 = "(http|ajp)") + (re2 = "(-)") + (re3 = "(nio)") + (re4 = "([-+]\\d+)") + (re5 = "(-)") + (re6 = "(exec)"), 34)).matcher(groupname)).find()) {
            String word1 = m.group(1);
            String c1 = m.group(2);
            String var1 = m.group(3);
            String signed_int1 = m.group(4);
            String c2 = m.group(5);
            String word2 = m.group(6);
            return word1.toString() + c1.toString() + var1.toString() + signed_int1.toString() + c2.toString() + word2.toString();
        }
        return null;
    }

    private String checkMiscThread(String groupname) {
        String re1 = null;
        if (groupname.contains("DefaultQuartzScheduler_Worker")) {
            re1 = "(DefaultQuartzScheduler_Worker)";
        } else if (groupname.contains("AsynchExecutorThreadFactory")) {
            re1 = "(AsynchExecutorThreadFactory)";
        } else if (groupname.contains("obj-skimmer")) {
            re1 = "(obj-skimmer)";
        } else if (groupname.contains("New I/O worker")) {
            re1 = "(New I/O worker)";
        } else if (groupname.contains("I/O dispatcher")) {
            re1 = "(I/O dispatcher)";
        } else {
            if (groupname.contains("Statistics Thread")) {
                return "Statistics Thread";
            }
            if (groupname.startsWith("Thread")) {
                return "Thread";
            }
            if (groupname.startsWith("elasticsearch[high-level-client]")) {
                return "elasticsearch[high-level-client]";
            }
            if (groupname.startsWith("MyClusteredScheduler")) {
                return "MyClusteredScheduler";
            }
            if (groupname.startsWith("QuartzScheduler")) {
                return "QuartzScheduler";
            }
            if (groupname.startsWith("pool")) {
                return "pool";
            }
            if (groupname.endsWith(".data")) {
                return "miscellaneous";
            }
            if (groupname.startsWith("New I/O server")) {
                return "New I/O server";
            }
            return re1;
        }
        return this.extractGroupName(groupname, re1);
    }

    private String extractGroupName(String groupname, String re1) {
        Pattern p = Pattern.compile(re1, 34);
        Matcher m = p.matcher(groupname);
        if (m.find()) {
            String word1 = m.group(1);
            return word1.toString();
        }
        return null;
    }

    private class DeadlockHandlerInThreadDump
    implements DeadlockHandler {
        private DeadlockHandlerInThreadDump() {
        }

        @Override
        public void handleDeadlock(ThreadInfo[] deadlockedThreadsDetected, String threadDumpId) {
            Map<Thread, StackTraceElement[]> stackTraceMap = Thread.getAllStackTraces();
            Iterator<Thread> it = stackTraceMap.keySet().iterator();
            ArrayList<Long> threadIds = new ArrayList<Long>();
            ArrayList<ThreadInfo> deadlockedThreads = new ArrayList<ThreadInfo>();
            while (it.hasNext()) {
                Thread t = it.next();
                threadIds.add(t.getId());
            }
            for (ThreadInfo threadInfo : deadlockedThreadsDetected) {
                if (!threadIds.contains(threadInfo.getThreadId())) continue;
                deadlockedThreads.add(threadInfo);
            }
            Client.get().submit(JSONConverter.toJson(new DeadlockedThreadList(threadDumpId, deadlockedThreads)), null);
        }
    }

    private class DeadlockedThreadList {
        private String threadDumpId = null;
        private List<ThreadInfo> deadlockedThreads;

        public DeadlockedThreadList(String threadDumpId, List<ThreadInfo> deadlockedThreads) {
            this.threadDumpId = threadDumpId;
            this.deadlockedThreads = deadlockedThreads;
        }
    }
}

