/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.throttle;

import coldfusion.filter.RequestThrottleFilter;
import coldfusion.runtime.Struct;
import coldfusion.util.MemorySemaphore;
import java.util.Map;

public enum RequestThrottleMonitor {
    INSTANCE;

    private static MemorySemaphore semaphore;

    public static RequestThrottleMonitor getInstance() {
        return INSTANCE;
    }

    public void record(String uri, long memoryUsed) {
    }

    public Map getCurrentThrottleStats() {
        Struct map = new Struct();
        map.put("throttle_queue_size", (Object)new Integer(semaphore.getQueueSize()));
        map.put("total_throttle_memory_used", (Object)new Double(this.trimDouble((double)semaphore.getTotalMemUsed() / 1048576.0)));
        return map;
    }

    private double trimDouble(double d) {
        return (double)((int)(d * 1000.0)) / 1000.0;
    }

    static {
        semaphore = MemorySemaphore.getInstance(RequestThrottleFilter.class.getName());
    }
}

