/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.util;

import coldfusion.monitor.stack.JStackTrace;
import coldfusion.monitor.stack.JStackTraceFactory;
import coldfusion.monitor.util.CFthreadDictionary;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.monitor.util.ThreadMonitorData;
import coldfusion.runtime.Struct;
import coldfusion.thread.Task;
import java.util.Map;

public class CFThreadMonitorData
extends ThreadMonitorData {
    private Task task;

    public CFThreadMonitorData(RequestMonitorData parent, String threadName, int lineNo, Runnable task2) {
        super(parent, threadName, lineNo);
        this.task = (Task)task2;
        CFthreadDictionary.getInstance().addThreadMonitor(this);
        this.initThreadStartData();
        parent.addThreadMonitorData(this);
        parent.updateThreadData(this);
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public int getLineNo() {
        return this.lineNo;
    }

    @Override
    public RequestMonitorData getParentRequestMonitorData() {
        return this.task.getRmd();
    }

    @Override
    public Thread getOwnerThread() {
        return this.task.getOwnerThread();
    }

    @Override
    public String getJavaThreadName() {
        if (this.task.getOwnerThread() != null) {
            return this.task.getOwnerThread().getName();
        }
        return null;
    }

    @Override
    public long getElapsedTime() {
        return this.task.getElapsedTime();
    }

    @Override
    public long getStartTime() {
        return this.task.getStartTime();
    }

    @Override
    public int getPriority() {
        return this.task.getPriority();
    }

    @Override
    public boolean isActive() {
        return this.task != null;
    }

    @Override
    public synchronized void destroy() {
        this.parent.removeThreadMonitorData(this);
        CFthreadDictionary.getInstance().removeThreadMonitor(this);
        this.parent = null;
        this.task = null;
        current.set(null);
    }

    @Override
    public Map getThreadInfoMap() {
        this.threadInfoMap = new Struct();
        this.threadInfoMap.put("threadName", (Object)this.getJavaThreadName());
        this.threadInfoMap.put("time_taken", (Object)Long.toString(this.getElapsedTime()));
        JStackTrace jstack = JStackTraceFactory.providerInstance();
        if (this.getOwnerThread() != null) {
            this.jStackFrames = jstack.getStackTraceElements(this.getOwnerThread());
        }
        super.getThreadInfoMap();
        return this.threadInfoMap;
    }
}

