/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.util;

import coldfusion.monitor.stack.JStackTrace;
import coldfusion.monitor.stack.JStackTraceFactory;
import coldfusion.monitor.util.CallableThreadDictionary;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.monitor.util.ThreadMonitorData;
import coldfusion.runtime.Struct;
import coldfusion.runtime.async.CallableUDFMethod;
import java.util.Map;

public class CallableThreadMonitorData
extends ThreadMonitorData {
    private CallableUDFMethod task;

    public CallableThreadMonitorData(CallableUDFMethod task2) {
        super(task2.getParentRmd(), Thread.currentThread().getName(), task2.getPageContext().getCurrentLineNo());
        this.task = task2;
        CallableThreadDictionary.getInstance().addThreadMonitor(this);
        this.initThreadStartData();
        this.parent.addThreadMonitorData(this);
        this.parent.updateThreadData(this);
    }

    @Override
    public synchronized void destroy() {
        this.parent.removeThreadMonitorData(this);
        CallableThreadDictionary.getInstance().removeThreadMonitor(this);
        this.parent = null;
        this.task = null;
        current.set(null);
    }

    @Override
    public boolean isActive() {
        return this.task != null;
    }

    @Override
    public Thread getOwnerThread() {
        return this.task.getOwnerThread();
    }

    @Override
    public int getPriority() {
        return this.getOwnerThread().getPriority();
    }

    @Override
    public String getJavaThreadName() {
        return this.getOwnerThread().getName();
    }

    @Override
    public Map getThreadInfoMap() {
        this.threadInfoMap = new Struct();
        this.threadInfoMap.put("threadName", (Object)this.task.getJavaThreadName());
        this.threadInfoMap.put("time_taken", (Object)Long.toString(this.task.getElapsedTime()));
        JStackTrace jstack = JStackTraceFactory.providerInstance();
        if (this.task.getOwnerThread() != null) {
            this.jStackFrames = jstack.getStackTraceElements(this.task.getOwnerThread());
        }
        super.getThreadInfoMap();
        return this.threadInfoMap;
    }

    @Override
    public RequestMonitorData getParentRequestMonitorData() {
        return this.task.getParentRmd();
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public int getLineNo() {
        return this.lineNo;
    }

    @Override
    public long getStartTime() {
        return this.task.getStartTime();
    }

    @Override
    public long getElapsedTime() {
        return this.task.getElapsedTime();
    }
}

