/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class MonitorList {
    private static final int DEFAULT_MONITORED_LIST_MAX_SIZE = 10;
    private ArrayList monitoredList = new ArrayList(10);
    private int monitoredListMaxSize = 10;
    protected boolean needsReload = false;

    public synchronized void setMaxSize(int size) {
        if (size <= 0) {
            return;
        }
        if (size < this.monitoredListMaxSize) {
            if (this.getSize() > size) {
                for (int i = this.monitoredList.size() - 1; i >= size; --i) {
                    this.monitoredList.remove(i);
                }
            }
        } else {
            this.needsReload = true;
        }
        this.monitoredListMaxSize = size;
    }

    public int getMaxSize() {
        return this.monitoredListMaxSize;
    }

    protected abstract Iterator getSourceData();

    protected abstract boolean compareThreshold(Object var1);

    protected abstract boolean compare(Object var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o) {
        if (this.compareThreshold(o)) {
            return false;
        }
        MonitorList monitorList = this;
        synchronized (monitorList) {
            int listSize = this.monitoredList.size();
            int elementIndex = this.monitoredList.indexOf(o);
            if (listSize == this.monitoredListMaxSize && this.compare(o, this.monitoredList.get(this.monitoredListMaxSize - 1)) && elementIndex == -1) {
                return false;
            }
            int startIndex = 0;
            int endIndex = 0;
            if (elementIndex != -1) {
                boolean largerThanNext;
                boolean smallerThanPrevious = elementIndex == 0 || this.compare(o, this.monitoredList.get(elementIndex - 1));
                boolean bl = largerThanNext = elementIndex == listSize - 1 || !this.compare(o, this.monitoredList.get(elementIndex + 1));
                if (smallerThanPrevious && largerThanNext) {
                    return true;
                }
                if (!largerThanNext) {
                    startIndex = listSize - 2;
                    endIndex = elementIndex + 1;
                    endIndex = endIndex > listSize - 2 ? listSize - 2 : endIndex;
                } else if (!smallerThanPrevious) {
                    startIndex = elementIndex - 2;
                    endIndex = 0;
                }
                this.monitoredList.remove(elementIndex);
            } else {
                startIndex = listSize - 1;
                endIndex = 0;
            }
            boolean isInserted = false;
            try {
                for (int i = startIndex; i >= endIndex && i < this.monitoredList.size(); --i) {
                    Object current = this.monitoredList.get(i);
                    if (!this.compare(o, current)) continue;
                    this.monitoredList.add(i + 1, o);
                    isInserted = true;
                    break;
                }
            }
            catch (AbortInsertException e) {
                return false;
            }
            if (!isInserted) {
                this.monitoredList.add(endIndex, o);
            }
            if (this.monitoredList.size() > this.monitoredListMaxSize) {
                this.monitoredList.remove(this.monitoredList.size() - 1);
            }
            return true;
        }
    }

    public synchronized void remove(Object o) {
        this.monitoredList.remove(o);
    }

    public synchronized void reload(boolean force) {
        if (force || this.needsReload) {
            Iterator data = this.getSourceData();
            if (data == null) {
                return;
            }
            this.clear();
            while (data.hasNext()) {
                this.add(data.next());
            }
        }
        this.needsReload = false;
    }

    public synchronized void compareTrim() {
        for (int i = this.monitoredList.size() - 1; i >= 0 && this.compareThreshold(this.monitoredList.get(i)); --i) {
            this.monitoredList.remove(i);
        }
    }

    public List getList() {
        return (ArrayList)this.monitoredList.clone();
    }

    public synchronized int getSize() {
        return this.monitoredList.size();
    }

    public synchronized void clear() {
        this.monitoredList.clear();
    }

    protected class AbortInsertException
    extends RuntimeException {
    }
}

