/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.util;

import coldfusion.monitor.beans.TagAttribute;
import coldfusion.monitor.stack.CFStack;
import java.util.List;

public abstract class PageElementStat {
    private int lineno;
    private String name;
    private long executionTime;
    private CFStack stackTrace;
    private List<TagAttribute> tagAttributes;
    private static final String keySep = "#";
    private String elementTemplatePath;

    public PageElementStat() {
    }

    public PageElementStat(String name, int lineno, CFStack stackTrace) {
        this();
        this.setName(name);
        this.setLineno(lineno);
        this.setStackTrace(stackTrace);
    }

    public void setStackTrace(CFStack stackTrace) {
        this.stackTrace = stackTrace;
    }

    public CFStack getStackTrace() {
        return this.stackTrace;
    }

    public int getLineno() {
        return this.lineno;
    }

    public void setLineno(int lineno) {
        this.lineno = lineno;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    public String getElementTemplatePath() {
        return this.elementTemplatePath;
    }

    public void setElementTemplatePath(String path) {
        this.elementTemplatePath = path;
    }

    public String makeKey() {
        return PageElementStat.makeKey(this.getElementTemplatePath(), this.getName(), this.getLineno());
    }

    public static String makeKey(String elementTemplatePath, String name, int lineno) {
        StringBuffer buff = new StringBuffer();
        if (elementTemplatePath != null) {
            buff.append(elementTemplatePath);
            buff.append(keySep);
        }
        buff.append(name);
        buff.append(keySep);
        buff.append(lineno);
        return buff.toString();
    }

    protected abstract String getResponseName();

    public List<TagAttribute> getTagAttributes() {
        return this.tagAttributes;
    }

    public void setTagAttributes(List<TagAttribute> tagAttributes) {
        this.tagAttributes = tagAttributes;
    }
}

