/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.util;

import coldfusion.filter.FusionContext;
import coldfusion.monitor.util.RequestMonitorData;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class ThreadDictionary {
    private Map dictionary = Collections.synchronizedMap(new WeakHashMap());
    private static ThreadDictionary instance = new ThreadDictionary();

    private ThreadDictionary() {
    }

    public static ThreadDictionary getInstance() {
        return instance;
    }

    public void set(FusionContext obj) {
        Object cobj;
        Thread currentThread = Thread.currentThread();
        if (obj != null && (cobj = this.dictionary.get(currentThread)) != null) {
            ((FusionContextExtraInfo)cobj).setContext(obj);
        }
    }

    public void set(RequestMonitorData obj) {
        Thread currentThread = Thread.currentThread();
        if (obj != null) {
            Object cobj = this.dictionary.get(currentThread);
            if (cobj != null) {
                ((FusionContextExtraInfo)cobj).setMonitorData(obj);
            } else {
                this.dictionary.put(currentThread, new FusionContextExtraInfo(obj, currentThread));
            }
        } else {
            this.dictionary.remove(currentThread);
        }
    }

    public FusionContextExtraInfo get(String threadName) {
        threadName = threadName.trim();
        FusionContextExtraInfo info = null;
        FusionContextExtraInfo[] values = this.getCurrentValues();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].getThreadName().equalsIgnoreCase(threadName)) continue;
            info = values[i];
            break;
        }
        return info;
    }

    public FusionContextExtraInfo[] getCurrentValues() {
        return this.dictionary.values().toArray(new FusionContextExtraInfo[0]);
    }

    public static class FusionContextExtraInfo {
        Thread thread;
        FusionContext context;
        RequestMonitorData monitorData;
        String clientIpAddress;

        FusionContextExtraInfo(RequestMonitorData monitorData, Thread currentThread) {
            this.monitorData = monitorData;
            this.thread = currentThread;
        }

        public String getClientIpAddress() {
            return this.clientIpAddress;
        }

        public FusionContext getContext() {
            return this.context;
        }

        public void setContext(FusionContext context) {
            this.context = context;
            try {
                this.clientIpAddress = context.getRequest().getRemoteAddr();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public RequestMonitorData getMonitorData() {
            return this.monitorData;
        }

        public void setMonitorData(RequestMonitorData monitorData) {
            this.monitorData = monitorData;
        }

        public String getThreadName() {
            return this.thread.getName();
        }

        public Thread getThread() {
            return this.thread;
        }
    }
}

