/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.util;

import coldfusion.monitor.stack.CFStack;
import coldfusion.monitor.stack.CFStackFrame;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.Struct;
import java.util.ArrayList;
import java.util.Map;

public abstract class ThreadMonitorData
extends RequestMonitorData {
    protected RequestMonitorData parent;
    protected String threadName;
    protected int lineNo;
    Struct threadInfoMap;
    StackTraceElement[] jStackFrames = null;

    public ThreadMonitorData(RequestMonitorData parent, String threadName, int lineNo) {
        this.parent = parent;
        this.threadName = threadName;
        this.lineNo = lineNo;
    }

    protected void initThreadStartData() {
        CFStack cfStack = this.parent.getCFStack();
        CFStackFrame cfStackFrame = cfStack != null ? cfStack.peekStackFrame() : null;
        CFStack currentStack = this.getCFStack();
        if (cfStackFrame != null && currentStack != null) {
            currentStack.pushStackFrame(cfStackFrame);
        }
        current.set(this);
    }

    public Map getThreadInfoMap() {
        this.threadInfoMap.put("SPAWNEDFROM", (Object)this.getTemplatePath());
        this.threadInfoMap.put("REQUESTTEMPLATE", (Object)this.getParentRequestMonitorData().getTemplatePath());
        this.threadInfoMap.put("LINENO", (Object)Integer.toString(this.getLineNo()));
        this.threadInfoMap.put("CFTHREADNAME", (Object)this.getThreadName());
        CFStack cfStack = this.getCFStack();
        ArrayList stackFrames = cfStack != null ? cfStack.getStackFramesAsStrings() : new ArrayList();
        this.threadInfoMap.put("CFSTACKTRACE", (Object)stackFrames);
        if (this.jStackFrames != null) {
            ArrayList<String> jStackFrameList = new ArrayList<String>();
            for (int j = 0; j < this.jStackFrames.length; ++j) {
                jStackFrameList.add(this.jStackFrames[j].toString());
            }
            this.threadInfoMap.put("JAVASTACKTRACE", (Object)jStackFrameList);
        }
        return this.threadInfoMap;
    }

    public abstract RequestMonitorData getParentRequestMonitorData();

    public abstract String getThreadName();

    public abstract int getLineNo();

    public abstract long getStartTime();

    public abstract long getElapsedTime();

    public abstract void destroy();

    public abstract boolean isActive();

    public abstract Thread getOwnerThread();

    public abstract int getPriority();

    public abstract String getJavaThreadName();
}

