/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql;

import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.nosql.NoSQLFactory;
import coldfusion.nosql.NoSQLPasswordDecryptor;
import coldfusion.nosql.NoSQLQueryDetails;
import coldfusion.nosql.NoSQLServiceHandle;
import coldfusion.rds.RdsServlet;
import coldfusion.runtime.AppHelper;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.server.ConfigMap;
import coldfusion.server.ConfigMapListener;
import coldfusion.server.NoSQLService;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.sql.CacheDetails;
import coldfusion.sql.CachedQuery;
import coldfusion.tagext.io.cache.CacheTO;
import coldfusion.tagext.io.cache.CacheTagHelper;
import coldfusion.tagext.io.cache.GenericCache;
import coldfusion.tagext.io.cache.GenericCacheFactory;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.LruCache;
import coldfusion.util.PasswordUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;

public class NoSQLServiceImpl
extends ServiceBase
implements NoSQLService,
Observer,
ConfigMapListener {
    private ConfigMap datasourcesDefs;
    private ConfigMap copy;
    private File datasourcefile;
    private String _rootDir;
    private NoSQLService instance;
    private Map<Integer, CacheDetails> cachedQueryMap;
    private Map<String, NoSQLServiceHandle> dataSources = new CaseInsensitiveMap();
    private Map<String, NoSQLFactory> dbServiceFactories = new HashMap<String, NoSQLFactory>();
    private String seed;
    private static final boolean migrate = Boolean.getBoolean("coldfusion.migrate.dsnloadonce");
    public static final String AUTH_MECHANISM = "authMechanism";
    public static final String INVALID_CREDENTIALS = "InvalidCredentials";
    public static final String PASSWORD = "password";
    public static final String USERNAME = "username";
    public static final String PORT = "port";
    public static final String USERNAME_PASSWORD = "USERNAMEPASSWORD";
    public static final String MONGODB_X509 = "MONGODB-X509";
    public static final String GSSAPI = "GSSAPI";
    public static final String PLAIN = "PLAIN";
    public static final String SCRAM_SHA_1 = "SCRAM-SHA-1";
    public static final String SCRAM_SHA_256 = "SCRAM-SHA-256";
    private final NoSQLPasswordDecryptor passwordDecryptor;
    ValidatorFiller filler = ValidatorFiller.INSTANCE;
    private LruCache query_cache = new LruCache(){

        @Override
        protected Object fetch(Object key) {
            return null;
        }
    };

    public NoSQLServiceImpl(File datasourcefile, String rootDir) {
        this.datasourcefile = datasourcefile;
        this._rootDir = rootDir;
        this.setEnableWatch(true);
        this.setWatchFile(datasourcefile);
        this.passwordDecryptor = new NoSQLPasswordDecryptorImpl(this);
        this.instance = this;
    }

    @Override
    public void start() throws ServiceException {
        super.start();
        if (this.isFirstLoad()) {
            PasswordUtils.getInstance().addObserver(this);
            CentralConfigClientUtil.delayStore(this);
        }
    }

    Vector loadDataSourceConfig() {
        return (Vector)this.deserialize(this.datasourcefile);
    }

    @Override
    public Map<?, ?> getDatasources() {
        if (!RdsServlet.getAuthenticated()) {
            ServiceFactory.getSecurityService().authenticateAdmin();
        }
        return this.datasourcesDefs;
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.datasourcesDefs = new ConfigMap(this, "nosql-datasources");
            Vector vDataSource = this.loadDataSourceConfig();
            Map _datasources = (Map)vDataSource.elementAt(0);
            for (String name : _datasources.keySet()) {
                Map c_M = (Map)_datasources.get(name);
                this.datasourcesDefs.put(name, (Object)c_M);
                if (!this.hasServiceFactory((String)c_M.get("type"))) continue;
                NoSQLServiceHandle serviceHandle = this.getServiceHandle((String)c_M.get("type"), c_M);
                this.dataSources.put(name, serviceHandle);
            }
            this.datasourcesDefs.setConfigMapListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reload(String dbType) throws ServiceException {
        Iterator keys = this.datasourcesDefs.keySet().iterator();
        while (keys.hasNext()) {
            try {
                String name = (String)keys.next();
                Map c_M = (Map)this.datasourcesDefs.get(name);
                if (!((String)c_M.get("type")).equalsIgnoreCase(dbType)) continue;
                NoSQLServiceHandle serviceHandle = this.getServiceHandle((String)c_M.get("type"), c_M);
                this.dataSources.put(name, serviceHandle);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.dataSources.keySet());
        return list;
    }

    @Override
    public void registerServiceFactory(NoSQLFactory factoryHandle) throws ServiceException {
        this.dbServiceFactories.put(factoryHandle.getName().toLowerCase(), factoryHandle);
        this.reload(factoryHandle.getName());
    }

    @Override
    public int getServiceFactoryCount() {
        return this.getServiceFactoryCount(false);
    }

    @Override
    public int getServiceFactoryCount(boolean throwError) {
        if (this.dbServiceFactories.size() == 0 && throwError) {
            throw new ServiceFactory.ModuleNotAvailableException("cfmongodb");
        }
        return this.dbServiceFactories.size();
    }

    @Override
    public void removeServiceFactory(String name) {
        this.dbServiceFactories.remove(name.toLowerCase());
    }

    @Override
    public NoSQLFactory getServiceFactory(String name) {
        NoSQLFactory serviceFactory = this.dbServiceFactories.get(name.toLowerCase());
        if (serviceFactory == null) {
            throw new ServiceRuntimeException(name + " is not a valid NoSQL database type");
        }
        return serviceFactory;
    }

    public boolean hasServiceFactory(String name) {
        return this.dbServiceFactories.get(name.toLowerCase()) != null;
    }

    public NoSQLServiceHandle getServiceHandle(String dbType, Map config) {
        NoSQLFactory serviceFactory = this.getServiceFactory(dbType);
        boolean init = false;
        Object object = config.get("init");
        if (object != null) {
            init = Cast._boolean(object);
        }
        return serviceFactory.getServiceHandle(config, init, this.passwordDecryptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NoSQLServiceHandle getServiceHandle(String dbType, Object config) {
        if (this.getServiceFactoryCount(true) == 0) {
            throw new ServiceRuntimeException(dbType + " is not a valid NoSQL database type");
        }
        NoSQLServiceHandle svcHandle = null;
        if (config instanceof String) {
            Map c_M;
            String dsn = (String)config;
            try {
                String appName = FusionContext.getCurrent().getApplicationName();
                ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
                svcHandle = (NoSQLServiceHandle)appScope.getAppNoSQLDataSource(dsn);
            }
            catch (Exception appName) {
                // empty catch block
            }
            if (svcHandle == null && (svcHandle = this.dataSources.get(dsn)) == null && (c_M = (Map)this.datasourcesDefs.get(dsn)) != null && ((String)c_M.get("type")).equalsIgnoreCase(dbType)) {
                ConfigMap configMap = this.datasourcesDefs;
                synchronized (configMap) {
                    svcHandle = this.dataSources.get(dsn);
                    if (svcHandle == null) {
                        svcHandle = this.getServiceHandle((String)c_M.get("type"), c_M);
                        this.dataSources.put(dsn, svcHandle);
                        return svcHandle;
                    }
                }
            }
            if (svcHandle != null) {
                if (svcHandle.getDBType().equalsIgnoreCase(dbType)) {
                    return svcHandle;
                }
                throw new ServiceRuntimeException("Requested datasource " + dsn + " is not of type " + dbType);
            }
            throw new ServiceRuntimeException("NoSQL Datasource with name " + dsn + " is not found");
        }
        return this.getServiceHandle(dbType, Cast._Map(config));
    }

    @Override
    public boolean verifyDatasource(String dsn) {
        Map dataSource = this.getDatasource(dsn);
        if (dataSource != null) {
            NoSQLFactory serviceFactory = this.getServiceFactory((String)dataSource.get("type"));
            return serviceFactory.verifyConnection(dataSource);
        }
        return false;
    }

    public String encryptPassword(String p) {
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        return PasswordUtils.encryptPassword(p, this.seed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String reEncryptPasswordForMigration(String password, String oldSeed, String oldAlgoValue, int majorVersion, int minorVersion) {
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        if (password != null) {
            ConfigMap configMap = this.datasourcesDefs;
            synchronized (configMap) {
                try {
                    String newPassword = PasswordUtils.reEncryptWithNewSeed(password, oldSeed, this.seed, oldAlgoValue, majorVersion, minorVersion);
                    return newPassword;
                }
                catch (Exception e) {
                    CFLogs.SERVER_LOG.error(e);
                }
            }
        }
        return null;
    }

    @Override
    public void store() throws ServiceException {
        this.store(true);
    }

    @Override
    public void store(boolean broadcast) throws ServiceException {
        this.store(null, null, null, broadcast);
    }

    @Override
    public void store(Object key, Object value, Object oldValue) throws ServiceException {
        this.store(key, value, oldValue, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Object key, Object value, Object oldValue, boolean broadcast) throws ServiceException {
        Vector<ConfigMap> vDatasources = new Vector<ConfigMap>();
        if (migrate) {
            ConfigMap configMap = this.datasourcesDefs;
            synchronized (configMap) {
                if (this.copy == null) {
                    this.copy = new ConfigMap(this, "nosql-datasources");
                }
                for (Object dsn : this.datasourcesDefs.keySet()) {
                    if (this.copy.containsKey(dsn)) continue;
                    Map ds = (Map)this.datasourcesDefs.get(dsn);
                    this.copy.put(dsn, (Object)ds);
                }
                vDatasources.addElement(this.copy);
            }
        }
        ConfigMap configMap = this.datasourcesDefs;
        synchronized (configMap) {
            ConfigMap copy = new ConfigMap(this, "nosql-datasources");
            for (Object dsn : this.datasourcesDefs.keySet()) {
                Map ds = (Map)this.datasourcesDefs.get(dsn);
                copy.put(dsn, (Object)ds);
            }
            vDatasources.addElement(copy);
        }
        this.serialize(vDatasources, this.datasourcefile, broadcast, key, value, oldValue);
    }

    @Override
    public void mapModified() {
        try {
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    @Override
    public void mapModified(ConfigMap map, Object key) {
        if (map == this.datasourcesDefs) {
            try {
                this.removeDatasource(key.toString());
            }
            catch (Exception sqle) {
                throw new ServiceRuntimeException(sqle);
            }
        }
        try {
            this.store(key, "", "DELETION");
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    private static String getStringProperty(String key, Map<?, ?> configMap) {
        try {
            return (String)configMap.get(key);
        }
        catch (ClassCastException e) {
            throw new ServiceRuntimeException("The datasource configuration contains an invalid value for " + key + ". Given value is not a valid string.");
        }
    }

    @Override
    public Closeable setDataSource(Map<?, ?> config) {
        return this.setDataSource((String)config.get("name"), (String)config.get("type"), config);
    }

    public Closeable setDataSource(String dsn, Map<?, ?> config) {
        String dbType = (String)config.get("type");
        return this.setDataSource(dsn, dbType, config);
    }

    public Closeable setDataSource(String dsn, String dbType, Map<?, ?> config) {
        NoSQLFactory serviceFactory = this.getServiceFactory(dbType);
        if (serviceFactory == null) {
            throw new RuntimeException("Unsupported NoSQL DB Type: " + dbType);
        }
        this.datasourcesDefs.put(dsn, (Object)config);
        NoSQLServiceHandle newDs = serviceFactory.getServiceHandle(config);
        Closeable previousDatasource = this.dataSources.put(dsn, newDs);
        if (previousDatasource != null) {
            try {
                previousDatasource.close();
            }
            catch (IOException e) {
                throw new ServiceRuntimeException(e);
            }
        }
        return newDs;
    }

    @Override
    public Map getDatasource(String dsn) {
        if (!RdsServlet.getAuthenticated()) {
            try {
                ServiceFactory.getSecurityService().authenticateAdmin();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return (Map)this.datasourcesDefs.get(dsn);
    }

    @Override
    public Object removeDatasource(String dsn) {
        if (!RdsServlet.getAuthenticated()) {
            try {
                ServiceFactory.getSecurityService().authenticateAdmin();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Object removed = this.datasourcesDefs.remove(dsn);
        Closeable removedDataSource = this.dataSources.remove(dsn);
        if (removedDataSource != null) {
            try {
                removedDataSource.close();
            }
            catch (IOException e) {
                throw new ServiceRuntimeException(e);
            }
        }
        return removed;
    }

    @Override
    public Object getCachedQuery(NoSQLQueryDetails key, String cacheRegion, Long cachedWithin) {
        String appName = null;
        if (FusionContext.getCurrent() != null) {
            appName = FusionContext.getCurrent().getApplicationName();
        }
        ApplicationScope appScope = null;
        if (appName != null) {
            appScope = ApplicationScopeTracker.getApplicationScope(appName);
        }
        if (!AppHelper.useInternalQueryCache(appScope)) {
            if (cacheRegion != null && !cacheRegion.equalsIgnoreCase("NOSQL_QUERY")) {
                GenericCache cache = GenericCacheFactory.getCache();
                CacheTO cacheTO = new CacheTO(appName, "NOSQL_QUERY", key.getCacheId(), null, -1L, -1L, cacheRegion, false, null);
                return cache.get(cacheTO, true);
            }
            Object argcacheid = key.getCacheId() instanceof String ? (String)key.getCacheId() : key.getCacheId();
            AppHelper.getDefaultCache(appScope);
            GenericCache cache = GenericCacheFactory.getCache();
            CacheTO cacheTO = new CacheTO(appName, "NOSQL_QUERY", argcacheid, null, -1L, -1L, cacheRegion, false, null);
            Object value = cache.get(cacheTO, false, cachedWithin == null ? null : cachedWithin);
            if (value != null) {
                return value;
            }
        } else {
            CachedQuery query = (CachedQuery)this.query_cache.get(key);
            if (query != null && (cachedWithin == null || System.currentTimeMillis() < query.getCreationTime() + cachedWithin)) {
                return query;
            }
        }
        return null;
    }

    @Override
    public void setCachedQuery(NoSQLQueryDetails key, int hashCode, Object value, Long cachedWithin, boolean eternal, String cacheId, String cacheRegion) {
        String appName = null;
        if (FusionContext.getCurrent() != null) {
            appName = FusionContext.getCurrent().getApplicationName();
        }
        ApplicationScope appScope = null;
        if (appName != null) {
            appScope = ApplicationScopeTracker.getApplicationScope(appName);
        }
        if (!AppHelper.useInternalQueryCache(appScope)) {
            Object id;
            Object object = id = cacheId != null ? cacheId : key.getCacheId();
            if (this.cachedQueryMap == null) {
                this.cachedQueryMap = new HashMap<Integer, CacheDetails>();
            }
            CacheDetails details = new CacheDetails();
            details.setApplicationName(appName);
            details.setCacheId(id);
            details.setCacheRegion(cacheRegion);
            this.cachedQueryMap.put(key.getHashCode(), details);
            if (cacheRegion != null && !cacheRegion.equalsIgnoreCase("NOSQL_QUERY")) {
                CacheTO cacheTO = new CacheTO(appName, "NOSQL_QUERY", id, value, -1L, -1L, cacheRegion, false, null);
                if (cachedWithin != null && cachedWithin > 0L) {
                    cacheTO.setTimetoLive(cachedWithin / 1000L);
                } else if (eternal) {
                    cacheTO.eternal = true;
                }
                GenericCache ehcache_cached_query = GenericCacheFactory.getCache();
                ehcache_cached_query.put(cacheTO, false);
            } else {
                if (id != null && id instanceof String) {
                    id = (String)id;
                }
                CacheTO xObj = new CacheTO();
                xObj.id = id;
                xObj.value = value;
                xObj.objecttype = "NOSQL_QUERY";
                xObj.appname = appName;
                if (eternal) {
                    xObj.eternal = true;
                } else if (cachedWithin != null && cachedWithin > 0L) {
                    xObj.timetoLive = (int)(cachedWithin / 1000L);
                }
                GenericCacheFactory.getCache().put(xObj, false);
            }
        } else {
            this.saveQueryInInternalCache(key, value);
        }
    }

    private void saveQueryInInternalCache(NoSQLQueryDetails key, Object value) {
        this.query_cache.put(key, value);
        int hash2 = key.hashCode();
        Set<NoSQLQueryDetails> qd = null;
        qd = this.query_cache.keys().contains(hash2) ? (Set)this.query_cache.get(hash2) : new HashSet<NoSQLQueryDetails>();
        qd.add(key);
        this.query_cache.put(hash2, qd);
    }

    @Override
    public void removeCachedQuery(NoSQLQueryDetails key, String cacheId, String cacheRegion) {
        String appName = FusionContext.getCurrent().getApplicationName();
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
        if (!AppHelper.useInternalQueryCache(appScope)) {
            Object queryCache;
            GenericCache ehcache_cached_query = GenericCacheFactory.getCache();
            CacheTO cacheTO = new CacheTO();
            if (cacheId != null) {
                cacheTO.setId(cacheId);
            } else {
                cacheTO.setId(key.getCacheId());
            }
            if (cacheRegion == null) {
                cacheTO.setKey("NOSQL_QUERY");
            } else {
                cacheTO.setKey(cacheRegion);
            }
            ehcache_cached_query.remove(cacheTO);
            if (this.cachedQueryMap != null) {
                this.cachedQueryMap.remove(key.getHashCode());
            }
            if ((queryCache = AppHelper.getDefaultCache(appScope)) != null) {
                GenericCache cache = GenericCacheFactory.getCache();
                cache.remove(cacheTO);
            }
        } else {
            this.query_cache.remove(key);
        }
    }

    @Override
    public void removeCachedQuery(Object query, String dsname, Array values, String region) {
    }

    @Override
    public void purgeQueryCache() {
        if (this.cachedQueryMap != null) {
            CacheTagHelper.purgeAllQueryCache(this.cachedQueryMap);
            this.cachedQueryMap.clear();
        }
        if (this.query_cache != null) {
            this.query_cache.clear();
        }
    }

    @Override
    public List<?> getCachedQueries() {
        return null;
    }

    @Override
    public void update(Observable o, Object arg) {
        String seedVal;
        String oldSeed = this.seed;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
            if (oldSeed == null) {
                return;
            }
            this.reEncryptPassword(oldSeed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reEncryptPassword(String oldSeed) {
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        Vector<ConfigMap> vDatasources = new Vector<ConfigMap>();
        ConfigMap configMap = this.datasourcesDefs;
        synchronized (configMap) {
            ConfigMap copy = new ConfigMap(this, "nosql-datasources");
            Iterator i = this.datasourcesDefs.keySet().iterator();
            while (i.hasNext()) {
                String dsn = null;
                try {
                    dsn = (String)i.next();
                    Map ds = (Map)this.datasourcesDefs.get(dsn);
                    try {
                        String oldPass = (String)ds.get(PASSWORD);
                        ds.put(PASSWORD, PasswordUtils.reEncryptWithNewSeed(oldPass, oldSeed, this.seed));
                    }
                    catch (Exception e) {
                        CFLogs.SERVER_LOG.error(e);
                    }
                    ConfigMap clon = new ConfigMap(this, "nosql-datasource");
                    clon.putAll(ds);
                    copy.put(dsn, (Object)clon);
                }
                catch (Exception se) {
                    CFLogs.SERVER_LOG.warn("Datasource Exception in Encryption with new Seed: " + dsn, se);
                }
            }
            vDatasources.addElement(copy);
        }
        this.serialize(vDatasources, this.datasourcefile);
    }

    String getSeed() {
        if (null != this.seed) {
            return this.seed;
        }
        return PasswordUtils.getInstance().getSeedValue();
    }

    @Override
    public boolean isValidNoSQLDBType(String name) {
        return this.dbServiceFactories.containsKey(name.toLowerCase());
    }

    private class NoSQLPasswordDecryptorImpl
    implements NoSQLPasswordDecryptor {
        private NoSQLServiceImpl noSQLImpl;

        private NoSQLPasswordDecryptorImpl(NoSQLServiceImpl noSQLImpl) {
            this.noSQLImpl = noSQLImpl;
        }

        @Override
        public String decryptPassword(String password) {
            return PasswordUtils.decryptPassword(password, this.noSQLImpl.getSeed());
        }
    }
}

