/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf.core;

import coldfusion.pdf.core.PDFDocException;
import coldfusion.runtime.ApplicationException;
import java.io.File;

public class PDFException {

    public static class FDFNotAllowedException
    extends ApplicationException {
    }

    public static class FormFillNotAllowedException
    extends ApplicationException {
    }

    public static class TargetFileIsDirectoryException
    extends ApplicationException {
        public String directory = null;

        public TargetFileIsDirectoryException(String directory) {
            this.directory = directory;
        }
    }

    public static class DataAttributeInvalidXMLException
    extends ApplicationException {
        public DataAttributeInvalidXMLException(Throwable e) {
            super(e);
        }
    }

    public static class XMLDataAttributeValueException
    extends ApplicationException {
        public XMLDataAttributeValueException(Throwable e) {
            super(e);
        }
    }

    public static class FileIOException
    extends ApplicationException {
        public String destination = null;

        public FileIOException(String destination) {
            this.destination = destination;
        }
    }

    public static class InvalidFileNameException
    extends ApplicationException {
        public String destination = null;

        public InvalidFileNameException(String destination) {
            this.destination = destination;
        }
    }

    public static class XDPConvertException
    extends ApplicationException {
        public String sourceFile = null;

        public XDPConvertException(String sourceFile) {
            this.sourceFile = sourceFile;
        }
    }

    public static class FileReadWriteException
    extends ApplicationException {
        public String destination = null;

        public FileReadWriteException(String destination) {
            this.destination = destination;
        }
    }

    public static class FileOverwriteException
    extends ApplicationException {
        public String destination = null;

        public FileOverwriteException(String destination) {
            this.destination = destination;
        }
    }

    public static class FileAccessException
    extends ApplicationException {
        public String destination = null;

        public FileAccessException(String destination) {
            this.destination = destination;
        }
    }

    public static class FileReadOnlyException
    extends ApplicationException {
        public String destination = null;

        public FileReadOnlyException(String destination) {
            this.destination = destination;
        }
    }

    public static class FileCouldNotBeFoundException
    extends ApplicationException {
        public String fileName = null;

        public FileCouldNotBeFoundException(String file) {
            this.fileName = file;
        }

        public FileCouldNotBeFoundException(Throwable t, String file) {
            super(t);
            this.fileName = file;
        }
    }

    public static class NotAPDFFormException
    extends ApplicationException {
    }

    public static class InvalidDataXMLException
    extends ApplicationException {
    }

    public static class InvalidUseException
    extends ApplicationException {
    }

    public static class InvalidXmlDataAttributeValueException
    extends ApplicationException {
        public InvalidXmlDataAttributeValueException(Throwable ex) {
            super(ex);
        }
    }

    public static class InvalidDataFileAttributeException
    extends ApplicationException {
    }

    public static class InvalidVariableException
    extends ApplicationException {
        public String attribute;

        public InvalidVariableException(String attr) {
            this.attribute = attr;
        }
    }

    public static class PDFInvalidDocumentVariableException
    extends PDFDocException {
    }

    public static class PDFOwnerPasswordPermException
    extends PDFDocException {
    }

    public static class PDFOwnerPasswordException
    extends PDFDocException {
        public String attrName;

        public PDFOwnerPasswordException(String attr) {
            this.attrName = attr;
        }
    }

    public static class PDFDocumentInvalidEncryptionPermission
    extends PDFDocException {
        public String permission = "";

        public PDFDocumentInvalidEncryptionPermission(String permission) {
            this.permission = permission;
        }
    }

    public static class PDFInvalidPermissionException
    extends PDFDocException {
        public String attrName;
        public String attrValue;

        public PDFInvalidPermissionException(String attr, String value) {
            this.attrName = attr;
            this.attrValue = value;
        }
    }

    public static class DocumentHeaderFooterException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        public DocumentHeaderFooterException(Throwable th) {
            super(th);
        }
    }

    public static class HtmlToPdfInvalidWaterMarkFileException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class PDFInvalidArgException
    extends PDFDocException {
    }

    public static class IconNameException
    extends PDFDocException {
    }

    public static class PDFCoordinateException
    extends PDFDocException {
    }

    public static class PDFNameDestinationException
    extends PDFDocException {
        public String attrName1 = null;
        public String attrName2 = null;
        public String actionName = null;

        public PDFNameDestinationException(String attrName1, String attrName2, String actionName) {
            this.attrName1 = attrName1;
            this.attrName2 = attrName2;
            this.actionName = actionName;
        }
    }

    public static class PDFMissingSourceAttribute
    extends PDFDocException {
        public String attrName = null;
        public String actionName = null;

        public PDFMissingSourceAttribute(String attrName, String actionName) {
            this.attrName = attrName;
            this.actionName = actionName;
        }
    }

    public static class PDFMissingParentTagException
    extends PDFDocException {
        public String action = "merge";
    }

    public static class MissingAttributeException
    extends PDFDocException {
        public String attrName = null;
        public String tagname = "CFPDF";
        public String action = null;

        public MissingAttributeException(String attrName, String tagname, String action) {
            this.attrName = attrName;
            this.tagname = tagname;
            this.action = action;
        }
    }

    public static class InvalidAttributeValueException2
    extends ApplicationException {
    }

    public static class InvalidActionAttributeException2
    extends ApplicationException {
    }

    public static class InvalidAttributeValueException
    extends PDFDocException {
        public String attrName = null;
        public String tagname = "CFPDF";
        public String dependentattrName = null;

        public InvalidAttributeValueException(String attrName, String tagname, String dependentattrName) {
            this.attrName = attrName;
            this.tagname = tagname;
            this.dependentattrName = dependentattrName;
        }
    }

    public static class PDFSignatureFieldUnsignNotAllowedException
    extends PDFDocException {
        public PDFSignatureFieldUnsignNotAllowedException(Object pdfdoc) {
            super(pdfdoc);
        }
    }

    public static class PDFSignatureFieldCreationNotPermittedExcception
    extends PDFDocException {
        public PDFSignatureFieldCreationNotPermittedExcception(Object pdfdoc) {
            super(pdfdoc);
        }
    }

    public static class PDFSignatureFieldFillingOperationNotPermittedExcception
    extends PDFDocException {
        public String field;

        public PDFSignatureFieldFillingOperationNotPermittedExcception(String field, Object pdfdoc) {
            super(pdfdoc);
            this.field = field;
        }
    }

    public static class PDFInvalidXSDException
    extends PDFDocException {
    }

    public static class PDFStandardException
    extends PDFDocException {
    }

    public static class PDFArchiveUnsuccessfulException
    extends PDFDocException {
        public Object report;

        public PDFArchiveUnsuccessfulException(Object obj) {
            this.report = obj;
        }
    }

    public static class PDFStructFNFException
    extends PDFDocException {
        public String attrValue = null;

        public PDFStructFNFException(Exception ex) {
            super(ex);
        }
    }

    public static class PDFInvalidDDXException
    extends PDFDocException {
        public String attrValue = null;

        public PDFInvalidDDXException(String attrValue) {
            this.attrValue = attrValue;
        }

        public PDFInvalidDDXException(String attrValue, Throwable t) {
            super(t);
            this.attrValue = attrValue;
        }
    }

    public static class PDFEmptyDirectoryException
    extends PDFDocException {
        public String attrName = "directory";
        public String actionName = "merge";
        public String attrValue = null;

        public PDFEmptyDirectoryException(String attrValue) {
            this.attrValue = attrValue;
        }
    }

    public static class PDFSanitizeException
    extends PDFDocException {
        public String error = null;

        public PDFSanitizeException(String error) {
            if (error.equalsIgnoreCase("collections")) {
                this.error = "collections";
            }
            if (error.equalsIgnoreCase("XFA")) {
                this.error = "XFA content";
            }
            if (error.equalsIgnoreCase("digital")) {
                this.error = "digitally signed";
            }
        }
    }

    public static class PDFCopyFromNoPageException
    extends PDFDocException {
        public String attrName = null;
        public String actionName = null;
        public String attrValue = null;

        public PDFCopyFromNoPageException(String attrName, String actionName, String attrValue) {
            this.attrName = attrName;
            this.actionName = actionName;
            this.attrValue = attrValue;
        }
    }

    public static class PDFWriteFlattenException
    extends PDFDocException {
        public String attrName = null;
        public String actionName = null;

        public PDFWriteFlattenException(String attrName, String actionName) {
            this.attrName = attrName;
            this.actionName = actionName;
        }
    }

    public static class PDFUnAuthorisedOperationException
    extends PDFDocException {
        public String Action;

        public PDFUnAuthorisedOperationException(String a, Throwable ex, Object pdfDocument) {
            super(ex, pdfDocument);
            this.Action = a;
        }

        public PDFUnAuthorisedOperationException(String a, Throwable ex) {
            super(ex);
            this.Action = a;
        }

        public PDFUnAuthorisedOperationException(String a) {
            this.Action = a;
        }

        public PDFUnAuthorisedOperationException(String a, Object pdfDocument) {
            super(pdfDocument);
            this.Action = a;
        }
    }

    public static class PDFInvallidDocumentNameException
    extends PDFDocException {
        public String Action;
        public String file;

        public PDFInvallidDocumentNameException(String a, Throwable ex, String name, Object pdfDocument) {
            super(ex, pdfDocument);
            this.Action = a;
            this.file = name;
        }

        public PDFInvallidDocumentNameException(String a, Throwable ex, String name) {
            super(ex);
            this.Action = a;
            this.file = name;
        }
    }

    public static class PDFSetInfoInvalidModException
    extends PDFDocException {
        public String Action;

        public PDFSetInfoInvalidModException(String a, Throwable ex, Object pdfDocument) {
            super(ex, pdfDocument);
            this.Action = a;
        }
    }

    public static class PDFNoSourceException2
    extends PDFDocException {
        public String attrName = null;
        public String actionName = null;

        public PDFNoSourceException2(String attrName, String actionName) {
            this.attrName = attrName;
            this.actionName = actionName;
        }
    }

    public static class PDFNoSourceException
    extends PDFDocException {
        public String Action;

        public PDFNoSourceException(String a) {
            this.Action = a;
        }
    }

    public static class PDFInvallidDocumentException
    extends PDFDocException {
        public String Action;

        public PDFInvallidDocumentException(String a, Throwable ex, Object pdfDocument) {
            super(ex, pdfDocument);
            this.Action = a;
        }

        public PDFInvallidDocumentException(String a, Throwable ex) {
            super(ex);
            this.Action = a;
        }

        public PDFInvallidDocumentException(String a, Object pdfDocument) {
            super(pdfDocument);
            this.Action = a;
        }
    }

    public static class PDFIncorrectPasswordException
    extends PDFDocException {
        public String Action;

        public PDFIncorrectPasswordException(String a, Throwable ex) {
            super(ex);
            this.Action = a;
        }
    }

    public static class PDFOperationException
    extends PDFDocException {
        public String Action;
        public String Cause;

        public PDFOperationException(String a, Throwable ex, Object pdfDocument) {
            super(ex, pdfDocument);
            this.Action = a;
            this.Cause = ex.getLocalizedMessage();
        }

        public PDFOperationException(String a, Throwable ex) {
            this.Action = a;
            this.Cause = ex.getLocalizedMessage();
        }
    }

    public static class InvalidKeystoreException
    extends PDFDocException {
        private static final long serialVersionUID = 1L;

        public InvalidKeystoreException(Throwable e) {
            super(e);
        }
    }

    public static class SignatureFieldNotSignedException
    extends PDFDocException {
        public SignatureFieldNotSignedException(Object pdfdoc) {
            super(pdfdoc);
        }
    }

    public static class NoSignaturesInPDFException
    extends PDFDocException {
        public NoSignaturesInPDFException(Object pdfdoc) {
            super(pdfdoc);
        }
    }

    public static class PageNumberOutOfRangeException
    extends PDFDocException {
        public int page;

        public PageNumberOutOfRangeException(int page, Object pdfdoc) {
            super(pdfdoc);
            this.page = page;
        }
    }

    public static class SignaturesAlreadyExistException
    extends PDFDocException {
        public SignaturesAlreadyExistException(Object pdfdoc) {
            super(pdfdoc);
        }
    }

    public static class DocumentAlreadyCertifiedException
    extends PDFDocException {
        public DocumentAlreadyCertifiedException(Object pdfdoc) {
            super(pdfdoc);
        }
    }

    public static class SignatureFieldNotFoundException
    extends PDFDocException {
        public String field;

        public SignatureFieldNotFoundException(String field, Object pdfdoc) {
            super(pdfdoc);
            this.field = field;
        }
    }

    public static class UnableToCertifyDocumentException
    extends PDFDocException {
        public UnableToCertifyDocumentException(Object pdfdoc) {
            super(pdfdoc);
        }
    }

    public static class InvalidCoordinateException
    extends PDFDocException {
        public String coordinates;

        public InvalidCoordinateException(String coordinate, Object pdfdoc) {
            super(pdfdoc);
            this.coordinates = coordinate;
        }
    }

    public static class InvalidCoordinatesException
    extends PDFDocException {
        public String coordinates;

        public InvalidCoordinatesException(String coordinate) {
            this.coordinates = coordinate;
        }
    }

    public static class UnrecoverablePrivateKeyException
    extends PDFDocException {
        private static final long serialVersionUID = 1L;

        public UnrecoverablePrivateKeyException(Throwable e) {
            super(e);
        }
    }

    public static class KeyNotFoundException
    extends PDFDocException {
        private static final long serialVersionUID = 1L;
        public String keyalias;

        public KeyNotFoundException(String keyalias) {
            this.keyalias = keyalias;
        }
    }

    public static class UnabletoSignPDFUsingGivenKeyStoreException
    extends PDFDocException {
        public String filename;

        public UnabletoSignPDFUsingGivenKeyStoreException(String filename) {
            this.filename = filename;
        }
    }

    public static class PDFExportImageException
    extends PDFDocException {
        public File src;

        public PDFExportImageException(File src) {
            this.src = src;
        }
    }

    public static class PDFNoDirectoryException2
    extends PDFDocException {
        public String attrName = null;
        public String actionName = null;

        public PDFNoDirectoryException2(String attrName, String actionName) {
            this.attrName = attrName;
            this.actionName = actionName;
        }
    }

    public static class PDFNoDirectoryException
    extends PDFDocException {
        public String file;

        public PDFNoDirectoryException(String file) {
            this.file = file;
        }
    }

    public static class PDFPageZeroException
    extends PDFDocException {
        public String attrdest = "pages";
        public String attrVal = null;

        public PDFPageZeroException(String page) {
            this.attrVal = page;
        }
    }

    public static class CouldNotDeleteFileException
    extends PDFDocException {
        public String file;

        public CouldNotDeleteFileException(String file) {
            this.file = file;
        }
    }

    public static class DirFileIsReadOnlyException
    extends PDFDocException {
        public String file;
        public String action;
        public String method;

        public DirFileIsReadOnlyException(String file, String action, String method) {
            this.file = file;
            this.action = action;
            this.method = method;
        }
    }

    public static class RemoveInvalidPageException
    extends PDFDocException {
        public String page = null;

        public RemoveInvalidPageException(String page, Object pdfDocument) {
            super(pdfDocument);
            this.page = page;
        }
    }

    public static class PDFInvalidPageDuplicatesException
    extends PDFDocException {
        public String attrName;
        public String attrValue;
        public int intA;

        public PDFInvalidPageDuplicatesException(String attr, String value, int a) {
            this.attrName = attr;
            this.attrValue = value;
            this.intA = a;
        }
    }

    public static class PDFInvalidPageFromToException
    extends PDFDocException {
        public String attrName;
        public String attrValue;

        public PDFInvalidPageFromToException(String attr, String value) {
            this.attrName = attr;
            this.attrValue = value;
        }
    }

    public static class PDFInvalidPageNumberException
    extends PDFDocException {
        public String Page;
        public String attr = "page";
        public String Action;

        public PDFInvalidPageNumberException(String page) {
            this.Page = page;
        }

        public PDFInvalidPageNumberException(String action, String page, Object pdfDocument) {
            super(pdfDocument);
            this.Action = action;
            this.Page = page;
        }
    }

    public static class PDFDeleteInvalidPageException
    extends PDFDocException {
        public String Action;
        public String Page;

        public PDFDeleteInvalidPageException(String action, String page, Object pdfDocument) {
            super(pdfDocument);
            this.Action = action;
            this.Page = page;
        }
    }

    public static class PDFInvalidPageException2
    extends PDFDocException {
    }

    public static class PDFInvalidPageException
    extends PDFDocException {
        public String attrName;
        public String attrValue;

        public PDFInvalidPageException(String attr, String value) {
            this.attrName = attr;
            this.attrValue = value;
        }
    }

    public static class PDFInvalidSourceException
    extends PDFDocException {
        public String cause;

        public PDFInvalidSourceException(String root) {
            this.cause = root;
        }
    }

    public static class PDFInvalidPassword
    extends PDFDocException {
    }

    public static class InvalidPageValueException
    extends PDFDocException {
    }

    public static class KeyStoreNotFoundException
    extends PDFDocException {
        public String filename;

        public KeyStoreNotFoundException(String filename) {
            this.filename = filename;
        }
    }

    public static class PDFFormatSpecificException
    extends PDFDocException {
        public String attrName;
        public String format;

        public PDFFormatSpecificException(String attrName, String format) {
            this.attrName = attrName;
            this.format = format;
        }
    }

    public static class PDFDirCreateException
    extends PDFDocException {
        public String attrName;
        public String attrValue;
        public String tagName = "pdf";

        public PDFDirCreateException(String attr, String value) {
            this.attrName = attr;
            this.attrValue = value;
        }
    }

    public static class PDFDirExistsException
    extends PDFDocException {
        public String attrName;
        public String attrValue;
        public String tagName = "pdf";

        public PDFDirExistsException(String attr, String value) {
            this.attrName = attr;
            this.attrValue = value;
        }
    }

    public static class PDFDirNotFoundException
    extends PDFDocException {
        public String attrName;
        public String attrValue;
        public String tagName = "pdf";

        public PDFDirNotFoundException(String attr, String value) {
            this.attrName = attr;
            this.attrValue = value;
        }
    }

    public static class PDFEmptyStructException
    extends PDFDocException {
        public String attrdest = null;

        public PDFEmptyStructException(String str) {
            this.attrdest = str;
        }
    }

    public static class PDFRedactSourceDirectoryException
    extends PDFDocException {
    }

    public static class PDFAddStampSourceDirectoryException
    extends PDFDocException {
    }

    public static class PDFMergeSourceDiretoryException
    extends PDFDocException {
    }

    public static class InvalidResolutionException
    extends PDFDocException {
        public String attrVal = null;

        public InvalidResolutionException(String op) {
            this.attrVal = op;
        }
    }

    public static class PDFInvalidFormatException
    extends PDFDocException {
        public String attrVal = null;

        public PDFInvalidFormatException(String op) {
            this.attrVal = op;
        }
    }

    public static class PDFInvalidScaleException
    extends PDFDocException {
        public String attrVal = null;
        public String scale = "scale";
        public String max = "100";

        public PDFInvalidScaleException(String op) {
            this.attrVal = op;
        }

        public PDFInvalidScaleException(String op, String scale) {
            this.attrVal = op;
            this.scale = scale;
            this.max = "1.0";
        }
    }

    public static class PDFInvalidOpacityException
    extends PDFDocException {
        public String attrVal = null;

        public PDFInvalidOpacityException(String op) {
            this.attrVal = op;
        }
    }

    public static class PDFDestNameException
    extends PDFDocException {
    }

    public static class PDFSourceNameException
    extends PDFDocException {
        public String attrsrc = "source";
        public String srcPdfFile = "";

        public PDFSourceNameException(File srcPdfFile) {
            if (srcPdfFile != null) {
                this.srcPdfFile = srcPdfFile.getPath();
            }
        }
    }

    public static class PDFActionValidateException
    extends PDFDocException {
        public String attrName = null;
        public String actionName = null;

        public PDFActionValidateException(String attrName, String actionName) {
            this.attrName = attrName;
            this.actionName = actionName;
        }
    }

    public static class NoPageException
    extends PDFDocException {
        public String actionName = null;

        public NoPageException(String actionName) {
            this.actionName = actionName;
        }
    }

    public static class IllegalPageException
    extends PDFDocException {
        public String attrName = "pages";
        public String actionName = "optimize";
    }

    public static class InvalidSourceAttributeException
    extends PDFDocException {
        public String attrName = null;
        public String actionName = null;

        public InvalidSourceAttributeException(String attrName, String actionName) {
            this.attrName = attrName;
            this.actionName = actionName;
        }
    }

    public static class PDFAttributeCombDelException
    extends PDFDocException {
        public String Action;

        PDFAttributeCombDelException(String action) {
            this.Action = action;
        }
    }

    public static class InvalidActionAttributeException
    extends PDFDocException {
        public String attrName = null;
        public String actionName = null;

        public InvalidActionAttributeException(String attrName, String actionName) {
            this.attrName = attrName;
            this.actionName = actionName;
        }
    }

    public static class InvalidVersionException
    extends PDFDocException {
        public String attrName = null;
        public double attrValue;

        public InvalidVersionException(String name, double value) {
            this.attrName = name;
            this.attrValue = value;
        }
    }

    public static class InvalidValueException
    extends PDFDocException {
        public String attrName = null;
        public String attrValue = null;
        public String valueList = null;

        public InvalidValueException(String name, String value, String list) {
            this.attrName = name;
            this.attrValue = value;
            this.valueList = list;
        }
    }

    public static class EmptyAttributeException2
    extends PDFDocException {
        public String attrName = null;
        public String tagname = "CFPDF";

        public EmptyAttributeException2(String attrName) {
            this.attrName = attrName;
        }
    }

    public static class PDFSubformTagEmptyAttributeException
    extends PDFDocException {
        public String attrName = null;
        public String tagname = "cfpdfsubform";

        public PDFSubformTagEmptyAttributeException(String attrName) {
            this.attrName = attrName;
        }
    }

    public static class EmptyAttributeException
    extends PDFDocException {
        public String attrName = null;
        public String tagname = "pdf";

        public EmptyAttributeException(String attrName) {
            this.attrName = attrName;
        }

        public EmptyAttributeException(String attrName, String tagname) {
            this.attrName = attrName;
            this.tagname = tagname;
        }
    }

    public static class EmptyAttributeException3
    extends ApplicationException {
        public String attrName = null;

        public EmptyAttributeException3(String attrName) {
            this.attrName = attrName;
        }
    }

    public static class EmptyAttributeForTagException
    extends ApplicationException {
        public String attrName = null;
        public String tag = null;

        public EmptyAttributeForTagException(String attrName, String tag) {
            this.attrName = attrName;
            this.tag = tag;
        }
    }
}

