/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf.core;

import coldfusion.runtime.Array;
import coldfusion.runtime.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class PDFFormFieldNamesConverter {
    private Struct outerMap = new Struct();

    public boolean extractFieldDetail(String complexFieldName, String complexFieldValue) {
        try {
            FieldDetail fieldDetail = null;
            if (FieldDetail.checkIfFieldNeedsConversion(complexFieldName)) {
                fieldDetail = new FieldDetail(complexFieldName);
            }
            if (fieldDetail != null) {
                Struct currentMap = this.outerMap;
                int level = 0;
                int depth = fieldDetail.getFieldTokens().size();
                for (String[] aField : fieldDetail.getFieldTokens()) {
                    String fieldName = aField[0];
                    int fieldIndex = Integer.parseInt(aField[1]);
                    Object value = currentMap.get(fieldName);
                    if (value == null) {
                        if (fieldIndex > 0) {
                            nestedFieldArray = new Array();
                            this.fillArrayListWithDummyValues(nestedFieldArray, fieldIndex);
                            if (depth - 1 == level) {
                                nestedFieldArray.set(fieldIndex, complexFieldValue);
                            } else {
                                nestedFieldArray.set(fieldIndex, new Struct());
                            }
                            currentMap.put(fieldName, (Object)nestedFieldArray);
                        } else if (depth - 1 == level) {
                            currentMap.put(fieldName, (Object)complexFieldValue);
                        } else {
                            currentMap.put(fieldName, (Object)new Struct());
                        }
                    } else if (value instanceof List) {
                        this.fillArrayListWithDummyValues((Array)value, fieldIndex);
                        if (depth - 1 == level) {
                            ((Array)value).set(fieldIndex, complexFieldValue);
                        } else if (((Array)value).get(fieldIndex) == null) {
                            ((Array)value).set(fieldIndex, new Struct());
                        }
                    } else if (value instanceof Map) {
                        if (fieldIndex > 0) {
                            nestedFieldArray = new Array();
                            nestedFieldArray.add(value);
                            this.fillArrayListWithDummyValues(nestedFieldArray, fieldIndex);
                            if (depth - 1 == level) {
                                nestedFieldArray.set(fieldIndex, complexFieldValue);
                            } else {
                                nestedFieldArray.set(fieldIndex, new Struct());
                            }
                            currentMap.put(fieldName, (Object)nestedFieldArray);
                        }
                    } else if (value instanceof String) {
                        nestedFieldArray = new Array();
                        nestedFieldArray.add(value);
                        this.fillArrayListWithDummyValues(nestedFieldArray, fieldIndex);
                        nestedFieldArray.set(fieldIndex, complexFieldValue);
                        currentMap.put(fieldName, (Object)nestedFieldArray);
                    } else {
                        fieldDetail.setTranslationSuccessful(false);
                    }
                    if (depth - 1 != level) {
                        Object tempObject = currentMap.get(fieldName);
                        if (tempObject instanceof Struct) {
                            currentMap = (Struct)tempObject;
                        } else if (tempObject instanceof List) {
                            currentMap = (Struct)((List)tempObject).get(fieldIndex);
                        } else {
                            fieldDetail.setTranslationSuccessful(false);
                        }
                    }
                    ++level;
                }
                if (fieldDetail.translationSuccessful) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void fillArrayListWithDummyValues(Array list, int index) {
        int size = list.size();
        if (size > index) {
            return;
        }
        for (int i = 0; i < index + 1; ++i) {
            if (i < size) continue;
            list.add(i, null);
        }
    }

    public Struct getConvertedMap() {
        return this.outerMap;
    }

    private static class FieldDetail {
        private ArrayList fieldTokens = new ArrayList();
        private boolean translationSuccessful = false;

        public FieldDetail(String complexFieldName) {
            StringTokenizer st = new StringTokenizer(complexFieldName, ".");
            while (st.hasMoreTokens()) {
                String aFieldToken = st.nextToken();
                int startIndex = aFieldToken.indexOf(91);
                int endIndex = aFieldToken.indexOf(93);
                if (startIndex != -1 && endIndex == -1) {
                    this.translationSuccessful = false;
                    break;
                }
                if (startIndex == -1 || endIndex < startIndex) {
                    this.translationSuccessful = false;
                    break;
                }
                String[] fieldToken = new String[2];
                if (startIndex == -1) {
                    fieldToken[0] = aFieldToken;
                    fieldToken[1] = "0";
                } else {
                    fieldToken[0] = aFieldToken.substring(0, startIndex);
                    fieldToken[1] = aFieldToken.substring(startIndex + 1, endIndex);
                }
                this.fieldTokens.add(fieldToken);
            }
            this.setTranslationSuccessful(true);
        }

        public static boolean checkIfFieldNeedsConversion(String complexFieldName) {
            return complexFieldName.indexOf(91) != -1;
        }

        public ArrayList getFieldTokens() {
            return this.fieldTokens;
        }

        public void setTranslationSuccessful(boolean translationSuccessful) {
            this.translationSuccessful = translationSuccessful;
        }
    }
}

