/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rds;

import coldfusion.log.CFLogs;
import coldfusion.rds.Encryptor;
import coldfusion.rds.RdsRequest;
import coldfusion.rds.RdsResponse;
import coldfusion.rds.RdsResponseImpl;
import coldfusion.rds.RdsServlet;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.UDFMethod;
import coldfusion.security.AuthorizedUser;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import coldfusion.wddx.WddxSerializer;
import jakarta.servlet.ServletException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AdminApiServlet
extends RdsServlet {
    private static final String CFIDE2 = "/CFIDE";
    private static final String DEBUGGING_GETLOGPROPERTY = "cfide.adminapi.debugging_getlogproperty";
    private static final String EXTENSIONS_GETCUSTOMTAGPATHS = "cfide.adminapi.extensions_getcustomtagpaths";
    private static final String EXTENSIONS_SETMAPPINGS = "cfide.adminapi.extensions_setmappings";
    private static final String EXTENSIONS_DELELTEMAPPINGS = "cfide.adminapi.extensions_deleltemappings";
    private static final String EXTENSIONS_GETMAPPINGS = "cfide.adminapi.extensions_getmappings";
    private static final long serialVersionUID = 1L;
    private static Set<String> apiCallsList = new HashSet<String>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws ServletException, IOException {
        String adminUserId;
        String service = request.getMetaString(0);
        String method = request.getMetaString(1);
        String arguments = request.getMetaString(2);
        String adminPassword = request.getPassword();
        if (user != null && !user.roles.contains("coldfusion.adminapi")) {
            String errorMsg = RB.getString(this, "AdminApiServlet.noPermissions");
            this.log(errorMsg);
            ((RdsResponseImpl)response).setError(-100, errorMsg, null);
            return;
        }
        SecurityService security = ServiceFactory.getSecurityService();
        String string = adminUserId = user != null ? user.username : request.getUserName();
        if (adminUserId == null) {
            if (!security.getUseSingleRdsPassword()) {
                String errorMsg = RB.getString(this, "RdsServlet.AccessDenied");
                this.log(errorMsg);
                ((RdsResponseImpl)response).setError(-100, errorMsg, null);
                return;
            }
            adminUserId = security.getRootAdminUserId();
        }
        if (!security.checkRDSUserIdPassword(adminUserId, adminPassword, false)) {
            try {
                adminPassword = Encryptor.decrypt(adminPassword);
                boolean success = security.checkRDSUserIdPassword(adminUserId, adminPassword, false);
                if (!success) {
                    String errorMsg = RB.getString(this, "AdminApiServlet.noPermissions");
                    this.log(errorMsg);
                    ((RdsResponseImpl)response).setError(-100, errorMsg, null);
                    return;
                }
            }
            catch (Exception e) {
                String errorMsg = RB.getString(this, "AdminApiServlet.noPermissions");
                this.log(errorMsg);
                ((RdsResponseImpl)response).setError(-100, errorMsg, null);
                return;
            }
        }
        String result = "";
        try {
            block29: {
                Object action = service + "_" + method;
                action = ((String)action).toLowerCase();
                if (!apiCallsList.contains(action)) {
                    String errorMsg = RB.getString(this, "AdminApiServlet.unknownapi");
                    this.log(errorMsg);
                    ((RdsResponseImpl)response).setError(-100, errorMsg, null);
                    return;
                }
                if (((String)action).equals(EXTENSIONS_GETMAPPINGS)) {
                    result = this.wddxSerialize(ServiceFactory.getRuntimeService().getMappings());
                } else if (((String)action).equals(EXTENSIONS_DELELTEMAPPINGS)) {
                    Map mappings = ServiceFactory.getRuntimeService().getMappings();
                    String validateMapping = this.validateMapping(arguments);
                    if (validateMapping != null && mappings.containsKey(validateMapping)) {
                        if (arguments.equals(CFIDE2)) {
                            String errorMsg = RB.getString(this, "AdminApiServlet.nomapping");
                            this.log(errorMsg);
                            ((RdsResponseImpl)response).setError(-100, errorMsg, null);
                            return;
                        }
                        mappings.remove(validateMapping);
                    }
                } else {
                    if (((String)action).equals(EXTENSIONS_SETMAPPINGS)) {
                        Map mappings = ServiceFactory.getRuntimeService().getMappings();
                        String mapName = null;
                        String mapPath = null;
                        String[] argumentsList = arguments.split(";");
                        if (argumentsList != null && argumentsList.length == 2) {
                            String pathList;
                            String[] paths;
                            String nameList = argumentsList[0];
                            String[] names = nameList.split(":");
                            if (names != null && names.length == 2) {
                                mapName = names[1];
                            }
                            if ((paths = (pathList = argumentsList[1]).split(":")) != null && paths.length == 2) {
                                mapPath = paths[1];
                            }
                        } else {
                            String errorMsg = RB.getString(this, "AdminApiServlet.notenougharguments");
                            this.log(errorMsg);
                            ((RdsResponseImpl)response).setError(-100, errorMsg, null);
                            return;
                        }
                        if (mapName == null || mapPath == null) {
                            String errorMsg = RB.getString(this, "AdminApiServlet.notenougharguments");
                            this.log(errorMsg);
                            ((RdsResponseImpl)response).setError(-100, errorMsg, null);
                            return;
                        }
                        String validateMapping = this.validateMapping(mapName);
                        if (validateMapping != null && !arguments.equals(CFIDE2)) {
                            mappings.put(mapName, mapPath);
                            break block29;
                        } else {
                            String errorMsg = RB.getString(this, "AdminApiServlet.noaccess");
                            this.log(errorMsg);
                            ((RdsResponseImpl)response).setError(-100, errorMsg, null);
                            return;
                        }
                    }
                    if (((String)action).equals(EXTENSIONS_GETCUSTOMTAGPATHS)) {
                        Map customtags = ServiceFactory.getRuntimeService().getCustomtags();
                        ArrayList<String> customTagPaths = new ArrayList<String>();
                        if (customtags != null && customtags.size() > 0) {
                            Set keys = customtags.keySet();
                            for (String key : keys) {
                                Object value = customtags.get(key);
                                if (value == null) continue;
                                customTagPaths.add(value.toString());
                            }
                        }
                        result = this.wddxSerialize(customTagPaths);
                    } else if (((String)action).equals(DEBUGGING_GETLOGPROPERTY) && arguments != null && arguments.toLowerCase().contains("logdirectory")) {
                        result = this.wddxSerialize(ServiceFactory.getLoggingService().getLogDirectory());
                    }
                }
            }
            response.addMetaData(result);
            return;
        }
        catch (Throwable ex) {
            CFLogs.RDS_LOG.error("Error invoking AdminAPI from RDS: " + ex.toString(), ex);
        }
    }

    private String validateMapping(String mappingName) {
        if (mappingName == null || mappingName != null && ((String)mappingName).length() == 0) {
            return null;
        }
        if (!((String)mappingName).startsWith("/")) {
            mappingName = "/" + (String)mappingName;
        }
        if (((String)mappingName).endsWith("/") && !((String)mappingName).equals("/")) {
            mappingName = ((String)mappingName).substring(0, ((String)mappingName).length() - 1);
        }
        if (((String)mappingName).trim().length() == 0 || ((String)mappingName).contains("//") || !((String)mappingName).startsWith("/") || CFPage.REFindNoCase("[^/a-z0-9_-]", ((String)mappingName).trim()) > 0 || ((String)mappingName).endsWith("/") && !((String)mappingName).equals("/")) {
            mappingName = null;
        }
        return mappingName;
    }

    private String wddxSerialize(Object obj) throws NullPointerException, IOException {
        if (obj == null) {
            return "";
        }
        if (!(obj instanceof TemplateProxy) && !(obj instanceof UDFMethod)) {
            WddxSerializer ws = new WddxSerializer();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ws.serialize(obj, out);
            return out.toString("UTF8");
        }
        return null;
    }

    static {
        apiCallsList.add(EXTENSIONS_GETMAPPINGS);
        apiCallsList.add(EXTENSIONS_DELELTEMAPPINGS);
        apiCallsList.add(EXTENSIONS_SETMAPPINGS);
        apiCallsList.add(EXTENSIONS_GETCUSTOMTAGPATHS);
        apiCallsList.add(DEBUGGING_GETLOGPROPERTY);
    }
}

