/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rds;

import coldfusion.rds.RdsRequest;
import coldfusion.rds.RdsResponse;
import coldfusion.rds.RdsServlet;
import coldfusion.security.AuthorizedUser;
import coldfusion.security.SandBoxFolderPermissions;
import coldfusion.server.SystemInfo;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

public class BrowseDirServlet
extends RdsServlet {
    private long FILE_ATTRIBUTE_READONLY = 1L;
    private long FILE_ATTRIBUTE_HIDDEN = 2L;
    private long FILE_ATTRIBUTE_ARCHIVE = 32L;
    private long FILE_ATTRIBUTE_NORMAL = 128L;

    @Override
    protected void processCmd(RdsRequest req, RdsResponse resp, AuthorizedUser user) throws ServletException, IOException {
        String dir = req.getMetaString(0);
        if (dir.equals("")) {
            this.listRoots(req, resp, user);
        } else {
            this.listDir(req, resp, dir, user);
        }
    }

    void listRoots(RdsRequest req, RdsResponse resp, AuthorizedUser user) throws ServletException, IOException {
        SandBoxFolderPermissions folderPermissions = null;
        if (user != null) {
            folderPermissions = user.getAuthorizedFolders();
        }
        File[] roots = BrowseDirServlet.listRootDrives();
        for (int i = 0; i < roots.length; ++i) {
            String path;
            if (folderPermissions != null) {
                path = roots[i].getPath();
                if (!folderPermissions.isAuthorized(roots[i])) continue;
                resp.addMetaData("3");
                resp.addMetaData(path);
                resp.addMetaData("");
                continue;
            }
            path = roots[i].getPath();
            resp.addMetaData("3");
            resp.addMetaData(path);
            resp.addMetaData("");
        }
    }

    void listDir(RdsRequest req, RdsResponse resp, String dirName, AuthorizedUser user) throws ServletException, IOException {
        File dir;
        SandBoxFolderPermissions folderPermissions = null;
        if (user != null) {
            folderPermissions = user.getAuthorizedFolders();
        }
        dirName = ((String)dirName).replace('/', File.separatorChar);
        if (SystemInfo.isWindows()) {
            dirName = ((String)dirName).substring(0, 2) + File.separatorChar + ((String)dirName).substring(2);
        }
        String[] files = null;
        if (folderPermissions != null) {
            dir = new File((String)dirName);
            if (folderPermissions.isAuthorized(dir, "read")) {
                files = dir.list();
            }
        } else {
            dir = new File((String)dirName);
            files = dir.list();
        }
        if (files == null) {
            files = new String[]{};
        }
        Arrays.sort(files, FileComparator.instance());
        for (int i = 0; i < files.length; ++i) {
            File f = new File(dir, files[i]);
            if (folderPermissions != null && !folderPermissions.isAuthorized(f)) continue;
            if (f.exists() && f.isDirectory()) {
                resp.addMetaData("D:");
            } else {
                resp.addMetaData("F:");
            }
            resp.addMetaData(files[i]);
            long fileAttrib = this.FILE_ATTRIBUTE_ARCHIVE;
            if (f.isHidden()) {
                fileAttrib |= this.FILE_ATTRIBUTE_HIDDEN;
            }
            if (!f.canWrite()) {
                fileAttrib |= this.FILE_ATTRIBUTE_READONLY;
            }
            resp.addMetaData(String.valueOf(fileAttrib));
            resp.addMetaData(new Long(f.length()).toString());
            long modDate = f.lastModified();
            modDate += 11644473600000L;
            int low = (int)(modDate *= 10000L);
            int high = (int)(modDate >> 32);
            resp.addMetaData(String.valueOf(low) + "," + String.valueOf(high));
        }
    }

    public static File[] listRootDrives() {
        File[] roots = File.listRoots();
        return roots;
    }

    static class FileComparator
    implements Comparator {
        static FileComparator _instance = new FileComparator();

        FileComparator() {
        }

        public static FileComparator instance() {
            return _instance;
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            if (SystemInfo.isWindows()) {
                s1 = s1.toLowerCase();
                s2 = s2.toLowerCase();
            }
            return s1.toString().compareTo(s2);
        }
    }
}

