/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rds;

import coldfusion.rds.RdsRequest;
import coldfusion.rds.RdsResponse;
import coldfusion.rds.RdsServlet;
import coldfusion.security.AuthorizedUser;
import coldfusion.server.DebuggingService;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;

public class CFDebuggerServlet
extends RdsServlet {
    private Object reqMgr = null;
    private ServletException initException = null;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.initilizeDebugger(config);
    }

    private void initilizeDebugger(ServletConfig config) {
        String host = "localhost";
        String cfRootDir = null;
        String ctxRoot = null;
        String canonicalCtxRoot = null;
        int port = 0;
        DebuggingService debuggingService = ServiceFactory.getDebuggingService();
        if (debuggingService == null) {
            return;
        }
        try {
            RuntimeService runtimeSvc = ServiceFactory.getRuntimeService();
            port = debuggingService.getDebuggerPort();
            cfRootDir = runtimeSvc.getRootDir();
            if (cfRootDir == null) {
                this.initException = new ServletException("Error starting the CF debugger. Error getting CF root directory");
                return;
            }
        }
        catch (Exception e) {
            this.initException = new ServletException(e.getMessage());
            return;
        }
        if (port <= 0) {
            this.initException = new ServletException("Error getting debug port.");
            return;
        }
        try {
            ctxRoot = debuggingService.getContextRootForLineDebugger();
            if (ctxRoot == null) {
                debuggingService.setContextRootForLineDebugger(config.getServletContext());
                ctxRoot = debuggingService.getContextRootForLineDebugger();
            }
            File ctxRootFile = new File(ctxRoot);
            try {
                if (ctxRootFile.exists()) {
                    canonicalCtxRoot = ctxRootFile.getCanonicalPath();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reqMgr = debuggingService.getDebuggerRDSRequestManager(host, ctxRoot, canonicalCtxRoot, port, cfRootDir, debuggingService.getMaxDebuggingSessions());
        }
        catch (Exception e) {
            this.initException = new ServletException(e.getMessage());
            return;
        }
    }

    public String getServletInfo() {
        return "CF Debugger Servlet";
    }

    @Override
    protected void processCmd(RdsRequest req, RdsResponse resp, AuthorizedUser user) throws ServletException, IOException {
        DebuggingService debuggingService = ServiceFactory.getDebuggingService();
        if (debuggingService == null) {
            return;
        }
        if (this.initException != null) {
            resp.setError(this.initException);
            return;
        }
        if (!debuggingService.isLineDebuggerEnabled()) {
            resp.setError(new ServletException("ColdFusion Line Debugger is not enabled."));
            return;
        }
        debuggingService.processRequest(this.reqMgr, req, resp);
    }
}

