/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rds;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.rds.DbDataSource;
import coldfusion.util.RB;
import java.io.FileInputStream;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DbDataSourceManager {
    Hashtable dataSources = new Hashtable();
    static Logger logger = CFLogs.RDS_LOG;

    public DbDataSourceManager(Properties props) throws SQLException {
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String dsName;
            String propName = (String)propNames.nextElement();
            if (!propName.startsWith("datasource.")) continue;
            int index1 = propName.indexOf(".");
            int index2 = propName.indexOf(".", index1 + 1);
            if (index1 == -1 || index2 == -1 || this.dataSources.get(dsName = propName.substring(index1 + 1, index2)) != null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug(RB.getString((Object)this, "DbDataSourceManager.Loading", (Object)dsName));
            }
            try {
                String driver = props.getProperty("datasource." + dsName + ".driver");
                Class.forName(driver);
                String url = props.getProperty("datasource." + dsName + ".url");
                String user = props.getProperty("datasource." + dsName + ".user");
                String password = props.getProperty("datasource." + dsName + ".password");
                String description = props.getProperty("datasource." + dsName + ".description");
                DbDataSource ds = new DbDataSource(dsName, description, url, user, password);
                this.dataSources.put(dsName, ds);
                if (!logger.isDebugEnabled()) continue;
                logger.debug(RB.getString((Object)this, "DbDataSourceManager.Loaded", (Object)dsName));
                logger.debug(dsName + ".description: " + description);
                logger.debug(dsName + ".driver: " + driver);
                logger.debug(dsName + ".url: " + url);
                logger.debug(dsName + ".user: " + user);
            }
            catch (Throwable th) {
                logger.error(RB.getString((Object)this, "DbDataSourceManager.LoadFailed", (Object)dsName), th);
            }
        }
    }

    public Enumeration getDataSourceNames() {
        return this.dataSources.keys();
    }

    public DbDataSource getDataSource(String name) {
        return (DbDataSource)this.dataSources.get(name);
    }

    public static void main(String[] args) {
        try {
            String datasourcePropsFile = args[0];
            Properties props = new Properties();
            FileInputStream fin = new FileInputStream(datasourcePropsFile);
            props.load(fin);
            fin.close();
            DbDataSourceManager dbDataSourceManager = new DbDataSourceManager(props);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }
}

