/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rds;

import coldfusion.rds.RdsCmdProcessor;
import coldfusion.rds.RdsCmdProcessorCompositeServlet;
import coldfusion.rds.RdsRequest;
import coldfusion.rds.RdsResponse;
import coldfusion.security.AuthorizedUser;
import coldfusion.security.ESAPIUtils;
import coldfusion.server.DataSourceService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;

public class DbFuncsServlet
extends RdsCmdProcessorCompositeServlet {
    private static final long serialVersionUID = 1L;
    private static int DBTYPE_UNKNOWN = 1;
    private static int DBTYPE_ORACLE = 2;
    DataSourceService _dsService;
    protected DbFuncsServlet _dbFuncsServlet;

    @Override
    public void doInit() throws ServletException {
        this.addCmdProcessor("DSNINFO", new DbDsnInfoOperator());
        this.addCmdProcessor("TABLEINFO", new DbTableInfoOperator());
        this.addCmdProcessor("COLUMNINFO", new DbColumnInfoOperator());
        this.addCmdProcessor("PRIMARYKEYS", new DbListPkOperator());
        this.addCmdProcessor("FOREIGNKEYS", new DbListImportedOperator());
        this.addCmdProcessor("IMPORTEDKEYS", new DbListImportedOperator());
        this.addCmdProcessor("EXPORTEDKEYS", new DbListExportedOperator());
        this.addCmdProcessor("SQLSTMNT", new DbSqlStatementOperator());
        this.addCmdProcessor("SQLMETADATA", new DbSqlMetaDataOperator());
        this.addCmdProcessor("SUPPORTEDCOMMANDS", new DbGetSupportedCommands());
        this.addCmdProcessor("DBDESCRIPTION", new DbDescriptionOperator());
        this._dsService = ServiceFactory.getDataSourceService();
        this._dbFuncsServlet = this;
    }

    @Override
    protected void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws ServletException, IOException {
        String operation = request.getMetaString(1).toUpperCase();
        RdsCmdProcessor rcp = this.getCmdProcessor(operation);
        if (rcp == null) {
            response.setError(RB.getString((Object)this, "DbFuncsServlet.UnsupportedOperation", (Object)ESAPIUtils.encodeForHTML(operation, false)));
            return;
        }
        rcp.processCmd(request, response, user);
    }

    Enumeration getDataSourceNames() throws ServletException {
        return new DsnEnumeration();
    }

    void quotedAppend(String str, StringBuffer sb) {
        this.quotedAppend(str, sb, null);
    }

    void quotedAppend(String str, StringBuffer sb, String doubleQuoteReplacement) {
        if (str == null) {
            str = "";
        }
        if (doubleQuoteReplacement != null) {
            str = DbFuncsServlet.replaceAll(str, "\"", doubleQuoteReplacement);
        }
        sb.append("\"");
        sb.append(str);
        sb.append("\"");
    }

    public static String replaceAll(String in, String match, String replacement) {
        if (match == null || match.length() == 0 || replacement == null || in == null) {
            return in;
        }
        int fromIndex = 0;
        int index = in.indexOf(match, fromIndex);
        if (index < 0) {
            return in;
        }
        StringBuffer buf = new StringBuffer("");
        while ((index = in.indexOf(match, fromIndex)) >= 0) {
            buf.append(in.substring(fromIndex, index));
            buf.append(replacement);
            fromIndex = index + match.length();
        }
        buf.append(in.substring(fromIndex));
        return buf.toString();
    }

    String getDatasourceName(RdsRequest request) {
        String dsName = request.getMetaString(0);
        int index = dsName.indexOf(";");
        if (index != -1) {
            dsName = dsName.substring(0, index);
        }
        return dsName;
    }

    String getTableName(String tableName) {
        String result = tableName;
        int index = tableName.lastIndexOf(".");
        if (index != -1) {
            result = tableName.substring(index + 1);
        }
        return result;
    }

    Connection getConnection(DataSource ds, String dsName) throws ServletException {
        Connection result = null;
        try {
            result = ds.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (result == null) {
            throw new ServletException(RB.getString((Object)this, "DbFuncsServlet.DSNotFound", (Object)ESAPIUtils.encodeForHTML(dsName, false)));
        }
        return result;
    }

    String getSchemaName(String tableName) {
        String result = null;
        int index = tableName.lastIndexOf(".");
        if (index != -1) {
            result = tableName.substring(0, index);
        }
        return result;
    }

    String quote(String str) {
        StringBuffer sb = new StringBuffer();
        this.quotedAppend(str, sb);
        return sb.toString();
    }

    String quote(int i) {
        return this.quote(new Integer(i).toString());
    }

    public static void close(ResultSet rs) {
        try {
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(Connection con) {
        try {
            con.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class DbDsnInfoOperator
    extends RdsCmdProcessor {
        DbDsnInfoOperator() {
        }

        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            Enumeration names = DbFuncsServlet.this.getDataSourceNames();
            Object conn = null;
            Map userDSNList = null;
            if (user != null) {
                userDSNList = user.getAuthorizedDatasources();
            }
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (user != null) {
                    if (userDSNList == null) continue;
                    Iterator itr = userDSNList.keySet().iterator();
                    boolean canAdd = false;
                    while (itr.hasNext()) {
                        String dbName = (String)itr.next();
                        if (!name.equals(dbName)) continue;
                        canAdd = true;
                    }
                    if (!canAdd) continue;
                }
                String dbDescription = "";
                String s = "\"" + name + "\",\"" + dbDescription + "\",\"SYSTEM\"";
                response.addMetaData(s);
            }
        }
    }

    class DbTableInfoOperator
    extends RdsCmdProcessor {
        DbTableInfoOperator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            Connection conn = null;
            try {
                String dsName = DbFuncsServlet.this.getDatasourceName(request);
                DataSource ds = DbFuncsServlet.this._dsService.getDatasource(dsName);
                conn = DbFuncsServlet.this.getConnection(ds, dsName);
                DatabaseMetaData meta = conn.getMetaData();
                String productName = meta.getDatabaseProductName();
                int dbtype = DBTYPE_UNKNOWN;
                if (productName.toLowerCase().indexOf("oracle") >= 0) {
                    dbtype = DBTYPE_ORACLE;
                }
                ResultSet rs = meta.getTables(null, null, "%", null);
                Hashtable tables = new Hashtable();
                try {
                    while (rs.next()) {
                        String tableCatalog = rs.getString(1);
                        String tableSchema = rs.getString(2);
                        String tableName = rs.getString(3);
                        String tableType = rs.getString(4);
                        String tableRemarks = rs.getString(5);
                        String tableOwner = "";
                        if (dbtype == DBTYPE_ORACLE && (tableSchema.equals("SYS") || tableName.indexOf("/") >= 0)) continue;
                        String arg = DbFuncsServlet.this.quote("") + "," + DbFuncsServlet.this.quote(tableSchema) + "," + DbFuncsServlet.this.quote(tableName) + "," + DbFuncsServlet.this.quote(tableType);
                        response.addMetaData(arg);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    DbFuncsServlet.close(rs);
                }
                if (conn == null) return;
            }
            catch (Exception e) {
                try {
                    throw new ServletException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (conn == null) throw throwable;
                    DbFuncsServlet.close(conn);
                    throw throwable;
                }
            }
            DbFuncsServlet.close(conn);
            return;
        }
    }

    class DbColumnInfoOperator
    extends RdsCmdProcessor {
        DbColumnInfoOperator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            try {
                String dsName = DbFuncsServlet.this.getDatasourceName(request);
                String tName = DbFuncsServlet.this.getTableName(request.getMetaString(2));
                String schema = DbFuncsServlet.this.getSchemaName(request.getMetaString(2));
                DataSource ds = DbFuncsServlet.this._dsService.getDatasource(dsName);
                Connection conn = ds.getConnection();
                try {
                    DatabaseMetaData meta = conn.getMetaData();
                    ResultSet rs = meta.getColumns(null, schema, tName, "%");
                    try {
                        while (rs.next()) {
                            String tableCatalog = rs.getString(1);
                            String tableOwner = rs.getString(2);
                            String tableName = rs.getString(3);
                            String colName = rs.getString(4);
                            int colType = rs.getInt(5);
                            String colTypeName = rs.getString(6);
                            int colPrecision = rs.getInt(7);
                            int colLength = rs.getInt(8);
                            int colScale = rs.getInt(9);
                            int colRadix = rs.getInt(10);
                            int colNullable = rs.getInt(11);
                            String arg = DbFuncsServlet.this.quote(tableCatalog) + "," + DbFuncsServlet.this.quote(tableOwner) + "," + DbFuncsServlet.this.quote(tableName) + "," + DbFuncsServlet.this.quote(colName) + "," + DbFuncsServlet.this.quote(colType) + "," + DbFuncsServlet.this.quote(colTypeName) + "," + DbFuncsServlet.this.quote(colPrecision) + "," + DbFuncsServlet.this.quote(colLength) + "," + DbFuncsServlet.this.quote(colScale) + "," + DbFuncsServlet.this.quote(colRadix) + "," + DbFuncsServlet.this.quote(colNullable);
                            response.addMetaData(arg);
                        }
                    }
                    finally {
                        DbFuncsServlet.close(rs);
                    }
                }
                finally {
                    DbFuncsServlet.close(conn);
                }
            }
            catch (SQLException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    class DbListPkOperator
    extends RdsCmdProcessor {
        DbListPkOperator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            try {
                String dsName = DbFuncsServlet.this.getDatasourceName(request);
                String tName = DbFuncsServlet.this.getTableName(request.getMetaString(2));
                String schema = DbFuncsServlet.this.getSchemaName(request.getMetaString(2));
                DataSource ds = DbFuncsServlet.this._dsService.getDatasource(dsName);
                Connection conn = DbFuncsServlet.this.getConnection(ds, dsName);
                try {
                    DatabaseMetaData meta = conn.getMetaData();
                    ResultSet rs = meta.getPrimaryKeys(conn.getCatalog(), schema, tName);
                    try {
                        while (rs.next()) {
                            String tableCatalog = rs.getString(1);
                            String tableOwner = rs.getString(2);
                            String tableName = rs.getString(3);
                            String colName = rs.getString(4);
                            int keySequence = rs.getInt(5);
                            String arg = DbFuncsServlet.this.quote(tableCatalog) + "," + DbFuncsServlet.this.quote(tableOwner) + "," + DbFuncsServlet.this.quote(tableName) + "," + DbFuncsServlet.this.quote(colName) + "," + DbFuncsServlet.this.quote(keySequence);
                            response.addMetaData(arg);
                        }
                    }
                    finally {
                        DbFuncsServlet.close(rs);
                    }
                }
                finally {
                    DbFuncsServlet.close(conn);
                }
            }
            catch (SQLException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    class DbListImportedOperator
    extends RdsCmdProcessor {
        DbListImportedOperator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            try {
                String dsName = DbFuncsServlet.this.getDatasourceName(request);
                String tName = DbFuncsServlet.this.getTableName(request.getMetaString(2));
                String schema = DbFuncsServlet.this.getSchemaName(request.getMetaString(2));
                DataSource ds = DbFuncsServlet.this._dsService.getDatasource(dsName);
                Connection conn = DbFuncsServlet.this.getConnection(ds, dsName);
                try {
                    DatabaseMetaData meta = conn.getMetaData();
                    ResultSet rs = meta.getImportedKeys(conn.getCatalog(), schema, tName);
                    try {
                        while (rs.next()) {
                            String pkTableCatalog = rs.getString(1);
                            String pkTableSchema = rs.getString(2);
                            String pkTableName = rs.getString(3);
                            String pkColName = rs.getString(4);
                            String fkTableCatalog = rs.getString(5);
                            String fkTableSchema = rs.getString(6);
                            String fkTableName = rs.getString(7);
                            String fkColName = rs.getString(8);
                            int keySequence = rs.getInt(9);
                            int updateRule = rs.getInt(10);
                            int deleteRule = rs.getInt(11);
                            String arg = DbFuncsServlet.this.quote(pkTableCatalog) + "," + DbFuncsServlet.this.quote(pkTableSchema) + "," + DbFuncsServlet.this.quote(pkTableName) + "," + DbFuncsServlet.this.quote(pkColName) + "," + DbFuncsServlet.this.quote(fkTableCatalog) + "," + DbFuncsServlet.this.quote(fkTableSchema) + "," + DbFuncsServlet.this.quote(fkTableName) + "," + DbFuncsServlet.this.quote(fkColName) + "," + DbFuncsServlet.this.quote(keySequence) + "," + DbFuncsServlet.this.quote(updateRule) + "," + DbFuncsServlet.this.quote(deleteRule);
                            response.addMetaData(arg);
                        }
                    }
                    finally {
                        DbFuncsServlet.close(rs);
                    }
                }
                finally {
                    DbFuncsServlet.close(conn);
                }
            }
            catch (SQLException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    class DbListExportedOperator
    extends RdsCmdProcessor {
        DbListExportedOperator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            try {
                String dsName = DbFuncsServlet.this.getDatasourceName(request);
                String tName = DbFuncsServlet.this.getTableName(request.getMetaString(2));
                String schema = DbFuncsServlet.this.getSchemaName(request.getMetaString(2));
                DataSource ds = DbFuncsServlet.this._dsService.getDatasource(dsName);
                Connection conn = DbFuncsServlet.this.getConnection(ds, dsName);
                try {
                    DatabaseMetaData meta = conn.getMetaData();
                    ResultSet rs = meta.getExportedKeys(conn.getCatalog(), schema, tName);
                    try {
                        while (rs.next()) {
                            String pkTableCatalog = rs.getString(1);
                            String pkTableSchema = rs.getString(2);
                            String pkTableName = rs.getString(3);
                            String pkColName = rs.getString(4);
                            String fkTableCatalog = rs.getString(5);
                            String fkTableSchema = rs.getString(6);
                            String fkTableName = rs.getString(7);
                            String fkColName = rs.getString(8);
                            int keySequence = rs.getInt(9);
                            int updateRule = rs.getInt(10);
                            int deleteRule = rs.getInt(11);
                            String arg = DbFuncsServlet.this.quote(pkTableCatalog) + "," + DbFuncsServlet.this.quote(pkTableSchema) + "," + DbFuncsServlet.this.quote(pkTableName) + "," + DbFuncsServlet.this.quote(pkColName) + "," + DbFuncsServlet.this.quote(fkTableCatalog) + "," + DbFuncsServlet.this.quote(fkTableSchema) + "," + DbFuncsServlet.this.quote(fkTableName) + "," + DbFuncsServlet.this.quote(fkColName) + "," + DbFuncsServlet.this.quote(keySequence) + "," + DbFuncsServlet.this.quote(updateRule) + "," + DbFuncsServlet.this.quote(deleteRule);
                            response.addMetaData(arg);
                        }
                    }
                    finally {
                        DbFuncsServlet.close(rs);
                    }
                }
                finally {
                    DbFuncsServlet.close(conn);
                }
            }
            catch (SQLException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    class DbSqlStatementOperator
    extends RdsCmdProcessor {
        DbSqlStatementOperator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            try {
                String dsName = DbFuncsServlet.this.getDatasourceName(request);
                String sql = request.getMetaString(2);
                DataSource ds = DbFuncsServlet.this._dsService.getDatasource(dsName);
                if (ds == null) {
                    throw new ServletException(RB.getString((Object)this, "DbFuncsServlet.ErrorLocatingDataSource", (Object)ESAPIUtils.encodeForHTML(dsName, false)));
                }
                Connection conn = DbFuncsServlet.this.getConnection(ds, dsName);
                try {
                    Statement st = conn.createStatement();
                    ResultSet rs = st.executeQuery(sql);
                    try {
                        int i;
                        ResultSetMetaData rsmd = rs.getMetaData();
                        int colCount = rsmd.getColumnCount();
                        StringBuffer rowVals = new StringBuffer();
                        for (i = 1; i <= colCount; ++i) {
                            String colName = rsmd.getColumnName(i);
                            DbFuncsServlet.this.quotedAppend(colName, rowVals, "''");
                            rowVals.append(",");
                        }
                        response.addMetaData(rowVals.toString());
                        while (rs.next()) {
                            rowVals.setLength(0);
                            for (i = 1; i <= colCount; ++i) {
                                DbFuncsServlet.this.quotedAppend(rs.getString(i), rowVals, "''");
                                rowVals.append(",");
                            }
                            response.addMetaData(rowVals.toString());
                        }
                        DbFuncsServlet.close(rs);
                        DbFuncsServlet.close(conn);
                    }
                    finally {
                        DbFuncsServlet.close(rs);
                    }
                }
                finally {
                    DbFuncsServlet.close(conn);
                }
            }
            catch (SQLException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    class DbSqlMetaDataOperator
    extends RdsCmdProcessor {
        DbSqlMetaDataOperator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            try {
                String dsName = DbFuncsServlet.this.getDatasourceName(request);
                String sql = request.getMetaString(2);
                DataSource ds = DbFuncsServlet.this._dsService.getDatasource(dsName);
                if (ds == null) {
                    throw new ServletException(RB.getString((Object)this, "DbFuncsServlet.ErrorLocatingDataSource", (Object)ESAPIUtils.encodeForHTML(dsName, false)));
                }
                Connection conn = DbFuncsServlet.this.getConnection(ds, dsName);
                try {
                    Statement st = conn.createStatement();
                    ResultSet rs = st.executeQuery(sql);
                    try {
                        ResultSetMetaData rsmd = rs.getMetaData();
                        int colCount = rsmd.getColumnCount();
                        StringBuffer rowVals = new StringBuffer();
                        for (int i = 1; i <= colCount; ++i) {
                            rowVals.setLength(0);
                            String colName = rsmd.getColumnName(i);
                            String colType = "";
                            try {
                                colType = rsmd.getColumnTypeName(i);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            int colTypeInt = rsmd.getColumnType(i);
                            String colJavaType = "";
                            switch (colTypeInt) {
                                case -6: {
                                    colJavaType = "java.lang.Byte";
                                    break;
                                }
                                case 5: {
                                    colJavaType = "java.lang.Short";
                                    break;
                                }
                                case 4: {
                                    colJavaType = "java.lang.Integer";
                                    break;
                                }
                                case -5: {
                                    colJavaType = "java.lang.Long";
                                    break;
                                }
                                case 6: 
                                case 7: {
                                    colJavaType = "java.lang.Float";
                                    break;
                                }
                                case 8: {
                                    colJavaType = "java.lang.Double";
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    colJavaType = "java.math.BigDecimal";
                                    break;
                                }
                                case -7: {
                                    colJavaType = "java.lang.Boolean";
                                    break;
                                }
                                case -16: 
                                case -15: 
                                case -9: 
                                case -1: 
                                case 1: 
                                case 12: {
                                    colJavaType = "java.lang.String";
                                    break;
                                }
                                case 2005: {
                                    colJavaType = "java.lang.reflect.Array";
                                    break;
                                }
                                case 2009: {
                                    colJavaType = "java.lang.reflect.Array";
                                    break;
                                }
                                case 2011: {
                                    colJavaType = "java.lang.reflect.Array";
                                    break;
                                }
                                case -8: {
                                    colJavaType = "java.sql.ROWId";
                                    break;
                                }
                                case -4: 
                                case -3: 
                                case -2: 
                                case 2003: 
                                case 2004: {
                                    colJavaType = "java.io.InputStream";
                                    break;
                                }
                                case 91: {
                                    colJavaType = "java.sql.Date";
                                    break;
                                }
                                case 92: {
                                    colJavaType = "java.sql.Time";
                                    break;
                                }
                                case 93: {
                                    colJavaType = "java.sql.Timestamp";
                                    break;
                                }
                                default: {
                                    colJavaType = "java.lang.Object";
                                }
                            }
                            DbFuncsServlet.this.quotedAppend(colName, rowVals);
                            rowVals.append(",");
                            DbFuncsServlet.this.quotedAppend(colType, rowVals);
                            rowVals.append(",");
                            DbFuncsServlet.this.quotedAppend(colJavaType, rowVals);
                            response.addMetaData(rowVals.toString());
                        }
                    }
                    finally {
                        DbFuncsServlet.close(rs);
                    }
                }
                finally {
                    DbFuncsServlet.close(conn);
                }
            }
            catch (SQLException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    class DbGetSupportedCommands
    extends RdsCmdProcessor {
        DbGetSupportedCommands() {
        }

        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            Map m = DbFuncsServlet.this._dbFuncsServlet.getProcessors();
            Object[] o = m.keySet().toArray();
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < o.length; ++i) {
                if (i > 0) {
                    result.append(",");
                }
                result.append(o[i]);
            }
            response.addMetaData(result.toString());
        }
    }

    class DbDescriptionOperator
    extends RdsCmdProcessor {
        DbDescriptionOperator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processCmd(RdsRequest request, RdsResponse response, AuthorizedUser user) throws IOException, ServletException {
            String dsName = DbFuncsServlet.this.getDatasourceName(request);
            Object dbDescription = "";
            try {
                DataSource ds = DbFuncsServlet.this._dsService.getDatasource(dsName);
                Connection conn = ds.getConnection();
                try {
                    DatabaseMetaData meta = conn.getMetaData();
                    dbDescription = meta.getDatabaseProductName() + "/" + meta.getDatabaseProductVersion();
                }
                finally {
                    DbFuncsServlet.close(conn);
                }
            }
            catch (Exception ds) {
                // empty catch block
            }
            String s = "\"" + (String)dbDescription + "\"";
            response.addMetaData(s);
        }
    }

    class DsnEnumeration
    implements Enumeration {
        Iterator it;

        DsnEnumeration() {
            Map map = DbFuncsServlet.this._dsService.getDatasources();
            ArrayList<String> verifiedDataSourceNames = new ArrayList<String>();
            for (String name : map.keySet()) {
                try {
                    DataSource ds = DbFuncsServlet.this._dsService.getDatasource(name);
                    verifiedDataSourceNames.add(name);
                }
                catch (Exception exception) {}
            }
            this.it = verifiedDataSourceNames.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public Object nextElement() {
            return this.it.next();
        }
    }
}

