/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rds;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class RdsDispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private boolean _debug = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletContext application = this.getServletContext();
        Properties props = new Properties();
        File propFile = new File(application.getRealPath("/") + File.separator + "rds.properties");
        if (!propFile.exists()) {
            this.log("RdsDispatcherServlet: file not found, " + propFile.getAbsolutePath());
        }
        props.load(new FileInputStream(propFile));
        String cfmxRootContext = "/" + props.getProperty("contextRoot", "ColdFusionMX");
        this.debug("RdsDispatcherServlet: forwarding request to CFMX, root context = " + cfmxRootContext);
        ServletContext cfmxContext = application.getContext(cfmxRootContext);
        if (request.getRequestURI().equals("/CFIDE/componentutils/cfcexplorer.cfc")) {
            String rdsServletPath = "/CFIDE/componentutils/cfcexplorer.cfc";
            RequestDispatcher dispatcher = cfmxContext.getRequestDispatcher(rdsServletPath);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            Map qMap = request.getParameterMap();
            request.setAttribute("__cfmx__query_string", (Object)qMap);
            String rdsServletPath = "/CFIDE/main/ide.cfm";
            RequestDispatcher dispatcher = cfmxContext.getRequestDispatcher(rdsServletPath);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void debug(String msg) {
        if (this._debug) {
            this.log(msg);
        }
    }
}

