/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rds;

import coldfusion.rds.CFRDSServletInit;
import coldfusion.rds.RdsGlobals;
import coldfusion.rds.RdsHttpResponseFormatter;
import coldfusion.rds.RdsRequestImpl;
import coldfusion.rds.RdsResponseImpl;
import coldfusion.security.ESAPIUtils;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RdsFrontEndServlet
extends HttpServlet
implements RdsGlobals {
    private static final boolean debug = false;
    private Map _servlets = new HashMap();

    public void init() throws ServletException {
        Map<String, Class> servletCommandMap = CFRDSServletInit.getServletCommandMap();
        for (String servletCommand : servletCommandMap.keySet()) {
            this.loadServlet(servletCommand, servletCommandMap.get(servletCommand));
        }
    }

    private void doPostProcessCmd(RdsRequestImpl request, RdsResponseImpl response) throws IOException, ServletException {
        response.finish();
        request.reset();
        response.reset();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.debug("enter RdsFrontEndServlet.service()");
        try {
            String[] str;
            Map qString;
            if (!ServiceFactory.getSecurityService().isRdsEnabled()) {
                RdsRequestImpl rdsReq = new RdsRequestImpl();
                RdsResponseImpl rdsResp = new RdsResponseImpl();
                rdsReq.init(req);
                rdsResp.init(resp);
                String errorMsg = RB.getString(this, "RdsServlet.AccessDenied");
                this.log(errorMsg);
                rdsResp.setError(-100, errorMsg, null);
                rdsResp.addMetaData("0");
                this.doPostProcessCmd(rdsReq, rdsResp);
                return;
            }
            String action = req.getParameter("ACTION");
            if (action == null && (qString = (Map)req.getAttribute("__cfmx__query_string")) != null && (str = (String[])qString.get("ACTION")) != null) {
                action = str[0];
            }
            if (action == null) {
                throw new ServletException("Could not locate Action attribute in request, RDS operation not defined");
            }
            action = action.toUpperCase();
            Servlet servlet = this.getServlet(action);
            this.debug("Servlet " + action + ": " + servlet);
            if (servlet == null) {
                throw new ServletException("Operation not supported: " + ESAPIUtils.encodeForHTML(action, false));
            }
            servlet.service((ServletRequest)req, (ServletResponse)resp);
        }
        catch (ServletException e) {
            Throwable tmpRoot = e;
            ServletException root = null;
            while (root == null) {
                if (tmpRoot instanceof ServletException) {
                    Throwable se = tmpRoot;
                    if (se.getRootCause() == null) {
                        root = se;
                        continue;
                    }
                    tmpRoot = se.getRootCause();
                    continue;
                }
                root = tmpRoot;
            }
            RdsHttpResponseFormatter rl = new RdsHttpResponseFormatter();
            rl.setError(e.getMessage(), root);
            resp.getOutputStream().write(rl.getMessageBytes());
            this.log("Error occurred!:" + new String(rl.getMessageBytes()));
        }
        catch (Throwable th) {
            RdsHttpResponseFormatter rl = new RdsHttpResponseFormatter();
            rl.setError(th.getMessage(), th);
            resp.getOutputStream().write(rl.getMessageBytes());
            this.log("Error occurred!:" + new String(rl.getMessageBytes()));
        }
        this.debug("exit dsFrontEndServlet.service()");
    }

    void debug(String message) {
    }

    public String getInitParameter(String name) {
        String value = this.getServletConfig().getInitParameter(name);
        if (value == null) {
            value = this.getServletContext().getInitParameter(name);
        }
        return value;
    }

    public void destroy() {
        for (String name : this._servlets.keySet()) {
            Servlet s = (Servlet)this._servlets.get(name);
            s.destroy();
        }
    }

    private Servlet getServlet(String action) {
        return (Servlet)this._servlets.get(action);
    }

    private void loadServlet(String name, Class cls) throws ServletException {
        try {
            Servlet s = (Servlet)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            s.init(this.getServletConfig());
            this._servlets.put(name, s);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

