/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rds;

import coldfusion.rds.RdsHttpRequestFormatter;
import coldfusion.rds.RdsRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Enumeration;

class RdsRequestImpl
implements RdsRequest {
    private final RdsHttpRequestFormatter _formatter = new RdsHttpRequestFormatter();
    private HttpServletRequest _request;

    RdsRequestImpl() {
    }

    final void init(HttpServletRequest req) throws IOException {
        this._request = req;
        this.loadMetaData();
    }

    final void reset() {
        this._request = null;
    }

    @Override
    public final String getMetaString(int i) {
        return this._formatter.getMetaString(i);
    }

    @Override
    public final byte[] getMetaBytes(int i) {
        return this._formatter.getMetaBytes(i);
    }

    @Override
    public final Enumeration enumerateMetaData() {
        return this._formatter.enumerateMetaData();
    }

    @Override
    public final int getMetaCount() {
        return this._formatter.getMetaCount();
    }

    @Override
    public final String getUserName() {
        String up = this._formatter.getMetaString(this._formatter.getMetaCount() - 1);
        if (up.indexOf(";") == -1) {
            return this._formatter.getMetaString(this._formatter.getMetaCount() - 2);
        }
        String[] parsedUP = up.split(";");
        if (parsedUP.length > 0) {
            return parsedUP[0];
        }
        return null;
    }

    @Override
    public final String getPassword() {
        String up = this._formatter.getMetaString(this._formatter.getMetaCount() - 1);
        if (up.indexOf(";") == -1) {
            return up;
        }
        String[] parsedUP = up.split(";");
        if (parsedUP.length != 2) {
            return "";
        }
        return parsedUP[1];
    }

    @Override
    public final HttpSession getSession() {
        return this._request.getSession();
    }

    @Override
    public final HttpSession getSession(boolean create) {
        return this._request.getSession(create);
    }

    @Override
    public final HttpServletRequest getHttpServletRequest() {
        return this._request;
    }

    private void loadMetaData() throws IOException {
        this._formatter.parseRequest(this._request);
    }
}

