/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rds;

import coldfusion.filter.IPFilterUtils;
import coldfusion.rds.Encryptor;
import coldfusion.rds.RdsGlobals;
import coldfusion.rds.RdsRequest;
import coldfusion.rds.RdsRequestImpl;
import coldfusion.rds.RdsResponse;
import coldfusion.rds.RdsResponseImpl;
import coldfusion.security.AuthorizedUser;
import coldfusion.security.ESAPIUtils;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public abstract class RdsServlet
extends HttpServlet
implements RdsGlobals {
    private static final long serialVersionUID = 1L;
    private static ThreadLocal<Boolean> authenticated = new ThreadLocal();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpServletResponse resp;
        HttpServletRequest req;
        IPFilterUtils.checkAdminAccess(request);
        try {
            req = request;
            resp = response;
        }
        catch (ClassCastException e) {
            throw new ServletException(RB.getString(this, "RdsServlet.NonHttp"));
        }
        RdsRequestImpl rdsReq = new RdsRequestImpl();
        RdsResponseImpl rdsResp = new RdsResponseImpl();
        rdsReq.init(req);
        rdsResp.init(resp);
        if (!this.checkRdsAccessAllowed()) {
            String errorMsg = RB.getString(this, "RdsServlet.AccessDenied");
            this.log(errorMsg);
            rdsResp.setError(-100, errorMsg, null);
            rdsResp.addMetaData("0");
            this.doPostProcessCmd(rdsReq, rdsResp);
            return;
        }
        try {
            SecurityService securityService = ServiceFactory.getSecurityService();
            if (securityService.isRdsSecurityEnabled() && this.isSecure()) {
                String reqPassword = rdsReq.getPassword();
                String reqUsername = rdsReq.getUserName();
                if (!this.checkAuthorization(reqUsername, reqPassword)) {
                    String errorMsg = RB.getString(this, "RdsServlet.AccessDenied");
                    this.log(errorMsg);
                    rdsResp.setError(-100, errorMsg, null);
                    rdsResp.addMetaData("0");
                    this.doPostProcessCmd(rdsReq, rdsResp);
                    return;
                }
                if (securityService.getUseSingleRdsPassword() || reqUsername == null || reqUsername.equals("") || reqUsername.equals("*") || reqUsername.equalsIgnoreCase(securityService.getRootAdminUserId())) {
                    RdsServlet.setAuthenticated();
                    this.processCmd(rdsReq, rdsResp, null);
                } else {
                    RdsServlet.setAuthenticated();
                    this.processCmd(rdsReq, rdsResp, securityService.getAuthorizedUser(reqUsername));
                }
            } else {
                RdsServlet.setAuthenticated();
                this.processCmd(rdsReq, rdsResp, null);
            }
        }
        catch (Throwable th) {
            this.log(th.getMessage(), th);
            rdsResp.setError(th);
        }
        finally {
            RdsServlet.removeAuthenticated();
        }
        this.doPostProcessCmd(rdsReq, rdsResp);
    }

    protected abstract void processCmd(RdsRequest var1, RdsResponse var2, AuthorizedUser var3) throws ServletException, IOException;

    private void doPostProcessCmd(RdsRequestImpl request, RdsResponseImpl response) throws IOException, ServletException {
        response.finish();
        request.reset();
        response.reset();
    }

    public String getInitParameter(String name) {
        String value = this.getServletConfig().getInitParameter(name);
        if (value == null) {
            value = this.getServletContext().getInitParameter(name);
        }
        return value;
    }

    public String getRequiredInitParameter(String name) throws ServletException {
        String value = this.getInitParameter(name);
        if (value == null) {
            throw new ServletException(RB.getString((Object)this, "RdsServlet.MissingRequiredInitParameter", (Object)ESAPIUtils.encodeForHTML(name, false)));
        }
        return value;
    }

    public int getRequiredInitParameterAsInt(String name) throws ServletException {
        String value = this.getRequiredInitParameter(name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ServletException(RB.getString((Object)this, "RdsServlet.InitParameterNotAnInt", (Object)ESAPIUtils.encodeForHTML(name, false)));
        }
    }

    public boolean checkAuthorization(String username, String password) {
        if (password == null) {
            return false;
        }
        if (ServiceFactory.getSecurityService().getUseSingleRdsPassword()) {
            return this.checkPassword(password);
        }
        return this.checkUsernamePassword(username, password);
    }

    private boolean checkRdsAccessAllowed() {
        return ServiceFactory.getSecurityService().isRdsEnabled();
    }

    protected boolean checkPassword(String pw) {
        SecurityService securityService = ServiceFactory.getSecurityService();
        if (securityService.checkRdsPassword(pw)) {
            return true;
        }
        try {
            pw = Encryptor.decrypt(pw);
            if (securityService.checkRdsPassword(pw)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected boolean checkUsernamePassword(String userName, String pw) {
        boolean isValid = false;
        SecurityService securityService = ServiceFactory.getSecurityService();
        try {
            if (securityService.checkRDSUserIdPassword(userName, pw, false)) {
                isValid = true;
            } else if (securityService.checkRDSUserIdPassword(userName, pw = Encryptor.decrypt(pw), false)) {
                isValid = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (isValid) {
            isValid = securityService.canAccessRDS(userName);
        }
        return isValid;
    }

    public Properties getInitParameters() {
        String name;
        Properties props = new Properties();
        ServletContext ctx = this.getServletContext();
        ServletConfig cfg = this.getServletConfig();
        Enumeration names = ctx.getInitParameterNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            props.put(name, ctx.getInitParameter(name));
        }
        names = cfg.getInitParameterNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            props.put(name, cfg.getInitParameter(name));
        }
        return props;
    }

    boolean isSecure() {
        return true;
    }

    private static void setAuthenticated() {
        authenticated.set(Boolean.TRUE);
    }

    private static void removeAuthenticated() {
        authenticated.remove();
    }

    public static boolean getAuthenticated() {
        Boolean auth = authenticated.get();
        return auth != null && auth != false;
    }
}

