/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.core;

import coldfusion.runtime.ApplicationException;
import coldfusion.serverless.ServerlessUtil;
import java.io.File;
import java.util.Map;

public class AppNameRootPair {
    private String givenName = null;
    private String appName;
    private File appRoot;
    private Map appSettings;
    private Map restDocInfo;
    private File[] restDirectory;
    private boolean initialized;
    private Boolean skipCFCOnError = null;
    private String host = "";
    private boolean isDefApp;
    private boolean genrateRestDoc = true;
    private String applicationCFCLoc;

    public String getApplicationCFCLoc() {
        return this.applicationCFCLoc;
    }

    public void setApplicationCFCLoc(String applicationCFCLoc) {
        this.applicationCFCLoc = applicationCFCLoc;
    }

    public boolean isGenrateRestDoc() {
        return this.genrateRestDoc;
    }

    public void setGenrateRestDoc(boolean genrateRestDoc) {
        this.genrateRestDoc = genrateRestDoc;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = !ServerlessUtil.isLambdaEnv() ? host : null;
    }

    public Boolean getSkipCFCOnError() {
        return this.skipCFCOnError;
    }

    public void setSkipCFCOnError(Boolean skipCFCOnError) {
        this.skipCFCOnError = skipCFCOnError;
    }

    public AppNameRootPair(String appName, File appRoot) {
        this.givenName = appName = "".equals(appName) ? null : appName;
        this.appRoot = appRoot;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized() {
        this.initialized = true;
    }

    public void setUnInitialized() {
        this.initialized = false;
        this.restDirectory = null;
    }

    public AppNameRootPair(String appName, String appRoot) {
        this(appName, new File(appRoot));
    }

    public File[] getRestDirectory() {
        return this.restDirectory;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setAppRoot(File appRoot) {
        this.appRoot = appRoot;
    }

    public void setAppSettings(Map appSettings) {
        this.appSettings = appSettings;
    }

    public void setRestDirectory(File[] restDirectory) {
        this.restDirectory = restDirectory;
    }

    public String getAppName() {
        if (this.givenName != null) {
            return this.givenName;
        }
        return this.appName;
    }

    public Map getAppSettings() {
        return this.appSettings;
    }

    public File getAppRoot() {
        return this.appRoot;
    }

    public Map getRestDocInfo() {
        return this.restDocInfo;
    }

    public void setRestDocInfo(Map restDocInfo) {
        this.restDocInfo = restDocInfo;
    }

    public void reset() {
        this.restDirectory = null;
        this.appName = null;
        this.initialized = false;
        this.skipCFCOnError = null;
        this.restDocInfo = null;
        this.genrateRestDoc = true;
    }

    public void setDefaultApplication(boolean isDefApp) {
        this.isDefApp = isDefApp;
    }

    public boolean isDefaultApplication() {
        return this.isDefApp;
    }

    public String getAppKey() {
        Object finalAppName = "";
        if (!this.isDefApp) {
            finalAppName = this.givenName != null ? this.givenName : this.appName;
        }
        if (null != this.host && 0 != this.host.length()) {
            finalAppName = this.host + (String)finalAppName;
        }
        return finalAppName;
    }

    public static class InvalidRestDirectoryException
    extends ApplicationException {
        public String path;
        public String name;

        public InvalidRestDirectoryException(String name, String path) {
            this.path = path;
            this.name = name;
        }
    }
}

