/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.provider;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.rest.JaxRsAppEventListener;
import coldfusion.rest.method.dispatch.CFRestException;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.Cast;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.runtime.XMLizerUtils;
import coldfusion.runtime.provider.SerializerProxyWrapper;
import coldfusion.runtime.xml.SerializationException;
import coldfusion.xml.rpc.CFCInvocationException;
import coldfusion.xml.rpc.CFComponentSkeleton;
import coldfusion.xml.rpc.DocumentQueryBean;
import coldfusion.xml.rpc.FilePath;
import coldfusion.xml.rpc.QueryBean;
import coldfusion.xml.rpc.TypeConverter;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.w3c.dom.Document;

@Provider
public class CFObjectProvider
implements MessageBodyWriter<Object>,
MessageBodyReader<Object> {
    private static final String XML = "xml";
    private static final String JSON = "json";
    private static final Logger logger = CFLogs.SERVER_LOG;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        SerializerProxyWrapper serializerProxy = this.getSerializerProxy();
        try {
            if (null != serializerProxy && serializerProxy.canDeSerialize(mediaType.toString())) {
                return true;
            }
        }
        catch (Throwable e) {
            logger.warn(e);
        }
        return this.isClassHandled(type, mediaType);
    }

    private boolean isClassHandled(Class<?> type, MediaType mediaType) {
        if (mediaType.getSubtype().toLowerCase().indexOf(JSON) > -1) {
            return this.isClassHandled(type);
        }
        if (mediaType.getSubtype().toLowerCase().indexOf(XML) > -1) {
            return this.isClassHandled(type);
        }
        if (mediaType.toString().toLowerCase().indexOf("text/plain") > -1) {
            return this.isClassHandled(type);
        }
        return false;
    }

    private boolean isClassHandled(Class<?> type) {
        boolean result = false;
        result = type.isArray() ? this.isClassHandled(type.getComponentType()) || Object.class.equals(type.getComponentType()) : Map.class.isAssignableFrom(type) && Form.class != type || QueryBean.class.isAssignableFrom(type) || DocumentQueryBean.class.isAssignableFrom(type) || CFComponentSkeleton.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Calendar.class.isAssignableFrom(type) || CFBoolean.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type) || Object.class.equals(type) || Document.class.isAssignableFrom(type);
        return result;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Object deserializedData;
        SerializerProxyWrapper serializerProxy = this.getSerializerProxy();
        String charset = this.getCharSet(mediaType);
        if (null == serializerProxy) {
            Object result = null;
            if (mediaType.getSubtype().toLowerCase().indexOf(JSON) > -1 || mediaType.toString().toLowerCase().indexOf("text/plain") > -1) {
                String jsonStr = this.getString(entityStream, charset);
                try {
                    result = JSONUtils.deserializeJSON(jsonStr, false);
                    FilePath fileAnnotation = type.getAnnotation(FilePath.class);
                    if (type != null && (type.getName().contains("java.util.Map") || fileAnnotation != null)) {
                        ObjectMapper mapper = new ObjectMapper();
                        mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
                        result = mapper.readValue(jsonStr, type);
                    }
                }
                catch (JSONUtils.JSONParseException je) {
                    if (Object.class.equals(type)) {
                        result = jsonStr;
                    }
                    this.handleException(je);
                }
                if (Double.class.isAssignableFrom(type) && result instanceof Integer) {
                    result = Cast._double(result);
                }
                if (Calendar.class.isAssignableFrom(type) && result instanceof String) {
                    Calendar instance = Calendar.getInstance();
                    Date date = null;
                    try {
                        date = Cast._Date(result);
                    }
                    catch (Cast.DateConversionException e) {
                        this.handleException(e);
                    }
                    instance.setTime(date);
                    result = instance;
                }
            } else if (mediaType.getSubtype().toLowerCase().indexOf(XML) > -1) {
                result = XMLizerUtils.deserializeXML(type, this.getString(entityStream, charset), false);
                if (DocumentQueryBean.class.isAssignableFrom(type) && result instanceof QueryBean) {
                    DocumentQueryBean bean = new DocumentQueryBean();
                    bean.setColumnList(((QueryBean)result).getColumnList());
                    bean.setData(((QueryBean)result).getData());
                    result = bean;
                }
            }
            Object temp = null;
            try {
                result = TypeConverter.convertOut(result, type.getClassLoader());
                if (result != null && result.getClass().isArray() && type.isArray() && !type.getComponentType().equals(Object.class)) {
                    Object newInstance = Array.newInstance(type.getComponentType(), Array.getLength(result));
                    result = this.getStrongTypeArray(result, type.getComponentType(), newInstance);
                }
            }
            catch (CFCInvocationException e) {
                temp = null;
            }
            result = temp == null ? result : temp;
            return result;
        }
        String serializedStr = this.getString(entityStream, charset);
        FusionContext context = FusionContext.getCurrent();
        Object oldData = context.getCurrentSerializedData();
        try {
            context.setCurrentSerializedData(serializedStr);
            deserializedData = serializerProxy.deserialize(serializedStr, mediaType.toString(), type.getName());
        }
        catch (Throwable e) {
            logger.error(e);
            throw new ParseException(serializedStr, e);
        }
        finally {
            context.setCurrentSerializedData(oldData);
        }
        Object temp = null;
        try {
            deserializedData = TypeConverter.convertOut(deserializedData, type.getClassLoader());
        }
        catch (CFCInvocationException e) {
            temp = null;
        }
        deserializedData = temp == null ? deserializedData : temp;
        return deserializedData;
    }

    private Object getStrongTypeArray(Object result, Class type, Object newInstance) {
        int length = Array.getLength(result);
        for (int i = 0; i < length; ++i) {
            Object object = Array.get(result, i);
            if (object.getClass().isArray() && type.isArray() && !type.getComponentType().equals(Object.class)) {
                Object newInstance1 = Array.newInstance(type.getComponentType(), Array.getLength(result));
                Array.set(newInstance, i, this.getStrongTypeArray(object, type.getComponentType(), newInstance1));
                continue;
            }
            Array.set(newInstance, i, object);
        }
        return newInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getString(InputStream is, String charSet) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, charSet));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        SerializerProxyWrapper serializerProxy = this.getSerializerProxy();
        try {
            if (null != serializerProxy && serializerProxy.canSerialize(mediaType.toString())) {
                return true;
            }
        }
        catch (Throwable e) {
            logger.warn(e);
        }
        return this.isClassHandled(type, mediaType);
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Object temp = null;
        try {
            t = TypeConverter.convertIn(t);
        }
        catch (CFCInvocationException e) {
            temp = null;
        }
        t = temp == null ? t : temp;
        SerializerProxyWrapper serializerProxy = this.getSerializerProxy();
        String charset = this.getCharSet(mediaType);
        if (null == serializerProxy) {
            String result = null;
            if (mediaType.getSubtype().toLowerCase().indexOf(JSON) > -1 || mediaType.toString().toLowerCase().indexOf("text/plain") > -1) {
                try {
                    result = JSONUtils.serializeJSON(t);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            } else if (mediaType.getSubtype().toLowerCase().indexOf(XML) > -1) {
                try {
                    result = XMLizerUtils.serializeXML(t, true);
                }
                catch (SerializationException e) {
                    this.handleException(e);
                }
            }
            PrintStream stream = new PrintStream(entityStream, false, charset);
            stream.print(result);
        } else {
            FusionContext context = FusionContext.getCurrent();
            String serializedData = null;
            Object oldData = context.getCurrentSerializedData();
            try {
                context.setCurrentSerializedData(t);
                serializedData = serializerProxy.serialize(t, mediaType.toString());
            }
            catch (Throwable e) {
                this.handleException(e);
            }
            finally {
                context.setCurrentSerializedData(oldData);
            }
            PrintStream stream = new PrintStream(entityStream, false, charset);
            stream.print(serializedData);
        }
    }

    private String getCharSet(MediaType mediaType) {
        Map params = mediaType.getParameters();
        String charset = (String)params.get("charset");
        if (null == charset) {
            charset = RuntimeServiceImpl.getDefaultCharset();
        }
        return charset;
    }

    private SerializerProxyWrapper getSerializerProxy() {
        Map appSettings;
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(FusionContext.getCurrent().getApplicationName());
        String serializer = null;
        if (appScope != null && (appSettings = appScope.getApplicationSettingsMap()) != null) {
            serializer = (String)appSettings.get("CustomSerializer");
        }
        if (null != serializer && serializer.trim().length() > 0) {
            try {
                Map appSettings2;
                SerializerProxyWrapper serializerProxy = new SerializerProxyWrapper(TemplateProxyFactory.resolveName(serializer, FusionContext.getCurrent().pageContext));
                if (appScope != null && (appSettings2 = appScope.getApplicationSettingsMap()) != null) {
                    appSettings2.put("CustomSerializerInstance", serializerProxy);
                }
                return serializerProxy;
            }
            catch (Throwable e) {
                throw new JaxRsAppEventListener.InvalidSerializerException(serializer, e);
            }
        }
        return null;
    }

    private void handleException(Throwable e) {
        logger.error(e);
        Response.ResponseBuilder serverError = Response.serverError();
        serverError.entity((Object)e.getMessage());
        throw new CFRestException(e);
    }

    public static class ParseException
    extends ApplicationException {
        public final String serializedStr;

        public ParseException(String serializedStr, Throwable e) {
            super(e);
            this.serializedStr = serializedStr;
        }

        public String getRootMessage() {
            String message = this.rootCause.getMessage();
            if (null != message && message.endsWith(".")) {
                message = message.substring(0, message.length() - 1);
            }
            return message;
        }
    }
}

