/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.provider;

import coldfusion.filter.ApplicationFilter;
import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.filter.MonitoringFilter;
import coldfusion.filter.RequestMonitorFilter;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.rest.method.dispatch.CFExecutionFilter;
import coldfusion.xml.rpc.CFComponentSkeleton;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.internal.util.collection.StringKeyIgnoreCaseMultivaluedMap;
import org.glassfish.jersey.message.internal.MediaTypes;

@Provider
public class CFRequestFilter
implements ContainerRequestFilter {
    private static final Logger logger = CFLogs.SERVER_LOG;
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext request) throws IOException {
        logger.debug("custom request filter invoked");
        if (MediaTypes.typeEqual((MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE, (MediaType)request.getMediaType())) {
            String propName = null;
            if (request.getProperty("jersey.config.server.representation.decoded.form") != null) {
                propName = "jersey.config.server.representation.decoded.form";
            } else if (request.getProperty("jersey.config.server.representation.form") != null) {
                propName = "jersey.config.server.representation.form";
            }
            if (propName != null) {
                Form form = (Form)request.getProperty(propName);
                StringKeyIgnoreCaseMultivaluedMap caseInsensitiveParameters = new StringKeyIgnoreCaseMultivaluedMap();
                caseInsensitiveParameters.putAll((Map)form.asMap());
                request.setProperty(propName, (Object)new Form((MultivaluedMap)caseInsensitiveParameters));
            }
        }
        FusionFilter filter = new CFExecutionFilter();
        List resourceList = request.getUriInfo().getMatchedResources();
        if (resourceList != null) {
            Object resource = resourceList.get(0);
            if (resource instanceof CFComponentSkeleton) {
                filter = new ApplicationFilter(filter, 1, resource, this.resourceInfo.getResourceMethod(), new Object[0]);
                if (RequestMonitorFilter.isFilterEnabled()) {
                    filter = new RequestMonitorFilter(filter);
                }
                filter = new MonitoringFilter(filter, "WEB SERVICE REQUEST");
            }
            try {
                ((FusionFilter)filter).invoke(FusionContext.getCurrent());
            }
            catch (Throwable e) {
                logger.error("Error in cfrequestfilter filter invocation ", e);
                throw new RuntimeException(e);
            }
        }
    }
}

