/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.provider;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.text.WordUtils;
import org.glassfish.jersey.message.MessageBodyWorkers;

@Provider
public class PatchReader
implements ReaderInterceptor {
    private UriInfo info;
    private HttpHeaders httpHeaders;
    private MessageBodyWorkers workers;

    @Context
    public void setInfo(UriInfo info) {
        this.info = info;
    }

    @Context
    public void setHttpHeaders(HttpHeaders httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    @Context
    public void setWorkers(MessageBodyWorkers workers) {
        this.workers = workers;
    }

    public Object aroundReadFrom(ReaderInterceptorContext readerInterceptorContext) throws IOException, WebApplicationException {
        Object resource = this.info.getMatchedResources().get(0);
        Method found = null;
        for (Method next : resource.getClass().getMethods()) {
            if (next.getAnnotation(GET.class) == null) continue;
            Path pathAnnotation = next.getAnnotation(Path.class);
            if (pathAnnotation != null) {
                String path = pathAnnotation.toString();
                if (path != null && path.contains(this.getLastToken(this.info.getPath(), "/"))) {
                    found = next;
                    break;
                }
                if (path == null || this.info.getMatchedResources() == null) continue;
                found = next;
                break;
            }
            if (pathAnnotation == null && !this.info.getPath().contains("/")) {
                found = next;
                break;
            }
            found = null;
        }
        if (found != null) {
            Object bean;
            Object[] args = new Object[found.getParameterCount()];
            Class<?>[] parameterTypes = found.getParameterTypes();
            MultivaluedMap pathParameters = this.info.getPathParameters();
            MultivaluedMap queryParameters = this.info.getQueryParameters();
            MultivaluedMap headerParams = this.httpHeaders.getRequestHeaders();
            List l = this.info.getPathSegments();
            PathSegment p = (PathSegment)l.get(l.size() - 1);
            MultivaluedMap matrixParams = p.getMatrixParameters();
            for (int i = 0; i < args.length; ++i) {
                Annotation[] annotations = found.getParameterAnnotations()[i];
                Class<?> paramType = parameterTypes[i];
                for (Annotation annotation : annotations) {
                    Object arg = null;
                    if (annotation.annotationType().equals(PathParam.class)) {
                        value = ((PathParam)annotation).value();
                        arg = this.extractArgs(paramType, (List)pathParameters.get((Object)value));
                    } else if (annotation.annotationType().equals(QueryParam.class)) {
                        value = ((QueryParam)annotation).value();
                        arg = this.extractArgs(paramType, (List)queryParameters.get((Object)value));
                    } else if (annotation.annotationType().equals(HeaderParam.class)) {
                        value = ((HeaderParam)annotation).value();
                        arg = this.extractArgs(paramType, (List)headerParams.get((Object)value));
                    } else if (annotation.annotationType().equals(MatrixParam.class)) {
                        value = ((MatrixParam)annotation).value();
                        arg = this.extractArgs(paramType, (List)matrixParams.get((Object)value));
                    }
                    args[i] = arg;
                }
            }
            try {
                bean = found.invoke(resource, args);
            }
            catch (Exception e) {
                throw new WebApplicationException((Throwable)e);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MessageBodyWriter bodyWriter = this.workers.getMessageBodyWriter(Object.class, bean.getClass(), new Annotation[0], MediaType.APPLICATION_JSON_TYPE);
            bodyWriter.writeTo(bean, bean.getClass(), bean.getClass(), new Annotation[0], MediaType.APPLICATION_JSON_TYPE, (MultivaluedMap)new MultivaluedHashMap(), (OutputStream)baos);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode serverState = (JsonNode)mapper.readValue(baos.toByteArray(), JsonNode.class);
            JsonNode patchAsNode = (JsonNode)mapper.readValue(readerInterceptorContext.getInputStream(), JsonNode.class);
            for (JsonNode node : patchAsNode) {
                PatchReader.updatePaths(serverState, node, "op");
                PatchReader.updatePaths(serverState, node, "path");
                PatchReader.updatePaths(serverState, node, "value");
            }
            JsonPatch patch = JsonPatch.fromJson((JsonNode)patchAsNode);
            try {
                JsonNode result = patch.apply(serverState);
                ByteArrayOutputStream resultAsByteArray = new ByteArrayOutputStream();
                mapper.writeValue((OutputStream)resultAsByteArray, (Object)result);
                readerInterceptorContext.setInputStream((InputStream)new ByteArrayInputStream(resultAsByteArray.toByteArray()));
                return readerInterceptorContext.proceed();
            }
            catch (JsonPatchException e) {
                throw new WebApplicationException(Response.status((int)500).type("text/plain").entity((Object)e.getMessage()).build());
            }
        }
        throw new IllegalArgumentException("No matching GET method on resource");
    }

    private String getLastToken(String strValue, String splitter) {
        String[] strArray = strValue.split(splitter);
        return strArray[strArray.length - 1];
    }

    public Object extractArgs(Class<?> typ, List<String> strings1) {
        List<String> strings = strings1;
        if (strings.size() > 0) {
            String value = strings.get(0);
            if (typ.equals(String.class)) {
                return value;
            }
            if (typ.equals(String.class)) {
                return value;
            }
            if (typ.equals(Boolean.TYPE) || typ.equals(Boolean.class)) {
                return value == null ? Boolean.FALSE : Boolean.valueOf(value);
            }
            if (value == null) {
                value = "0";
            }
            if (typ.equals(Long.TYPE) || typ.equals(Long.class)) {
                return Long.valueOf(value);
            }
            if (typ.equals(Integer.TYPE) || typ.equals(Integer.class)) {
                return Integer.valueOf(value);
            }
            if (typ.equals(Double.TYPE) || typ.equals(Double.class)) {
                return Double.valueOf(value);
            }
            return null;
        }
        return null;
    }

    private static JsonNode updatePaths(JsonNode serverState, JsonNode node, String nodename) {
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String lcase;
            JsonNode pathnode;
            String nodeKey = (String)fieldNames.next();
            String value = "";
            JsonNode valueNode = null;
            if (nodeKey != null && nodeKey.equalsIgnoreCase("path") && (pathnode = serverState.at(value = node.get(nodeKey).asText())).isMissingNode() && (pathnode = serverState.at(value = value.toUpperCase())).isMissingNode() && (pathnode = serverState.at(value = value.toLowerCase())).isMissingNode()) {
                value = WordUtils.capitalizeFully((String)value, (char[])new char[]{'/'});
                pathnode = serverState.at(value);
            }
            if (nodeKey != null && nodeKey.equalsIgnoreCase("op")) {
                value = node.get(nodeKey).asText().toLowerCase();
            }
            if (nodeKey != null && nodeKey.equalsIgnoreCase("value")) {
                valueNode = node.get(nodeKey);
            }
            if (!(lcase = nodeKey.toLowerCase()).equals(nodename)) continue;
            ObjectNode oNode = (ObjectNode)node;
            oNode.remove(nodeKey);
            if (nodeKey.equalsIgnoreCase("value")) {
                oNode.put(nodename, valueNode);
            } else {
                oNode.put(nodename, value);
            }
            return oNode;
        }
        return null;
    }
}

