/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.scanning;

import coldfusion.cfc.DummyHttpServletRequest;
import coldfusion.cfc.DummyHttpServletResponse;
import coldfusion.filter.FusionContext;
import coldfusion.rest.classloader.RestSkeletonClassLoader;
import coldfusion.rest.core.AppNameRootPair;
import coldfusion.rest.servlet.CFRestServlet;
import coldfusion.rest.swagger.CFSwaggerApiCreator;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.util.Key;
import coldfusion.util.RB;
import com.smartbear.swagger4j.ApiDeclaration;
import com.smartbear.swagger4j.SwaggerFactory;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CFRestResourceScannerListener {
    private final List<Class<?>> rootResourceClasses = new ArrayList();
    private final List<ApiDeclaration> apiDeclerations = new ArrayList<ApiDeclaration>();
    private final ServletContext serv;
    private final String[] applicationRoot;
    private boolean skipCFC;
    private final SwaggerFactory factory;
    private final AppNameRootPair appNameRootPair;

    public CFRestResourceScannerListener(ServletContext serv, String[] applicationRoot, boolean skipCFC, SwaggerFactory factory, AppNameRootPair appNameRootPair) {
        this.serv = serv;
        this.applicationRoot = applicationRoot;
        this.skipCFC = skipCFC;
        this.factory = factory;
        this.appNameRootPair = appNameRootPair;
    }

    public boolean onAccept(String name) {
        return name.endsWith(".cfc");
    }

    public void onProcess(String cfcPath, InputStream in) throws IOException {
        TemplateProxy proxy = null;
        FusionContext fusionContext = this.getDummyFusionContext(cfcPath);
        FusionContext oldContext = FusionContext.setCurrent(fusionContext);
        try {
            boolean isDoc;
            proxy = TemplateProxyFactory.resolveFile(fusionContext.pageContext, new File(cfcPath));
            AttributeCollection metadata = (AttributeCollection)proxy.getMetadata();
            String restAttribute = (String)metadata.get(Key.getInstance("rest"));
            String restPathAttribute = (String)metadata.get(Key.getInstance("restPath"));
            if (null == restAttribute) {
                Class<?> annotatedClass;
                if (null != restPathAttribute && (annotatedClass = this.getAnnotatedClass(cfcPath, proxy)) != null) {
                    this.rootResourceClasses.add(annotatedClass);
                }
            } else if (Cast._boolean(restAttribute.trim())) {
                Object substring = null;
                int maxLength = -1;
                for (int i = 0; i < this.applicationRoot.length; ++i) {
                    if (!cfcPath.startsWith(this.applicationRoot[i]) || maxLength != -1 && maxLength >= this.applicationRoot[i].length()) continue;
                    substring = cfcPath.substring(this.applicationRoot[i].length(), cfcPath.length() - 4);
                    maxLength = this.applicationRoot[i].length();
                }
                substring = ((String)(substring = ((String)substring).replaceAll("\\" + File.separator, "/"))).startsWith("/") ? substring : "/" + (String)substring;
                fusionContext.pageContext.setAttribute("_restpath_", substring);
                Class<?> annotatedClass = this.getAnnotatedClass(cfcPath, proxy);
                if (annotatedClass != null) {
                    this.rootResourceClasses.add(annotatedClass);
                }
            }
            if ((null != restPathAttribute || null != restAttribute) && (isDoc = this.appNameRootPair.isGenrateRestDoc())) {
                CFSwaggerApiCreator swaggerApiCreator = new CFSwaggerApiCreator();
                ApiDeclaration apiDecleration = swaggerApiCreator.generateApiDeclaration(proxy, this.factory, this.appNameRootPair, fusionContext.pageContext);
                this.apiDeclerations.add(apiDecleration);
                swaggerApiCreator = null;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(RB.getString((Object)this, "CFRestResourceScannerListener.ExceptionOnResolving", new Object[]{new File(cfcPath).toURI()}), e);
        }
        finally {
            FusionContext.setCurrent(oldContext);
        }
    }

    private Class<?> getAnnotatedClass(String cfcPath, TemplateProxy proxy) throws Throwable {
        Class<?> annotatedClass = RestSkeletonClassLoader.getAnnotatedClass(cfcPath, proxy, this.skipCFC);
        return annotatedClass;
    }

    public Set<Class<?>> getAnnotatedClasses() {
        return new HashSet(this.rootResourceClasses);
    }

    public List<ApiDeclaration> getApiDeclerations() {
        return this.apiDeclerations;
    }

    private FusionContext getDummyFusionContext(String cfcPath) {
        FusionContext fusionContext = FusionContext.getCurrent();
        DummyHttpServletRequest req = null;
        DummyHttpServletResponse resp = null;
        fusionContext = new FusionContext();
        fusionContext.setUseMappings(true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (req == null) {
            req = new DummyHttpServletRequest(cfcPath);
        }
        if (baos != null || resp == null) {
            resp = new DummyHttpServletResponse(baos);
        }
        CFRestServlet servlet = CFRestServlet.getCFRestServlet();
        fusionContext.setServletObjects((Servlet)servlet, (ServletRequest)req, (ServletResponse)resp);
        fusionContext.setPagePath(cfcPath);
        try {
            fusionContext.SymTab_initForRequest(true);
        }
        catch (Throwable e) {
            throw new RuntimeException(RB.getString((Object)this, "CFRestResourceScannerListener.ExceptionOnInitializing", new Object[]{cfcPath}), e);
        }
        return fusionContext;
    }
}

