/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.scanning;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.rest.scanning.CFRestResourceScannerListener;
import coldfusion.runtime.ApplicationException;
import coldfusion.util.RB;
import java.io.File;

public class CFScanner {
    private static final Logger LOGGER = CFLogs.RESTSERVICE_LOG;
    private final File[] applicationRoot;
    private final boolean skipCFC;

    public CFScanner(File[] applicationRoot, boolean skipCFC) {
        this.applicationRoot = applicationRoot;
        this.skipCFC = skipCFC;
    }

    public void scan(CFRestResourceScannerListener scannerListener) {
        for (int i = 0; i < this.applicationRoot.length; ++i) {
            File[] files = this.applicationRoot[i].listFiles();
            if (files == null) continue;
            for (File file : files) {
                if (file.isDirectory()) {
                    this.processDirectory(scannerListener, file);
                    continue;
                }
                this.processFile(scannerListener, file);
            }
        }
    }

    private void processDirectory(CFRestResourceScannerListener scannerListener, File file) {
        File[] subFiles = file.listFiles();
        if (subFiles != null && subFiles.length > 0) {
            for (File subFile : subFiles) {
                if (subFile.isDirectory()) {
                    this.processDirectory(scannerListener, subFile);
                    continue;
                }
                this.processFile(scannerListener, subFile);
            }
        }
    }

    private void processFile(CFRestResourceScannerListener scannerListener, File file) {
        block5: {
            try {
                String path = file.getCanonicalPath();
                if (scannerListener.onAccept(path)) {
                    scannerListener.onProcess(path, null);
                }
            }
            catch (Throwable e) {
                LOGGER.error(RB.getString((Object)this, "CFScanner.ExceptionOnScanningCFC", new Object[]{file.getName()}), e);
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof ApplicationException) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(((ApplicationException)cause).getMessage()).append(" ").append(((ApplicationException)cause).getDetail());
                    LOGGER.error(sb.toString());
                }
                if (this.skipCFC) break block5;
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(RB.getString((Object)this, "CFScanner.ExceptionOnScanningCFC", new Object[]{file.getName()}), e);
            }
        }
    }
}

