/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.servlet;

import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.rest.core.AppNameRootPair;
import coldfusion.rest.scanning.CFResourceConfig;
import coldfusion.server.MonitoringService;
import coldfusion.server.ServiceFactory;
import coldfusion.serverless.ServerlessUtil;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.UriBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.glassfish.jersey.uri.UriComponent;

public class CFRestServletContainer
extends ServletContainer {
    private final File[] applicationRoot;
    private final ServletConfig servletConfig;
    private final String appName;
    private final boolean skipCFC;
    private final AppNameRootPair appNameRootPair;

    public CFRestServletContainer(CFResourceConfig resourceConfig, String appName, File[] applicationRoot, ServletConfig servletConfig, boolean skipCFC, AppNameRootPair appNameRootPair) {
        super((ResourceConfig)resourceConfig);
        this.appName = appName;
        this.applicationRoot = applicationRoot;
        this.servletConfig = servletConfig;
        this.skipCFC = skipCFC;
        this.appNameRootPair = appNameRootPair;
    }

    public static CFRestServletContainer getServletContainer(String appName, File[] applicationRoot, ServletConfig servletConfig, boolean skipCFC, AppNameRootPair appNameRootPair) {
        CFResourceConfig resourceConfig = new CFResourceConfig(applicationRoot, servletConfig.getServletContext(), skipCFC, appNameRootPair);
        return new CFRestServletContainer(resourceConfig, appName, applicationRoot, servletConfig, skipCFC, appNameRootPair);
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.service(request, response, false);
    }

    public String getLambdaURIComponent(String value) {
        if (!ServerlessUtil.isLambdaEnv()) {
            return value;
        }
        CharSequence[] pathParts = value.split("/rest/");
        if (pathParts.length == 1) {
            return value;
        }
        if (pathParts.length > 1) {
            boolean i = false;
            pathParts[0] = "";
            return String.join((CharSequence)"/rest/", pathParts);
        }
        return value;
    }

    public String getLambdaURL(String value) {
        CharSequence[] pathParts;
        if (!ServerlessUtil.isLambdaEnv()) {
            return value;
        }
        String protocol = null;
        String host = null;
        Object pathInfo = null;
        int pathAfterProtocolIndex = value.indexOf("//");
        protocol = value.substring(0, pathAfterProtocolIndex);
        if (pathAfterProtocolIndex != -1) {
            String pathAfterProtocol = value.substring(pathAfterProtocolIndex + 2);
            host = pathAfterProtocol.substring(0, pathAfterProtocol.indexOf("/"));
            String pathAfterDomain = pathAfterProtocol.substring(pathAfterProtocol.indexOf("/") + 1);
            pathInfo = pathAfterDomain;
            if (!((String)pathInfo).startsWith("/")) {
                pathInfo = "/" + (String)pathInfo;
            }
        }
        if ((pathParts = ((String)pathInfo).split("/rest/")).length == 1) {
            return this.constructLambdaURL(protocol, host, pathParts[0]);
        }
        if (pathParts.length > 1) {
            pathParts[0] = "";
            return this.constructLambdaURL(protocol, host, String.join((CharSequence)"/rest/", pathParts));
        }
        return value;
    }

    private String constructLambdaURL(String protocol, String host, String path) {
        return protocol + "//" + host + path;
    }

    public void service(HttpServletRequest request, HttpServletResponse response, boolean isDefault) throws ServletException, IOException {
        String queryParameters;
        boolean checkServletPath;
        String servletPath = ServerlessUtil.isLambdaEnv() ? this.getLambdaRestServletPath(request) : request.getServletPath();
        String pathInfo = this.getLambdaURIComponent(request.getPathInfo());
        StringBuffer requestURL = new StringBuffer(this.getLambdaURL(request.getRequestURL().toString()));
        Object requestURI = this.getLambdaURIComponent(request.getRequestURI());
        if (((String)requestURI).endsWith(".json")) {
            requestURI = ((String)requestURI).substring(0, ((String)requestURI).length() - 5);
        } else if (((String)requestURI).endsWith(".xml")) {
            requestURI = ((String)requestURI).substring(0, ((String)requestURI).length() - 4);
        }
        boolean checkPathInfo = pathInfo == null || pathInfo.isEmpty() || pathInfo.equals("/");
        boolean bl = checkServletPath = servletPath == null || servletPath.isEmpty();
        if (checkPathInfo && checkServletPath && !request.getRequestURI().endsWith("/")) {
            pathInfo = "/";
            requestURL.append("/");
            requestURI = (String)requestURI + "/";
        }
        UriBuilder absoluteUriBuilder = UriBuilder.fromUri((String)requestURL.toString());
        String name = isDefault ? "" : this.appName + "/";
        String decodedBasePath = pathInfo != null ? request.getContextPath() + servletPath + "/" + name : request.getContextPath() + "/";
        String encodedBasePath = UriComponent.encode((String)decodedBasePath, (UriComponent.Type)UriComponent.Type.PATH);
        if (encodedBasePath.indexOf("%20") > -1) {
            encodedBasePath = encodedBasePath.replace("%20", " ");
        }
        if (!decodedBasePath.equals(encodedBasePath)) {
            // empty if block
        }
        URI baseUri = absoluteUriBuilder.replacePath(encodedBasePath).build(new Object[0]);
        MonitoringService monitoringService = ServiceFactory.getMonitoringService();
        if (monitoringService != null && monitoringService.isMonitoringEnabled()) {
            RequestMonitorEventProcessor.onRestStart((String)requestURI, this.appName);
        }
        if ((queryParameters = request.getQueryString()) == null) {
            queryParameters = "";
        }
        URI requestUri = absoluteUriBuilder.replacePath((String)requestURI).replaceQuery(queryParameters).build(new Object[0]);
        this.service(baseUri, requestUri, request, response);
    }

    private String getLambdaRestServletPath(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        if (requestURI.startsWith("/rest")) {
            return "/rest";
        }
        return null;
    }
}

