/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.servlet;

import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.rest.servlet.CFRestServlet;
import coldfusion.server.ServiceFactory;
import coldfusion.serverless.ServerlessUtil;
import jakarta.servlet.http.HttpServletRequest;

public class RestFilter
extends FusionFilter {
    private CFRestServlet cfRestServlet;

    public RestFilter(FusionFilter next) {
        super(next);
    }

    public RestFilter(CFRestServlet cfRestServlet) {
        this((FusionFilter)null);
        this.cfRestServlet = cfRestServlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(FusionContext context) throws Throwable {
        FusionContext oldContext = FusionContext.setCurrent(context);
        context.setRestServiceCall(true);
        try {
            String[] hostAppNamePair = this.getHostAndApplicationNameFromURL(context.getRequest());
            context.setRestServiceName(hostAppNamePair[1]);
            this.cfRestServlet.invoke(hostAppNamePair[0], hostAppNamePair[1], context.getRequest(), context.getResponse());
        }
        finally {
            FusionContext.setCurrent(oldContext);
        }
    }

    private String[] getHostAndApplicationNameFromURL(HttpServletRequest request) {
        String restPath;
        StringBuffer requestURI = request.getRequestURL();
        String host = "";
        int pathAfterProtocolIndex = requestURI.indexOf("//");
        if (pathAfterProtocolIndex != -1) {
            String pathAfterDomain;
            String pathAfterProtocol = requestURI.substring(pathAfterProtocolIndex + 2);
            host = pathAfterProtocol.substring(0, pathAfterProtocol.indexOf("/"));
            restPath = pathAfterDomain = pathAfterProtocol.substring(pathAfterProtocol.indexOf("/") + 1);
        } else {
            restPath = requestURI.substring(1);
        }
        if (0 != request.getContextPath().length()) {
            restPath = restPath.substring(request.getContextPath().length());
        }
        if (0 != request.getServletPath().length()) {
            restPath = restPath.substring(request.getServletPath().length());
        }
        if (ServiceFactory.getRuntimeService().isAllowRestDiscovery() && restPath.equals("_api_listing")) {
            return new String[]{host, "_cf__default_apim_"};
        }
        if (restPath.indexOf("/") == -1 && restPath.length() < 1) {
            return new String[]{host, "_cf__default_"};
        }
        String applicationName = restPath.indexOf("/") > 0 ? restPath.substring(0, restPath.indexOf("/")) : restPath;
        if (ServerlessUtil.isLambdaEnv()) {
            int i;
            String[] restPathParts = restPath.split("/");
            for (i = 0; i < restPathParts.length && !restPathParts[i].equals("rest"); ++i) {
            }
            if (restPathParts[i].equals("rest")) {
                applicationName = restPathParts[i + 1];
            }
        }
        if (applicationName.indexOf("%20") > -1) {
            applicationName = applicationName.replace("%20", " ");
        }
        return new String[]{host, applicationName};
    }
}

