/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.rest.swagger;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.rest.core.AppNameRootPair;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.util.FastHashtable;
import coldfusion.xml.rpc.SkeletonClassLoader;
import com.smartbear.swagger4j.Api;
import com.smartbear.swagger4j.ApiDeclaration;
import com.smartbear.swagger4j.DataType;
import com.smartbear.swagger4j.Model;
import com.smartbear.swagger4j.Operation;
import com.smartbear.swagger4j.Parameter;
import com.smartbear.swagger4j.PrimitiveType;
import com.smartbear.swagger4j.ResourceListing;
import com.smartbear.swagger4j.ResponseMessage;
import com.smartbear.swagger4j.Swagger;
import com.smartbear.swagger4j.SwaggerFactory;
import com.smartbear.swagger4j.SwaggerFormat;
import com.smartbear.swagger4j.SwaggerStore;
import com.smartbear.swagger4j.SwaggerVersion;
import com.smartbear.swagger4j.impl.ModelImpl;
import com.smartbear.swagger4j.impl.PrimitiveArrayType;
import com.smartbear.swagger4j.impl.PropertyImpl;
import com.smartbear.swagger4j.impl.RefArrayType;
import com.smartbear.swagger4j.impl.RefDataType;
import com.smartbear.swagger4j.impl.ResourceListingImpl;
import com.smartbear.swagger4j.impl.Utils;
import jakarta.servlet.ServletContext;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CFSwaggerApiCreator {
    private static final Logger LOGGER = CFLogs.WEBSERVICE_LOG;
    private static int dfeaultPort = 8500;
    private static String defaultHost = "127.0.0.1";
    private boolean isExtending = false;
    public static final String SWAGGER_API_DOCS = "api-docs";
    private static final FastHashtable mappingsForCFCtoSwagger = new FastHashtable();
    private static final Set<String> complexCFCmappings;
    private static final FastHashtable swaggerToPrimitiveType;
    private static final Set<String> httpMethods;

    public ApiDeclaration generateApiDeclaration(TemplateProxy proxy, SwaggerFactory factory, AppNameRootPair appNameRootPair, NeoPageContext pageContext) {
        Map restDocInfotemp;
        String compConsumes;
        HashMap<String, List<Map>> restPathOperations = new HashMap<String, List<Map>>();
        AttributeCollection descriptor = (AttributeCollection)proxy.getMetadata();
        HashSet<String> complexCFC = new HashSet<String>();
        Object resourcePath = (String)descriptor.get("RESTPATH");
        Object appName = "/" + appNameRootPair.getAppName();
        if (appNameRootPair.isDefaultApplication()) {
            appName = "";
        }
        if (!this.isNullorEmpty((String)resourcePath)) {
            if (!((String)resourcePath).startsWith("/")) {
                resourcePath = "/" + (String)resourcePath;
            }
        } else {
            resourcePath = (String)pageContext.getAttribute("_restpath_");
        }
        ApiDeclaration apiDecleration = factory.createApiDeclaration("$", (String)resourcePath);
        String compProduces = (String)descriptor.get("PRODUCES");
        if (!this.isNullorEmpty(compProduces)) {
            String[] producesArray;
            for (String produce : producesArray = compProduces.split(",")) {
                apiDecleration.addProduces(produce);
            }
        }
        if (!this.isNullorEmpty(compConsumes = (String)descriptor.get("CONSUMES"))) {
            String[] consumesArray;
            for (String consumes : consumesArray = compConsumes.split(",")) {
                apiDecleration.addConsumes(consumes);
            }
        }
        if ((restDocInfotemp = appNameRootPair.getRestDocInfo()) != null && !this.isNullorEmpty((String)restDocInfotemp.get("apiVersion"))) {
            apiDecleration.setApiVersion((String)restDocInfotemp.get("apiVersion"));
        }
        if (!this.isExtended(descriptor)) {
            Object[] methods = (Object[])descriptor.get("functions");
            for (int i = 0; methods != null && i < methods.length; ++i) {
                Map method = (Map)methods[i];
                this.updateRestPathOperationMap(restPathOperations, method, proxy, pageContext);
            }
        } else {
            HashMap<String, Map> allMethods = new HashMap<String, Map>();
            Map<String, Map> methods = this.getExtendedMethods(descriptor, allMethods);
            for (String methodName : methods.keySet()) {
                this.updateRestPathOperationMap(restPathOperations, methods.get(methodName), proxy, pageContext);
            }
        }
        Set resourcePathKeys = restPathOperations.keySet();
        for (Object resourcePathKey : resourcePathKeys) {
            List operations = (List)restPathOperations.get(resourcePathKey);
            if (resourcePathKey == null) {
                resourcePathKey = "";
            } else if (!((String)resourcePathKey).startsWith("/")) {
                resourcePathKey = "/" + (String)resourcePathKey;
            }
            Api api = apiDecleration.addApi((String)resourcePath + (String)resourcePathKey);
            for (Map method : operations) {
                if (!"remote".equalsIgnoreCase((String)method.get("access"))) continue;
                String description = (String)method.get("DESCRIPTION");
                api.setDescription(description);
                this.generateOperationLevelDoc(method, api, complexCFC, descriptor);
            }
            if (complexCFC.isEmpty()) continue;
            this.generateModels(apiDecleration, complexCFC, proxy, pageContext);
        }
        return apiDecleration;
    }

    private void generateOperationLevelDoc(Map method, Api api, Set<String> complexCFC, AttributeCollection descriptor) {
        String returnType;
        String hint;
        String httpMethod = (String)method.get("HTTPMETHOD");
        String comphttpMethod = (String)descriptor.get("HTTPMETHOD");
        if (this.isNullorEmpty(httpMethod)) {
            httpMethod = comphttpMethod;
        }
        String methodName = (String)method.get("NAME");
        Operation op = api.addOperation(methodName, this.getHttpMethod(httpMethod, methodName));
        String description = (String)method.get("DESCRIPTION");
        if (!this.isNullorEmpty(description)) {
            op.setSummary(description);
        }
        if (!this.isNullorEmpty(hint = (String)method.get("HINT"))) {
            op.setNotes(hint);
        }
        if (!this.isNullorEmpty(returnType = (String)method.get("RETURNTYPE")) && mappingsForCFCtoSwagger.get(returnType.toLowerCase()) != null) {
            op.setResponseClass(mappingsForCFCtoSwagger.get(returnType.toLowerCase()).toString());
            if (complexCFCmappings.contains(returnType.toLowerCase().trim())) {
                complexCFC.add(returnType.toLowerCase().trim());
            } else if (returnType.toLowerCase().equalsIgnoreCase("array")) {
                RefArrayType dataType = new RefArrayType("object");
                op.setDataType((DataType)dataType);
            } else if (returnType.toLowerCase().equalsIgnoreCase("binary")) {
                op.setResponseClass("array");
                PrimitiveArrayType dataType = new PrimitiveArrayType(PrimitiveType.get((PrimitiveType.Type)PrimitiveType.Type.STRING, (PrimitiveType.Format)PrimitiveType.Format.BYTE));
                op.setDataType((DataType)dataType);
            }
        } else if (SkeletonClassLoader.isCFCArray(returnType)) {
            int pos = returnType.indexOf("[]");
            returnType = returnType.substring(0, pos);
            RefArrayType dataType = new RefArrayType(returnType);
            op.setDataType((DataType)dataType);
            op.setResponseClass("array");
            complexCFC.add(returnType);
        } else {
            op.setResponseClass(returnType);
            complexCFC.add(returnType);
        }
        String responseMessages = (String)method.get("responseMessages");
        if (!this.isNullorEmpty(responseMessages)) {
            this.generateResponseMessage(responseMessages, op);
        }
        String compProduces = (String)descriptor.get("PRODUCES");
        String produces = (String)method.get("PRODUCES");
        if (this.isNullorEmpty(produces)) {
            produces = compProduces;
        }
        if (!this.isNullorEmpty(produces)) {
            String[] producesArray;
            for (String produce : producesArray = produces.split(",")) {
                op.addProduces(produce);
            }
        }
        String compConsumes = (String)descriptor.get("CONSUMES");
        String consumes = (String)method.get("CONSUMES");
        if (this.isNullorEmpty(consumes)) {
            consumes = compConsumes;
        }
        if (!this.isNullorEmpty(consumes)) {
            String[] consumesArray;
            for (String consume : consumesArray = consumes.split(",")) {
                op.addConsumes(consume);
            }
        }
        this.generateParameterLevelDoc(method, op, complexCFC);
    }

    private void generateParameterLevelDoc(Map method, Operation op, Set<String> complexCFC) {
        Object[] parameters = (Object[])method.get("parameters");
        for (int j = 0; parameters != null && j < parameters.length; ++j) {
            Map parameter = (Map)parameters[j];
            String name = (String)parameter.get("NAME");
            String paramType = (String)parameter.get("RESTARGSOURCE");
            Parameter param = op.addParameter(name, this.getParamType(paramType));
            String required = (String)parameter.get("REQUIRED");
            String description = (String)parameter.get("HINT");
            if (!this.isNullorEmpty(description)) {
                param.setDescription(description);
            }
            if (required != null && (required.equalsIgnoreCase("yes") || required.equalsIgnoreCase("true"))) {
                param.setRequired(true);
            } else {
                param.setRequired(false);
            }
            String type = (String)parameter.get("TYPE");
            if (!this.isNullorEmpty(type) && mappingsForCFCtoSwagger.get(type.toLowerCase()) != null) {
                param.setType(mappingsForCFCtoSwagger.get(type.toLowerCase()).toString());
                if (complexCFCmappings.contains(type.toLowerCase().trim())) {
                    complexCFC.add(type.toLowerCase().trim());
                    continue;
                }
                if (type.toLowerCase().equalsIgnoreCase("array")) {
                    RefArrayType dataType = new RefArrayType("object");
                    param.setDataType((DataType)dataType);
                    continue;
                }
                if (!type.toLowerCase().equalsIgnoreCase("binary")) continue;
                param.setType("array");
                PrimitiveArrayType dataType = new PrimitiveArrayType(PrimitiveType.get((PrimitiveType.Type)PrimitiveType.Type.STRING, (PrimitiveType.Format)PrimitiveType.Format.BYTE));
                param.setDataType((DataType)dataType);
                continue;
            }
            if (this.isNullorEmpty(type)) {
                param.setType("object");
                continue;
            }
            if (SkeletonClassLoader.isCFCArray(type)) {
                int pos = type.indexOf("[]");
                type = type.substring(0, pos);
                RefArrayType dataType = new RefArrayType(type);
                param.setDataType((DataType)dataType);
                param.setType("array");
                complexCFC.add(type);
                continue;
            }
            complexCFC.add(type);
            param.setType(type);
        }
    }

    private void generateResponseMessage(String responseMessages, Operation op) {
        String[] responses;
        for (String response : responses = responseMessages.split(",")) {
            String[] codeandMessage = response.split(":");
            if (codeandMessage == null || codeandMessage.length < 2 || this.isNullorEmpty(codeandMessage[0]) || this.isNullorEmpty(codeandMessage[1])) continue;
            try {
                int code = Integer.parseInt(codeandMessage[0]);
                ResponseMessage responseMessage = op.addResponseMessage(code, codeandMessage[1]);
                if (codeandMessage.length < 3) continue;
                responseMessage.setResponseModel(codeandMessage[2]);
            }
            catch (NumberFormatException exception) {
                LOGGER.info("response code format is not numeric ", exception);
            }
        }
    }

    private void generateModels(ApiDeclaration apiDecleration, Set<String> complexCFC, TemplateProxy proxy, NeoPageContext pageContext) {
        HashMap<String, Model> models = new HashMap<String, Model>();
        HashSet<String> cloneCFC = new HashSet<String>();
        cloneCFC.addAll(complexCFC);
        for (String ret_type : complexCFC) {
            if (!SkeletonClassLoader.isCFC(ret_type)) continue;
            this.createRecursiveModels(proxy, pageContext, models, ret_type, cloneCFC);
        }
        if (cloneCFC.contains("struct")) {
            models.put("struct", this.generateStructModel());
        }
        if (cloneCFC.contains("query")) {
            models.put("query", this.generateQueryModel());
        }
        for (String modelname : models.keySet()) {
            apiDecleration.addModel((Model)models.get(modelname));
        }
    }

    private Model generateStructModel() {
        ModelImpl model = new ModelImpl("struct", "Sample model for struct type");
        ArrayList<PropertyImpl> model_properties = new ArrayList<PropertyImpl>();
        model.setProperties(model_properties);
        PrimitiveType dataType = PrimitiveType.get((PrimitiveType.Type)PrimitiveType.Type.STRING, (PrimitiveType.Format)PrimitiveType.Format.UNDEFINED);
        PropertyImpl por1 = new PropertyImpl("Key1", (DataType)dataType, "Key1", true);
        por1.setDefaultValue((Object)"Value1");
        PropertyImpl por2 = new PropertyImpl("Key2", (DataType)dataType, "Key2", true);
        por2.setDefaultValue((Object)"Value2");
        model_properties.add(por1);
        model_properties.add(por2);
        return model;
    }

    private Model generateQueryModel() {
        ModelImpl model = new ModelImpl("query", "Sample model for query type");
        ArrayList<PropertyImpl> model_properties = new ArrayList<PropertyImpl>();
        model.setProperties(model_properties);
        PrimitiveArrayType dataType = new PrimitiveArrayType(PrimitiveType.get((PrimitiveType.Type)PrimitiveType.Type.STRING, (PrimitiveType.Format)PrimitiveType.Format.UNDEFINED));
        PropertyImpl por1 = new PropertyImpl("column", (DataType)dataType, "column", true);
        RefArrayType dataType2 = new RefArrayType("object");
        PropertyImpl por2 = new PropertyImpl("data", (DataType)dataType2, "data", true);
        model_properties.add(por1);
        model_properties.add(por2);
        return model;
    }

    private void createRecursiveModels(TemplateProxy proxy, NeoPageContext pageContext, Map<String, Model> models, String cfc_ret_type, Set<String> complexCFCs) {
        try {
            TemplateProxy tp = TemplateProxyFactory.resolveName(cfc_ret_type, proxy, pageContext);
            AttributeCollection metadata = (AttributeCollection)tp.getMetadata();
            tp.release();
            String hint = (String)metadata.get("HINT");
            String name = (String)metadata.get("NAME");
            ModelImpl model = new ModelImpl(cfc_ret_type, hint);
            ArrayList<PropertyImpl> model_properties = new ArrayList<PropertyImpl>();
            ArrayList<String> model_required_properties = new ArrayList<String>();
            model.setProperties(model_properties);
            model.setRequiredProperties(model_required_properties);
            HashMap<String, Map> propertyMap = new HashMap<String, Map>();
            this.recurseExtendingProperty(metadata, propertyMap);
            Object[] properties = propertyMap.values().toArray();
            for (int i = 0; properties != null && i < properties.length; ++i) {
                PropertyImpl por;
                DataType primePrimitiveType;
                String swaggerType;
                Map prop = (Map)properties[i];
                String prop_type = (String)prop.get("type");
                String prop_name = (String)prop.get("name");
                String prop_hint = (String)prop.get("hint");
                String prop_required = (String)prop.get("required");
                boolean propRequired = false;
                boolean isCFCComplexType = true;
                if (prop_required != null && prop_required.equalsIgnoreCase("true")) {
                    propRequired = true;
                }
                if (propRequired) {
                    model_required_properties.add(prop_name);
                }
                if (!this.isNullorEmpty(swaggerType = (String)mappingsForCFCtoSwagger.get(prop_type.toLowerCase())) && (primePrimitiveType = (DataType)swaggerToPrimitiveType.get(swaggerType)) != null && !this.isNullorEmpty(primePrimitiveType.toString())) {
                    por = new PropertyImpl(prop_name, primePrimitiveType, prop_hint, propRequired);
                    model_properties.add(por);
                    isCFCComplexType = false;
                }
                if (SkeletonClassLoader.isCFC(prop_type)) {
                    RefDataType dataType = new RefDataType(prop_type);
                    por = new PropertyImpl(prop_name, (DataType)dataType, prop_hint, propRequired);
                    model_properties.add(por);
                    isCFCComplexType = false;
                    if (!complexCFCs.contains(prop_type.toLowerCase())) {
                        complexCFCs.add(prop_type.toLowerCase());
                        this.createRecursiveModels(proxy, pageContext, models, prop_type, complexCFCs);
                    }
                }
                if (SkeletonClassLoader.isCFCArray(prop_type)) {
                    int pos = prop_type.indexOf("[]");
                    prop_type = prop_type.substring(0, pos);
                    RefArrayType dataType = new RefArrayType(prop_type);
                    PropertyImpl por2 = new PropertyImpl(prop_name, (DataType)dataType, prop_hint, propRequired);
                    model_properties.add(por2);
                    isCFCComplexType = false;
                    if (!complexCFCs.contains(prop_type.toLowerCase())) {
                        complexCFCs.add(prop_type.toLowerCase());
                        this.createRecursiveModels(proxy, pageContext, models, prop_type, complexCFCs);
                    }
                }
                if ("array".equalsIgnoreCase(prop_type)) {
                    RefArrayType dataType = new RefArrayType("object");
                    por = new PropertyImpl(prop_name, (DataType)dataType, prop_hint, propRequired);
                    model_properties.add(por);
                    isCFCComplexType = false;
                }
                if ("binary".equalsIgnoreCase(prop_type)) {
                    PrimitiveArrayType dataType = new PrimitiveArrayType(PrimitiveType.get((PrimitiveType.Type)PrimitiveType.Type.STRING, (PrimitiveType.Format)PrimitiveType.Format.BYTE));
                    por = new PropertyImpl(prop_name, (DataType)dataType, prop_hint, propRequired);
                    model_properties.add(por);
                    isCFCComplexType = false;
                }
                if ("any".equalsIgnoreCase(prop_type)) {
                    PrimitiveType dataType = PrimitiveType.OBJECT;
                    por = new PropertyImpl(prop_name, (DataType)dataType, prop_hint, propRequired);
                    model_properties.add(por);
                    isCFCComplexType = false;
                }
                if ("date".equalsIgnoreCase(prop_type)) {
                    PrimitiveType dataType = PrimitiveType.DATE_TIME;
                    por = new PropertyImpl(prop_name, (DataType)dataType, prop_hint, propRequired);
                    model_properties.add(por);
                    isCFCComplexType = false;
                }
                if ("void".equalsIgnoreCase(prop_type)) {
                    DataType dataType = PrimitiveType.VOID;
                    por = new PropertyImpl(prop_name, dataType, prop_hint, propRequired);
                    model_properties.add(por);
                    isCFCComplexType = false;
                }
                if (!isCFCComplexType) continue;
                RefDataType dataType = new RefDataType(prop_type);
                por = new PropertyImpl(prop_name, (DataType)dataType, prop_hint, propRequired);
                model_properties.add(por);
                if (complexCFCs.contains(prop_type.toLowerCase())) continue;
                complexCFCs.add(prop_type.toLowerCase());
            }
            models.put(model.getName(), (Model)model);
        }
        catch (Throwable e) {
            LOGGER.error(e);
        }
    }

    private void recurseExtendingProperty(AttributeCollection metadata, Map<String, Map> propertyMap) {
        Object[] properties = (Object[])metadata.get("properties");
        for (int i = 0; properties != null && i < properties.length; ++i) {
            Map prop = (Map)properties[i];
            String prop_name = (String)prop.get("name");
            if (propertyMap.keySet().contains(prop_name.toLowerCase())) continue;
            propertyMap.put(prop_name.toLowerCase(), prop);
        }
        if (this.isExtended(metadata)) {
            AttributeCollection base = (AttributeCollection)metadata.get("extends");
            this.recurseExtendingProperty(base, propertyMap);
        }
    }

    public void createResourceListing(ServletContext context, SwaggerFactory factory, AppNameRootPair appNameRootPair, List<ApiDeclaration> apiDeclerations) {
        if (apiDeclerations != null && !apiDeclerations.isEmpty()) {
            final ResourceListing rl = factory.createResourceListing(SwaggerVersion.V1_2);
            this.upDateDocInfo(appNameRootPair, rl);
            for (ApiDeclaration apiDecleration : apiDeclerations) {
                List list = rl.getApis();
                ResourceListingImpl.ResourceListingApiImpl resourceListingApiOld2 = null;
                for (ResourceListingImpl.ResourceListingApiImpl resourceListingApiOld2 : list) {
                    String oldresourcepath = resourceListingApiOld2.getPath();
                    if (!apiDecleration.getResourcePath().equals(oldresourcepath)) continue;
                    LOGGER.warn("Same 'restpath' named " + oldresourcepath + " is used in multiple CFCs. Swagger docs are not generated only for one of the resource and for the other resources with same restpath.");
                    break;
                }
                rl.addApi(apiDecleration, apiDecleration.getResourcePath());
            }
            try {
                final Utils.MapSwaggerStore mapStore = new Utils.MapSwaggerStore();
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            Swagger.createWriter((SwaggerFormat)SwaggerFormat.json).writeSwagger((SwaggerStore)mapStore, rl);
                            return null;
                        }
                    }, null, new FilePermission("<<ALL FILES>>", "read"));
                } else {
                    Swagger.createWriter((SwaggerFormat)SwaggerFormat.json).writeSwagger((SwaggerStore)mapStore, rl);
                }
                Map fileMap = mapStore.getFileMap();
                this.putResourceListingInContext(context, appNameRootPair, fileMap);
            }
            catch (IOException e) {
                LOGGER.error("Error while writing the swagger object as JSON", e);
            }
            catch (PrivilegedActionException e) {
                LOGGER.error("Error while writing the swagger object as JSON", e.getException() != null ? e.getException() : e);
            }
        }
    }

    private synchronized void putResourceListingInContext(ServletContext context, AppNameRootPair pair, Map value) {
        ConcurrentHashMap<String, Map> restServicesMap;
        String appName = null;
        String appNameWithHost = null;
        appName = pair.isDefaultApplication() ? "DefaultApplication" : pair.getAppName();
        String host = pair.getHost();
        if (host != null && host.length() > 0) {
            appNameWithHost = pair.isDefaultApplication() ? "http://" + pair.getHost() : "http://" + pair.getHost() + "/" + pair.getAppName();
        }
        if ((restServicesMap = (ConcurrentHashMap<String, Map>)context.getAttribute("cfrestservices")) == null) {
            restServicesMap = new ConcurrentHashMap<String, Map>();
        }
        restServicesMap.put(appName, value);
        if (appNameWithHost != null) {
            HashMap<String, CallSite> mapWithHostURL = new HashMap<String, CallSite>();
            mapWithHostURL.put("basePath", (CallSite)((Object)appNameWithHost));
            restServicesMap.put(appName + "_hostinurl", mapWithHostURL);
        } else {
            restServicesMap.remove(appName + "_hostinurl");
        }
        context.setAttribute("cfrestservices", restServicesMap);
    }

    private void upDateDocInfo(AppNameRootPair appNameRootPair, ResourceListing rl) {
        Map restDocInfo = appNameRootPair.getRestDocInfo();
        if (restDocInfo != null) {
            if (!this.isNullorEmpty((String)restDocInfo.get("apiVersion"))) {
                rl.setApiVersion((String)restDocInfo.get("apiVersion"));
            }
            if (!this.isNullorEmpty((String)restDocInfo.get("description"))) {
                rl.getInfo().setDescription((String)restDocInfo.get("description"));
            }
            if (!this.isNullorEmpty((String)restDocInfo.get("title"))) {
                rl.getInfo().setTitle((String)restDocInfo.get("title"));
            }
            if (!this.isNullorEmpty((String)restDocInfo.get("license"))) {
                rl.getInfo().setLicense((String)restDocInfo.get("license"));
            }
            if (!this.isNullorEmpty((String)restDocInfo.get("licenseUrl"))) {
                rl.getInfo().setLicenseUrl((String)restDocInfo.get("licenseUrl"));
            }
            if (!this.isNullorEmpty((String)restDocInfo.get("termOfServiceUrl"))) {
                rl.getInfo().setTermsOfServiceUrl((String)restDocInfo.get("termOfServiceUrl"));
            }
            if (!this.isNullorEmpty((String)restDocInfo.get("contact"))) {
                rl.getInfo().setContact((String)restDocInfo.get("contact"));
            }
        }
    }

    private URL formURL(AppNameRootPair appNameRootPair) throws MalformedURLException {
        String[] hostport;
        URL url = null;
        String host = appNameRootPair.getHost();
        String hostname = null;
        int portnumber = -1;
        boolean isSytemGenHost = false;
        if (host != null && !host.isEmpty() && (hostport = host.split(":")).length >= 2) {
            hostname = hostport[0];
            String port = hostport[1];
            try {
                portnumber = Integer.parseInt(port);
            }
            catch (Exception e) {
                LOGGER.error("Invalid port number specified", e);
            }
        }
        if (hostname == null || hostname.trim().isEmpty()) {
            try {
                hostname = CFSwaggerApiCreator.getIpAddress();
                isSytemGenHost = true;
            }
            catch (SocketException e) {
                LOGGER.error("Error finding network interfaces while forming URL", e);
            }
            if (hostname == null || hostname.trim().isEmpty()) {
                hostname = defaultHost;
                isSytemGenHost = true;
            }
        }
        try {
            url = portnumber != -1 ? new URL("Http", hostname, portnumber, "") : (isSytemGenHost ? new URL("Http", hostname, dfeaultPort, "") : new URL("Http", hostname, ""));
        }
        catch (MalformedURLException e) {
            LOGGER.error("Error while forming URL ", e);
        }
        return url;
    }

    public static String getIpAddress() throws SocketException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface netface = e.nextElement();
            Enumeration<InetAddress> addresses = netface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress ip = addresses.nextElement();
                if (ip.isLoopbackAddress() || !CFSwaggerApiCreator.isIP(ip.getHostAddress())) continue;
                String fqdn = ip.getCanonicalHostName();
                if (fqdn != null && !fqdn.isEmpty()) {
                    return fqdn;
                }
                return ip.getHostAddress();
            }
        }
        return defaultHost;
    }

    private static boolean isIP(String hostAddress) {
        return hostAddress.split("[.]").length == 4;
    }

    private boolean isNullorEmpty(String data) {
        return data == null || data.isEmpty();
    }

    private Parameter.ParamType getParamType(String paramType) {
        String typeParam = "body";
        if (paramType != null && !paramType.isEmpty()) {
            typeParam = paramType.toLowerCase().trim();
        }
        Parameter.ParamType param = Parameter.ParamType.body;
        switch (typeParam) {
            case "body": {
                param = Parameter.ParamType.body;
                break;
            }
            case "path": {
                param = Parameter.ParamType.path;
                break;
            }
            case "query": {
                param = Parameter.ParamType.query;
                break;
            }
            case "header": {
                param = Parameter.ParamType.header;
                break;
            }
            case "form": {
                param = Parameter.ParamType.form;
                break;
            }
            default: {
                param = Parameter.ParamType.body;
            }
        }
        return param;
    }

    private Operation.Method getHttpMethod(String httpMethod, String methodName) {
        String methodhttp = "get";
        if (httpMethod != null && !httpMethod.isEmpty()) {
            methodhttp = httpMethod.toLowerCase().trim();
        } else if (this.isMethodNameHttpVerb(methodName)) {
            methodhttp = methodName.toLowerCase();
        }
        Operation.Method method = Operation.Method.GET;
        switch (methodhttp) {
            case "get": {
                method = Operation.Method.GET;
                break;
            }
            case "delete": {
                method = Operation.Method.DELETE;
                break;
            }
            case "head": {
                method = Operation.Method.HEAD;
                break;
            }
            case "post": {
                method = Operation.Method.POST;
                break;
            }
            case "put": {
                method = Operation.Method.PUT;
                break;
            }
            case "options": {
                method = Operation.Method.OPTIONS;
                break;
            }
            case "patch": {
                method = Operation.Method.PATCH;
                break;
            }
            default: {
                method = Operation.Method.GET;
            }
        }
        return method;
    }

    private void updateRestPathOperationMap(Map<String, List<Map>> restPathOperations, Map method, TemplateProxy proxy, NeoPageContext pageContext) {
        AttributeCollection descriptor = (AttributeCollection)proxy.getMetadata();
        String comphttpMethod = (String)descriptor.get("HTTPMETHOD");
        String methodName = (String)method.get("NAME");
        boolean isMethodNameHttpVerb = this.isMethodNameHttpVerb(methodName);
        if ("remote".equalsIgnoreCase((String)method.get("access")) && (method.get("httpmethod") != null || !this.isNullorEmpty(comphttpMethod) || isMethodNameHttpVerb)) {
            String restPath = (String)method.get("RESTPATH");
            this.modifyRestPathMap(restPathOperations, method, restPath);
        } else if (method.get("RESTPATH") != null && this.isNullorEmpty(comphttpMethod)) {
            String retType = (String)method.get("returntype");
            String restPath = (String)method.get("RESTPATH");
            if (SkeletonClassLoader.isCFC(retType)) {
                this.updateRestPathMapForSubresource(restPath, retType, restPathOperations, proxy, pageContext);
            }
        }
    }

    private boolean isMethodNameHttpVerb(String methodName) {
        boolean isMethodNameHttpVerb = false;
        if (httpMethods.stream().anyMatch(x -> x.equalsIgnoreCase(methodName))) {
            isMethodNameHttpVerb = true;
        }
        return isMethodNameHttpVerb;
    }

    private void updateRestPathMapForSubresource(String parentRestPath, String ret_type, Map<String, List<Map>> restPathOperations, TemplateProxy proxy, NeoPageContext pageContext) {
        try {
            TemplateProxy tp = TemplateProxyFactory.resolveName(ret_type, proxy, pageContext);
            AttributeCollection metadata = (AttributeCollection)tp.getMetadata();
            tp.release();
            Object[] methods = (Object[])metadata.get("functions");
            for (int i = 0; methods != null && i < methods.length; ++i) {
                String retType;
                Map method = (Map)methods[i];
                if ("remote".equalsIgnoreCase((String)method.get("access")) && method.get("httpmethod") != null) {
                    String restPath = (String)method.get("RESTPATH");
                    if (!this.isNullorEmpty(restPath)) {
                        this.modifyRestPathMap(restPathOperations, method, parentRestPath + "/" + restPath);
                        continue;
                    }
                    this.modifyRestPathMap(restPathOperations, method, parentRestPath);
                    continue;
                }
                if (method.get("RESTPATH") == null || !SkeletonClassLoader.isCFC(retType = (String)method.get("returntype")) || ret_type.equals(retType)) continue;
                String restPath = (String)method.get("RESTPATH");
                this.updateRestPathMapForSubresource(parentRestPath + "/" + restPath, retType, restPathOperations, proxy, pageContext);
            }
        }
        catch (Throwable e) {
            LOGGER.error(e);
        }
    }

    private void modifyRestPathMap(Map<String, List<Map>> restPathOperations, Map method, String restPath) {
        List<Map> operations = restPathOperations.get(restPath);
        if (operations != null && !operations.isEmpty()) {
            operations.add(method);
        } else {
            ArrayList<Map> operation = new ArrayList<Map>();
            operation.add(method);
            restPathOperations.put(restPath, operation);
        }
    }

    private Map<String, Map> getExtendedMethods(AttributeCollection extending, Map<String, Map> allMethods) {
        Object[] methods = (Object[])extending.get("functions");
        for (int i = 0; i < methods.length; ++i) {
            Map inheritedMethod = (Map)methods[i];
            boolean allmethodsContains = allMethods.keySet().contains((String)inheritedMethod.get("NAME"));
            if (allmethodsContains) continue;
            if (inheritedMethod.containsKey("httpMethod") || inheritedMethod.containsKey("produces") || inheritedMethod.containsKey("consumes") || inheritedMethod.containsKey("restPath")) {
                allMethods.put((String)inheritedMethod.get("NAME"), inheritedMethod);
                continue;
            }
            Object[] parameters = (Object[])inheritedMethod.get("parameters");
            for (int j = 0; parameters != null && j < parameters.length; ++j) {
                Map parameter = (Map)parameters[j];
                if (!parameter.containsKey("restargsource") && !parameter.containsKey("restargname")) continue;
                allMethods.put((String)inheritedMethod.get("NAME"), inheritedMethod);
            }
        }
        if (this.isExtended(extending)) {
            AttributeCollection base = (AttributeCollection)extending.get("extends");
            this.getExtendedMethods(base, allMethods);
        }
        return allMethods;
    }

    private boolean isExtended(AttributeCollection extending) {
        String baseClass;
        AttributeCollection base = (AttributeCollection)extending.get("extends");
        this.isExtending = base != null ? !"WEB-INF.cftags.component".equals(baseClass = (String)base.get("name")) : false;
        return this.isExtending;
    }

    static {
        mappingsForCFCtoSwagger.put("string", (Object)"string");
        mappingsForCFCtoSwagger.put("uuid", (Object)"string");
        mappingsForCFCtoSwagger.put("guid", (Object)"string");
        mappingsForCFCtoSwagger.put("query", (Object)"query");
        mappingsForCFCtoSwagger.put("documentquery", (Object)"coldfusion.xml.rpc.DocumentQueryBean");
        mappingsForCFCtoSwagger.put("void", (Object)"void");
        mappingsForCFCtoSwagger.put("numeric", (Object)"number");
        mappingsForCFCtoSwagger.put("boolean", (Object)"boolean");
        mappingsForCFCtoSwagger.put("date", (Object)"string");
        mappingsForCFCtoSwagger.put("any", (Object)"Object");
        mappingsForCFCtoSwagger.put("array", (Object)"array");
        mappingsForCFCtoSwagger.put("binary", (Object)"byte[]");
        mappingsForCFCtoSwagger.put("struct", (Object)"struct");
        mappingsForCFCtoSwagger.put("xml", (Object)"string");
        complexCFCmappings = new HashSet<String>();
        complexCFCmappings.add("query");
        complexCFCmappings.add("struct");
        swaggerToPrimitiveType = new FastHashtable();
        swaggerToPrimitiveType.put("string", (Object)PrimitiveType.STRING);
        swaggerToPrimitiveType.put("date", (Object)PrimitiveType.DATE);
        swaggerToPrimitiveType.put("boolean", (Object)PrimitiveType.BOOLEAN);
        swaggerToPrimitiveType.put("number", (Object)PrimitiveType.DOUBLE);
        httpMethods = new HashSet<String>();
        httpMethods.add("GET");
        httpMethods.add("PUT");
        httpMethods.add("POST");
        httpMethods.add("DELETE");
        httpMethods.add("OPTIONS");
        httpMethods.add("HEAD");
        httpMethods.add("PATCH");
    }
}

