/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.Cast;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.java.DynamicClassLoader;
import coldfusion.runtime.java.JavaDynamicClassLoader;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.FileUtils;
import coldfusion.util.ExtensionFilter;
import coldfusion.util.IOUtils;
import coldfusion.watch.Watcher;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class AppClassLoaderHelper
implements Watcher.Listener {
    public static final String JAVASETTING = "javasettings";
    public static final String LOADPATHS = "loadPaths";
    public static final String LOADCOLDFUSIONCLASSPATH = "loadColdFusionClassPath";
    public static final String RELOADONCHANGE = "reloadOnChange";
    public static final String APPCLASSES = "appClasses";
    private static final String WATCHINTERVAL = "watchInterval";
    private static final String WATCHEXTENSIONS = "watchExtensions";
    private static final int SIXTY_SECONDS = 60;
    private static File cacheDir = new File(ServiceFactory.getRuntimeService().getTempCacheDirectory());
    private static String cacheDirAbsPath = cacheDir.getAbsolutePath();
    private Map<String, Object> javaSetting;
    private DynamicClassLoader applicationClassLoader;
    private Watcher watcher;
    private boolean reloadOnChange = false;
    private boolean loadColdFusionClassPath = true;
    private long watchInterval = 60L;
    private List<String> loadPaths;
    private ConcurrentHashMap<String, SoftReference<DynamicClassLoader>> variableCLs;
    private String applicationCFCPath;
    private boolean appDirectoryCreated = false;
    private String watchedExtensions = "class,jar";
    private String appDirectory;
    private Map<File, File> jarMap;
    private Map<File, File> destJarMap;
    private volatile boolean refreshing = false;
    private Object lockObject = new Object();

    public boolean isRefreshing() {
        return this.refreshing;
    }

    public Object getLockObject() {
        return this.lockObject;
    }

    public DynamicClassLoader getApplicationClassLoader() {
        return this.applicationClassLoader;
    }

    public void init(Map<String, Object> aJavaSetting, String applicationPath) {
        if (aJavaSetting != null) {
            Object strReloadOnChange;
            Object interval;
            this.javaSetting = aJavaSetting;
            this.applicationCFCPath = applicationPath;
            if (this.javaSetting.get(LOADPATHS) == null || this.javaSetting.get(LOADPATHS).equals("")) {
                throw new LoadPathsRequiredException();
            }
            this.loadPaths = (List)this.javaSetting.get(LOADPATHS);
            if (this.loadPaths == null || this.loadPaths.size() == 0) {
                throw new LoadPathsRequiredException();
            }
            this.resolvePaths(this.loadPaths);
            Object strLoadColdFusionClassPath = this.javaSetting.get(LOADCOLDFUSIONCLASSPATH);
            if (strLoadColdFusionClassPath != null && !strLoadColdFusionClassPath.equals("")) {
                this.loadColdFusionClassPath = Cast._boolean(strLoadColdFusionClassPath);
            }
            this.createClassLoader();
            String strWatchedExtensions = (String)this.javaSetting.get(WATCHEXTENSIONS);
            if (strWatchedExtensions != null && !strWatchedExtensions.trim().equals("")) {
                this.watchedExtensions = strWatchedExtensions;
            }
            if ((interval = this.javaSetting.get(WATCHINTERVAL)) != null && !interval.equals("")) {
                try {
                    this.watchInterval = Cast._long(interval);
                    if (this.watchInterval <= 0L) {
                        throw new InvalidNumericValueException(WATCHINTERVAL, interval);
                    }
                }
                catch (Cast.NumberConversionException e) {
                    throw new InvalidNumericValueException(WATCHINTERVAL, interval);
                }
            }
            if ((strReloadOnChange = this.javaSetting.get(RELOADONCHANGE)) != null && !strReloadOnChange.equals("")) {
                this.reloadOnChange = Cast._boolean(strReloadOnChange);
            }
            if (this.reloadOnChange) {
                this.handleDynamicLoading();
            } else {
                this.handleStaticLoading();
            }
        }
    }

    public ClassLoader getClassLoader(List<String> paths) {
        return Objects.nonNull(paths) && paths.size() > 0 ? this.getCustomClassLoader(paths) : this.getApplicationClassLoader();
    }

    private DynamicClassLoader getCustomClassLoader(List<String> paths) {
        SoftReference<DynamicClassLoader> dclRef;
        DynamicClassLoader classLoader;
        this.resolvePaths(paths);
        String key = this.hash(paths);
        if (Objects.isNull(this.variableCLs)) {
            this.variableCLs = new ConcurrentHashMap();
        }
        DynamicClassLoader dynamicClassLoader = classLoader = Objects.nonNull(dclRef = this.variableCLs.get(key)) ? dclRef.get() : null;
        if (Objects.isNull(classLoader)) {
            classLoader = this.createCustomClassLoader(paths);
            this.variableCLs.put(key, new SoftReference<DynamicClassLoader>(classLoader));
        }
        return classLoader;
    }

    private void resolvePaths(List<String> paths) {
        for (int i = 0; i < paths.size(); ++i) {
            String realPath;
            File realFile;
            File appCFC;
            File f;
            String userPath = paths.get(i);
            String path = userPath.replace("\\", "/");
            if (this.applicationCFCPath != null && (f = new File((appCFC = new File(this.applicationCFCPath)).getParentFile().getAbsolutePath(), path)).exists()) {
                paths.set(i, f.getAbsolutePath());
                continue;
            }
            if (path.startsWith("/") && (realFile = new File(realPath = FusionContext.getCurrent().getRealPath(path))).exists()) {
                paths.set(i, realFile.getAbsolutePath());
                continue;
            }
            File pathFile = new File(path);
            if (pathFile.exists() && pathFile.isAbsolute()) {
                paths.set(i, pathFile.getAbsolutePath());
                continue;
            }
            throw new LoadPathNotFoundException(userPath);
        }
    }

    private ClassLoader getColdFusionParentCL() {
        return this.loadColdFusionClassPath ? this.getClass().getClassLoader() : this.getClass().getClassLoader().getParent();
    }

    private DynamicClassLoader createCustomClassLoader(List<String> paths) {
        ClassLoader parentCL = Objects.nonNull(this.applicationClassLoader) ? this.applicationClassLoader : this.getColdFusionParentCL();
        JavaDynamicClassLoader classLoader = new JavaDynamicClassLoader(parentCL, true, false, this);
        this.handleStaticLoading(paths, classLoader);
        return classLoader;
    }

    private void createClassLoader() {
        this.applicationClassLoader = new JavaDynamicClassLoader(this.getColdFusionParentCL(), false, false, this);
    }

    private void handleDynamicLoading() {
        this.jarMap = new HashMap<File, File>();
        this.destJarMap = new HashMap<File, File>();
        if (this.watcher == null) {
            this.watcher = new Watcher(this.watchInterval);
            this.watcher.addListener(this);
            this.watcher.setExtensions(this.watchedExtensions);
            this.watcher.setRecursive(true);
            this.watcher.setWatchForRecentChange(false);
        }
        this.createAppDirectory();
        for (final String fileName : this.loadPaths) {
            File f = new File(fileName);
            final File tmpFile = new File(fileName);
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (fileName.endsWith(".jar")) {
                if (this.jarMap.get(f) == null) {
                    final File sourceFile = f;
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            File destFile = new File(AppClassLoaderHelper.this.appDirectory, tmpFile.getPath());
                            if (!destFile.exists()) {
                                FileUtils.copy(fileName, AppClassLoaderHelper.this.appDirectory);
                            } else if (destFile.exists() && sourceFile.lastModified() != destFile.lastModified()) {
                                IOUtils.delete(destFile);
                                FileUtils.copy(fileName, AppClassLoaderHelper.this.appDirectory);
                            }
                            return null;
                        }
                    });
                }
                File destJarFile = new File(this.appDirectory + File.separator + f.getName());
                this.jarMap.put(f, destJarFile);
                try {
                    destJarFile = destJarFile.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.destJarMap.put(destJarFile, f);
                this.applicationClassLoader.addToClasspath(destJarFile);
                if (!this.refreshing) {
                    this.watcher.addWatchedDirectory(f.getParentFile().getAbsolutePath());
                }
            }
            if (!f.isDirectory()) continue;
            if (!f.canRead()) {
                throw new FileUtils.CannotReadDirectoryException(f.getPath());
            }
            this.applicationClassLoader.addToClasspath(f);
            if (!this.refreshing) {
                this.watcher.addWatchedDirectory(f.getParentFile().getAbsolutePath());
            }
            ExtensionFilter fileFilter = new ExtensionFilter("*.jar");
            File[] jarFiles = f.listFiles(fileFilter);
            for (int j = 0; j < jarFiles.length; ++j) {
                if (this.jarMap.get(jarFiles[j]) == null) {
                    FileUtils.copy(jarFiles[j].getAbsolutePath(), this.appDirectory);
                }
                File destJarFile = new File(this.appDirectory + File.separator + jarFiles[j].getName());
                try {
                    destJarFile = destJarFile.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.jarMap.put(jarFiles[j], destJarFile);
                this.destJarMap.put(destJarFile, f);
                this.applicationClassLoader.addToClasspath(destJarFile);
            }
        }
        this.deleteUnusedJars(this.destJarMap);
        try {
            this.watcher.start();
        }
        catch (ServiceException e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    private void deleteUnusedJars(Map destMap) {
        ExtensionFilter fileFilter = new ExtensionFilter("*.jar");
        File appDirectoryFile = new File(this.appDirectory);
        File[] jarFiles = appDirectoryFile.listFiles(fileFilter);
        for (int j = 0; j < jarFiles.length; ++j) {
            try {
                if (destMap.containsKey(jarFiles[j].getCanonicalFile())) continue;
                IOUtils.delete(jarFiles[j]);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return null;
            }
        });
    }

    private void createAppDirectory() {
        if (!this.appDirectoryCreated) {
            this.appDirectory = cacheDirAbsPath + File.separator + APPCLASSES + File.separator + this.applicationCFCPath.hashCode();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    File appDirectoryFile = new File(AppClassLoaderHelper.this.appDirectory);
                    if (!appDirectoryFile.exists()) {
                        FileUtils.createDirectory(AppClassLoaderHelper.this.appDirectory);
                    }
                    return null;
                }
            });
            this.appDirectoryCreated = true;
        }
    }

    private void handleStaticLoading() {
        this.handleStaticLoading(this.loadPaths, this.applicationClassLoader);
    }

    private void handleStaticLoading(List<String> paths, DynamicClassLoader classLoader) {
        for (String fileName : paths) {
            File f = new File(fileName);
            classLoader.addToClasspath(f);
            if (!f.isDirectory()) continue;
            if (!f.canRead()) {
                throw new FileUtils.CannotReadDirectoryException(f.getPath());
            }
            ExtensionFilter fileFilter = new ExtensionFilter("*.jar");
            File[] jarFiles = f.listFiles(fileFilter);
            for (int j = 0; j < jarFiles.length; ++j) {
                classLoader.addToClasspath(jarFiles[j]);
            }
        }
    }

    public void checkPermission(File destFile) {
        if (System.getSecurityManager() != null) {
            File f = null;
            f = this.reloadOnChange ? this.destJarMap.get(destFile) : destFile;
            if (f != null) {
                try {
                    AccessController.checkPermission(new FilePermission(f.getCanonicalPath(), "read"));
                }
                catch (IOException e) {
                    AccessController.checkPermission(new FilePermission(f.getAbsolutePath(), "read"));
                }
            }
        }
    }

    public void release() {
        if (this.watcher != null) {
            try {
                this.watcher.stop();
            }
            catch (ServiceException e) {
                CFLogs.SERVER_LOG.error(e);
            }
        }
        if (this.applicationClassLoader != null) {
            this.applicationClassLoader.release();
        }
        this.applicationClassLoader = null;
        this.watcher = null;
        this.reloadOnChange = false;
        this.loadColdFusionClassPath = true;
        this.loadPaths = null;
        this.applicationCFCPath = null;
        this.appDirectoryCreated = false;
        this.appDirectory = null;
        this.jarMap = null;
        this.destJarMap = null;
        this.refreshing = false;
    }

    public void reset() {
        if (this.watcher != null) {
            try {
                this.watcher.stop();
            }
            catch (ServiceException e) {
                CFLogs.SERVER_LOG.error(e);
            }
        }
        if (this.applicationClassLoader != null) {
            this.applicationClassLoader.release();
        }
        this.applicationClassLoader = null;
        this.jarMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filesModified(List l) {
        boolean refreshRequired = false;
        ArrayList<File> jarFilesToCopy = new ArrayList<File>();
        if (this.applicationCFCPath == null) {
            return;
        }
        for (File file : l) {
            if (file.getName().endsWith(".jar")) {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!this.jarMap.containsKey(file)) continue;
                refreshRequired = true;
                jarFilesToCopy.add(file);
                continue;
            }
            refreshRequired = true;
        }
        if (refreshRequired) {
            Object object = this.lockObject;
            synchronized (object) {
                try {
                    this.reset();
                    this.refreshing = true;
                    for (final File jar : jarFilesToCopy) {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                FileUtils.copy(jar.getAbsolutePath(), AppClassLoaderHelper.this.appDirectory);
                                return null;
                            }
                        });
                    }
                    this.createClassLoader();
                    this.handleDynamicLoading();
                }
                finally {
                    this.refreshing = false;
                    this.lockObject.notifyAll();
                }
            }
        }
    }

    @Override
    public boolean isInterested(File modifiedFile) {
        String[] extensions;
        for (String extension : extensions = this.watcher.getExtensions()) {
            if (!modifiedFile.getName().endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private String hash(List<String> aList) {
        return aList.stream().sorted().collect(Collectors.toList()).toString();
    }

    public class LoadPathsRequiredException
    extends NeoException {
        LoadPathsRequiredException() {
        }
    }

    class InvalidNumericValueException
    extends NeoException {
        public String property;
        public Object value;

        InvalidNumericValueException(String property, Object value) {
            this.property = property;
            this.value = value;
        }
    }

    public class LoadPathNotFoundException
    extends NeoException {
        public String path;

        LoadPathNotFoundException(String path) {
            this.path = path;
        }
    }
}

