/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.cfc.CFCProxy;
import coldfusion.cfc.CFCProxyFilter;
import coldfusion.filter.ExceptionFilter;
import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.log.CFLogs;
import coldfusion.runtime.AbortException;
import coldfusion.runtime.AppHelper;
import coldfusion.runtime.Cast;
import coldfusion.runtime.EventHandlerException;
import coldfusion.runtime.Struct;
import coldfusion.runtime.UDFMethod;
import coldfusion.util.FastHashtable;
import coldfusion.util.RuntimeWrapper;
import jakarta.servlet.jsp.PageContext;
import java.util.Map;

public class AppEventInvoker
extends CFCProxy {
    private String mAppName = null;
    private static String ONAPPSTART = "onApplicationStart";

    static Map getAppThisDefaults() {
        FastHashtable table = new FastHashtable(10);
        table.put("applicationtimeout", (Object)new Integer(AppHelper.getDefaultApplicationTimeout()));
        table.put("sessionmanagement", (Object)false);
        table.put("sessiontimeout", (Object)new Integer(AppHelper.getDefaultSessionTimeout()));
        table.put("setdomaincookies", (Object)false);
        table.put("clientmanagement", (Object)false);
        table.put("clientstorage", (Object)AppHelper.getDefaultClientStorage());
        table.put("setclientcookies", (Object)true);
        table.put("loginstorage", (Object)"cookie");
        table.put("scriptprotect", (Object)AppHelper.getScriptProtectList());
        table.put("SESSIONCOOKIE", (Object)new Struct());
        table.put("AUTHCOOKIE", (Object)new Struct());
        return table;
    }

    public AppEventInvoker(String path) throws Throwable {
        this(path, false);
    }

    public AppEventInvoker(String path, boolean directInvoke) throws Throwable {
        super(path, AppEventInvoker.getAppThisDefaults(), directInvoke);
        this.setApplicationExecution(false);
    }

    @Override
    protected String getApplicationName() {
        if (this.mAppName != null) {
            return this.mAppName;
        }
        return super.getApplicationName();
    }

    public void setmAppName(String mAppName) {
        this.mAppName = mAppName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invoke(String method, Object[] args, FusionContext fContext) throws Throwable {
        if (!this.isInvocationRequired(fContext, method)) {
            return true;
        }
        boolean rc = false;
        boolean isRemoting = fContext.setIsRemoting(false);
        try {
            if (this.isMethodPresent(method)) {
                Object retval = this.template.invoke(method, args, (PageContext)fContext.pageContext);
                try {
                    rc = Cast._boolean(retval == null ? Boolean.TRUE : retval);
                }
                catch (Cast.BooleanConversionException e) {
                    CFLogs.APPLICATION_LOG.warn("Error processing the return value from " + method + ": " + e.getMessage(), e);
                    rc = true;
                }
            } else {
                rc = true;
            }
        }
        finally {
            fContext.setIsRemoting(isRemoting);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeWithReturn(String method, Object[] args, FusionContext fContext) throws Throwable {
        Object retval = null;
        boolean isRemoting = fContext.setIsRemoting(false);
        try {
            if (this.isMethodPresent(method)) {
                retval = this.template.invoke(method, args, (PageContext)fContext.pageContext);
            }
        }
        finally {
            fContext.setIsRemoting(isRemoting);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeMissingTemplate(String method, Object[] args, FusionContext fContext) throws Throwable {
        boolean rc = false;
        boolean isRemoting = fContext.setIsRemoting(false);
        try {
            if (this.isMethodPresent(method)) {
                Object retval = this.template.invoke(method, args, (PageContext)fContext.pageContext);
                try {
                    rc = Cast._boolean(retval == null ? Boolean.TRUE : retval);
                }
                catch (Cast.BooleanConversionException e) {
                    CFLogs.APPLICATION_LOG.warn("Error processing the return value from " + method + ": " + e.getMessage(), e);
                    rc = true;
                }
            } else {
                rc = false;
            }
        }
        finally {
            fContext.setIsRemoting(isRemoting);
        }
        return rc;
    }

    public boolean isMethodPresent(String name) {
        UDFMethod m = super.getMethod(name);
        return m != null;
    }

    public boolean onApplicationStart(Object[] args, FusionContext fContext) throws Throwable {
        boolean rc;
        try {
            rc = this.invoke(ONAPPSTART, args, fContext);
        }
        catch (AbortException a) {
            throw a;
        }
        catch (Throwable e) {
            throw new EventHandlerException(e, ONAPPSTART);
        }
        return rc;
    }

    public void onApplicationEnd(Object[] args) throws Throwable {
        try {
            if (this.isMethodPresent("onApplicationEnd")) {
                this.invoke("onApplicationEnd", args, null, null, null, this);
            }
        }
        catch (AbortException a) {
            throw a;
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error(new ExceptionFilter.ApplicationExceptionWrapper(e, FusionContext.getCurrent().getPagePath()));
            throw new EventHandlerException(e, "onApplicationEnd");
        }
    }

    public boolean onRequestStart(Object[] args, FusionContext fContext) throws Throwable {
        boolean rc;
        try {
            rc = this.invoke("onRequestStart", args, fContext);
        }
        catch (AbortException a) {
            throw a;
        }
        catch (Throwable e) {
            throw new EventHandlerException(e, "onRequestStart");
        }
        return rc;
    }

    public void onRequest(Object[] args, FusionContext fContext) throws Throwable {
        try {
            this.invoke("onRequest", args, fContext);
        }
        catch (AbortException a) {
            throw a;
        }
        catch (Throwable e) {
            if (e instanceof RuntimeWrapper && ((RuntimeWrapper)e).getRootCause() != null && ((RuntimeWrapper)e).getRootCause() instanceof AbortException) {
                throw ((RuntimeWrapper)e).getRootCause();
            }
            throw new EventHandlerException(e, "onRequest");
        }
    }

    public Object OnCfcRequest(Object[] args, FusionContext fContext) throws Throwable {
        Object result = null;
        try {
            result = this.invokeWithReturn("OnCfcRequest", args, fContext);
        }
        catch (AbortException a) {
            throw a;
        }
        catch (Throwable e) {
            throw new EventHandlerException(e, "OnCfcRequest");
        }
        return result;
    }

    public Object OnRESTRequest(Object[] args, FusionContext fContext) throws Throwable {
        Object result = null;
        try {
            result = this.invokeWithReturn("OnRESTRequest", args, fContext);
        }
        catch (AbortException a) {
            throw a;
        }
        catch (Throwable e) {
            throw new EventHandlerException(e, "OnRESTRequest");
        }
        return result;
    }

    public void onRequestEnd(Object[] args, FusionContext fContext) throws Throwable {
        try {
            this.invoke("onRequestEnd", args, fContext);
        }
        catch (AbortException a) {
            throw a;
        }
        catch (Throwable e) {
            throw new EventHandlerException(e, "onRequestEnd");
        }
    }

    public boolean onWebsocketAuthenticate(Object[] args, FusionContext fContext) throws Throwable {
        try {
            return this.invoke("onWSAuthenticate", args, fContext);
        }
        catch (Exception a) {
            throw a;
        }
        catch (Throwable e) {
            throw new EventHandlerException(e, "onWSAuthenticate");
        }
    }

    public void onAbort(Object[] args, FusionContext fContext) throws Throwable {
        try {
            this.invoke("onAbort", args, fContext);
        }
        catch (AbortException a) {
            throw a;
        }
        catch (Throwable e) {
            throw new EventHandlerException(e, "onAbort");
        }
    }

    public boolean onMissingTemplate(Object[] args, FusionContext fContext) throws Throwable {
        boolean rc;
        try {
            rc = this.invokeMissingTemplate("onMissingTemplate", args, fContext);
        }
        catch (AbortException a) {
            throw a;
        }
        catch (Throwable e) {
            throw new EventHandlerException(e, "onMissingTemplate");
        }
        return rc;
    }

    public void onSessionStart(Object[] args, FusionContext fContext) throws Throwable {
        try {
            this.invoke("onSessionStart", args, fContext);
        }
        catch (AbortException a) {
            throw a;
        }
        catch (Throwable e) {
            throw new EventHandlerException(e, "onSessionStart");
        }
    }

    public void onSessionEnd(Object[] args) throws Throwable {
        try {
            if (this.isMethodPresent("onSessionEnd")) {
                this.invoke("onSessionEnd", args, null, null, null, this);
            }
        }
        catch (AbortException a) {
            throw a;
        }
        catch (Throwable e) {
            CFLogs.APPLICATION_LOG.error(new ExceptionFilter.ApplicationExceptionWrapper(e, FusionContext.getCurrent() != null ? FusionContext.getCurrent().getPagePath() : null));
            throw new EventHandlerException(e, "onSessionEnd");
        }
    }

    public void onError(Object[] args) throws Throwable {
        if (this.isMethodPresent("onError")) {
            this.invoke("onError", args, null, null, null, this);
        }
    }

    public void onError(Object[] args, FusionContext fContext) throws Throwable {
        this.invoke("onError", args, fContext);
    }

    @Override
    protected FusionFilter getComponentFilterChain(String method, Object[] args) throws Throwable {
        FusionFilter filter;
        FusionFilter tmpFilter = filter = super.getComponentFilterChain(method, args);
        while (tmpFilter != null) {
            if (tmpFilter instanceof CFCProxyFilter) {
                ((CFCProxyFilter)tmpFilter).setAppEvenInvoker(true);
                break;
            }
            tmpFilter = tmpFilter.next;
        }
        return filter;
    }

    private boolean isInvocationRequired(FusionContext fContext, String method) {
        return !fContext.isSchedulerEvent() || ONAPPSTART.equals(method);
    }
}

