/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.eventgateway.EventContext;
import coldfusion.filter.FormScope;
import coldfusion.filter.FusionContext;
import coldfusion.filter.UrlScope;
import coldfusion.log.CFLogs;
import coldfusion.runtime.AppEventInvoker;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.ApplicationSettings;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFCookie;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CgiScope;
import coldfusion.runtime.ClientScope;
import coldfusion.runtime.ClientScopeKey;
import coldfusion.runtime.ClientScopeKeyWrapper;
import coldfusion.runtime.ClientScopeService;
import coldfusion.runtime.ClientStorageException;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.J2eeSessionScope;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.NoNameJ2eeSessionScope;
import coldfusion.runtime.NoOperClientScope;
import coldfusion.runtime.NoOperScope;
import coldfusion.runtime.RequestMonitor;
import coldfusion.runtime.Scope;
import coldfusion.runtime.SessionScope;
import coldfusion.runtime.SessionTracker;
import coldfusion.runtime.Struct;
import coldfusion.runtime.SynchronizedLocalScope;
import coldfusion.runtime.UDFMethod;
import coldfusion.security.SecurityManager;
import coldfusion.security.SecurityUtils;
import coldfusion.server.DataSourceService;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.cache.CacheTagHelper;
import coldfusion.tagext.io.cache.GenericCache;
import coldfusion.tagext.io.cache.GenericCacheFactory;
import coldfusion.tagext.lang.ApplicationTag;
import coldfusion.tagext.lang.InvalidClientStorageException;
import coldfusion.tagext.validation.UnnamedApplicationException;
import coldfusion.tagext.validation.UnnamedApplicationMappingNotAllowed;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.FastHashtable;
import coldfusion.util.IPAddressUtils;
import coldfusion.util.RB;
import coldfusion.util.URLDecoder;
import coldfusion.util.Utils;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.PageContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class AppHelper {
    public static final String CFTOKEN = "CFTOKEN";
    public static final String CFID = "CFID";
    private static RuntimeService runtime = ServiceFactory.getRuntimeService();
    private static ClientScopeService service = ServiceFactory.getClientScopeService();
    private static NoOperScope NoOperAppScope = new NoOperScope("application");
    private static NoOperScope NoOperSessionScope = new NoOperScope("session");
    private static NoOperScope NoOperClientScope = new NoOperClientScope("client");
    private Struct appMetaData;
    private Map m_Settings;
    private String m_cfid;
    private String m_cftoken;
    private String old_cfid;
    private String old_cftoken;
    private boolean m_IsClientIdFromUrl = false;
    private boolean m_IsClientIdFromForm = false;
    private PageContext m_PageContext;
    private int m_ApplicationTimeOut;
    private boolean m_ApplicationTimeOutSet;
    private String m_ApplicationName;
    private boolean m_ClientManagement;
    private String m_ClientStorage;
    private boolean m_SetClientCookies;
    private boolean m_SessionManagement;
    private int m_SessionTimeout;
    private boolean m_SessionTimeoutSet;
    private boolean m_SetDomainCookies;
    private String m_LoginStorage;
    private List m_ScriptProtect;
    private SessionScope m_SessionScope = null;
    private ApplicationScope m_ApplicationScope = null;
    private ClientScope m_ClientScope = null;
    private String m_Jsessionid;
    private boolean m_isSecureJSON;
    private String m_secureJSONPrefix;
    private boolean m_serverSideFormValidation;
    private FusionContext fContext = null;
    private AppEventInvoker appProxy;
    private Scope appScope;
    public static final String APP_NAME_NAME = "name";
    public static final String APP_TIMEOUT_NAME = "applicationtimeout";
    public static final String SESSION_MGMT_NAME = "sessionmanagement";
    public static final String SESSION_TIMEOUT_NAME = "sessiontimeout";
    public static final String DOMAIN_COOKIES_NAME = "setdomaincookies";
    public static final String CLIENT_MGMT_NAME = "clientmanagement";
    public static final String CLIENT_STORAGE_NAME = "clientstorage";
    public static final String CLIENT_COOKIES_NAME = "setclientcookies";
    public static final String LOGIN_STORAGE_NAME = "loginstorage";
    public static final String SCRIPT_PROTECT_NAME = "scriptprotect";
    public static final String SECURE_JSON_NAME = "securejson";
    public static final String SECURE_JSON_PREFIX_NAME = "securejsonprefix";
    public static final String SAME_NAME_FORM_FIELDS_AS_ARRAY = "sameformfieldsasarray";
    public static final boolean DefaultSessionMgmt = false;
    public static final boolean DefaultDomainCookies = false;
    public static final boolean DefaultClientMgmt = false;
    public static final boolean DefaultClientCookies = true;
    public static final String DefaultLoginStorage = "cookie";
    private static Object defaultQueryCache;
    private static final int DEFAULT_MAX_CACHED_QUERY_COUNT = 100;
    private static final String SESSIONFIXATION = "coldfusion.session.protectfixation";
    private static final String MAPPINGS = "MAPPINGS";
    public static boolean protectSessionFixation;
    private static volatile Map<String, String> domainHashes;
    private static final boolean addDomainHashToCookie;

    public AppHelper(PageContext pageContext, Map settings, FusionContext fContext) {
        this.m_PageContext = pageContext;
        if (settings != null) {
            this.m_Settings = this.getSynchronizedSetting(settings);
        }
        this.fContext = fContext;
        this.appMetaData = new Struct();
        this.setApplicationDefaults();
    }

    private Map getSynchronizedSetting(Map settings) {
        if (settings instanceof LocalScope) {
            return new SynchronizedLocalScope((LocalScope)settings, true);
        }
        if (settings instanceof FastHashtable) {
            FastHashtable table = new FastHashtable(true, settings.size());
            settings.forEach(table::put);
            return table;
        }
        CaseInsensitiveMap.CFConcurrentHashMap map = new CaseInsensitiveMap.CFConcurrentHashMap(settings.size());
        settings.forEach(map::put);
        return map;
    }

    public AppHelper(PageContext pageContext, AppEventInvoker appProxy, Map settings, FusionContext fContext) {
        this(pageContext, settings, fContext);
        this.appProxy = appProxy;
    }

    public AppEventInvoker getAppProxy() {
        return this.appProxy;
    }

    public Scope getAppScope() {
        return this.m_ApplicationScope;
    }

    protected String getDomain() {
        String domainname = null;
        if (this.m_SetDomainCookies) {
            String serverName = this.m_PageContext.getRequest().getServerName();
            if (IPAddressUtils.validateIPAdress(serverName)) {
                return null;
            }
            int startPos = serverName.indexOf(46);
            int lastPos = serverName.lastIndexOf(46);
            if (startPos != -1 && lastPos != serverName.length() - 1 && startPos != 0) {
                domainname = startPos == lastPos ? serverName : serverName.substring(startPos, serverName.length());
            }
        }
        return domainname;
    }

    private void handleClientIDs() {
        HttpServletRequest request = (HttpServletRequest)this.m_PageContext.getRequest();
        this.getClientIDs(request);
        if (protectSessionFixation) {
            this.checkIfSessionExists();
        }
        if (this.m_cfid == null || this.m_cftoken == null) {
            this.generateNewClientIDs(request);
        }
    }

    private void getClientIDs(HttpServletRequest request) {
        if (this.m_ApplicationName != null && this.m_ApplicationName.equalsIgnoreCase("cfadmin")) {
            String cookieSuffix = ((SecurityManager)ServiceFactory.getSecurityService()).getCFAdminCookieSuffix();
            Object oCfid = this.m_PageContext.findAttribute("COOKIE.CFID" + cookieSuffix);
            Object oCftoken = this.m_PageContext.findAttribute("COOKIE.CFTOKEN" + cookieSuffix);
            if (oCfid != null && oCftoken != null) {
                this.m_cfid = oCfid.toString();
                this.m_cftoken = oCftoken.toString();
            }
        } else {
            FormScope fs = this.fContext.getFormScope();
            UrlScope us = (UrlScope)this.fContext.hiddenScope.get("URL");
            if (fs != null) {
                this.m_cfid = (String)fs.get(CFID);
                this.m_cftoken = (String)fs.get(CFTOKEN);
                if (this.m_cfid == null || this.m_cftoken == null) {
                    this.m_cfid = (String)fs.get("cfid");
                    this.m_cftoken = (String)fs.get("cftoken");
                }
            }
            boolean bl = this.m_IsClientIdFromForm = this.m_cfid != null && this.m_cftoken != null;
            if (this.m_cfid == null && this.m_cftoken == null && us != null) {
                this.m_cfid = (String)us.get(CFID);
                this.m_cftoken = (String)us.get(CFTOKEN);
                if (this.m_cfid == null || this.m_cftoken == null) {
                    this.m_cfid = (String)us.get("cfid");
                    this.m_cftoken = (String)us.get("cftoken");
                }
                if (!protectSessionFixation) {
                    this.checkIfOldSessionExists();
                }
            }
            this.m_IsClientIdFromUrl = this.m_cfid != null && this.m_cftoken != null;
            Object oCfid = this.m_PageContext.findAttribute("COOKIE.CFID");
            Object oCftoken = this.m_PageContext.findAttribute("COOKIE.CFTOKEN");
            if (!this.m_IsClientIdFromUrl) {
                Cookie[] cookies;
                if (oCfid != null && oCftoken != null) {
                    this.m_cfid = oCfid.toString();
                    this.m_cftoken = oCftoken.toString();
                }
                if ((this.m_cfid == null || this.m_cftoken == null) && (cookies = request.getCookies()) != null) {
                    boolean cfidFound = false;
                    boolean cfTokenFound = false;
                    for (int i = 0; !(i >= cookies.length || cfidFound && cfTokenFound); ++i) {
                        String value;
                        if (cookies[i].getName().equalsIgnoreCase(CFID) && !cfidFound) {
                            value = URLDecoder.decode(cookies[i].getValue());
                            if (AppHelper.isValidCFID(value = this.validateCookieValue(value, true))) {
                                this.m_cfid = value;
                            }
                            if (this.m_cfid != null) {
                                cfidFound = true;
                            }
                        }
                        if (!cookies[i].getName().equalsIgnoreCase(CFTOKEN) || cfTokenFound) continue;
                        value = URLDecoder.decode(cookies[i].getValue());
                        if (AppHelper.isValidCFTOKEN(value = this.validateCookieValue(value, true))) {
                            this.m_cftoken = value;
                        }
                        if (this.m_cftoken == null) continue;
                        cfTokenFound = true;
                    }
                }
            } else if (this.m_cfid != null && this.m_cfid.equals(oCfid) && this.m_cftoken != null && this.m_cftoken.equals(oCftoken)) {
                this.m_IsClientIdFromUrl = false;
            }
        }
        if (this.m_cfid != null) {
            this.m_cfid = this.m_cfid.trim();
        }
        if (this.m_cftoken != null) {
            this.m_cftoken = this.m_cftoken.trim();
        }
        if (this.m_cfid != null && this.m_cftoken != null && !AppHelper.validateIDs(this.m_cfid, this.m_cftoken)) {
            this.m_cfid = null;
            this.m_cftoken = null;
        }
    }

    protected String validateCookieValue(String cookieValue, boolean stripDomainHash) {
        String domain;
        if (!this.m_SetDomainCookies || (domain = this.getDomain()) == null) {
            if (!cookieValue.startsWith("Z")) {
                return cookieValue;
            }
            return null;
        }
        if (addDomainHashToCookie && cookieValue.startsWith("Z") && domain != null) {
            String domainHashStart = this.getDomainHash(domain);
            int cookieRealValueStart = domainHashStart.length();
            if (cookieValue.startsWith(domainHashStart) && cookieValue.length() > cookieRealValueStart) {
                if (stripDomainHash) {
                    return cookieValue.substring(cookieRealValueStart);
                }
                return cookieValue;
            }
        }
        if (!addDomainHashToCookie) {
            return cookieValue;
        }
        return null;
    }

    private String getDomainHash(String domain) {
        StringBuilder domainHashBuilder = new StringBuilder();
        domainHashBuilder.append("Z");
        domainHashBuilder.append(AppHelper.getAndCreateDomainHash(domain));
        domainHashBuilder.append("-");
        return domainHashBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAndCreateDomainHash(String domainName) {
        String domainHash;
        block6: {
            domainHash = null;
            try {
                domainHash = domainHashes.get(domainName);
                if (domainHash != null) break block6;
                Map<String, String> map = domainHashes;
                synchronized (map) {
                    domainHash = domainHashes.get(domainName);
                    if (domainHash == null) {
                        domainHash = SecurityUtils.hash(domainName, "SHA-256", null, null);
                        domainHash = Utils.toBase36(domainHash);
                        domainHashes.put(domainName, domainHash);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return domainHash;
    }

    protected String prepareDomainCookie(String value, boolean checkBeforeDomainHashInsert) {
        String domain;
        if (addDomainHashToCookie && StringUtils.isNotBlank((CharSequence)value) && (domain = this.getDomain()) != null) {
            String domainHash = this.getDomainHash(domain);
            if (!checkBeforeDomainHashInsert || !value.startsWith(domainHash)) {
                return domainHash.concat(value);
            }
        }
        return value;
    }

    private static boolean validateIDs(String CFID, String CFTOKEN) {
        return AppHelper.isValidCFID(CFID) && AppHelper.isValidCFTOKEN(CFTOKEN);
    }

    static boolean isValidCFID(String CFID) {
        if (CFID == null || CFID.length() == 0) {
            return false;
        }
        for (int i = 0; i < CFID.length(); ++i) {
            char c = CFID.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    static boolean isValidCFTOKEN(String CFTOKEN) {
        if (CFTOKEN == null || CFTOKEN.length() < 8) {
            return false;
        }
        for (int i = 0; i < CFTOKEN.length(); ++i) {
            char c = CFTOKEN.charAt(i);
            if (c == '-' || c == '%' || Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    private void checkIfOldSessionExists() {
        if (this.m_cfid != null && this.m_cftoken != null && this.m_SessionManagement && !runtime.useJ2eeSession() && SessionTracker.getSession(this.m_ApplicationName, this.m_cfid, this.m_cftoken) == null) {
            this.old_cfid = this.m_cfid;
            this.old_cftoken = this.m_cftoken;
            this.m_cfid = null;
            this.m_cftoken = null;
        }
    }

    private void checkIfSessionExists() {
        if (this.m_cfid != null && this.m_cftoken != null && this.m_SessionManagement && !runtime.useJ2eeSession()) {
            boolean tokensInvalid = true;
            if (this.m_IsClientIdFromForm && SessionTracker.getSession(this.m_ApplicationName, this.m_cfid, this.m_cftoken) != null) {
                tokensInvalid = false;
            }
            if (SessionTracker.sessionExists(this.m_ApplicationName, this.m_cfid, this.m_cftoken)) {
                tokensInvalid = false;
            }
            if (tokensInvalid) {
                this.old_cfid = this.m_cfid;
                this.old_cftoken = this.m_cftoken;
                this.m_cfid = null;
                this.m_cftoken = null;
            }
        }
    }

    private void generateNewClientIDs(HttpServletRequest request) {
        int clientid = service.GetClientId((NeoPageContext)this.m_PageContext);
        this.m_cfid = Integer.toString(clientid);
        this.m_cftoken = service.GetCFTOKEN();
        if (this.m_SetClientCookies) {
            Object path = request.getContextPath();
            if (path != null && (((String)path).equals("") || !((String)path).endsWith("/"))) {
                path = (String)path + "/";
            }
            String domain = this.getDomain();
            Object cfid = CFID;
            Object cftoken = CFTOKEN;
            if (this.m_ApplicationName != null && this.m_ApplicationName.equalsIgnoreCase("cfadmin")) {
                String cookieSuffix = ((SecurityManager)ServiceFactory.getSecurityService()).getCFAdminCookieSuffix();
                cfid = (String)cfid + cookieSuffix;
                cftoken = (String)cftoken + cookieSuffix;
            }
            CFCookie cfidCookie = new CFCookie((String)cfid, this.m_cfid, domain);
            CFCookie cftokenCookie = new CFCookie((String)cftoken, this.m_cftoken, domain);
            String samesite = FusionContext.getApplicationSettings().getSessionCookieSamesite();
            if (samesite == null || samesite.trim().length() == 0) {
                samesite = ServiceFactory.getRuntimeService().getSessionCookieSamesite();
            }
            cfidCookie.setSamesite(samesite);
            cftokenCookie.setSamesite(samesite);
            if (path != null) {
                cfidCookie.setPath((String)path);
                cftokenCookie.setPath((String)path);
            }
            this.m_PageContext.setAttribute("COOKIE." + (String)cfid, (Object)cfidCookie);
            this.m_PageContext.setAttribute("COOKIE." + (String)cftoken, (Object)cftokenCookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scope connectApplication() {
        this.fContext.setApplicationName(this.m_ApplicationName);
        if (!runtime.isApplicationEnabled()) {
            FusionContext.SymTab_setApplicationScope(NoOperAppScope);
            return NoOperAppScope;
        }
        if ((this.m_ApplicationName == null || this.m_ApplicationName.trim().equals("")) && runtime.isDisableUnnamedApplication()) {
            throw new UnnamedApplicationException();
        }
        this.m_ApplicationScope = ApplicationScopeTracker.getApplicationScope(this.m_ApplicationName);
        ServletContext context = FusionContext.getCurrent().getServletContext();
        if (this.m_ApplicationScope == null) {
            Class<ApplicationScopeTracker> clazz = ApplicationScopeTracker.class;
            synchronized (ApplicationScopeTracker.class) {
                this.m_ApplicationScope = ApplicationScopeTracker.getApplicationScope(this.m_ApplicationName);
                if (this.m_ApplicationScope == null) {
                    this.m_ApplicationScope = ApplicationScopeTracker.createApplication(this.m_ApplicationName);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else if (context.getAttribute(this.m_ApplicationName) == null && (this.m_ApplicationName != null && this.m_ApplicationName.length() == 0 || ServiceFactory.getRuntimeService().isAllowAppVarInServContext())) {
            context.setAttribute(this.m_ApplicationName, (Object)this.m_ApplicationScope.getAttributeMap());
        }
        {
            FusionContext.SymTab_setApplicationScope(this.m_ApplicationScope);
            return this.m_ApplicationScope;
        }
    }

    public void applyAppSettings(ApplicationScope scope) {
        if (!this.m_LoginStorage.equalsIgnoreCase("session") && !this.m_LoginStorage.equalsIgnoreCase(DefaultLoginStorage)) {
            throw new ApplicationTag.InvalidLoginStorage(this.m_LoginStorage);
        }
        if (!this.m_SessionManagement && this.m_LoginStorage.equalsIgnoreCase("session")) {
            throw new ApplicationTag.SessionNotEnabled();
        }
        scope.setApplicationSettings(this.m_Settings);
        this.overrideReqTimeout();
        Object appCustomTagPaths = this.m_Settings.get("customtagpaths");
        if (appCustomTagPaths != null && appCustomTagPaths instanceof String) {
            scope.setApplicationCustomTagPaths((String)appCustomTagPaths);
        }
        scope.setLastAccess();
        if (this.m_ApplicationTimeOutSet) {
            if ((long)this.m_ApplicationTimeOut > runtime.getApplicationMaxTimeout()) {
                scope.SetMaxInactiveInterval(runtime.getApplicationMaxTimeout());
            } else {
                scope.SetMaxInactiveInterval(this.m_ApplicationTimeOut);
            }
        } else {
            scope.SetMaxInactiveInterval(runtime.getApplicationTimeout());
        }
        scope.setStoreloginCredentialInSession(this.m_LoginStorage.equalsIgnoreCase("session"));
    }

    public void validateMappings() {
        Struct obj;
        Object mappings;
        if ((this.m_ApplicationName == null || this.m_ApplicationName.trim().length() == 0) && (mappings = this.m_Settings.get(MAPPINGS)) instanceof Struct && (obj = (Struct)mappings).get("/CFIDE") != null) {
            throw new UnnamedApplicationMappingNotAllowed();
        }
    }

    public void overrideReqTimeout() {
        if (this.m_Settings.get("timeout") != null) {
            RequestMonitor.overrideRequestTimeout(Cast._long(this.m_Settings.get("timeout")));
        }
    }

    private void applyClientSettings() {
        if (this.m_ClientManagement) {
            if (this.m_ClientStorage == null) {
                this.m_ClientStorage = service.GetDefaultDSN();
            }
            if (this.m_ClientStorage == null) {
                throw new InvalidClientSettings();
            }
            if (this.m_ClientStorage.length() == 0) {
                throw new ClientStorageException();
            }
            if (this.m_ClientStorage.equalsIgnoreCase(DefaultLoginStorage) && !this.m_SetClientCookies) {
                throw new InvalidClientSettings();
            }
        }
    }

    private void applySessionSettings() {
        if (this.m_SessionManagement && !runtime.isSessionEnabled()) {
            throw new ApplicationTag.SessionScopeDisabledException();
        }
    }

    private void setApplicationDefaults() {
        Object obj = this.m_Settings.get(APP_TIMEOUT_NAME);
        this.m_ApplicationTimeOut = obj == null ? AppHelper.getDefaultApplicationTimeout() : Cast._int(obj);
        this.m_ApplicationTimeOutSet = obj != null;
        this.appMetaData.put("APPLICATIONTIMEOUT", (Object)new Integer(this.m_ApplicationTimeOut));
        obj = this.m_Settings.get(APP_NAME_NAME);
        this.m_ApplicationName = Cast._String(obj == null ? "" : obj);
        this.appMetaData.put("NAME", (Object)this.m_ApplicationName);
        obj = this.m_Settings.get(SESSION_MGMT_NAME);
        this.m_SessionManagement = obj == null ? false : Cast._boolean(obj);
        this.appMetaData.put("SESSIONMANAGEMENT", (Object)new Boolean(this.m_SessionManagement));
        obj = this.m_Settings.get(SESSION_TIMEOUT_NAME);
        this.m_SessionTimeout = obj == null ? AppHelper.getDefaultSessionTimeout() : Cast._int(obj);
        this.m_SessionTimeoutSet = obj != null;
        this.appMetaData.put("SESSIONTIMEOUT", (Object)new Integer(this.m_SessionTimeout));
        obj = this.m_Settings.get(DOMAIN_COOKIES_NAME);
        this.m_SetDomainCookies = obj == null ? false : Cast._boolean(obj);
        this.appMetaData.put("SETDOMAINCOOKIES", (Object)new Boolean(this.m_SetDomainCookies));
        obj = this.m_Settings.get(CLIENT_MGMT_NAME);
        this.m_ClientManagement = obj == null ? false : Cast._boolean(obj);
        this.appMetaData.put("CLIENTMANAGEMENT", (Object)new Boolean(this.m_ClientManagement));
        obj = this.m_Settings.get(CLIENT_STORAGE_NAME);
        this.m_ClientStorage = obj == null ? AppHelper.getDefaultClientStorage() : Cast._String(obj);
        this.appMetaData.put("CLIENTSTORAGE", (Object)this.m_ClientStorage);
        obj = this.m_Settings.get(CLIENT_COOKIES_NAME);
        this.m_SetClientCookies = obj == null ? true : Cast._boolean(obj);
        this.appMetaData.put("SETCLIENTCOOKIES", (Object)new Boolean(this.m_SetClientCookies));
        obj = this.m_Settings.get(LOGIN_STORAGE_NAME);
        this.m_LoginStorage = obj == null ? DefaultLoginStorage : Cast._String(obj);
        this.appMetaData.put("LOGINSTORAGE", (Object)this.m_LoginStorage);
        obj = this.m_Settings.get(SCRIPT_PROTECT_NAME);
        if (obj != null) {
            this.setupScriptProtect(obj);
        } else {
            this.m_ScriptProtect = this.fContext.getScriptProtect();
        }
        this.appMetaData.put("SCRIPTPROTECT", (Object)this.m_ScriptProtect);
        obj = this.m_Settings.get(SECURE_JSON_NAME);
        try {
            this.m_isSecureJSON = obj == null ? this.fContext.isSecureJSON() : Cast._boolean(obj);
        }
        catch (Exception ex) {
            throw new InvalidSecureJSONSetting(obj);
        }
        this.fContext.setSecureJSON(this.m_isSecureJSON);
        this.appMetaData.put("SECUREJSON", (Object)new Boolean(this.m_isSecureJSON));
        obj = this.m_Settings.get("serverSideFormValidation");
        try {
            this.m_serverSideFormValidation = obj == null ? this.fContext.isServerSideFormValidation() : Cast._boolean(obj);
        }
        catch (Exception ex) {
            throw new InvalidServerSideFormValidationSetting(obj);
        }
        this.fContext.setServerSideFormValidation(this.m_serverSideFormValidation);
        this.appMetaData.put("SERVERSIDEFORMVALIDATION", (Object)new Boolean(this.m_serverSideFormValidation));
        obj = this.m_Settings.get(SECURE_JSON_PREFIX_NAME);
        this.m_secureJSONPrefix = obj == null ? this.fContext.getSecureJSONPrefix() : Cast._String(obj);
        this.fContext.setSecureJSONPrefix(this.m_secureJSONPrefix);
        this.appMetaData.put("SECUREJSONPREFIX", (Object)this.m_secureJSONPrefix);
        obj = this.m_Settings.get("compileextforinclude");
        this.appMetaData.put("COMPILEEXTFORINCLUDE", (Object)(obj == null ? runtime.getCompileExtForInclude() : obj));
        obj = this.m_Settings.get("STRICTNUMBERVALIDATION");
        this.appMetaData.put("STRICTNUMBERVALIDATION", (Object)new Boolean(obj == null ? true : Cast._boolean(obj)));
        obj = this.m_Settings.get("PASSARRAYBYREFERENCE");
        obj = obj == null ? false : Cast._boolean(obj);
        this.fContext.setPassArrayByReference((Boolean)obj);
        this.appMetaData.put("PASSARRAYBYREFERENCE", obj);
    }

    static String getDefaultClientStorage() {
        try {
            return service.GetDefaultDSN();
        }
        catch (ServiceFactory.ServiceNotAvailableException e) {
            return null;
        }
    }

    static int getDefaultApplicationTimeout() {
        return (int)runtime.getApplicationTimeout();
    }

    static int getDefaultSessionTimeout() {
        return (int)runtime.getSessionTimeout();
    }

    private void setupScriptProtect(Object obj) {
        if (obj instanceof String) {
            String s = (String)obj;
            if (s.equalsIgnoreCase("all")) {
                this.m_ScriptProtect = new ArrayList(4);
                this.m_ScriptProtect.add("FORM");
                this.m_ScriptProtect.add("URL");
                this.m_ScriptProtect.add("COOKIE");
                this.m_ScriptProtect.add("CGI");
            } else if (s.equalsIgnoreCase("none")) {
                this.m_ScriptProtect = Collections.EMPTY_LIST;
            } else {
                StringTokenizer st = new StringTokenizer(s, ",");
                Array newScriptProtect = new Array();
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    if (!item.equalsIgnoreCase("FORM") && !item.equalsIgnoreCase("URL") && !item.equalsIgnoreCase("COOKIE") && !item.equalsIgnoreCase("CGI")) continue;
                    newScriptProtect.add(item);
                }
                this.m_ScriptProtect = newScriptProtect.size() == 0 ? Collections.EMPTY_LIST : newScriptProtect;
            }
        }
        this.fContext.setScriptProtect(this.m_ScriptProtect);
    }

    static String getScriptProtectList() {
        return ServiceFactory.getRuntimeService().getScriptProtect();
    }

    public Scope setupClientScope() {
        Scope scope = NoOperClientScope;
        EventContext ectxt = this.fContext.getEventContext();
        if (ectxt != null) {
            this.m_cfid = ectxt.originatorID;
            this.m_cftoken = ectxt.gwType + "_" + ectxt.gwID;
        }
        if (this.m_ClientManagement) {
            if (this.m_ClientStorage != null && !service.IsValidDSN(this.m_ClientStorage)) {
                throw new InvalidClientStorageException(this.m_ClientStorage);
            }
            Properties persistSettings = new Properties();
            if (this.m_ClientStorage != null) {
                persistSettings.setProperty(CLIENT_STORAGE_NAME, this.m_ClientStorage);
            }
            if (ectxt == null && this.old_cfid != null && this.old_cftoken != null) {
                this.updateClientStore(persistSettings);
            } else {
                this.m_ClientScope = service.GetClientScope((NeoPageContext)this.m_PageContext, new ClientScopeKey(this.m_cfid, this.m_ApplicationName, this.m_cftoken), persistSettings, null, null);
            }
            this.m_ClientScope.setIsClientIdFromUrl(this.m_IsClientIdFromUrl);
            if (this.m_SetDomainCookies) {
                this.m_ClientScope.setUseDomainCookies(this.getDomain());
            }
            FusionContext.SymTab_setClientScope(this.m_ClientScope);
            scope = this.m_ClientScope;
        } else {
            FusionContext.SymTab_setClientScope(NoOperClientScope);
        }
        return scope;
    }

    private void updateClientStore(Properties persistSettings) {
        this.m_ClientScope = service.GetClientScope((NeoPageContext)this.m_PageContext, new ClientScopeKey(this.old_cfid, this.m_ApplicationName, this.old_cftoken), persistSettings, this.m_cfid, this.m_cftoken);
        ClientScopeKey csKey = this.m_ClientScope.getKey();
        this.m_ClientScope.bind("cfid", this.m_cfid);
        this.m_ClientScope.bind("cftoken", this.m_cftoken);
        this.computeURLToken();
        this.m_ClientScope.markDirty();
        this.queueCSKeyForRemoval();
        this.old_cfid = null;
        this.old_cftoken = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueCSKeyForRemoval() {
        try {
            boolean oldMatchFound = false;
            LinkedList<ClientScopeKeyWrapper> linkedList = ClientScopeService.removableClientScopeKeys;
            synchronized (linkedList) {
                ListIterator listIterator = ClientScopeService.removableClientScopeKeys.listIterator();
                while (listIterator.hasNext()) {
                    ClientScopeKeyWrapper removableCSKey = (ClientScopeKeyWrapper)listIterator.next();
                    ClientScopeKey csk = removableCSKey.getClientScopeKey();
                    if (!csk.mCFID.equalsIgnoreCase(this.old_cfid) || !csk.mCFToken.equalsIgnoreCase(this.old_cftoken) || !csk.mApplicationName.equalsIgnoreCase(this.m_ApplicationName) || !removableCSKey.getClientStorage().equalsIgnoreCase(this.m_ClientStorage)) continue;
                    oldMatchFound = true;
                    removableCSKey.updateTimeToLive();
                    break;
                }
            }
            if (!oldMatchFound) {
                ClientScopeService.removableClientScopeKeys.add(new ClientScopeKeyWrapper(new ClientScopeKey(this.old_cfid, this.m_ApplicationName, this.old_cftoken), this.m_ClientStorage));
            }
        }
        catch (Exception e) {
            ClientScopeService.removableClientScopeKeys.add(new ClientScopeKeyWrapper(new ClientScopeKey(this.old_cfid, this.m_ApplicationName, this.old_cftoken), this.m_ClientStorage));
        }
    }

    private void setupClassicSessionScope() {
        if (this.m_SessionTimeoutSet && this.m_SessionTimeout == 0) {
            SessionTracker.cleanUp(this.m_ApplicationName, this.m_cfid, this.m_cftoken);
            return;
        }
        if (!ServiceFactory.getRuntimeService().isCommandLineCompile()) {
            this.m_SessionScope = SessionTracker.getSession(this.m_ApplicationName, this.m_cfid, this.m_cftoken);
            if (this.m_SessionScope == null) {
                this.m_SessionScope = SessionTracker.createSession(this.m_ApplicationName, this.m_cfid, this.m_cftoken);
                this.m_SessionScope.setClientIp(this.m_PageContext.getRequest().getRemoteAddr());
                if (!this.m_SessionTimeoutSet) {
                    long sessionTimeout = runtime.getSessionTimeout();
                    this.m_SessionScope.SetMaxInactiveInterval(sessionTimeout);
                }
                this.m_SessionScope.put("cfid", this.m_cfid);
                this.m_SessionScope.put("cftoken", this.m_cftoken);
                this.m_SessionScope.put("sessionid", this.m_ApplicationName.toUpperCase() + "_" + this.m_cfid + "_" + this.m_cftoken);
                SessionTracker.setSessionScope(this.m_ApplicationName, SessionTracker.getSessionKey(this.m_cfid, this.m_cftoken), this.m_SessionScope);
            }
            if (this.m_SessionTimeoutSet) {
                if ((long)this.m_SessionTimeout > runtime.getSessionMaxTimeout()) {
                    this.m_SessionScope.SetMaxInactiveInterval(runtime.getSessionMaxTimeout());
                } else {
                    this.m_SessionScope.SetMaxInactiveInterval(this.m_SessionTimeout);
                }
            }
            this.m_SessionScope.setLastAccess();
            this.m_SessionScope.setIsIdFromURL(this.m_IsClientIdFromUrl);
            FusionContext.getCurrent().setCurrentSession(this.m_SessionScope);
        }
    }

    private void setupJ2eeSessionScope() {
        HttpServletRequest request = (HttpServletRequest)this.m_PageContext.getRequest();
        HttpSession session = request.getSession(true);
        if (session == null) {
            this.setupClassicSessionScope();
            return;
        }
        if (this.m_SessionTimeoutSet && this.m_SessionTimeout == 0) {
            SessionTracker.cleanUp(session, this.m_ApplicationName);
            return;
        }
        this.m_SessionScope = SessionTracker.getSession(session, this.m_ApplicationName);
        if (this.m_SessionScope == null) {
            this.m_SessionScope = SessionTracker.createSession(session, this.m_ApplicationName);
            this.m_SessionScope.setClientIp(request.getRemoteAddr());
        } else if (this.m_SessionScope instanceof J2eeSessionScope) {
            ((J2eeSessionScope)this.m_SessionScope).setHttpServletSession(session);
        } else if (this.m_SessionScope instanceof NoNameJ2eeSessionScope) {
            ((NoNameJ2eeSessionScope)this.m_SessionScope).setHttpServletSession(session);
        }
        if (this.m_SessionTimeoutSet) {
            if ((long)this.m_SessionTimeout > runtime.getSessionMaxTimeout()) {
                this.m_SessionScope.SetMaxInactiveInterval(runtime.getSessionMaxTimeout());
            } else {
                this.m_SessionScope.SetMaxInactiveInterval(this.m_SessionTimeout);
            }
        } else {
            long sessionTimeout = runtime.getSessionTimeout();
            this.m_SessionScope.SetMaxInactiveInterval(sessionTimeout);
        }
        this.m_SessionScope.put("sessionid", session.getId());
        this.m_Jsessionid = session.getId();
        this.m_SessionScope.setLastAccess();
        this.m_SessionScope.setIsIdFromURL(request.isRequestedSessionIdFromURL());
        FusionContext.getCurrent().setCurrentSession(this.m_SessionScope);
    }

    private Scope setupEventSessionScope(EventContext eventContext) {
        String eventSessionid = eventContext.sessionId;
        if (this.m_SessionManagement && eventSessionid != null) {
            if (this.m_SessionTimeoutSet && this.m_SessionTimeout == 0) {
                SessionTracker.cleanUp(this.m_ApplicationName, eventSessionid);
                return NoOperSessionScope;
            }
            this.m_SessionScope = SessionTracker.getSession(this.m_ApplicationName, eventSessionid);
            if (this.m_SessionScope == null) {
                this.m_SessionScope = SessionTracker.createSession(this.m_ApplicationName, eventSessionid);
                if (this.m_SessionTimeoutSet) {
                    if ((long)this.m_SessionTimeout > runtime.getSessionMaxTimeout()) {
                        this.m_SessionScope.SetMaxInactiveInterval(runtime.getSessionMaxTimeout());
                    } else {
                        this.m_SessionScope.SetMaxInactiveInterval(this.m_SessionTimeout);
                    }
                } else {
                    long sessionTimeout = runtime.getSessionTimeout();
                    this.m_SessionScope.SetMaxInactiveInterval(sessionTimeout);
                }
                this.m_SessionScope.put("sessionid", this.m_ApplicationName.toUpperCase() + "_" + eventSessionid);
            }
            this.m_SessionScope.setLastAccess();
            this.m_SessionScope.setIsIdFromURL(this.m_IsClientIdFromUrl);
            FusionContext.SymTab_setSessionScope(this.m_SessionScope);
        }
        return this.m_SessionScope;
    }

    public Scope setupSessionScope() {
        Scope scope = NoOperSessionScope;
        EventContext ectxt = this.fContext.getEventContext();
        if (this.fContext.isSchedulerEvent()) {
            FusionContext.SymTab_setSessionScope(NoOperSessionScope);
            return scope;
        }
        if (ectxt != null) {
            scope = this.setupEventSessionScope(ectxt);
        } else if (this.m_SessionManagement) {
            if (runtime.useJ2eeSession()) {
                this.setupJ2eeSessionScope();
            } else {
                this.setupClassicSessionScope();
            }
            FusionContext.SymTab_setSessionScope(this.m_SessionScope);
            scope = this.m_SessionScope;
        } else {
            FusionContext.SymTab_setSessionScope(NoOperSessionScope);
        }
        return scope;
    }

    public final void computeURLToken() {
        if (this.m_ClientManagement || this.m_SessionManagement) {
            StringBuffer urltokenbuf = new StringBuffer();
            boolean cfid_cftoken_present = false;
            if (this.m_cfid != null && this.m_cftoken != null) {
                cfid_cftoken_present = true;
                urltokenbuf.append("CFID=");
                urltokenbuf.append(this.m_cfid);
                urltokenbuf.append('&');
                urltokenbuf.append("CFTOKEN=");
                urltokenbuf.append(this.m_cftoken);
            }
            if (this.m_Jsessionid != null) {
                if (cfid_cftoken_present) {
                    urltokenbuf.append('&');
                }
                urltokenbuf.append("jsessionid=");
                urltokenbuf.append(this.m_Jsessionid);
            }
            String m_URLToken = urltokenbuf.toString();
            if (this.m_SessionScope != null) {
                this.m_SessionScope.put("urltoken", m_URLToken);
            }
            if (this.m_ClientScope != null) {
                this.m_ClientScope.put("urltoken", m_URLToken);
            }
        }
    }

    public void ValidateClientAndSession() {
        if (this.m_ApplicationScope != null && this.m_ApplicationScope.getMaxInactiveInterval() == 0L) {
            ApplicationScopeTracker.cleanUp(this.m_ApplicationScope);
        }
        this.applyClientSettings();
        this.applySessionSettings();
        if ((this.m_SessionManagement || this.m_ClientManagement) && this.fContext.getEventContext() == null) {
            this.handleClientIDs();
        }
    }

    public static Object getApplicationSetting(String propertyName) {
        Map appSettings = (Map)AppHelper.getApplicationSetting();
        if (appSettings != null) {
            return appSettings.get(propertyName);
        }
        return null;
    }

    public static Object getApplicationSetting() {
        ApplicationScope appScope;
        FusionContext context = FusionContext.getCurrent();
        if (context == null) {
            return null;
        }
        String appName = context.getApplicationName();
        if (appName != null && (appScope = ApplicationScopeTracker.getApplicationScope(appName)) != null) {
            Map appSettings = appScope.getApplicationSettingsMap();
            return appSettings;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getDefaultCache(ApplicationScope appScope) {
        if (appScope != null) {
            return appScope.getDefaultQueryCache();
        }
        if (defaultQueryCache == null) {
            GenericCache cacheMgr;
            GenericCache genericCache = cacheMgr = GenericCacheFactory.getCache();
            synchronized (genericCache) {
                defaultQueryCache = cacheMgr.createCache("QUERY", "QUERY", null, null);
            }
            AppHelper.setMaxQueryCount(-1, true);
        }
        return defaultQueryCache;
    }

    public static boolean useInternalQueryCache(ApplicationScope appScope) {
        if (appScope != null) {
            return appScope.useInternalQueryCache();
        }
        return AppHelper.isServerWideInternalQueryCacheEnabled();
    }

    public static boolean isServerWideInternalQueryCacheEnabled() {
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        if (runtimeService != null) {
            return runtimeService.isInternalCacheForQueryEnabled();
        }
        return false;
    }

    public static void setMaxQueryCount(int count, boolean forceSet) {
        String appName = null;
        if (FusionContext.getCurrent() != null) {
            appName = FusionContext.getCurrent().getApplicationName();
        }
        ApplicationScope appScope = null;
        if (appName != null) {
            appScope = ApplicationScopeTracker.getApplicationScope(appName);
        }
        if (AppHelper.getDefaultCache(appScope) == null || forceSet) {
            GenericCache cacheMgr = GenericCacheFactory.getCache();
            if (cacheMgr.isApplicationSpecificCache()) {
                Map settingsMap;
                Map cacheSettings;
                if (count == -1) {
                    count = 100;
                }
                if (appName != null && !appName.equals("") && appScope != null && (cacheSettings = (Map)(settingsMap = appScope.getApplicationSettingsMap()).get("cache")) != null) {
                    String querySize = null;
                    if (cacheSettings.get("querysize") != null) {
                        querySize = cacheSettings.get("querysize").toString();
                    }
                    if (querySize != null) {
                        try {
                            count = Integer.parseInt(querySize);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            } else if (count == -1) {
                RuntimeService runtimeService = ServiceFactory.getRuntimeService();
                DataSourceService dsSvc = ServiceFactory.getDataSourceService();
                if (dsSvc != null) {
                    count = dsSvc.getMaxQueryCount().intValue();
                }
            }
            if (count >= 0 && AppHelper.getDefaultCache(appScope) != null) {
                GenericCacheFactory.getCache().setMaxElementsInMemory(CacheTagHelper.getCacheKey("QUERY", appName, "QUERY", null), count);
            }
        }
    }

    public Struct getApplicationMetaData() {
        Map appSettings = (Map)AppHelper.getApplicationSetting();
        String appName = FusionContext.getCurrent().getApplicationName();
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
        ApplicationSettings applicationSettings = null;
        if (appScope != null) {
            applicationSettings = appScope.getApplicationSettings();
        }
        if (appSettings != null) {
            Object obj = null;
            for (String key : appSettings.keySet()) {
                if (key.equals(APP_TIMEOUT_NAME) || key.equals(SESSION_MGMT_NAME) || key.equals(SESSION_TIMEOUT_NAME) || key.equals(DOMAIN_COOKIES_NAME) || key.equals(CLIENT_MGMT_NAME) || key.equals(CLIENT_STORAGE_NAME) || key.equals(CLIENT_COOKIES_NAME) || key.equals(LOGIN_STORAGE_NAME) || key.equals(APP_NAME_NAME) || key.equals(SECURE_JSON_NAME) || key.equals(SECURE_JSON_PREFIX_NAME) || key.equals("serverSideFormValidation")) continue;
                if (key.equalsIgnoreCase("inmemoryfilesystem")) {
                    Map inmemoryfilesystem = (Map)appSettings.get(key);
                    if (applicationSettings != null) {
                        inmemoryfilesystem.put("enabled", new Boolean(applicationSettings.isInMemoryEnabled()));
                        inmemoryfilesystem.put("size", new Integer(applicationSettings.getInMemorySize()));
                    }
                    this.appMetaData.put(key, (Object)inmemoryfilesystem);
                    continue;
                }
                if (key.equalsIgnoreCase("SESSIONCOOKIE")) {
                    if (applicationSettings == null) continue;
                    Struct sessioncookie = new Struct();
                    sessioncookie.put("HTTPONLY", new Boolean(applicationSettings.isHttpOnlySessionCookie()));
                    sessioncookie.put("SECURE", new Boolean(applicationSettings.isSecureSessionCookie()));
                    sessioncookie.put("TIMEOUT", new Integer(applicationSettings.getSessionCookieTimeout()));
                    String domain = applicationSettings.getSessionCookieDomain();
                    if (domain != null && !"".equalsIgnoreCase(domain)) {
                        sessioncookie.put("DOMAIN", domain);
                    }
                    sessioncookie.put("DISABLEUPDATE", new Boolean(applicationSettings.isSessionCookieUpdateDisabled()));
                    this.appMetaData.put(key, (Object)sessioncookie);
                    continue;
                }
                if (key.equalsIgnoreCase("AUTHCOOKIE")) {
                    if (applicationSettings == null) continue;
                    Struct authcookie = new Struct();
                    authcookie.put("TIMEOUT", new Integer(applicationSettings.getAuthCookieTimeout()));
                    authcookie.put("DISABLEUPDATE", new Boolean(applicationSettings.isAuthCookieUpdateDisabled()));
                    this.appMetaData.put(key, (Object)authcookie);
                    continue;
                }
                if (key.equalsIgnoreCase(SCRIPT_PROTECT_NAME)) {
                    obj = this.appMetaData.get(key);
                    if (obj == null || obj.equals(Collections.EMPTY_LIST)) {
                        obj = "none";
                    }
                    this.appMetaData.put(key, obj);
                    continue;
                }
                obj = appSettings.get(key);
                boolean appMetadataMappingsPresent = false;
                if (MAPPINGS.equalsIgnoreCase(key)) {
                    Struct mappings;
                    Object mappingsObj = this.appMetaData.get(MAPPINGS);
                    if (mappingsObj != null && mappingsObj instanceof Struct && !(mappings = (Struct)mappingsObj).isEmpty()) {
                        appMetadataMappingsPresent = true;
                        appSettings.put(key, mappingsObj);
                    }
                    if (obj instanceof Struct && MAPPINGS.equalsIgnoreCase(key) && !appMetadataMappingsPresent) {
                        obj = ((Struct)obj).clone();
                    }
                }
                if (obj instanceof UDFMethod || appMetadataMappingsPresent) continue;
                this.appMetaData.put(key, obj);
            }
            if (this.appMetaData != null) {
                Boolean value;
                if (this.appMetaData.get("ENABLENULLSUPPORT") == null) {
                    this.appMetaData.put("ENABLENULLSUPPORT", (Object)false);
                } else {
                    value = applicationSettings.getEnableNullSupport();
                    if (value == null) {
                        value = false;
                    }
                    this.appMetaData.put("ENABLENULLSUPPORT", (Object)value);
                }
                if (this.appMetaData.get("SEARCHIMPLICITSCOPES") == null) {
                    this.appMetaData.put("SEARCHIMPLICITSCOPES", (Object)ApplicationSettings.DEFAULT_SEARCH_IMPLICIT_SCOPES);
                } else {
                    this.appMetaData.put("SEARCHIMPLICITSCOPES", (Object)new Boolean(applicationSettings.isSearchImplicitScope()));
                }
                if (this.appMetaData.get("SAMEFORMFIELDSASARRAY") == null) {
                    this.appMetaData.put("SAMEFORMFIELDSASARRAY", (Object)false);
                } else {
                    value = applicationSettings.getSameFormFieldsArray();
                    if (value == null) {
                        value = false;
                    }
                    this.appMetaData.put("SAMEFORMFIELDSASARRAY", (Object)value);
                }
            }
        } else {
            return null;
        }
        return this.appMetaData;
    }

    public Struct getApplicationMappings() {
        return (Struct)this.appMetaData.get(MAPPINGS);
    }

    public static void protectScopes(FusionContext context) {
        List scriptProtectList = context.getScriptProtect();
        if (scriptProtectList != null) {
            for (int i = 0; i < scriptProtectList.size(); ++i) {
                try {
                    Scope scope = (Scope)context.pageContext.SymTab_findBuiltinScope(((String)scriptProtectList.get(i)).toUpperCase());
                    if (scope == null || scope instanceof CgiScope) continue;
                    Set keySet = scope.keySet();
                    for (Object key : keySet) {
                        String origValue;
                        Object value = scope.get(key);
                        if (!(value instanceof String) || (origValue = (String)value).equals(value = ServiceFactory.getSecurityService().crossSiteProtectString(origValue))) continue;
                        scope.put(key, value.toString());
                    }
                    continue;
                }
                catch (UnsupportedOperationException ex) {
                    throw new ScriptProtectReplaceException(scriptProtectList.get(i).toString());
                }
            }
        }
    }

    public void sessionRotate() {
        String oldTrackerKey;
        String newTrackerKey;
        SessionScope sessionScope;
        HttpServletRequest request;
        EventContext ectxt = this.fContext.getEventContext();
        if (ectxt != null) {
            CFLogs.APPLICATION_LOG.info(RB.getString(this, "SessionRotateNoOp"));
            return;
        }
        if (this.m_SessionManagement) {
            request = (HttpServletRequest)this.m_PageContext.getRequest();
            sessionScope = null;
            boolean isJ2ee = runtime.useJ2eeSession();
            newTrackerKey = "";
            oldTrackerKey = "";
            if (this.m_cfid != null && this.m_cftoken != null) {
                this.old_cfid = this.m_cfid;
                this.old_cftoken = this.m_cftoken;
                this.m_cfid = null;
                this.m_cftoken = null;
                this.generateNewClientIDs(request);
            }
            if (isJ2ee) {
                HttpSession httpSession = request.getSession(false);
                sessionScope = SessionTracker.getSession(httpSession, this.m_ApplicationName);
                if (sessionScope != null) {
                    oldTrackerKey = sessionScope.getTrackerSessionId();
                    HashMap<String, Object> attributes = sessionScope.getSessionData();
                    sessionScope.CleanUp();
                    HttpSession sess = request.getSession(true);
                    sessionScope.setSessionData(sess, attributes);
                    newTrackerKey = SessionTracker.getSessionTrackerId(this.m_ApplicationName, sess.getId());
                }
            } else {
                if (SessionTracker.isExternalSessionStorage) {
                    sessionScope = FusionContext.getCurrent().getCurrentSession();
                }
                if (sessionScope == null) {
                    sessionScope = SessionTracker.getSession(this.m_ApplicationName, this.old_cfid, this.old_cftoken);
                }
                if (sessionScope != null) {
                    oldTrackerKey = sessionScope.getTrackerSessionId();
                    if (!this.m_SessionTimeoutSet) {
                        long sessionTimeout = runtime.getSessionTimeout();
                        sessionScope.SetMaxInactiveInterval(sessionTimeout);
                    }
                    sessionScope.put("cfid", this.m_cfid);
                    sessionScope.put("cftoken", this.m_cftoken);
                    sessionScope.put("sessionid", this.m_ApplicationName.toUpperCase() + "_" + this.m_cfid + "_" + this.m_cftoken);
                    newTrackerKey = SessionTracker.getSessionTrackerId(this.m_ApplicationName, this.m_cfid, this.m_cftoken);
                }
            }
        } else {
            CFLogs.APPLICATION_LOG.info(RB.getString(this, "SessionRotateFailure"));
            throw new SecurityUtils.SessionManipulationException();
        }
        this.finishSessionRotate(request, sessionScope, oldTrackerKey, newTrackerKey);
        CFLogs.APPLICATION_LOG.info(RB.getString(this, "SessionRotateSuccess"));
    }

    private void finishSessionRotate(HttpServletRequest request, SessionScope sessionScope, String oldTrackerKey, String newTrackerKey) {
        if (sessionScope != null) {
            sessionScope.setTrackerSessionId(newTrackerKey);
            sessionScope.setIsNew(true);
            sessionScope.setClientIp(request.getRemoteAddr());
            SessionTracker.updateSessionScope(sessionScope.getAppName(), oldTrackerKey, newTrackerKey, this.m_cfid, this.m_cftoken, sessionScope);
            this.setupClientScope();
            this.setupSessionScope();
            this.computeURLToken();
        }
    }

    protected boolean isSetDomainCookies() {
        return this.m_SetDomainCookies;
    }

    public int getSessionTimeout() {
        return this.m_SessionTimeout;
    }

    public static void resetDefaultQueryCache() {
        defaultQueryCache = null;
    }

    public boolean isSessionManagmentEnabled() {
        return this.m_SessionManagement;
    }

    static {
        protectSessionFixation = true;
        domainHashes = new HashMap<String, String>();
        addDomainHashToCookie = Boolean.valueOf(System.getProperty("coldfusion.cookie.prefixdomainhash", "true"));
        String protectSession = System.getProperty(SESSIONFIXATION);
        if (protectSession != null && protectSession.length() > 0) {
            protectSessionFixation = Boolean.parseBoolean(protectSession);
        }
    }

    public static final class InvalidClientSettings
    extends ExpressionException {
    }

    public static final class InvalidSecureJSONSetting
    extends ExpressionException {
        public Object secureJSONSetting;

        public InvalidSecureJSONSetting(Object secureJSONSetting) {
            this.secureJSONSetting = secureJSONSetting;
        }
    }

    public static final class InvalidServerSideFormValidationSetting
    extends ExpressionException {
        public Object serverSideFormValidation;

        public InvalidServerSideFormValidationSetting(Object serverSideFormValidation) {
            this.serverSideFormValidation = serverSideFormValidation;
        }
    }

    public static final class ScriptProtectReplaceException
    extends ExpressionException {
        public String scope;

        public ScriptProtectReplaceException(String scope) {
            this.scope = scope;
        }
    }
}

