/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.compiler.CustomTagTable;
import coldfusion.filter.FusionContext;
import coldfusion.monitor.memory.MemoryTrackableRoot;
import coldfusion.monitor.memory.MemoryTracker;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.runtime.AbstractScope;
import coldfusion.runtime.AppClassLoaderHelper;
import coldfusion.runtime.AppEventInvoker;
import coldfusion.runtime.AppHelper;
import coldfusion.runtime.ApplicationSettings;
import coldfusion.runtime.LockManager;
import coldfusion.runtime.LockableScope;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TimedScope;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.sql.CFDataSource;
import coldfusion.tagext.io.cache.GenericCache;
import coldfusion.tagext.io.cache.GenericCacheFactory;
import coldfusion.util.FastHashtable;
import coldfusion.util.Key;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public final class ApplicationScope
extends AbstractScope
implements LockableScope,
MemoryTrackableRoot,
TimedScope {
    private ServletContext mApp;
    private String mAppName;
    private long mLastAccess;
    private long mMaxInterval;
    private long mStartTime;
    protected FastHashtable mTable;
    private AppEventInvoker mCFCProxy;
    private Map appSettingsMap;
    private boolean mIsNew = true;
    private boolean mStoreloginCredentialInSession = false;
    private String appCustomTagPaths;
    private String applicationPath;
    private AppClassLoaderHelper appClassLoaderHelper;
    private Boolean useInternalQueryCache = null;
    private Map appDataSources = null;
    private Map appnoSQLDataSources = null;
    private Map graphQLDataSources = null;
    private final String MAPPINGS = "MAPPINGS";
    private ApplicationSettings appSettings;
    private Map appResolvedCustomTags;
    private CustomTagTable appTagTable;
    private Object defaultQueryCache;
    private static Map<String, Object> scopeLocks = new HashMap<String, Object>();
    private boolean isInited = false;

    private void updateAppResolvedCustomTags() {
        this.appResolvedCustomTags = new FastHashtable();
        this.appTagTable = null;
        StringTokenizer st = new StringTokenizer(this.appCustomTagPaths, ",");
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            if (path == null) continue;
            this.appResolvedCustomTags.put(path, path);
        }
        this.appTagTable = new CustomTagTable(this.appResolvedCustomTags);
    }

    public CustomTagTable getApplicationTagTable() {
        return this.appTagTable;
    }

    public Map getAppResolvedCustomTags() {
        return this.appResolvedCustomTags;
    }

    ApplicationScope(String appName) {
        this.setScopeType(7);
        this.mTable = new FastHashtable();
        this.mLastAccess = System.currentTimeMillis();
        this.mStartTime = System.currentTimeMillis();
        this.mMaxInterval = 86400000L;
        this.mApp = FusionContext.getCurrent().getServletContext();
        this.mAppName = appName != null && appName.length() > 0 ? appName : "";
        if (ServiceFactory.getRuntimeService().isAllowAppVarInServContext()) {
            this.mApp.setAttribute(this.mAppName, (Object)this.mTable);
        }
        this.put("APPLICATIONNAME", this.mAppName);
    }

    public String getName() {
        return this.mAppName;
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.mStartTime;
    }

    public long getTimeSinceLastAccess() {
        return System.currentTimeMillis() - this.mLastAccess;
    }

    public long getMaxInactiveInterval() {
        return this.mMaxInterval;
    }

    @Override
    protected void bind(String name, Object value) {
        this.mLastAccess = System.currentTimeMillis();
        this.mTable.put(name, value);
        if (this.mAppName.equalsIgnoreCase("")) {
            this.mApp.setAttribute(name, value);
        }
    }

    @Override
    protected void bind_Final(String name, Object value) {
        this.bind(name, value);
    }

    @Override
    protected void unbind(String name) {
        this.mLastAccess = System.currentTimeMillis();
        this.mTable.remove(name);
        if (this.mAppName.equalsIgnoreCase("")) {
            this.mApp.removeAttribute(name);
        }
    }

    @Override
    protected Object resolve(String name) {
        this.mLastAccess = System.currentTimeMillis();
        return this.mTable.get(name);
    }

    @Override
    public boolean containsKey(Object key) {
        String lower;
        if (FusionContext.isPreserveNullValues()) {
            Key keyObj = key instanceof Key ? (Key)key : Key.getInstance(key.toString());
            boolean hasKey = this.mTable._containsKey(keyObj);
            if (!hasKey) {
                keyObj = Key.getInstance(key.toString().toLowerCase());
                hasKey = this.mTable._containsKey(keyObj);
            }
            return hasKey;
        }
        String strKey = (String)key;
        Object o = this.resolve(strKey);
        if (o == null && !(lower = strKey.toLowerCase()).equals(strKey)) {
            o = this.resolve(lower);
        }
        return o != null;
    }

    @Override
    public Object getValueWIthoutChange(String name) {
        return this.mTable.get(name);
    }

    public void setLastAccess() {
        this.mLastAccess = System.currentTimeMillis();
    }

    public void setStoreloginCredentialInSession(boolean flag) {
        this.mStoreloginCredentialInSession = flag;
    }

    public boolean getStoreloginCredentialInSession() {
        return this.mStoreloginCredentialInSession;
    }

    @Override
    public Iterator getNames() {
        return this.mTable.keySet().iterator();
    }

    public String getApplicationPath() {
        return this.applicationPath;
    }

    public void setApplicationPath(String applicationPath) {
        this.applicationPath = applicationPath;
    }

    public boolean expired() {
        return System.currentTimeMillis() - this.mLastAccess > this.mMaxInterval;
    }

    public void SetMaxInactiveInterval(long max) {
        this.mMaxInterval = max * 1000L;
    }

    public CFDataSource getAppDataSource(String dsn) {
        if (this.appDataSources != null && dsn != null) {
            return (CFDataSource)this.appDataSources.get(dsn.toUpperCase());
        }
        return null;
    }

    public Object getAppNoSQLDataSource(String dsn) {
        if (this.appnoSQLDataSources != null && dsn != null) {
            return this.appnoSQLDataSources.get(dsn.toUpperCase());
        }
        return null;
    }

    public Object getGraphQLDataSource(String dsn) {
        if (this.graphQLDataSources != null && dsn != null) {
            return this.graphQLDataSources.get(dsn.toUpperCase());
        }
        return null;
    }

    void setApplicationSettings(Map settings) {
        if (settings.get("MAPPINGS") == null) {
            settings.put("MAPPINGS", new Struct());
        }
        this.appSettingsMap = settings;
        boolean reloadDatasources = false;
        if (this.appSettings != null && this.appSettings.getDatasources() != null && settings != null && settings.get("datasources") != null && !this.appSettings.getDatasources().toString().equals(settings.get("datasources").toString())) {
            reloadDatasources = true;
        }
        this.appSettings = new ApplicationSettings(settings);
        if (this.isNew() && !this.isInited() || reloadDatasources) {
            Map ds = this.appSettings.loadAppDatasources();
            if (ds != null) {
                this.appDataSources = (Map)ds.get("sql");
                this.appnoSQLDataSources = (Map)ds.get("nosql");
                this.graphQLDataSources = (Map)ds.get("graphql");
            } else {
                this.graphQLDataSources = null;
                this.appnoSQLDataSources = null;
                this.appDataSources = null;
            }
        }
    }

    public Map getApplicationSettingsMap() {
        return this.appSettingsMap;
    }

    public ApplicationSettings getApplicationSettings() {
        return this.appSettings;
    }

    public void setApplicationCustomTagPaths(String custom_tag_paths) {
        if (this.appCustomTagPaths == null || !this.appCustomTagPaths.equalsIgnoreCase(custom_tag_paths)) {
            this.appCustomTagPaths = custom_tag_paths;
            this.updateAppResolvedCustomTags();
        }
    }

    public boolean isNew() {
        return this.mIsNew;
    }

    public void setIsNew(boolean status) {
        this.mIsNew = status;
    }

    public void setEventInvoker(AppEventInvoker proxy) {
        this.mCFCProxy = proxy;
        this.mCFCProxy.setmAppName(this.mAppName);
    }

    public AppEventInvoker getEventInvoker() {
        return this.mCFCProxy;
    }

    public void cleanup() {
        if (this.appClassLoaderHelper != null) {
            this.appClassLoaderHelper.release();
        }
        if (this.expired() && ServiceFactory.getRuntimeService().isAllowAppVarInServContext()) {
            this.mApp.removeAttribute(this.mAppName);
        }
    }

    public void setIsInited(boolean isInited) {
        this.isInited = isInited;
    }

    public boolean isInited() {
        return this.isInited;
    }

    public AppClassLoaderHelper getAppClassLoaderHelper() {
        return this.appClassLoaderHelper;
    }

    public void setAppClassLoaderHelper(AppClassLoaderHelper appClassLoaderHelper) {
        this.appClassLoaderHelper = appClassLoaderHelper;
    }

    public void reloadDataSources() {
        this.appnoSQLDataSources = this.appSettings.reloadNoSqlDataSources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getLock() {
        Object result;
        Map<String, Object> map = scopeLocks;
        synchronized (map) {
            result = scopeLocks.get(this.mAppName);
            if (result == null) {
                result = LockManager.get().requestNewLock();
                scopeLocks.put(this.mAppName, result);
            }
        }
        return result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.cloneAsStruct();
    }

    @Override
    public MemoryTracker getMemoryTracker() {
        MemoryTracker mt = null;
        MemoryTrackerProxy mtp = this.getMemoryTrackerProxy();
        if (mtp != null) {
            mt = mtp.getBuiltInMemoryTracker();
        }
        return mt;
    }

    public File resolveTemplateName(String name, String ext) {
        File f = null;
        if (((String)name).indexOf(46) != -1 && ((String)(name = ((String)name).replace('.', '/'))).charAt(0) != '/') {
            name = "/" + (String)name;
        }
        String origName = name;
        name = ((String)name).toLowerCase();
        if (this.appTagTable != null && (f = this.appTagTable.findTemplate((String)name + ext)) == null && !SystemInfo.isWindows()) {
            f = this.appTagTable.findTemplate(origName + ext);
        }
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        if (this.appResolvedCustomTags != null && f == null && !runtimeService.isTrustedCache()) {
            CustomTagTable newTable = new CustomTagTable(this.appResolvedCustomTags);
            f = newTable.findTemplate((String)name + ext);
            if (f == null && !SystemInfo.isWindows()) {
                f = newTable.findTemplate(origName + ext);
            }
            if (f != null) {
                this.appTagTable = newTable;
            }
        }
        return f;
    }

    FastHashtable getAttributeMap() {
        return this.mTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDefaultQueryCache() {
        if (this.defaultQueryCache == null) {
            GenericCache cacheMgr;
            GenericCache genericCache = cacheMgr = GenericCacheFactory.getCache();
            synchronized (genericCache) {
                String appName = null;
                FusionContext context = FusionContext.getCurrent();
                if (context != null && (appName = context.getApplicationName()) == null && context.cacheConfig != null) {
                    appName = context.cacheConfig.applicationName;
                }
                this.defaultQueryCache = cacheMgr.createCache("QUERY", appName, null, null);
                AppHelper.setMaxQueryCount(-1, true);
            }
        }
        return this.defaultQueryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useInternalQueryCache() {
        if (this.useInternalQueryCache == null) {
            try {
                if (this.appSettingsMap != null) {
                    Map map = this.appSettingsMap;
                    synchronized (map) {
                        Object val;
                        Map cacheSettings = (Map)this.appSettingsMap.get("cache");
                        if (cacheSettings != null && (val = cacheSettings.get("useinternalquerycache")) != null) {
                            this.useInternalQueryCache = Boolean.parseBoolean((String)val);
                        }
                    }
                }
                if (this.useInternalQueryCache == null) {
                    this.useInternalQueryCache = AppHelper.isServerWideInternalQueryCacheEnabled();
                }
            }
            catch (Exception e) {
                this.useInternalQueryCache = false;
            }
        }
        return this.useInternalQueryCache;
    }

    public void resetDefaultQueryCache() {
        this.defaultQueryCache = null;
    }
}

