/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.log.CFLogs;
import coldfusion.monitor.Configuration;
import coldfusion.nosql.NoSQLServiceHandle;
import coldfusion.osgi.services.GraphQLClientService;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Struct;
import coldfusion.server.MonitoringService;
import coldfusion.server.NoSQLService;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.CFDataSource;
import coldfusion.sql.DataSourceDef;
import coldfusion.sql.DataSourceFactory;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.UUIDUtils;
import coldfusion.util.Utils;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class ApplicationSettings {
    public static final String INVOKE_ACCESSOR = "invokeimplicitaccessor";
    public static final String INMEMORY_FILESYSTEM = "inmemoryfilesystem";
    public static final String INMEMORY_FILESYSTEM_ENABLED = "enabled";
    public static final String INMEMORY_FILESYSTEM_SIZE = "size";
    public static final String SESSION_COOKIE = "SESSIONCOOKIE";
    public static final String AUTH_COOKIE = "AUTHCOOKIE";
    public static final String DOMAIN = "DOMAIN";
    public static final String TIMEOUT = "TIMEOUT";
    public static final String SECURE = "SECURE";
    public static final String HTTPONLY = "HTTPONLY";
    public static final String SAMESITE = "SAMESITE";
    public static final String MAXUNZIPRATIO = "MAXUNZIPRATIO";
    public static final String DISABLEUPDATE = "DISABLEUPDATE";
    public static final String SECURITY = "SECURITY";
    public static final String ANTISAMY_POLICY_FILE = "ANTISAMYPOLICY";
    public static final String SERIALIZE_QUERY_AS = "SERIALIZEQUERYAS";
    public static final String PRESERVE_CASE_FOR_STRUCT_KEY = "PRESERVECASEFORSTRUCTKEY";
    public static final String PRESERVE_CASE_FOR_QUERY_COLUMN = "PRESERVECASEFORQUERYCOLUMN";
    public static final String SERIALIZATION = "SERIALIZATION";
    public static final String DATASOURCES = "datasources";
    public static final String NOSQL_DATASOURCES = "nosql-datasources";
    public static final String GRAPHQL_DATASOURCES = "graphql-datasoures";
    public static final String MAILSETTINGS = "mail";
    public static final String COMPILEEXTFORINCLUDE = "compileextforinclude";
    public static final String STRICTNUMBERVALIDATION = "STRICTNUMBERVALIDATION";
    public static final String PASS_ARRAY_BY_REFERENCE = "PASSARRAYBYREFERENCE";
    public static final String SEARCH_IMPLICIT_SCOPES = "SEARCHIMPLICITSCOPES";
    public static final String STRUCT_METADATA = "STRUCTMETADATA";
    public static final String ENABLE_NULL_SUPPORT = "ENABLENULLSUPPORT";
    public static final String USE_JAVA_AS_REGEX_ENGINE = "USEJAVAASREGEXENGINE";
    public static final String SAMEFORMFIELDSASARRAY = "SAMEFORMFIELDSASARRAY";
    public static final String TIMEZONE = "TIMEZONE";
    public static final String SAMLSETTINGS = "SAMLSETTINGS";
    public static final boolean DEFAULT_STRICTNUMBERVALIDATION = true;
    public static final boolean DEFAULT_PASS_ARRAY_BY_REFERENCE = false;
    public static final boolean DEFAULT_SEARCH_IMPLICIT_SCOPES = Boolean.valueOf(System.getProperty("coldfusion.searchimplicitscopes", "false"));
    public static final boolean DEFAULT_ENABLE_NULL_SUPPORT = false;
    public static final boolean DEFAULT_USE_JAVA_AS_REGEX_ENGINE = false;
    public static final boolean DEFAULT_SAMEFORMFIELDSASARRAY = false;
    public static final String CSP_NONCE = "ENABLECSPNONCEFORSCRIPT";
    private Map settingsMap;
    private Map serializationsettingMap;
    private Boolean invokeAccessor = null;
    private Boolean applicationInMemoryEnabled = null;
    private Integer applicationInMemorySize = null;
    private Boolean httpOnlySessionCookie = null;
    private Boolean secureSessionCookie = null;
    private Integer sessionCookieTimeout = null;
    private Integer authCookieTimeout = null;
    private String sessionCookieDomain = null;
    private Boolean sessionCookieDisableUpdate = null;
    private Boolean authCookieDisableUpdate = null;
    private String antiSamyPolicyFile = null;
    private Boolean preserveCaseForSerialize = null;
    private Boolean preserveCaseForQueryColumn = null;
    private String compileExtForInclude = null;
    private Boolean strictNumberValidation = null;
    private Boolean passArrayByReference = null;
    private Boolean searchImplicitScopes = null;
    private Map structMetadata;
    private Boolean enableNullSupport = null;
    private Boolean useJavaAsRegexEngine = null;
    private Boolean sameFormFieldsArray = null;
    private String blockedFileExtForFileUpload = null;
    private TimeZone timezone = null;
    private String sessionCookieSamesite = null;
    private String authCookieSamesite = null;
    private Integer maxUnzipRatio = null;
    private boolean cspScript = false;
    private boolean isExplicitInMemoryFileSystem = false;
    private String serializeQueryAs = null;

    public ApplicationSettings(Map settings) {
        this.settingsMap = settings;
        this.serializationsettingMap = (Map)this.settingsMap.get(SERIALIZATION);
        this.timezone = this.getAppTimezone();
    }

    public Map loadAppDatasources() {
        Map datasources = (Map)this.settingsMap.get(DATASOURCES);
        if (datasources == null) {
            return null;
        }
        CaseInsensitiveMap appDatasources = new CaseInsensitiveMap();
        CaseInsensitiveMap appNoSQLDatasources = new CaseInsensitiveMap();
        NoSQLService noSQLService = ServiceFactory.getNoSQLService();
        CaseInsensitiveMap graphQLDatasources = new CaseInsensitiveMap();
        GraphQLClientService graphQLClientService = ServiceFactory.getGraphQLClientService(true);
        for (Object dsn : datasources.keySet()) {
            String name = dsn.toString();
            try {
                CaseInsensitiveMap m = new CaseInsensitiveMap();
                m.putAll((Map)datasources.get(name));
                m.put("name", name);
                Object type = m.get("type");
                if (noSQLService == null && type instanceof String && ((String)type).equalsIgnoreCase("mongodb")) continue;
                if (type instanceof String && noSQLService.isValidNoSQLDBType((String)type)) {
                    NoSQLServiceHandle serviceHandle = noSQLService.getServiceHandle((String)type, m);
                    appNoSQLDatasources.put(name, serviceHandle);
                    continue;
                }
                if (type instanceof String && graphQLClientService != null) {
                    Object graphQLServiceHandle = null;
                    graphQLDatasources.put(name, graphQLServiceHandle);
                    continue;
                }
                CFDataSource ds = null;
                if (!m.containsKey("alter")) {
                    m.put("alter", true);
                }
                if (!m.containsKey("update")) {
                    m.put("update", true);
                }
                if (!m.containsKey("delete")) {
                    m.put("delete", true);
                }
                if (!m.containsKey("storedproc")) {
                    m.put("storedproc", true);
                }
                if (!m.containsKey("insert")) {
                    m.put("insert", true);
                }
                if (!m.containsKey("drop")) {
                    m.put("drop", true);
                }
                if (!m.containsKey("create")) {
                    m.put("create", true);
                }
                if (!m.containsKey("revoke")) {
                    m.put("revoke", true);
                }
                if (!m.containsKey("select")) {
                    m.put("select", true);
                }
                if (!m.containsKey("grant")) {
                    m.put("grant", true);
                }
                if (!m.containsKey("disable")) {
                    m.put("disable", false);
                }
                if (!m.containsKey("disable_blob")) {
                    m.put("disable_blob", false);
                }
                if (!m.containsKey("disable_clob")) {
                    m.put("disable_clob", false);
                }
                if (!m.containsKey("urlmap")) {
                    m.put("urlmap", new HashMap());
                }
                Map urlMap = (Map)m.get("urlmap");
                urlMap.put("host", m.get("host"));
                urlMap.put("name", UUIDUtils.createUUID(false));
                urlMap.put("database", m.get("database"));
                urlMap.put("port", m.get("port"));
                urlMap.put("class", m.get("class"));
                urlMap.put("type", m.get("type"));
                urlMap.put("DRIVER", m.get("DRIVER"));
                urlMap.put("username", m.get("username"));
                urlMap.put("password", m.get("password"));
                urlMap.put("servicename", m.get("servicename"));
                DataSourceDef def = new DataSourceDef(m);
                def.encryptPassword();
                def.setDynamic(true);
                String url = def.getUrl();
                if (url == null) {
                    url = DataSourceDef.getJDBCUrl(def);
                }
                if (url != null) {
                    def.setUrl(url.replace("&;", "&"));
                }
                if ((ds = DataSourceFactory.getInstance().setDataSource(name, def)) != null) {
                    appDatasources.put(name, ds);
                }
                this.updateDatasourcesForMonitoring(name, m);
            }
            catch (Exception e) {
                CFLogs.APPLICATION_LOG.error("Datasource could not be registered: " + name, e);
            }
        }
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("sql", appDatasources);
        map.put("nosql", appNoSQLDatasources);
        map.put("graphql", graphQLDatasources);
        return map;
    }

    public Map reloadNoSqlDataSources() {
        Map datasources = (Map)this.settingsMap.get(DATASOURCES);
        if (datasources == null) {
            return null;
        }
        CaseInsensitiveMap appNoSQLDatasources = new CaseInsensitiveMap();
        NoSQLService noSQLService = ServiceFactory.getNoSQLService();
        Object noSQLFactory = null;
        for (Object dsn : datasources.keySet()) {
            String name = dsn.toString();
            try {
                CaseInsensitiveMap m = new CaseInsensitiveMap();
                m.putAll((Map)datasources.get(name));
                m.put("name", name);
                Object type = m.get("type");
                if (noSQLService == null || !(type instanceof String) || !noSQLService.isValidNoSQLDBType((String)type)) continue;
                NoSQLServiceHandle serviceHandle = noSQLService.getServiceHandle((String)type, m);
                appNoSQLDatasources.put(name, serviceHandle);
            }
            catch (Exception e) {
                e.printStackTrace();
                CFLogs.APPLICATION_LOG.error("Datasource could not be registered: " + name, e);
            }
        }
        return appNoSQLDatasources;
    }

    private void updateDatasourcesForMonitoring(String name, Map m) {
        MonitoringService monitoringService = ServiceFactory.getMonitoringService();
        if (monitoringService != null && monitoringService.isMonitoringEnabled()) {
            try {
                Struct strt = new Struct();
                this.updateMapFromURLIfRequired(m);
                strt.put("host", m.get("host"));
                strt.put("port", m.get("port"));
                strt.put("vendor", m.get("DRIVER"));
                strt.put("db_server_name", m.get("database"));
                Configuration.INSTANCE.getDataSourcesMap().put(name.toLowerCase(), strt);
            }
            catch (Exception ex) {
                CFLogs.APPLICATION_LOG.error("PMT Monitoring:In-Memory Static database list could not be updated" + name, ex);
            }
        }
    }

    private void updateMapFromURLIfRequired(Map m) {
        Object host = m.get("host");
        Object port = m.get("port");
        Object database = m.get("database");
        if (host != null && port != null && database != null) {
            return;
        }
        boolean namedInstance = false;
        if (m.get("url") != null) {
            String jdbcUrl = m.get("url").toString();
            String dbServerName = "";
            URI uri = null;
            if ((jdbcUrl = jdbcUrl.startsWith("jdbc:macromedia") ? jdbcUrl.substring(16) : jdbcUrl.substring(5)).contains("\\")) {
                namedInstance = true;
                uri = URI.create(jdbcUrl.split("\\\\")[0]);
            } else {
                uri = URI.create(jdbcUrl.split(";")[0]);
            }
            if (host == null) {
                host = namedInstance ? uri.getHost() + "\\" + jdbcUrl.split("\\\\")[1].split(";")[0] : uri.getHost();
                m.put("host", host);
            }
            if (port == null) {
                port = namedInstance ? null : Integer.valueOf(uri.getPort());
                m.put("port", port);
            }
            if (database == null) {
                if (namedInstance) {
                    String[] keyVal;
                    for (String key : keyVal = jdbcUrl.split("\\\\")[1].split(";")) {
                        if (!key.toLowerCase().startsWith("databasename")) continue;
                        dbServerName = key.split("=")[1];
                        break;
                    }
                } else {
                    if (jdbcUrl.split(";").length > 1) {
                        String[] keyVal;
                        for (String key : keyVal = jdbcUrl.split(";")[1].split(";")) {
                            if (key.toLowerCase().startsWith("databasename")) {
                                dbServerName = key.split("=")[1];
                                break;
                            }
                            if (!key.toLowerCase().startsWith("sid")) continue;
                            dbServerName = key.split("=")[1];
                            break;
                        }
                    }
                    if (dbServerName.isEmpty()) {
                        dbServerName = uri.getPath().substring(1);
                    }
                }
                m.put("database", dbServerName);
            }
        }
    }

    public Map loadAppMailSettings() {
        Map mailsettings = (Map)this.settingsMap.get(MAILSETTINGS);
        return mailsettings;
    }

    public boolean isInvokeAccessorEnabled() {
        if (this.invokeAccessor == null) {
            Object key = this.settingsMap.get(INVOKE_ACCESSOR);
            this.invokeAccessor = key != null ? Boolean.valueOf(Cast._boolean(key, false)) : Boolean.FALSE;
        }
        return this.invokeAccessor;
    }

    public Map getDatasources() {
        return (Map)this.settingsMap.get(DATASOURCES);
    }

    public String getAntiSamyPolicyFile() {
        Map security;
        if (this.antiSamyPolicyFile == null && (security = (Map)this.settingsMap.get(SECURITY)) != null) {
            this.antiSamyPolicyFile = (String)security.get(ANTISAMY_POLICY_FILE);
        }
        return this.antiSamyPolicyFile;
    }

    public boolean isInMemoryEnabled() {
        if (this.applicationInMemoryEnabled == null) {
            Map inmemoryfilesystem = (Map)this.settingsMap.get(INMEMORY_FILESYSTEM);
            if (inmemoryfilesystem != null) {
                Object key = inmemoryfilesystem.get(INMEMORY_FILESYSTEM_ENABLED);
                if (key != null) {
                    this.applicationInMemoryEnabled = Cast._boolean(key, false);
                    if (this.applicationInMemoryEnabled.booleanValue()) {
                        this.isExplicitInMemoryFileSystem = true;
                    }
                } else {
                    this.applicationInMemoryEnabled = Boolean.TRUE;
                }
            } else {
                this.applicationInMemoryEnabled = Boolean.TRUE;
            }
        }
        return this.applicationInMemoryEnabled;
    }

    public int getInMemorySize() {
        if (this.applicationInMemorySize == null) {
            Map inmemoryfilesystem = (Map)this.settingsMap.get(INMEMORY_FILESYSTEM);
            int appLimit = ServiceFactory.getRuntimeService().getInMemoryFileSystemAppLimit();
            if (inmemoryfilesystem != null) {
                Object key = inmemoryfilesystem.get(INMEMORY_FILESYSTEM_SIZE);
                if (key != null) {
                    int size = Cast._int(key);
                    if ((long)size > Utils.getMaxHeapSize()) {
                        throw new InMemoryFileSystemAppLimitException();
                    }
                    this.applicationInMemorySize = size >= 0 && size <= appLimit ? new Integer(size) : new Integer(appLimit);
                } else {
                    this.applicationInMemorySize = new Integer(appLimit);
                }
            } else {
                this.applicationInMemorySize = new Integer(appLimit);
            }
        }
        return this.applicationInMemorySize;
    }

    public boolean isInMemoryFileSystemEnabled() {
        Object inmemoryfilesystemObj = this.settingsMap.get(INMEMORY_FILESYSTEM);
        if (inmemoryfilesystemObj != null) {
            Map inmemoryfilesystem = (Map)inmemoryfilesystemObj;
            Object key = inmemoryfilesystem.get(INMEMORY_FILESYSTEM_ENABLED);
            this.applicationInMemoryEnabled = Cast._boolean(key, false);
            return this.applicationInMemoryEnabled;
        }
        return false;
    }

    public int getAuthCookieTimeout() {
        if (this.authCookieTimeout == null) {
            Object val;
            Map authCookie = (Map)this.settingsMap.get(AUTH_COOKIE);
            if (authCookie != null && (val = authCookie.get(TIMEOUT)) != null) {
                Double value = Cast._double(val);
                this.authCookieTimeout = value > 0.0 ? Integer.valueOf((int)(value * 24.0 * 60.0 * 60.0)) : Integer.valueOf(value.intValue());
                return this.authCookieTimeout;
            }
            this.authCookieTimeout = -1;
        }
        return this.authCookieTimeout;
    }

    public String getAuthCookieSamesite() {
        if (this.authCookieSamesite == null) {
            Object val;
            Map authCookie = (Map)this.settingsMap.get(AUTH_COOKIE);
            if (authCookie != null && (val = authCookie.get(SAMESITE)) != null) {
                String value = (String)val;
                this.authCookieSamesite = value.trim();
                return this.authCookieSamesite;
            }
            this.authCookieSamesite = ServiceFactory.getRuntimeService().getSessionCookieSamesite();
        }
        return this.authCookieSamesite;
    }

    public boolean generateCspNonce() {
        this.cspScript = this.settingsMap != null && this.settingsMap.get(CSP_NONCE) != null ? Cast._boolean(this.settingsMap.get(CSP_NONCE)) : ServiceFactory.getRuntimeService().isEnableCspNonceForScript();
        return this.cspScript;
    }

    public boolean isSessionCookieUpdateDisabled() {
        if (this.sessionCookieDisableUpdate == null) {
            Object val;
            Map sessionCookie = (Map)this.settingsMap.get(SESSION_COOKIE);
            if (sessionCookie != null && (val = sessionCookie.get(DISABLEUPDATE)) != null) {
                this.sessionCookieDisableUpdate = Cast._boolean(val);
                return this.sessionCookieDisableUpdate;
            }
            this.sessionCookieDisableUpdate = ServiceFactory.getRuntimeService().isCFInternalCookiesDisableUpdate();
        }
        return this.sessionCookieDisableUpdate;
    }

    public boolean isAuthCookieUpdateDisabled() {
        if (this.authCookieDisableUpdate == null) {
            Object val;
            Map authCookie = (Map)this.settingsMap.get(AUTH_COOKIE);
            if (authCookie != null && (val = authCookie.get(DISABLEUPDATE)) != null) {
                this.authCookieDisableUpdate = Cast._boolean(val);
                return this.authCookieDisableUpdate;
            }
            this.authCookieDisableUpdate = ServiceFactory.getRuntimeService().isCFInternalCookiesDisableUpdate();
        }
        return this.authCookieDisableUpdate;
    }

    public boolean isHttpOnlySessionCookie() {
        if (this.httpOnlySessionCookie == null) {
            Object val;
            Map sessionCookie = (Map)this.settingsMap.get(SESSION_COOKIE);
            if (sessionCookie != null && (val = sessionCookie.get(HTTPONLY)) != null) {
                this.httpOnlySessionCookie = Cast._boolean(val);
                return this.httpOnlySessionCookie;
            }
            this.httpOnlySessionCookie = ServiceFactory.getRuntimeService().isHttpOnlySessionCookie();
        }
        return this.httpOnlySessionCookie;
    }

    public boolean isSecureSessionCookie() {
        if (this.secureSessionCookie == null) {
            Object val;
            Map sessionCookie = (Map)this.settingsMap.get(SESSION_COOKIE);
            if (sessionCookie != null && (val = sessionCookie.get(SECURE)) != null) {
                this.secureSessionCookie = Cast._boolean(val);
                return this.secureSessionCookie;
            }
            this.secureSessionCookie = ServiceFactory.getRuntimeService().isSecureSessionCookie();
        }
        return this.secureSessionCookie;
    }

    public int getSessionCookieTimeout() {
        if (this.sessionCookieTimeout == null) {
            Object val;
            Map sessionCookie = (Map)this.settingsMap.get(SESSION_COOKIE);
            if (sessionCookie != null && (val = sessionCookie.get(TIMEOUT)) != null) {
                Double value = Cast._double(val);
                this.sessionCookieTimeout = value > 0.0 ? Integer.valueOf((int)(value * 24.0 * 60.0 * 60.0)) : Integer.valueOf(value.intValue());
                return this.sessionCookieTimeout;
            }
            this.sessionCookieTimeout = ServiceFactory.getRuntimeService().getSessionCookieTimeout();
        }
        return this.sessionCookieTimeout;
    }

    public String getSessionCookieDomain() {
        if (this.sessionCookieDomain == null) {
            Object val;
            Map sessionCookie = (Map)this.settingsMap.get(SESSION_COOKIE);
            if (sessionCookie != null && (val = sessionCookie.get(DOMAIN)) != null) {
                String value = (String)val;
                this.sessionCookieDomain = value.trim();
                return this.sessionCookieDomain;
            }
            this.sessionCookieDomain = ServiceFactory.getRuntimeService().getSessionCookieDomain();
        }
        return this.sessionCookieDomain;
    }

    public String getSessionCookieSamesite() {
        if (this.sessionCookieSamesite == null) {
            Object val;
            Map sessionCookie = (Map)this.settingsMap.get(SESSION_COOKIE);
            if (sessionCookie != null && (val = sessionCookie.get(SAMESITE)) != null) {
                String value = (String)val;
                this.sessionCookieSamesite = value.trim();
                return this.sessionCookieSamesite;
            }
            this.sessionCookieSamesite = ServiceFactory.getRuntimeService().getSessionCookieSamesite();
        }
        return this.sessionCookieSamesite;
    }

    public int getMaxUnzipRatio() {
        if (this.maxUnzipRatio == null) {
            Object val = this.settingsMap.get(MAXUNZIPRATIO);
            if (val != null) {
                this.maxUnzipRatio = Cast._int(val);
                return this.maxUnzipRatio;
            }
            this.maxUnzipRatio = ServiceFactory.getRuntimeService().getMaxUnzipRatio();
        }
        return this.maxUnzipRatio;
    }

    public String getSerializeQueryFormat() {
        if (this.serializeQueryAs == null) {
            if (this.serializationsettingMap != null) {
                this.serializeQueryAs = (String)this.serializationsettingMap.get(SERIALIZE_QUERY_AS);
            }
            if (this.serializeQueryAs == null) {
                this.serializeQueryAs = "row";
            }
        }
        return this.serializeQueryAs;
    }

    public boolean getPreserveCaseForQueryColumn() {
        if (this.preserveCaseForQueryColumn == null) {
            Object val = null;
            if (this.serializationsettingMap != null) {
                val = this.serializationsettingMap.get(PRESERVE_CASE_FOR_QUERY_COLUMN);
            }
            this.preserveCaseForQueryColumn = val != null ? Boolean.valueOf(Cast._boolean(val)) : Boolean.valueOf(false);
        }
        return this.preserveCaseForQueryColumn;
    }

    public boolean getPreserveCaseForSerialize() {
        if (this.preserveCaseForSerialize == null) {
            Object val = null;
            if (this.serializationsettingMap != null) {
                val = this.serializationsettingMap.get(PRESERVE_CASE_FOR_STRUCT_KEY);
            }
            this.preserveCaseForSerialize = val != null ? Boolean.valueOf(Cast._boolean(val, ServiceFactory.getRuntimeService().getPreserveCaseForSerialize())) : Boolean.valueOf(ServiceFactory.getRuntimeService().getPreserveCaseForSerialize());
        }
        return this.preserveCaseForSerialize;
    }

    public String getCompileExtForInclude() {
        if (this.compileExtForInclude == null) {
            String value = (String)this.settingsMap.get(COMPILEEXTFORINCLUDE);
            if (value != null) {
                if (!(value = value.trim()).equals("")) {
                    value = Utils.removeDuplicates(value.toUpperCase(), ",");
                }
                this.compileExtForInclude = value;
            } else {
                this.compileExtForInclude = ServiceFactory.getRuntimeService().getCompileExtForInclude();
            }
        }
        return this.compileExtForInclude;
    }

    public String getBlockedExtForFileUpload() {
        if (this.blockedFileExtForFileUpload == null) {
            String value = (String)this.settingsMap.get("blockedExtForFileUpload");
            if (value != null) {
                if (!(value = value.trim()).equals("")) {
                    value = Utils.removeDuplicates(value.toUpperCase(), ",");
                }
                this.blockedFileExtForFileUpload = value;
            } else {
                this.blockedFileExtForFileUpload = ServiceFactory.getRuntimeService().getBlockedExtForFileUpload();
            }
        }
        return this.blockedFileExtForFileUpload;
    }

    public boolean getStrictNumberValidation() {
        if (this.strictNumberValidation == null) {
            Object value = this.settingsMap.get(STRICTNUMBERVALIDATION);
            this.strictNumberValidation = value != null ? Boolean.valueOf(Cast._boolean(value, true)) : Boolean.valueOf(true);
        }
        return this.strictNumberValidation;
    }

    public boolean getPassArrayByReference() {
        if (this.passArrayByReference == null) {
            Object value = this.settingsMap.get(PASS_ARRAY_BY_REFERENCE);
            if (value instanceof Boolean) {
                this.passArrayByReference = (Boolean)value;
            }
            this.passArrayByReference = value != null ? Boolean.valueOf(Cast._boolean(value)) : Boolean.valueOf(false);
        }
        return this.passArrayByReference;
    }

    public boolean isSearchImplicitScope() {
        if (this.searchImplicitScopes == null) {
            Object value = this.settingsMap.get(SEARCH_IMPLICIT_SCOPES);
            if (value instanceof Boolean) {
                this.searchImplicitScopes = (Boolean)value;
            }
            this.searchImplicitScopes = value != null ? Boolean.valueOf(Cast._boolean(value)) : Boolean.valueOf(DEFAULT_SEARCH_IMPLICIT_SCOPES);
        }
        return this.searchImplicitScopes;
    }

    public Boolean getEnableNullSupport() {
        if (this.enableNullSupport == null) {
            Object value = this.settingsMap.get(ENABLE_NULL_SUPPORT);
            if (value instanceof Boolean) {
                this.enableNullSupport = (Boolean)value;
            } else if (value != null) {
                this.enableNullSupport = Cast._boolean(value);
            }
        }
        return this.enableNullSupport;
    }

    public Boolean isJavaRegexEngine() {
        if (this.useJavaAsRegexEngine == null) {
            Object value = this.settingsMap.get(USE_JAVA_AS_REGEX_ENGINE);
            if (value instanceof Boolean) {
                this.useJavaAsRegexEngine = (Boolean)value;
            } else if (value != null) {
                this.useJavaAsRegexEngine = Cast._boolean(value);
            }
        }
        return this.useJavaAsRegexEngine;
    }

    public Boolean getSameFormFieldsArray() {
        if (this.sameFormFieldsArray == null) {
            Object value = this.settingsMap.get(SAMEFORMFIELDSASARRAY);
            if (value instanceof Boolean) {
                this.sameFormFieldsArray = (Boolean)value;
            } else if (value != null) {
                this.sameFormFieldsArray = Cast._boolean(value);
            }
        }
        return this.sameFormFieldsArray;
    }

    public boolean isExplicitInMemoryFileSystem() {
        return this.isExplicitInMemoryFileSystem;
    }

    public Map getStructMetadata() {
        if (this.structMetadata == null) {
            Object val = null;
            if (this.serializationsettingMap != null) {
                val = this.serializationsettingMap.get(STRUCT_METADATA);
            }
            this.structMetadata = val instanceof Map ? (Map)val : Collections.emptyMap();
        }
        return this.structMetadata;
    }

    public TimeZone getTimeZone() {
        return this.timezone;
    }

    private TimeZone getAppTimezone() {
        String value = (String)this.settingsMap.get(TIMEZONE);
        if (value != null) {
            return TimeZone.getTimeZone(value);
        }
        return null;
    }

    public static class InMemoryFileSystemAppLimitException
    extends ApplicationException {
    }
}

