/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.monitor.memory.MemoryTrackable;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.runtime.CFDouble;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.InvalidArrayIndexException;
import coldfusion.runtime.ObjectDuplicator;
import coldfusion.runtime.Variable;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.Key;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArgumentCollection
extends CaseInsensitiveMap
implements MemoryTrackable {
    private List entryOrderValues = new ArrayList(4);

    public ArgumentCollection(Object[] keys, Object[] values) {
        int count = 0;
        if (keys != null && (count = keys.length) > 0) {
            boolean preserveNull = false;
            if (count > values.length) {
                preserveNull = FusionContext.isPreserveNullValues();
            }
            for (int i = 0; i < count; ++i) {
                Object key = keys[i];
                if (key == null) continue;
                Object value = null;
                if (values.length > i) {
                    value = values[i];
                }
                this.entryOrderValues.add(this.getCaseInsensitiveString(key.toString()));
                Variable v = new Variable(key.toString());
                v.setContainer(this);
                if (values.length > i || !preserveNull) {
                    v.set(value);
                }
                super.put(key, (Object)v);
            }
        }
        while (count < values.length) {
            this.add(count, values[count++]);
        }
    }

    public ArgumentCollection(Object[] keys, Map namedArgs) {
        Object value;
        if (keys != null) {
            for (Object key : keys) {
                value = namedArgs.get(key);
                this.put(key, value);
            }
        }
        for (Map.Entry entry : namedArgs.entrySet()) {
            Object key;
            key = entry.getKey();
            value = entry.getValue();
            if (key != null && key.toString().equalsIgnoreCase("argumentCollection")) continue;
            key = this.normalizeKey(key);
            this.handleParametrizedArgs(key, value);
        }
        Object argsObj = namedArgs.get("argumentCollection");
        if (argsObj != null && argsObj instanceof Map) {
            Map args = (Map)argsObj;
            for (Object key1 : args.keySet()) {
                Object value1 = args.get(key1);
                key1 = this.normalizeKey(key1);
                this.handleParametrizedArgs(key1, value1);
            }
        }
    }

    private Object normalizeKey(Object key) {
        if (!(key instanceof String)) {
            return key;
        }
        String skey = (String)key;
        if (skey.length() != 0) {
            switch (skey.charAt(0)) {
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    try {
                        return Integer.parseInt(skey);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return key;
    }

    private void handleParametrizedArgs(Object key, Object value) {
        int keyIndex;
        if (key instanceof Integer && (keyIndex = (Integer)key - 1) < this.entryOrderValues.size() && this.get(this.entryOrderValues.get(keyIndex)) == null) {
            key = this.entryOrderValues.get(keyIndex);
        }
        if (this.get(key) == null) {
            this.put(key, value);
        }
    }

    public Object get(int pos) {
        if (pos < this.entryOrderValues.size()) {
            return this.get(this.getKey(pos));
        }
        return null;
    }

    @Override
    public Object get(Object key) {
        Key keyObj = key instanceof Key ? (Key)key : Key.getInstance(key.toString());
        return this.get(keyObj);
    }

    @Override
    public Object get(Key key) {
        Object o = super.get(key);
        if (o instanceof Variable) {
            Variable v = (Variable)o;
            return v.value;
        }
        return null;
    }

    public Variable getVariable(int pos) {
        Object o;
        if (pos < this.entryOrderValues.size() && (o = super.get(this.getKey(pos))) instanceof Variable) {
            return (Variable)o;
        }
        return null;
    }

    public Variable getVariable(String key) {
        Object o = super.get(key);
        if (o instanceof Variable) {
            return (Variable)o;
        }
        return null;
    }

    protected Object getKey(int pos) {
        return this.entryOrderValues.get(pos);
    }

    @Override
    public boolean containsKey(Object key) {
        Object o = this.get(key);
        if (o == null && FusionContext.isPreserveNullValues()) {
            return super.containsKey(key);
        }
        return o != null;
    }

    private boolean containsKeyForVariable(Key key) {
        boolean contains = false;
        Object o = super.get(key);
        if (o instanceof Variable) {
            contains = true;
        }
        return contains;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CaseInsensitiveMap clone = (CaseInsensitiveMap)super.clone();
        CaseInsensitiveMap copy = new CaseInsensitiveMap();
        copy.putAll((Map)clone);
        return copy;
    }

    @Override
    public Object put(Object key, Object value) {
        Key keyObj = Key.getInstance(key.toString());
        if (!this.containsKeyForVariable(keyObj)) {
            this.entryOrderValues.add(this.getCaseInsensitiveString(key.toString()));
        }
        Object o = super.get(keyObj);
        Object result = null;
        if (o instanceof Variable) {
            Variable v = (Variable)o;
            result = v.value;
            v.set(value);
        } else {
            Variable v = new Variable(key.toString());
            v.setContainer(this);
            v.set(value);
            super.put(keyObj, (Object)v);
        }
        return result;
    }

    public Object put_Final(Object key, Object value) {
        Key keyObj = Key.getInstance(key.toString());
        if (!this.containsKeyForVariable(keyObj)) {
            this.entryOrderValues.add(this.getCaseInsensitiveString(key.toString()));
        }
        Object o = super.get(keyObj);
        Object result = null;
        if (o instanceof Variable) {
            Variable v = (Variable)o;
            result = v.value;
            v.set(value);
        } else {
            Variable v = new Variable(key.toString(), true);
            v.setContainer(this);
            v.set(value);
            super.put(keyObj, (Object)v);
        }
        return result;
    }

    Object arrayGetAt(Object pos) {
        Double d;
        if (pos instanceof Number) {
            return this.get(Cast._int(pos) - 1);
        }
        if (pos instanceof String && (d = CFDouble.parseDouble((String)((String)pos), (boolean)false)) != null) {
            return this.get(Cast._int(d) - 1);
        }
        return this.get(pos);
    }

    public void add(int index, Object value) {
        Integer newKey = new Integer(index + 1);
        if (index == this.size()) {
            this.put(newKey, value);
        } else {
            boolean doReindex = false;
            if (CfJspPage.internalIsNumeric(this.getKey(index))) {
                doReindex = true;
            }
            this.entryOrderValues.add(index, newKey);
            if (doReindex) {
                int newLastIndex;
                for (int i = newLastIndex = this.size(); i > index; --i) {
                    Object key = this.entryOrderValues.get(i);
                    if (!CfJspPage.internalIsNumeric(key)) continue;
                    Integer keyOneUp = new Integer(Cast._int(key) + 1);
                    super.put(keyOneUp, super.remove(key));
                    this.entryOrderValues.set(i, keyOneUp);
                }
            }
            super.put(newKey, value);
        }
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.size()) {
            throw new InvalidArrayIndexException(index, this.entryOrderValues.size());
        }
        return super.remove(this.entryOrderValues.remove(index));
    }

    @Override
    public Object remove(Object key) {
        this.entryOrderValues.remove(this.getCaseInsensitiveString(key.toString()));
        return super.remove(key);
    }

    @Override
    public Object remove(Key key) {
        this.entryOrderValues.remove(this.getCaseInsensitiveString(key.getKeyString()));
        return super.remove(key);
    }

    @Override
    public int size() {
        return this.entryOrderValues.size();
    }

    @Override
    public synchronized Map duplicate(IdentityHashMap refCache) throws IllegalAccessException {
        if (refCache == null) {
            refCache = new IdentityHashMap();
        }
        Object[] keys = new Object[this.map.size()];
        Object[] duplicatedValues = new Object[this.map.size()];
        int i = 0;
        for (Map.Entry entry : this.map.entrySet()) {
            keys[i] = ((Key)entry.getKey()).getKeyString();
            Object val = entry.getValue();
            if (val instanceof Variable) {
                val = ((Variable)val).value;
            }
            duplicatedValues[i] = ObjectDuplicator.duplicate(val, refCache);
            ++i;
        }
        return new ArgumentCollection(keys, duplicatedValues);
    }

    @Override
    public Set entrySet() {
        return new ArgumentCollectionSet();
    }

    private String getCaseInsensitiveString(String str) {
        if (!ArgumentCollection.isUpperCase(str)) {
            return str.toUpperCase();
        }
        return str;
    }

    private static boolean isUpperCase(String str) {
        int len = str.length();
        for (int index = 0; index < len; ++index) {
            if (!Character.isLowerCase(str.charAt(index))) continue;
            return false;
        }
        return true;
    }

    private Object[] getValues() {
        return this.values().toArray();
    }

    @Override
    public Enumeration elements() {
        return new ArgumentElementsEnumeration(this.entrySet().iterator());
    }

    @Override
    public Enumeration keys() {
        return new ArgumentKeysEnumeration(this.entrySet().iterator());
    }

    @Override
    public int getScopeType() {
        return 1;
    }

    @Override
    public MemoryTrackerProxy getMemoryTrackerProxy() {
        return this.mtProxy;
    }

    @Override
    public void setMemoryTrackerProxy(MemoryTrackerProxy mtp) {
        this.mtProxy = mtp;
    }

    @Override
    public Iterator valuesIterator() {
        return this.values().iterator();
    }

    class ArgumentCollectionSet
    extends HashSet {
        List<Object> OrderedArgumentCollection = new ArrayList<Object>();

        ArgumentCollectionSet() {
            int i;
            Object[] values = ArgumentCollection.this.getValues();
            for (i = 0; i < values.length; ++i) {
                Object o = values[i];
                if (!(o instanceof Variable)) continue;
                this.add(o);
            }
            for (i = 0; i < ArgumentCollection.this.entryOrderValues.size(); ++i) {
                Variable variableObj = ArgumentCollection.this.getVariable((String)ArgumentCollection.this.entryOrderValues.get(i));
                if (variableObj == null) continue;
                this.OrderedArgumentCollection.add(variableObj);
            }
        }

        @Override
        public Iterator iterator() {
            return this.OrderedArgumentCollection.iterator();
        }
    }

    static class ArgumentElementsEnumeration
    implements Enumeration {
        Iterator it;

        ArgumentElementsEnumeration(Iterator it) {
            this.it = it;
        }

        @Override
        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public Object nextElement() {
            Object o = this.it.next();
            if (o instanceof Variable) {
                return ((Variable)o).value;
            }
            return null;
        }
    }

    class ArgumentKeysEnumeration
    extends ArgumentElementsEnumeration {
        ArgumentKeysEnumeration(Iterator it) {
            super(it);
        }

        @Override
        public Object nextElement() {
            Object o = this.it.next();
            if (o instanceof Variable) {
                return ((Variable)o).getKey();
            }
            return null;
        }
    }
}

